/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.am.util.FileLookup;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.common.validation.PositiveIntegerValidator;
import com.sun.identity.common.validation.URLValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.federation.alliance.FSAllianceManagementConstants;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.FSAttributePlugin;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSLocalConfigurationDescriptor {
    private ServiceConfig sc = null;
    private String providerAlias = null;
    private String providerAuthType = null;
    private String authnfedProfile = null;
    private String orgDN = null;
    private boolean forceAuthentication = false;
    private boolean isPassive = false;
    private String respondWiths = null;
    private String libertyVersionURI = null;
    private Set trustedProviders = null;
    private String authnDecisionProvider = null;
    private String defaultAuthenticationContext = null;
    private int assertionInterval = 60;
    private int artifactTimeout = 120;
    private int cleanupInterval = 180;
    private int assertionLimit = 1000;
    private Map spAuthContextInfo = null;
    private Map idpAuthContextInfo = null;
    private Set authDomainURLList = null;
    private String providerHomePageURL = null;
    private String providerCommonLoginPageURL = null;
    private String installDir = SystemProperties.get((String)"com.iplanet.am.install.basedir");
    private String nameIdentifierImpl = null;
    private static String logoutDoneURL = SystemProperties.get((String)"com.sun.identity.federation.logout.done.url");
    private static String federationDoneURL = SystemProperties.get((String)"com.sun.identity.federation.federation.done.url");
    private static String terminationDoneURL = SystemProperties.get((String)"com.sun.identity.federation.termination.done.url");
    private static String nameRegDoneURL = SystemProperties.get((String)"com.sun.identity.federation.registration.done.url");
    private String assertionIssuer = null;
    private static AuthUtils au = null;
    private String attributePluginImpl = null;
    private FSAttributePlugin attributePluginClass = null;
    private String autoFedAttribute = null;
    private boolean autoFedEnabled = false;

    public FSLocalConfigurationDescriptor() {
        this.orgDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        this.respondWiths = "lib:AuthenticationStatement";
        try {
            this.setDefaultValuesForAuth();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSLocalConfigurationDescriptor", (Throwable)((Object)fSAllianceManagementException));
        }
    }

    public FSLocalConfigurationDescriptor(String string, String string2) throws FSAllianceManagementException {
        this.setDefaultValuesForURLs(string, string2);
        this.providerAlias = string2;
        this.orgDN = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        this.respondWiths = "lib:AuthenticationStatement";
        try {
            this.setDefaultValuesForAuth();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSLocalConfigurationDescriptor", (Throwable)((Object)fSAllianceManagementException));
        }
    }

    FSLocalConfigurationDescriptor(ServiceConfig serviceConfig, Map map) throws SSOException, SMSException, FSAllianceManagementException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.setProviderAlias(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-alias"));
        this.setProviderAuthType(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-auth-type"));
        this.setAuthnfedProfile(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authnfed-profile"));
        this.setAssociatedOrgDN(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-orgdn"));
        String string = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-force-authentication");
        this.forceAuthentication = string.equalsIgnoreCase("true");
        String string2 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-is-passive");
        this.isPassive = string2.equalsIgnoreCase("true");
        this.setRespondWiths(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-respond-withs"));
        this.setLibertyVersionURI(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-liberty-version-url"));
        this.setNameIdentifierImpl(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-identifier-implementation"));
        this.setTrustedProviders((Set)map.get("iplanet-am-trusted-providers"));
        this.setAuthDecisionProvider(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-decision-provider"));
        this.setDefaultAuthenticationContext(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-default-authncontext"));
        this.setProviderHomePageURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-homepage-url"));
        this.setProviderCommonLoginPageURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-sso-fail-redirect-url"));
        this.setAssertionInterval(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-interval"));
        this.setCleanupInterval(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-cleanup-interval"));
        this.setArtifactTimeout(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-artifact-timeout"));
        this.setAssertionLimit(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-limit"));
        this.setAssertionIssuer(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderAssertionIssuer"));
        this.setAttributePlugin(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderAttributePlugin"));
        this.setAutoFedAttribute(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderAutoFedAttr"));
        String string3 = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderisAutoFedEnabled");
        if (string3 != null) {
            this.autoFedEnabled = string3.equalsIgnoreCase("true");
        }
        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig("SPAuthenticationContextInfo");
        Set set = null;
        if (serviceConfig2 != null) {
            set = serviceConfig2.getSubConfigNames();
            this.spAuthContextInfo = new HashMap();
            if (set != null) {
                object4 = set.iterator();
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    object2 = null;
                    if (object3 == null || ((String)object3).length() <= 0 || (object = serviceConfig2.getSubConfig((String)object3)) == null) continue;
                    object2 = new FSSPAuthenticationContextInfo(((ServiceConfig)object).getAttributes());
                    this.spAuthContextInfo.put(((FSSPAuthenticationContextInfo)object2).getAuthenticationContext(), object2);
                }
            }
        }
        if ((object4 = serviceConfig.getSubConfig("IDPAuthenticationContextInfo")) != null) {
            this.idpAuthContextInfo = new HashMap();
            set = ((ServiceConfig)object4).getSubConfigNames();
            if (set != null) {
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object = (String)object3.next();
                    FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = null;
                    if (((String)object).length() <= 0 || (object2 = ((ServiceConfig)object4).getSubConfig((String)object)) == null) continue;
                    fSIDPAuthenticationContextInfo = new FSIDPAuthenticationContextInfo(((ServiceConfig)object2).getAttributes());
                    this.idpAuthContextInfo.put(fSIDPAuthenticationContextInfo.getAuthenticationContext(), fSIDPAuthenticationContextInfo);
                }
            }
        }
    }

    public String getProviderAlias() {
        return this.providerAlias;
    }

    public void setProviderAlias(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_provider_alias", null);
        }
        this.providerAlias = string;
    }

    public String getProviderAuthType() {
        return this.providerAuthType;
    }

    public void setProviderAuthType(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("remote") && !string.equalsIgnoreCase("local")) {
            throw new FSAllianceManagementException("alliance_management_invalid_auth_type", null);
        }
        this.providerAuthType = string;
    }

    public String getDoFederationPageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("Federate.jsp", httpServletRequest);
    }

    public String getLogoutDonePageURL(HttpServletRequest httpServletRequest) {
        if (logoutDoneURL != null && !logoutDoneURL.equals("")) {
            return logoutDoneURL + '?' + "metaAlias" + '=' + this.providerAlias;
        }
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("LogoutDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getFederationDonePageURL(HttpServletRequest httpServletRequest) {
        if (federationDoneURL != null && !federationDoneURL.equals("")) {
            return federationDoneURL + '?' + "metaAlias" + '=' + this.providerAlias;
        }
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("FederationDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getErrorPageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("Error.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getNameIdentifierImpl() {
        return this.nameIdentifierImpl;
    }

    public void setNameIdentifierImpl(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_name_identifier_impl", null);
        }
        this.nameIdentifierImpl = string;
    }

    public String getAssociatedOrgDN() {
        return this.orgDN;
    }

    public void setAssociatedOrgDN(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_org_dn", null);
        }
        this.orgDN = string;
    }

    public String getAuthnfedProfile() {
        return this.authnfedProfile;
    }

    public void setAuthnfedProfile(String string) {
        this.authnfedProfile = string;
    }

    public boolean getForceAuthentication() {
        return this.forceAuthentication;
    }

    public void setForceAuthentication(boolean bl) {
        this.forceAuthentication = bl;
    }

    public boolean getIsPassive() {
        return this.isPassive;
    }

    public void setIsPassive(boolean bl) {
        this.isPassive = bl;
    }

    public String getRespondWiths() {
        return this.respondWiths;
    }

    public void setRespondWiths(String string) {
        this.respondWiths = string;
    }

    public String getLibertyVersionURI() {
        return this.libertyVersionURI;
    }

    public void setLibertyVersionURI(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_liberty_version_uri", null);
        }
        this.libertyVersionURI = string;
    }

    public Set getTrustedProviders() {
        return this.trustedProviders;
    }

    public void setTrustedProviders(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null && !set.isEmpty()) {
            int n = -1;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.endsWith("|SP") && (n = string.indexOf("|SP")) != -1) {
                    string = string.substring(0, n);
                } else if (string.endsWith("|IDP") && (n = string.indexOf("|IDP")) != -1) {
                    string = string.substring(0, n);
                }
                hashSet.add(string);
            }
        }
        this.trustedProviders = hashSet;
    }

    public String getListOfCOTsPageURL(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("ListOfCOTs.jsp", httpServletRequest);
    }

    public String getTerminationDonePageURL(HttpServletRequest httpServletRequest) {
        if (terminationDoneURL != null && !terminationDoneURL.equals("")) {
            return terminationDoneURL + '?' + "metaAlias" + '=' + this.providerAlias;
        }
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("TerminationDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getNameRegistrationDonePageURL(HttpServletRequest httpServletRequest) {
        if (nameRegDoneURL != null && !nameRegDoneURL.equals("")) {
            return nameRegDoneURL + '?' + "metaAlias" + '=' + this.providerAlias;
        }
        return FSServiceUtils.getBaseURL(httpServletRequest) + this.getAbsoluteFileName("NameRegistrationDone.jsp", httpServletRequest) + '?' + "metaAlias" + '=' + this.providerAlias;
    }

    public String getProviderCommonLoginPageURL(HttpServletRequest httpServletRequest) {
        return this.providerCommonLoginPageURL;
    }

    public String getProviderCommonLoginPageURL() {
        return this.providerCommonLoginPageURL;
    }

    public String getProviderHomePageURL() {
        return this.providerHomePageURL;
    }

    public void setProviderHomePageURL(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_home_page_url", null);
        }
        URLValidator uRLValidator = URLValidator.getInstance();
        try {
            uRLValidator.validate(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_home_page_url", null);
        }
        this.providerHomePageURL = string;
    }

    public void setProviderCommonLoginPageURL(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_common_login_page_url", null);
        }
        URLValidator uRLValidator = URLValidator.getInstance();
        try {
            uRLValidator.validate(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_common_login_page_url", null);
        }
        this.providerCommonLoginPageURL = string;
    }

    public String getAuthDecisionProvider() {
        return this.authnDecisionProvider;
    }

    public void setAuthDecisionProvider(String string) {
        this.authnDecisionProvider = string;
    }

    public String getDefaultAuthenticationContext() {
        return this.defaultAuthenticationContext;
    }

    public void setDefaultAuthenticationContext(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_default_auth_context", null);
        }
        this.defaultAuthenticationContext = string;
    }

    public int getAssertionInterval() {
        return this.assertionInterval;
    }

    public void setAssertionInterval(int n) throws FSAllianceManagementException {
        if (n < 0) {
            throw new FSAllianceManagementException("alliance_management_invalid_assertion_interval", null);
        }
        this.assertionInterval = n;
    }

    public void setAssertionInterval(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_assertion_interval", null);
        }
        PositiveIntegerValidator positiveIntegerValidator = PositiveIntegerValidator.getInstance();
        try {
            positiveIntegerValidator.validate(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_assertion_interval", null);
        }
        this.assertionInterval = Integer.parseInt(string);
    }

    public String getAssertionIssuer() {
        return this.assertionIssuer;
    }

    public void setAssertionIssuer(String string) {
        this.assertionIssuer = string;
    }

    public int getAssertionLimit() {
        return this.assertionLimit;
    }

    public void setAssertionLimit(int n) throws FSAllianceManagementException {
        if (n < 0) {
            throw new FSAllianceManagementException("alliance_management_invalid_assertion_limit", null);
        }
        this.assertionLimit = n;
    }

    public void setAssertionLimit(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_assertion_limit", null);
        }
        PositiveIntegerValidator positiveIntegerValidator = PositiveIntegerValidator.getInstance();
        try {
            positiveIntegerValidator.validate(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_assertion_limit", null);
        }
        this.assertionLimit = Integer.parseInt(string);
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(int n) throws FSAllianceManagementException {
        if (n < 0) {
            throw new FSAllianceManagementException("alliance_management_invalid_cleanup_interval", null);
        }
        this.cleanupInterval = n;
    }

    public void setCleanupInterval(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_cleanup_interval", null);
        }
        PositiveIntegerValidator positiveIntegerValidator = PositiveIntegerValidator.getInstance();
        try {
            positiveIntegerValidator.validate(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_cleanup_interval", null);
        }
        this.cleanupInterval = Integer.parseInt(string);
    }

    public int getArtifactTimeout() {
        return this.artifactTimeout;
    }

    public void setArtifactTimeout(int n) throws FSAllianceManagementException {
        if (n < 0) {
            throw new FSAllianceManagementException("alliance_management_invalid_artifact_timeout", null);
        }
        this.artifactTimeout = n;
    }

    public void setArtifactTimeout(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_artifact_timeout", null);
        }
        PositiveIntegerValidator positiveIntegerValidator = PositiveIntegerValidator.getInstance();
        try {
            positiveIntegerValidator.validate(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_artifact_timeout", null);
        }
        this.artifactTimeout = Integer.parseInt(string);
    }

    public Map getSPAuthContextInfo() {
        return this.spAuthContextInfo;
    }

    public Map getIDPAuthContextInfo() {
        return this.idpAuthContextInfo;
    }

    public void setSPAuthContextInfo(Map map) {
        this.spAuthContextInfo = map;
    }

    public void setIDPAuthContextInfo(Map map) {
        this.idpAuthContextInfo = map;
    }

    public Set getAuthDomainURLList() {
        return this.authDomainURLList;
    }

    void setAuthDomainURLList(Set set) {
        this.authDomainURLList = set;
    }

    Map getAttributes(int n) {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-alias", this.providerAlias);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-auth-type", this.providerAuthType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authnfed-profile", this.authnfedProfile);
        String string = this.forceAuthentication ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-force-authentication", string);
        String string2 = this.isPassive ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-is-passive", string2);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-orgdn", this.orgDN);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-respond-withs", this.respondWiths);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-liberty-version-url", this.libertyVersionURI);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-identifier-implementation", this.nameIdentifierImpl);
        if (this.trustedProviders != null) {
            hashMap.put("iplanet-am-trusted-providers", this.trustedProviders);
        }
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-decision-provider", this.authnDecisionProvider);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-homepage-url", this.providerHomePageURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-sso-fail-redirect-url", this.providerCommonLoginPageURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-default-authncontext", this.defaultAuthenticationContext);
        String string3 = String.valueOf(this.assertionInterval);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-interval", string3);
        String string4 = String.valueOf(this.assertionLimit);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-limit", string4);
        String string5 = String.valueOf(this.artifactTimeout);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-artifact-timeout", string5);
        String string6 = String.valueOf(this.cleanupInterval);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-cleanup-interval", string6);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderAssertionIssuer", this.assertionIssuer);
        if (n == 30) {
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderAttributePlugin", this.attributePluginImpl);
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderAutoFedAttr", this.autoFedAttribute);
            String string7 = this.autoFedEnabled ? "true" : "false";
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderisAutoFedEnabled", string7);
        }
        return hashMap;
    }

    public Set getActiveTrustedProviders() {
        if (this.trustedProviders == null) {
            return this.trustedProviders;
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Iterator iterator = this.trustedProviders.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.isActiveProvider(string)) continue;
                hashSet.add(string);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLocalConfigurationDescriptor.getActiveTrustedProviders", (Throwable)exception);
            hashSet = null;
        }
        return hashSet;
    }

    boolean isActiveProvider(String string) throws Exception {
        String string2;
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProvider(string);
        return fSProviderDescriptor != null && (string2 = fSProviderDescriptor.getProviderStatus()) != null && string2.equalsIgnoreCase("active");
    }

    private String getAbsoluteFileName(String string, HttpServletRequest httpServletRequest) {
        String string2 = null;
        int n = this.installDir.lastIndexOf("/");
        string2 = n != -1 ? this.installDir.substring(0, n) : this.installDir;
        String string3 = string2 + "/config/federation";
        String string4 = "/" + this.providerAlias;
        if (this.providerAlias == null) {
            string4 = "/default";
        }
        File file = null;
        String string5 = FSServiceUtils.getLocale(httpServletRequest);
        au = new AuthUtils();
        String string6 = au.getFilePath(au.getClientType(httpServletRequest));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSLocalConfigurationDescriptor.getAbsoluteFileName() filePath :: " + string6);
        }
        try {
            String string7;
            String string8;
            file = FileLookup.getFirstExisting((String)string4, (String)string5, null, (String)string6, (String)string, (String)string3, (boolean)true);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message(file.getPath());
            }
            if ((string8 = (string7 = file.getPath()).substring(string2.length(), string7.length())).indexOf("\\") != -1) {
                string8 = string8.replace('\\', '/');
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("relativeFileName : " + string8);
            }
            return string8;
        }
        catch (Exception exception) {
            FSUtils.debug.warning("No file found, returing default", (Throwable)exception);
            return "/config/federation/default/" + string;
        }
    }

    void setDefaultValuesForURLs(String string, String string2) throws FSAllianceManagementException {
        String string3 = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
        if (string3 == null || string3.length() <= 0) {
            string3 = "DEPLOY_URI";
        }
        String string4 = "/config/federation/default";
        String string5 = string + string3 + string4;
        this.providerHomePageURL = string5 + "/index.html";
        this.providerCommonLoginPageURL = string5 + "/CommonLogin.jsp";
        this.setProviderAlias(string2);
    }

    void setDefaultValuesForAuth() throws FSAllianceManagementException {
        String[] stringArray = new String[10];
        int n = FSAllianceManagementConstants.SPAUTHLEVEL_DEFAULT;
        FSSPAuthenticationContextInfo[] fSSPAuthenticationContextInfoArray = new FSSPAuthenticationContextInfo[10];
        stringArray[0] = "http://www.projectliberty.org/schemas/authctx/classes/MobileContract";
        fSSPAuthenticationContextInfoArray[0] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileContract", n);
        stringArray[1] = "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID";
        fSSPAuthenticationContextInfoArray[1] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID", n);
        stringArray[2] = "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered";
        fSSPAuthenticationContextInfoArray[2] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered", n);
        stringArray[3] = "http://www.projectliberty.org/schemas/authctx/classes/Password";
        fSSPAuthenticationContextInfoArray[3] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Password", n);
        stringArray[4] = "http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport";
        fSSPAuthenticationContextInfoArray[4] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport", n);
        stringArray[5] = "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session";
        fSSPAuthenticationContextInfoArray[5] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Previous-Session", n);
        stringArray[6] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard";
        fSSPAuthenticationContextInfoArray[6] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard", n);
        stringArray[7] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI";
        fSSPAuthenticationContextInfoArray[7] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI", n);
        stringArray[8] = "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI";
        fSSPAuthenticationContextInfoArray[8] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Software-PKI", n);
        stringArray[9] = "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token";
        fSSPAuthenticationContextInfoArray[9] = new FSSPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token", n);
        String[] stringArray2 = new String[10];
        int n2 = FSAllianceManagementConstants.IDPAUTHPRIORITY_DEFAULT;
        String string = FSAllianceManagementConstants.IDP_MODULE_KEY;
        String string2 = FSAllianceManagementConstants.IDP_MODULE_VALUE;
        boolean bl = FSAllianceManagementConstants.IDP_SUPPORTED;
        FSIDPAuthenticationContextInfo[] fSIDPAuthenticationContextInfoArray = new FSIDPAuthenticationContextInfo[10];
        stringArray2[0] = "http://www.projectliberty.org/schemas/authctx/classes/MobileContract";
        fSIDPAuthenticationContextInfoArray[0] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileContract", n2, string, string2, bl);
        stringArray2[1] = "http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID";
        fSIDPAuthenticationContextInfoArray[1] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID", n2, string, string2, bl);
        stringArray2[2] = "http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered";
        fSIDPAuthenticationContextInfoArray[2] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered", n2, string, string2, bl);
        stringArray2[3] = "http://www.projectliberty.org/schemas/authctx/classes/Password";
        fSIDPAuthenticationContextInfoArray[3] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Password", n2, string, string2, bl);
        stringArray2[4] = "http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport";
        fSIDPAuthenticationContextInfoArray[4] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/PasswordProtectedTransport", n2, string, string2, bl);
        stringArray2[5] = "http://www.projectliberty.org/schemas/authctx/classes/Previous-Session";
        fSIDPAuthenticationContextInfoArray[5] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Previous-Session", n2, string, string2, bl);
        stringArray2[6] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard";
        fSIDPAuthenticationContextInfoArray[6] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard", n2, string, string2, bl);
        stringArray2[7] = "http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI";
        fSIDPAuthenticationContextInfoArray[7] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI", n2, string, string2, bl);
        stringArray2[8] = "http://www.projectliberty.org/schemas/authctx/classes/Software-PKI";
        fSIDPAuthenticationContextInfoArray[8] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Software-PKI", n2, string, string2, bl);
        stringArray2[9] = "http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token";
        fSIDPAuthenticationContextInfoArray[9] = new FSIDPAuthenticationContextInfo("http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token", n2, string, string2, bl);
        this.spAuthContextInfo = new HashMap();
        this.idpAuthContextInfo = new HashMap();
        int n3 = 0;
        while (n3 < 10) {
            this.spAuthContextInfo.put(stringArray[n3], fSSPAuthenticationContextInfoArray[n3]);
            this.idpAuthContextInfo.put(stringArray2[n3], fSIDPAuthenticationContextInfoArray[n3]);
            ++n3;
        }
    }

    public FSAttributePlugin getAttributePlugin() {
        if (this.attributePluginClass == null && this.attributePluginImpl != null) {
            try {
                Class<?> clazz = Class.forName(this.attributePluginImpl);
                this.attributePluginClass = (FSAttributePlugin)clazz.newInstance();
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSLocalProviderDescriptor.getAttributePlugin", (Throwable)exception);
            }
        }
        return this.attributePluginClass;
    }

    public String getAttributePluginClassName() {
        return this.attributePluginImpl;
    }

    public void setAttributePlugin(String string) {
        this.attributePluginImpl = string;
    }

    public String getAutoFedAttribute() {
        return this.autoFedAttribute;
    }

    public void setAutoFedAttribute(String string) {
        this.autoFedAttribute = string;
    }

    public boolean isAutoFedEnabled() {
        return this.autoFedEnabled;
    }

    public void setAutoFedEnabled(boolean bl) {
        this.autoFedEnabled = bl;
    }
}

