/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.IntegerValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FSIDPAuthenticationContextInfo
implements Serializable {
    private String authenticationContext = null;
    private int priority = 0;
    private String moduleIndicatorKey = null;
    private String moduleIndicatorValue = null;
    private boolean isSupported = true;

    public FSIDPAuthenticationContextInfo() {
    }

    FSIDPAuthenticationContextInfo(Map map) throws FSAllianceManagementException {
        this.setAuthenticationContext(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-context"));
        this.setPriority(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-context-priority"));
        this.setModuleIndicatorKey(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-context-moduleindicator-key"));
        this.setModuleIndicatorValue(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authentication-context-moduleindicator-value"));
        this.setIsSupported(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-is-supported"));
    }

    public FSIDPAuthenticationContextInfo(String string, int n, String string2, String string3) throws FSAllianceManagementException {
        this.setAuthenticationContext(string);
        this.setPriority(n);
        this.setModuleIndicatorKey(string2);
        this.setModuleIndicatorValue(string3);
    }

    public FSIDPAuthenticationContextInfo(String string, String string2, String string3, String string4) throws FSAllianceManagementException {
        this.setAuthenticationContext(string);
        this.setPriority(string2);
        this.setModuleIndicatorKey(string3);
        this.setModuleIndicatorValue(string4);
    }

    public FSIDPAuthenticationContextInfo(String string, String string2, String string3, String string4, boolean bl) throws FSAllianceManagementException {
        this.setAuthenticationContext(string);
        this.setPriority(string2);
        this.setModuleIndicatorKey(string3);
        this.setModuleIndicatorValue(string4);
        this.setIsSupported(bl);
    }

    public FSIDPAuthenticationContextInfo(String string, int n, String string2, String string3, boolean bl) throws FSAllianceManagementException {
        this.setAuthenticationContext(string);
        this.setPriority(n);
        this.setModuleIndicatorKey(string2);
        this.setModuleIndicatorValue(string3);
        this.setIsSupported(bl);
    }

    public String getAuthenticationContext() {
        return this.authenticationContext;
    }

    public void setAuthenticationContext(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_missing_auth_context", null);
        }
        this.authenticationContext = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(String string) throws FSAllianceManagementException {
        IntegerValidator integerValidator = IntegerValidator.getInstance();
        try {
            integerValidator.validate(string);
            this.priority = Integer.parseInt(string);
        }
        catch (ValidationException validationException) {
            throw new FSAllianceManagementException("alliance_management_invalid_priority", null);
        }
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public String getModuleIndicatorKey() {
        return this.moduleIndicatorKey;
    }

    public void setModuleIndicatorKey(String string) {
        this.moduleIndicatorKey = string;
    }

    public String getModuleIndicatorValue() {
        return this.moduleIndicatorValue;
    }

    public void setModuleIndicatorValue(String string) {
        this.moduleIndicatorValue = string;
    }

    public boolean getIsSupported() {
        return this.isSupported;
    }

    public void setIsSupported(boolean bl) {
        this.isSupported = bl;
    }

    public void setIsSupported(String string) {
        this.isSupported = string.equalsIgnoreCase("true");
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-context", this.authenticationContext);
        String string = String.valueOf(this.priority);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-context-priority", string);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-context-moduleindicator-key", this.moduleIndicatorKey);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authentication-context-moduleindicator-value", this.moduleIndicatorValue);
        String string2 = this.isSupported ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-is-supported", string2);
        return hashMap;
    }
}

