/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.common.validation.XSDateTimeValidator;
import com.sun.identity.common.validation.XSDurationValidator;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FSEntityDescriptor {
    private Map SPDescriptorMap = null;
    private Map IDPDescriptorMap = null;
    private FSAffiliationDescriptor AffiliationDescriptor = null;
    private String Extension = null;
    private FSContactPerson contactPerson = null;
    private FSOrganization organization = null;
    private String validUtil = null;
    private String cacheDuration = null;
    private String entityID = null;
    private String entityStatus = "Active";
    private String providerType = "urn:liberty:iff:provider";
    private String description = null;

    public FSEntityDescriptor(String string, String string2) throws FSAllianceManagementException {
        this.setEntityID(string);
        this.setEntityStatus(string2);
    }

    FSEntityDescriptor(String string, Map map) throws FSAllianceManagementException {
        this.setEntityID(string);
        this.setValidUntil(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityValidUntil"));
        this.setCacheDuration(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityCacheDuration"));
        this.setProviderType(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityType"));
        this.setEntityDescription(FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityDescription"));
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() == 0) {
            throw new FSAllianceManagementException("alliance_management_entityid_invalid", null);
        }
        this.entityID = string;
    }

    public void setEntityStatus(String string) {
        this.entityStatus = string;
    }

    public void setProviderType(String string) {
        this.providerType = string == null || string.trim().length() == 0 ? "urn:liberty:iff:provider" : string;
    }

    public String getEntityDescription() {
        return this.description;
    }

    public void setEntityDescription(String string) {
        this.description = string;
    }

    public void setAffiliationDescriptor(FSAffiliationDescriptor fSAffiliationDescriptor) {
        this.AffiliationDescriptor = fSAffiliationDescriptor;
        this.providerType = "urn:liberty:iff:affiliate";
    }

    public FSAffiliationDescriptor getAffiliationDescriptor() {
        return this.AffiliationDescriptor;
    }

    public void setContactPerson(FSContactPerson fSContactPerson) {
        this.contactPerson = fSContactPerson;
    }

    public FSContactPerson getContactPerson() {
        return this.contactPerson;
    }

    public void setOrganization(FSOrganization fSOrganization) {
        this.organization = fSOrganization;
    }

    public FSOrganization getOrganization() {
        return this.organization;
    }

    public void addIDPDescriptor(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string = fSProviderDescriptor.getProviderID();
        if (this.IDPDescriptorMap == null) {
            this.IDPDescriptorMap = new HashMap();
        } else if (this.IDPDescriptorMap.keySet().contains(string)) {
            Object[] objectArray = new String[]{string};
            throw new FSAllianceManagementException("alliance_management_idp_already_exist", objectArray);
        }
        this.IDPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public void modifyIDPDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        String string = fSProviderDescriptor.getProviderID();
        if (this.IDPDescriptorMap == null) {
            this.IDPDescriptorMap = new HashMap();
        } else if (this.IDPDescriptorMap.keySet().contains(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Modify Provider " + string);
            }
            this.IDPDescriptorMap.remove(string);
        }
        this.IDPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public Set getIDPDescriptor() {
        return this.IDPDescriptorMap != null ? this.IDPDescriptorMap.entrySet() : null;
    }

    public Set getIDPDescriptorKey() {
        return this.IDPDescriptorMap != null ? this.IDPDescriptorMap.keySet() : null;
    }

    public void addSPDescriptor(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string = fSProviderDescriptor.getProviderID();
        if (this.SPDescriptorMap == null) {
            this.SPDescriptorMap = new HashMap();
        } else if (this.SPDescriptorMap.keySet().contains(string)) {
            Object[] objectArray = new String[]{string};
            throw new FSAllianceManagementException("alliance_management_sp_already_exist", objectArray);
        }
        this.SPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public void modifySPDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        String string = fSProviderDescriptor.getProviderID();
        if (this.SPDescriptorMap == null) {
            this.SPDescriptorMap = new HashMap();
        } else if (this.SPDescriptorMap.keySet().contains(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Modify provider " + string);
            }
            this.SPDescriptorMap.remove(string);
        }
        this.SPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public Set getSPDescriptor() {
        return this.SPDescriptorMap != null ? this.SPDescriptorMap.entrySet() : null;
    }

    public Set getSPDescriptorKey() {
        return this.SPDescriptorMap != null ? this.SPDescriptorMap.keySet() : null;
    }

    public String getValidUntil() {
        return this.validUtil;
    }

    public void setValidUntil(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            XSDateTimeValidator xSDateTimeValidator = XSDateTimeValidator.getInstance();
            try {
                xSDateTimeValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_valid_until", null);
            }
        }
        this.validUtil = string;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            XSDurationValidator xSDurationValidator = XSDurationValidator.getInstance();
            try {
                xSDurationValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_cache_duration", null);
            }
        }
        this.cacheDuration = string;
    }

    public String getType() {
        return this.providerType;
    }

    public void setType(String string) {
        this.providerType = string;
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityValidUntil", this.validUtil);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityCacheDuration", this.cacheDuration);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityType", this.providerType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityDescription", this.description);
        return hashMap;
    }
}

