/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.common.validation.URLValidator;
import com.sun.identity.common.validation.ValidationException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import java.util.HashMap;
import java.util.Map;

public class FSCircleOfTrustDescriptor {
    private String circleOfTrustName = null;
    private String circleOfTrustDescription = null;
    private String circleOfTrustStatus = null;
    private String writerServiceURL = null;
    private String readerServiceURL = null;

    FSCircleOfTrustDescriptor(String string, Map map) throws FSAllianceManagementException {
        this.setCircleOfTrustName(string);
        this.setCircleOfTrustDescription(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authenticationdomain-description"));
        this.setCircleOfTrustStatus(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authenticationdomain-status"));
        this.setWriterServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-writerservice-url"));
        this.setReaderServiceURL(FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-readerservice-url"));
    }

    public FSCircleOfTrustDescriptor(String string, String string2) throws FSAllianceManagementException {
        this.setCircleOfTrustName(string);
        this.setCircleOfTrustStatus(string2);
    }

    private void setCircleOfTrustName(String string) throws FSAllianceManagementException {
        if (string == null || string.trim().length() <= 0) {
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        this.circleOfTrustName = string;
    }

    public String getCircleOfTrustName() {
        return this.circleOfTrustName;
    }

    public String getCircleOfTrustStatus() {
        return this.circleOfTrustStatus;
    }

    public String getCircleOfTrustDescription() {
        return this.circleOfTrustDescription;
    }

    public String getReaderServiceURL() {
        return this.readerServiceURL;
    }

    public String getWriterServiceURL() {
        return this.writerServiceURL;
    }

    public void setCircleOfTrustDescription(String string) {
        this.circleOfTrustDescription = string;
    }

    public void setReaderServiceURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_service_url", null);
            }
        }
        this.readerServiceURL = string;
    }

    public void setWriterServiceURL(String string) throws FSAllianceManagementException {
        if (string != null && string.trim().length() > 0) {
            URLValidator uRLValidator = URLValidator.getInstance();
            try {
                uRLValidator.validate(string);
            }
            catch (ValidationException validationException) {
                throw new FSAllianceManagementException("alliance_management_invalid_service_url", null);
            }
        }
        this.writerServiceURL = string;
    }

    public void setCircleOfTrustStatus(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("active") && !string.equalsIgnoreCase("inactive")) {
            throw new FSAllianceManagementException("alliance_management_invalid_cot_status", null);
        }
        this.circleOfTrustStatus = string;
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authenticationdomain-description", this.circleOfTrustDescription);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authenticationdomain-status", this.circleOfTrustStatus);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-writerservice-url", this.writerServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-readerservice-url", this.readerServiceURL);
        return hashMap;
    }
}

