/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.security.AccessController;
import java.util.Hashtable;

public class FSCache
implements ServiceListener {
    private static FSCache fsCache = new FSCache();
    private static Hashtable fsProviderTable = new Hashtable();
    private static Hashtable fsAffiliationTable = new Hashtable();
    private static Hashtable fsHostedProviderTable = new Hashtable();
    private static ServiceConfigManager scm;
    private static SSOToken token;
    private static SSOToken ssoAuthSession;

    public static FSProviderDescriptor getProviderDescriptor(String string, String string2) {
        return (FSProviderDescriptor)fsProviderTable.get(string2 == null ? string : string + "|" + string2);
    }

    public static FSProviderDescriptor setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor, String string, String string2) throws NullPointerException, FSAllianceManagementException {
        if (fSProviderDescriptor == null) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullInput"));
        }
        String string3 = fSProviderDescriptor.getProviderID();
        String string4 = fSProviderDescriptor.getProviderRole();
        if (string3 == null || string3.equals("")) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullProviderID"));
        }
        return fsProviderTable.put(string2 == null ? string : string + "|" + string2, fSProviderDescriptor);
    }

    public static FSHostedProviderDescriptor getHostedProviderDescriptor(String string) {
        return (FSHostedProviderDescriptor)fsHostedProviderTable.get(string);
    }

    public static FSHostedProviderDescriptor setHostedProviderDescriptor(FSHostedProviderDescriptor fSHostedProviderDescriptor, String string) {
        return fsHostedProviderTable.put(string, fSHostedProviderDescriptor);
    }

    public static FSAffiliationDescriptor getAffiliationDescriptor(String string) {
        return (FSAffiliationDescriptor)fsAffiliationTable.get(string);
    }

    public static FSAffiliationDescriptor setAffiliationDescriptor(FSAffiliationDescriptor fSAffiliationDescriptor) throws NullPointerException, FSAllianceManagementException {
        if (fSAffiliationDescriptor == null) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullInput"));
        }
        String string = fSAffiliationDescriptor.getAffiliationID();
        if (string == null || string.equals("")) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullAffiliationID"));
        }
        return fsAffiliationTable.put(string, fSAffiliationDescriptor);
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        this.clearProviderTable();
    }

    public void schemaChanged(String string, String string2) {
        FSUtils.debug.message("FSCache: schemaChanged.");
        this.clearProviderTable();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        FSUtils.debug.message("FSCache: globalConfigChanged.");
        this.clearProviderTable();
    }

    private void clearProviderTable() {
        if (fsProviderTable != null && !fsProviderTable.isEmpty()) {
            fsProviderTable.clear();
        }
        if (fsAffiliationTable != null && !fsAffiliationTable.isEmpty()) {
            fsAffiliationTable.clear();
        }
        if (!fsHostedProviderTable.isEmpty()) {
            fsHostedProviderTable.clear();
        }
    }

    private static SSOToken getSSOToken() throws SSOException, SessionException {
        if (ssoAuthSession == null) {
            ssoAuthSession = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return ssoAuthSession;
    }

    static {
        ssoAuthSession = null;
        try {
            token = FSCache.getSSOToken();
            scm = new ServiceConfigManager(token, "iPlanetAMProviderConfigService", "1.1");
            scm.addListener(fsCache);
        }
        catch (Exception exception) {
            FSUtils.debug.error(FSUtils.bundle.getString("can_not_create_provider_cache"), (Throwable)exception);
        }
    }
}

