/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entity;

import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.entity.EntityException;
import com.sun.identity.entity.EntityObjectIF;
import com.sun.identity.entity.EntityUtils;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EntityObjectImpl
implements EntityObjectIF {
    protected static Cache oCache;
    protected static Object lock;
    protected SSOToken token;
    protected AMStoreConnection amsc;
    protected AMOrganization entity = null;
    private static SSOTokenManager tokenManager;

    public Set createEntity(String string, String string2, String string3, String string4, Map map) throws EntityException, SSOException {
        HashSet<String> hashSet = new HashSet<String>();
        this.initializeObject(string, string4);
        try {
            int n = 0;
            n = this.getIntTypeFromStr(string3);
            HashMap<String, Map> hashMap = new HashMap<String, Map>(2);
            hashMap.put(string2, map);
            if (this.entity != null) {
                Set set = this.entity.createEntities(n, hashMap);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(((AMEntity)iterator.next()).getDN());
                }
            }
        }
        catch (AMException aMException) {
            EntityUtils.debug.error("EntityObjectImpl.createEntity() : Create Entity Failed. " + aMException);
            throw EntityUtils.convertException(aMException);
        }
        return hashSet;
    }

    public void deleteEntity(String string, String string2, String string3, String string4) throws EntityException, SSOException {
        this.initializeObject(string, string4);
        HashSet<String> hashSet = new HashSet<String>();
        try {
            int n = 0;
            n = this.getIntTypeFromStr(string3);
            String string5 = this.getEntityDN(string2, n, string4);
            hashSet.add(string5);
            if (this.entity != null) {
                this.entity.deleteEntities(n, hashSet);
                if (EntityUtils.debug.messageEnabled()) {
                    EntityUtils.debug.message("EntityObjectImpl.deleteEntity(): Deleted " + ((Object)hashSet).toString());
                }
            }
        }
        catch (AMException aMException) {
            EntityUtils.debug.error("EntityObjectImpl.deleteEntity() : Delete Entity Failed. " + aMException);
            throw EntityUtils.convertException(aMException);
        }
    }

    public Map getEntity(String string, String string2, String string3, String string4) throws EntityException, SSOException, RemoteException {
        this.initializeObject(string, string4);
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    public Set getEntityNames(String string, String string2, String string3, String string4) throws EntityException, SSOException, RemoteException {
        this.initializeObject(string, string3);
        HashSet hashSet = new HashSet();
        return hashSet;
    }

    public void modifyEntity(String string, String string2, String string3, String string4, Map map) throws EntityException, SSOException, RemoteException {
        this.initializeObject(string, string4);
        AMEntity aMEntity = this.getAMEntity(string, string2, string3, string4);
        try {
            if (aMEntity != null) {
                aMEntity.setAttributes(map);
                aMEntity.store();
            }
        }
        catch (AMException aMException) {
            EntityUtils.debug.error("EntityObjectImpl.modifyEntity() : Modify Entity Failed. " + aMException);
            throw EntityUtils.convertException(aMException);
        }
    }

    protected static void checkInitialization() throws SSOException {
        if (tokenManager == null) {
            Object object = lock;
            synchronized (object) {
                if (tokenManager == null) {
                    try {
                        tokenManager = SSOTokenManager.getInstance();
                        oCache = new Cache(1000);
                    }
                    catch (SSOException sSOException) {
                        EntityUtils.debug.error("EntityObjectImpl:checkInitialization() :Unable to get SSOTokenManager", (Throwable)sSOException);
                        throw sSOException;
                    }
                }
            }
        }
    }

    protected AMEntity getAMEntity(String string, String string2, String string3, String string4) throws EntityException, SSOException {
        AMEntity aMEntity;
        EntityObjectImpl.checkInitialization();
        try {
            int n = 0;
            n = this.getIntTypeFromStr(string3);
            String string5 = this.getEntityDN(string2, n, string4);
            String string6 = string + "/" + string5;
            aMEntity = (AMEntity)oCache.get((Object)string6);
            if (aMEntity == null) {
                aMEntity = this.amsc.getEntity(string5);
                oCache.put((Object)string6, (Object)aMEntity);
            }
        }
        catch (SSOException sSOException) {
            EntityUtils.debug.error("EntityObjectImpl.getAMEntity(): Unable to convert SSOToken: " + string, (Throwable)sSOException);
            throw sSOException;
        }
        return aMEntity;
    }

    protected void initializeObject(String string, String string2) throws EntityException, SSOException {
        EntityObjectImpl.checkInitialization();
        try {
            this.token = tokenManager.createSSOToken(string);
            this.amsc = new AMStoreConnection(this.token);
            String string3 = this.amsc.getOrganizationDN(string2, null);
            this.entity = this.amsc.getOrganization(string3);
        }
        catch (AMException aMException) {
            EntityUtils.debug.error("EntityObjectImpl.initializeObject() : Unable to get Organization DN " + aMException);
            throw EntityUtils.convertException(aMException);
        }
        catch (SSOException sSOException) {
            EntityUtils.debug.error("EntityObjectImpl.initializeObject() : Unable to convert SSOToken: " + string, (Throwable)sSOException);
            throw sSOException;
        }
        if (EntityUtils.debug.messageEnabled()) {
            EntityUtils.debug.message("EntityObjectImpl.getAMEntity(): Obtained ssotoken: " + string);
            EntityUtils.debug.message("EntityObjectImpl.getAMEntity(): Obtained AMSToreConnection object for SSOToken: " + string);
        }
    }

    private int getIntTypeFromStr(String string) {
        int n = 0;
        Set set = this.amsc.getEntityTypes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AMEntityType aMEntityType = (AMEntityType)iterator.next();
            if (!aMEntityType.getName().equalsIgnoreCase(string)) continue;
            n = aMEntityType.getType();
            break;
        }
        return n;
    }

    private String getEntityDN(String string, int n, String string2) throws EntityException, SSOException {
        String string3 = null;
        try {
            Set set = this.entity.searchEntities(n, "*", 2, new HashMap());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (string3.indexOf(string) < 0) {
                    continue;
                }
                break;
            }
        }
        catch (AMException aMException) {
            EntityUtils.debug.error("EntityObjectImpl.getEntityDN() : Unable to get DN for the Entity " + aMException);
            throw EntityUtils.convertException(aMException);
        }
        return string3;
    }

    static {
        lock = new Object();
    }
}

