/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation.plugins;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.delegation.interfaces.DelegationInterface;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class DelegationPolicyImpl
implements DelegationInterface,
ServiceListener,
IdEventListener,
PolicyListener {
    private static final String POLICY_REPOSITORY_REALM = "/sunamhiddenrealmdelegationservicepermissions";
    private static final String NAME_DELIMITER = "^^";
    private static final char REPLACEMENT_FOR_COMMA = '^';
    private static final String PREFIX = "sms://";
    private static final String DELIMITER = "/";
    private static final String ACTION_ALLOW = "allow";
    private static final String ACTION_DENY = "deny";
    private static final String DELEGATION_RULE = "delegation-rule";
    private static final String DELEGATION_SUBJECT = "delegation-subject";
    private static final String POLICY_SUBJECT = "AMIdentitySubject";
    private static final String AUTHN_USERS_ID = "id=All Authenticated Users,ou=role";
    private static final String DELEGATION_AUTHN_USERS = "AuthenticatedUsers";
    private static final String AUTHENTICATED_USERS_SUBJECT = "AuthenticatedUsers";
    private static final String CONFIGURED_CACHE_SIZE = "com.sun.identity.delegation.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 20000;
    private static Cache delegationCache;
    private static int maxCacheSize;
    private static Map idRepoListeners;
    private static ServiceConfigManager scm;
    private SSOToken appToken;
    private Map configParams;
    private PolicyEvaluator pe;

    public void initialize(SSOToken sSOToken, Map map) throws DelegationException {
        this.appToken = sSOToken;
        this.configParams = map;
        try {
            OrganizationConfigManager organizationConfigManager;
            Set set;
            String string = SystemProperties.get((String)CONFIGURED_CACHE_SIZE);
            if (string != null) {
                try {
                    maxCacheSize = Integer.parseInt(string);
                    if (maxCacheSize < 0) {
                        maxCacheSize = 20000;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    DelegationManager.debug.error("DelegationPolicyImpl.initialize(): invalid cache size specified in AMConfig.properties. Use default cache size 20000");
                    maxCacheSize = 20000;
                }
            }
            delegationCache = new Cache(maxCacheSize);
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.initialize(): cache size=" + maxCacheSize);
            }
            this.pe = new PolicyEvaluator(POLICY_REPOSITORY_REALM, "sunAMDelegationService");
            this.pe.addPolicyListener(this);
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(this.appToken, DELIMITER);
            aMIdentityRepository.addEventListener(this);
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener added for root realm.");
            }
            if ((set = (organizationConfigManager = new OrganizationConfigManager(this.appToken, DELIMITER)).getSubOrganizationNames("*", true)) != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    AMIdentityRepository aMIdentityRepository2 = new AMIdentityRepository(this.appToken, string2);
                    aMIdentityRepository2.addEventListener(this);
                    idRepoListeners.put(string2, aMIdentityRepository);
                    if (!DelegationManager.debug.messageEnabled()) continue;
                    DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener added for realm (" + string2 + ").");
                }
            }
            scm = new ServiceConfigManager("iPlanetAMPolicyConfigService", sSOToken);
            scm.addListener(this);
        }
        catch (Exception exception) {
            DelegationManager.debug.error("DelegationPolicyImpl: initialize() failed");
            throw new DelegationException(exception);
        }
    }

    public Set getPrivileges(SSOToken sSOToken, String string) throws SSOException, DelegationException {
        try {
            HashSet<DelegationPrivilege> hashSet = new HashSet<DelegationPrivilege>();
            PolicyManager policyManager = new PolicyManager(sSOToken, POLICY_REPOSITORY_REALM);
            Set set = policyManager.getPolicyNames();
            if (set != null) {
                String string2 = null;
                if (string != null) {
                    string2 = string.toLowerCase() + NAME_DELIMITER;
                    string2 = string2.replace(',', '^');
                } else {
                    string2 = NAME_DELIMITER;
                }
                int n = string2.length();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Policy policy;
                    DelegationPrivilege delegationPrivilege;
                    String string3 = (String)iterator.next();
                    if (!string3.toLowerCase().startsWith(string2) || (delegationPrivilege = this.policyToPrivilege(policy = policyManager.getPolicy(string3))) == null) continue;
                    delegationPrivilege.setName(string3.substring(n));
                    hashSet.add(delegationPrivilege);
                }
            }
            return hashSet;
        }
        catch (Exception exception) {
            DelegationManager.debug.error("unable to get privileges from realm " + string);
            throw new DelegationException(exception);
        }
    }

    public void addPrivilege(SSOToken sSOToken, String string, DelegationPrivilege delegationPrivilege) throws SSOException, DelegationException {
        if (delegationPrivilege != null) {
            try {
                String string2;
                PolicyManager policyManager = new PolicyManager(sSOToken, POLICY_REPOSITORY_REALM);
                Policy policy = this.privilegeToPolicy(policyManager, delegationPrivilege);
                if (policy != null) {
                    string2 = null;
                    if (string != null) {
                        string2 = string.toLowerCase() + NAME_DELIMITER;
                        string2 = string2.replace(',', '^');
                    } else {
                        string2 = NAME_DELIMITER;
                    }
                } else {
                    throw new DelegationException("amDelegation", "invalid_delegation_privilege", null, null);
                }
                policy.setName(string2 + policy.getName());
                policyManager.addPolicy(policy);
            }
            catch (Exception exception) {
                throw new DelegationException(exception);
            }
        }
    }

    public void removePrivilege(SSOToken sSOToken, String string, String string2) throws SSOException, DelegationException {
        try {
            PolicyManager policyManager = new PolicyManager(sSOToken, POLICY_REPOSITORY_REALM);
            String string3 = null;
            if (string != null) {
                string3 = string.toLowerCase() + NAME_DELIMITER;
                string3 = string3.replace(',', '^');
            } else {
                string3 = NAME_DELIMITER;
            }
            policyManager.removePolicy(string3 + string2);
        }
        catch (Exception exception) {
            throw new DelegationException(exception);
        }
    }

    public Set getSubjects(SSOToken sSOToken, String string, Set set, String string2) throws SSOException, DelegationException {
        HashSet<String> hashSet = new HashSet<String>();
        if (string2 != null && string2.equals("*")) {
            hashSet.add(AUTHN_USERS_ID);
        }
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl.getSubjects(): types=" + set);
        }
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(this.appToken, string);
            Set set2 = aMIdentityRepository.getSupportedIdTypes();
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.getSubjects(): supported subject types=" + set2);
            }
            if (set2 != null && !set2.isEmpty() && set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Set set3;
                    IdType idType = IdUtils.getType((String)iterator.next());
                    if (!set2.contains(idType)) continue;
                    IdSearchControl idSearchControl = new IdSearchControl();
                    idSearchControl.setRecursive(true);
                    idSearchControl.setMaxResults(-1);
                    idSearchControl.setTimeOut(-1);
                    IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(idType, string2, idSearchControl);
                    if (idSearchResults == null || (set3 = idSearchResults.getSearchResults()) == null || set3.isEmpty()) continue;
                    Iterator iterator2 = set3.iterator();
                    while (iterator2.hasNext()) {
                        AMIdentity aMIdentity = (AMIdentity)iterator2.next();
                        hashSet.add(IdUtils.getUniversalId(aMIdentity));
                    }
                }
            }
            return hashSet;
        }
        catch (IdRepoException idRepoException) {
            throw new DelegationException(idRepoException);
        }
    }

    public Set getManageableOrganizationNames(SSOToken sSOToken, Set set) throws SSOException, DelegationException {
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = this.getPermissions(sSOToken, string);
                if (set2 == null || set2.isEmpty()) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    public boolean isAllowed(SSOToken sSOToken, DelegationPermission delegationPermission, Map map) throws SSOException, DelegationException {
        SSOTokenID sSOTokenID;
        String string = null;
        boolean bl = false;
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl.isAllowed() is called");
        }
        if (sSOToken != null && (sSOTokenID = sSOToken.getTokenID()) != null && delegationPermission != null) {
            String string2 = sSOTokenID.toString();
            Set set = delegationPermission.getActions();
            if (set != null && !set.isEmpty()) {
                try {
                    Map map2;
                    string = this.getResourceName(delegationPermission);
                    PolicyDecision policyDecision = DelegationPolicyImpl.getResultFromCache(string2, string, map);
                    if (policyDecision != null) {
                        if (DelegationManager.debug.messageEnabled()) {
                            DelegationManager.debug.message("got delegation evaluation result from cache.");
                        }
                    } else {
                        policyDecision = this.pe.getPolicyDecision(sSOToken, string, null, map);
                        DelegationPolicyImpl.putResultIntoCache(string2, string, map, policyDecision);
                        if (DelegationManager.debug.messageEnabled()) {
                            DelegationManager.debug.message("put delegation evaluation result into cache.");
                        }
                    }
                    if ((map2 = policyDecision.getActionDecisions()) != null && !map2.isEmpty()) {
                        bl = true;
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext() && bl) {
                            String string3 = (String)iterator.next();
                            ActionDecision actionDecision = (ActionDecision)map2.get(string3);
                            if (actionDecision != null) {
                                Set set2 = actionDecision.getValues();
                                if (set2 != null && !set2.contains(ACTION_DENY)) continue;
                                bl = false;
                                continue;
                            }
                            bl = false;
                        }
                    }
                }
                catch (PolicyException policyException) {
                    throw new DelegationException(policyException);
                }
            }
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.isAllowed(): actions=" + set + "  resource=" + string + "  result is:" + bl);
            }
        }
        return bl;
    }

    private static PolicyDecision getResultFromCache(String string, String string2, Map map) throws SSOException, DelegationException {
        ArrayList arrayList;
        Map map2;
        if (string2 != null && (map2 = (Map)delegationCache.get((Object)string)) != null && !map2.isEmpty() && (arrayList = (ArrayList)map2.get(string2)) != null) {
            PolicyDecision policyDecision;
            Map map3 = (Map)arrayList.get(0);
            if (map == null || map.isEmpty()) {
                map = Collections.EMPTY_MAP;
            }
            if (map3 == null || map3.isEmpty()) {
                map3 = Collections.EMPTY_MAP;
            }
            if (map.equals(map3) && (policyDecision = (PolicyDecision)arrayList.get(1)) != null) {
                long l;
                long l2 = policyDecision.getTimeToLive();
                if (l2 > (l = System.currentTimeMillis())) {
                    return policyDecision;
                }
                if (DelegationManager.debug.messageEnabled()) {
                    DelegationManager.debug.message("DelegationPolicyImpl: delegation decision expired.  TTL=" + l2 + "; current time=" + l);
                }
            }
        }
        return null;
    }

    private static void putResultIntoCache(String string, String string2, Map map, PolicyDecision policyDecision) throws SSOException, DelegationException {
        if (string2 != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(0, map);
            arrayList.add(1, policyDecision);
            HashMap hashMap = (HashMap)delegationCache.get((Object)string);
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            hashMap.put(string2, arrayList);
            delegationCache.put((Object)string, hashMap);
        }
    }

    private static void cleanupCache() {
        if (delegationCache.size() > 0) {
            delegationCache = new Cache(maxCacheSize);
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.cleanupCache(): cache cleared");
            }
        }
    }

    public Set getPermissions(SSOToken sSOToken, String string) throws SSOException, DelegationException {
        HashSet<DelegationPrivilege> hashSet = new HashSet<DelegationPrivilege>();
        AMIdentity aMIdentity = null;
        AMIdentity aMIdentity2 = null;
        IdSearchResults idSearchResults = null;
        if (sSOToken == null) {
            if (DelegationManager.debug.warningEnabled()) {
                DelegationManager.debug.warning("DelegationPolicyImpl.getPermissions():user sso token is null");
            }
            return hashSet;
        }
        try {
            aMIdentity = IdUtils.getIdentity(sSOToken);
            if (aMIdentity == null) {
                if (DelegationManager.debug.warningEnabled()) {
                    DelegationManager.debug.warning("DelegationPolicyImpl.getPermissions():could not get user's identity from token");
                }
                return hashSet;
            }
            Set set = this.getPrivileges(this.appToken, string);
            if (set != null && !set.isEmpty()) {
                AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(this.appToken, string);
                IdSearchControl idSearchControl = new IdSearchControl();
                idSearchControl.setRecursive(true);
                idSearchControl.setMaxResults(-1);
                idSearchControl.setTimeOut(-1);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    DelegationPrivilege delegationPrivilege = (DelegationPrivilege)iterator.next();
                    Set set2 = delegationPrivilege.getSubjects();
                    if (set2 == null || set2.isEmpty()) continue;
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        Set set3;
                        String string2 = (String)iterator2.next();
                        String string3 = new DN(string2).explodeDN(true)[0];
                        if (string3 == null || (idSearchResults = aMIdentityRepository.searchIdentities(IdType.ROLE, string3, idSearchControl)) == null || (set3 = idSearchResults.getSearchResults()) == null || set3.isEmpty() || !aMIdentity.isMember(aMIdentity2 = (AMIdentity)set3.iterator().next())) continue;
                        hashSet.add(delegationPrivilege);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new DelegationException(exception);
        }
        return hashSet;
    }

    private Policy privilegeToPolicy(PolicyManager policyManager, DelegationPrivilege delegationPrivilege) throws DelegationException {
        try {
            Object object;
            Object object2;
            Cloneable cloneable;
            String string = delegationPrivilege.getName();
            Policy policy = new Policy(string);
            String string2 = this.getResourceName(delegationPrivilege);
            HashMap hashMap = new HashMap();
            Set set = delegationPrivilege.getActions();
            if (set != null) {
                cloneable = new HashSet<String>();
                cloneable.add(ACTION_ALLOW);
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    hashMap.put((String)object, cloneable);
                }
            }
            cloneable = new Rule(DELEGATION_RULE, "sunAMDelegationService", string2, hashMap);
            policy.addRule((Rule)cloneable);
            object2 = new HashSet(delegationPrivilege.getSubjects());
            if (object2 != null && object2.contains(AUTHN_USERS_ID)) {
                object = policyManager.getSubjectTypeManager().getSubject("AuthenticatedUsers");
                policy.addSubject("AuthenticatedUsers", (Subject)object);
                object2.remove(AUTHN_USERS_ID);
            }
            object = policyManager.getSubjectTypeManager().getSubject(POLICY_SUBJECT);
            object.setValues((Set)object2);
            policy.addSubject(DELEGATION_SUBJECT, (Subject)object);
            return policy;
        }
        catch (Exception exception) {
            DelegationManager.debug.error("unable to convert a privilege to a policy", (Throwable)exception);
            throw new DelegationException(exception);
        }
    }

    private DelegationPrivilege policyToPrivilege(Policy policy) throws DelegationException {
        String string = null;
        String string2 = null;
        Set set = null;
        HashSet<String> hashSet = new HashSet<String>();
        if (policy == null) {
            return null;
        }
        try {
            Cloneable cloneable;
            Object object;
            string = policy.getName();
            Set set2 = policy.getSubjectNames();
            if (set2 != null && !set2.isEmpty()) {
                if (set2.contains("AuthenticatedUsers")) {
                    hashSet.add(AUTHN_USERS_ID);
                }
                if (set2.contains(DELEGATION_SUBJECT) && (object = (cloneable = policy.getSubject(DELEGATION_SUBJECT)).getValues()) != null) {
                    hashSet.addAll((Collection<String>)object);
                }
            }
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("SubjectValues=" + hashSet);
            }
            if ((cloneable = policy.getRule(DELEGATION_RULE)) != null && ((String)(object = ((Rule)cloneable).getServiceTypeName())).equalsIgnoreCase("sunAMDelegationService")) {
                string2 = ((Rule)cloneable).getResourceName();
                set = ((Rule)cloneable).getActionNames();
            }
            if (string2.startsWith(PREFIX)) {
                object = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                boolean bl = false;
                String string7 = string2.substring(PREFIX.length());
                if (string7 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string7, DELIMITER);
                    object = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                            if (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                                if (stringTokenizer.hasMoreTokens()) {
                                    string6 = stringTokenizer.nextToken();
                                    while (stringTokenizer.hasMoreTokens()) {
                                        string6 = string6 + DELIMITER + stringTokenizer.nextToken();
                                    }
                                }
                            }
                        }
                    }
                    return new DelegationPrivilege(string, hashSet, (String)object, string3, string4, string5, string6, set, null);
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw new DelegationException(exception);
        }
    }

    private String getResourceName(DelegationPermission delegationPermission) {
        String string = delegationPermission.getOrganizationName();
        String string2 = delegationPermission.getServiceName();
        String string3 = delegationPermission.getVersion();
        String string4 = delegationPermission.getConfigType();
        String string5 = delegationPermission.getSubConfigName();
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(PREFIX);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(DELIMITER);
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(DELIMITER);
        }
        if (string3 != null) {
            stringBuffer.append(string3);
            stringBuffer.append(DELIMITER);
        }
        if (string4 != null) {
            stringBuffer.append(string4);
            stringBuffer.append(DELIMITER);
        }
        if (string5 != null) {
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }

    public void schemaChanged(String string, String string2) {
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: org config changed: " + string3);
        }
        Map map = idRepoListeners;
        synchronized (map) {
            if (n == 1) {
                if (idRepoListeners.get(string3) == null) {
                    try {
                        AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(this.appToken, string3);
                        aMIdentityRepository.addEventListener(this);
                        idRepoListeners.put(string3, aMIdentityRepository);
                        if (DelegationManager.debug.messageEnabled()) {
                            DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener added for realm (" + string3 + ").");
                        }
                    }
                    catch (Exception exception) {
                        DelegationManager.debug.error("DelegationPolicyImpl: failed to process organization config changes. ", (Throwable)exception);
                    }
                }
            } else if (n == 2) {
                idRepoListeners.remove(string3);
                if (DelegationManager.debug.messageEnabled()) {
                    DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener removed for realm (" + string3 + ").");
                }
            }
        }
    }

    public void identityChanged(String string) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: changed universalId=" + string);
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public void identityDeleted(String string) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: deleted universalId=" + string);
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public void identityRenamed(String string) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: renamed universalId=" + string);
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public void allIdentitiesChanged() {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: all identities changed.");
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public String getServiceTypeName() {
        return "sunAMDelegationService";
    }

    public void policyChanged(PolicyEvent policyEvent) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: delegation policy changed.");
        }
        DelegationPolicyImpl.cleanupCache();
    }

    static {
        maxCacheSize = 20000;
        idRepoListeners = new HashMap();
    }
}

