/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DelegationUtils {
    static final Debug debug = DelegationManager.debug;
    static final String REALM_NAME_TAG = "REALM";
    static final String SUBJECTS_IN_LEGACY_MODE = "defaultSubjectInLegacyMode";

    public static void createRealmPrivileges(SSOToken sSOToken, String string) throws SSOException, DelegationException {
        DelegationPrivilege delegationPrivilege = null;
        HashSet<String> hashSet = null;
        ServiceConfig serviceConfig = null;
        String string2 = DNMapper.orgNameToDN(string);
        DelegationManager delegationManager = new DelegationManager(sSOToken, string);
        Set set = delegationManager.getConfiguredPrivilegeNames();
        if (set == null || set.isEmpty()) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("DelegationUtils:Getting global privileges");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            serviceConfig = DelegationUtils.getServiceConfig(null, string3, true);
            Map map = serviceConfig.getAttributes();
            if (map == null || map.isEmpty()) {
                throw new DelegationException("amDelegation", "get_privilege_attrs_failed", null, null);
            }
            Set set2 = (Set)map.get(SUBJECTS_IN_LEGACY_MODE);
            if (set2 != null && !set2.isEmpty()) {
                Iterator iterator2 = set2.iterator();
                hashSet = new HashSet<String>();
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    hashSet.add(DelegationUtils.swapRealmTag(string2, string4));
                }
            }
            delegationPrivilege = new DelegationPrivilege(string3, hashSet, string);
            delegationManager.addPrivilege(delegationPrivilege);
            if (!debug.messageEnabled()) continue;
            debug.message("added " + string3 + " privilege in realm " + string);
        }
    }

    public static void copyRealmPrivilegesFromParent(SSOToken sSOToken, OrganizationConfigManager organizationConfigManager, OrganizationConfigManager organizationConfigManager2) throws SSOException, DelegationException {
        if (debug.messageEnabled()) {
            debug.message("DelegationUtils.copyRealmPrivilegesFromParent Parent org: " + organizationConfigManager.getOrganizationName() + " Child org: " + organizationConfigManager2.getOrganizationName());
        }
        DelegationManager delegationManager = new DelegationManager(sSOToken, organizationConfigManager.getOrganizationName());
        DelegationManager delegationManager2 = new DelegationManager(sSOToken, organizationConfigManager2.getOrganizationName());
        String string = DNMapper.orgNameToDN(organizationConfigManager2.getOrganizationName());
        Set set = delegationManager.getPrivileges();
        if (set == null || set.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("DelegationUtils.copyRealmPrivilegesFromParent: No privilege subjects in parent");
            }
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DelegationPrivilege delegationPrivilege = (DelegationPrivilege)iterator.next();
            Set set2 = delegationPrivilege.getSubjects();
            if (set2 == null || set2.isEmpty()) {
                if (!debug.messageEnabled()) continue;
                debug.message("DelegationUtils.copyRealmPrivilegesFromParent: No subjects in privilege: " + delegationPrivilege);
                continue;
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                try {
                    AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string2);
                    AMIdentity aMIdentity2 = new AMIdentity(sSOToken, aMIdentity.getName(), aMIdentity.getType(), string, aMIdentity.getDN());
                    hashSet.add(IdUtils.getUniversalId(aMIdentity2));
                }
                catch (IdRepoException idRepoException) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("DelegationUtils.copyRealmPrivilegesFromParent: IdRepoException for: " + delegationPrivilege, (Throwable)idRepoException);
                }
            }
            delegationPrivilege.setSubjects(hashSet);
            delegationPrivilege.setOrganizationName("*" + string);
            delegationManager2.addPrivilege(delegationPrivilege);
            if (!debug.messageEnabled()) continue;
            debug.message("DelegationUtils.copyRealmPrivilegesFromParent: Privilege copied from parent: " + delegationPrivilege);
        }
    }

    public static void deleteRealmPrivileges(SSOToken sSOToken, String string) throws SSOException, DelegationException {
        DelegationManager delegationManager = new DelegationManager(sSOToken, string);
        Set set = delegationManager.getPrivileges();
        if (set == null || set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DelegationPrivilege delegationPrivilege = (DelegationPrivilege)iterator.next();
            String string2 = delegationPrivilege.getName();
            delegationManager.removePrivilege(string2);
            if (!debug.messageEnabled()) continue;
            debug.message("removed " + string2 + " privilege from realm " + string);
        }
    }

    static ServiceConfig getServiceConfig(String string, String string2, boolean bl) throws SSOException, DelegationException {
        ServiceConfig serviceConfig = null;
        ServiceConfig serviceConfig2 = null;
        ServiceConfig serviceConfig3 = null;
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("sunAMDelegationService", DelegationManager.getAdminToken());
            serviceConfig = bl ? serviceConfigManager.getGlobalConfig(null) : serviceConfigManager.getOrganizationConfig(string, null);
        }
        catch (SMSException sMSException) {
            throw new DelegationException("amDelegation", "get_org_config_failed", null, sMSException);
        }
        if (serviceConfig == null) {
            throw new DelegationException("amDelegation", "get_perms_config_failed", null, null);
        }
        try {
            serviceConfig2 = serviceConfig.getSubConfig("Permissions");
        }
        catch (SMSException sMSException) {
            throw new DelegationException("amDelegation", "get_perms_config_failed", null, sMSException);
        }
        try {
            serviceConfig3 = serviceConfig2.getSubConfig(string2);
        }
        catch (SMSException sMSException) {
            throw new DelegationException("amDelegation", "get_privilege_config_failed", null, sMSException);
        }
        return serviceConfig3;
    }

    static String swapRealmTag(String string, String string2) {
        int n = REALM_NAME_TAG.length();
        int n2 = string2.indexOf(REALM_NAME_TAG);
        while (n2 >= 0) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + n);
            string2 = string3 + string + string4;
            n2 = string2.indexOf(REALM_NAME_TAG);
        }
        return string2;
    }
}

