/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.util;

import java.io.ByteArrayInputStream;

public class DerValue {
    private byte tag = 0;
    private int length = 0;
    private byte[] data = null;

    public DerValue(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.init(byteArrayInputStream);
    }

    public DerValue(ByteArrayInputStream byteArrayInputStream) {
        this.init(byteArrayInputStream);
    }

    public byte getTag() {
        return this.tag;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    private void init(ByteArrayInputStream byteArrayInputStream) {
        this.tag = (byte)byteArrayInputStream.read();
        this.length = this.getLength(byteArrayInputStream);
        this.data = new byte[this.length];
        byteArrayInputStream.read(this.data, 0, this.length);
    }

    private int getLength(ByteArrayInputStream byteArrayInputStream) {
        int n = 0;
        int n2 = byteArrayInputStream.read();
        if ((n2 & 0x80) == 0) {
            n = n2;
        } else {
            n2 &= 0x7F;
            n = 0;
            while (n2 > 0) {
                byte by = (byte)byteArrayInputStream.read();
                n = n * 256 + (by & 0xFF);
                --n2;
            }
        }
        return n;
    }

    public static String printByte(byte by) {
        return Integer.toHexString((by & 0xF0) >> 4 & 0xF) + Integer.toHexString(by & 0xF & 0xF);
    }

    public static String printByteArray(byte[] byArray, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 16;
        int n5 = 1;
        while (n5 * n4 < n2) {
            n3 = 0;
            while (n3 < n4) {
                stringBuffer.append(DerValue.printByte(byArray[(n5 - 1) * n4 + n3 + n]) + " ");
                ++n3;
            }
            stringBuffer.append("\n");
            ++n5;
        }
        if (--n5 * n4 < n2) {
            n3 = n5 * n4;
            while (n3 < n2) {
                stringBuffer.append(DerValue.printByte(byArray[n3 + n]) + " ");
                ++n3;
            }
        }
        return stringBuffer.toString();
    }
}

