/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AMAuthCallBack;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMAuthCallBackImpl {
    static final String AUTH_PLUGIN_MODULES_ATTR = "sunAMUserStatusCallbackPlugins";
    static final String DEBUG_FILE = "amAuth";
    static final String bundleName = "amAuth";
    private static Debug debug = Debug.getInstance((String)"amAuth");
    private static Map theCallBackInst = new HashMap();
    private Set pluginSet;
    private String theRealm;

    private AMAuthCallBackImpl(String string) throws AMAuthCallBackException {
        SSOToken sSOToken;
        block3: {
            this.pluginSet = Collections.EMPTY_SET;
            this.theRealm = null;
            this.theRealm = string;
            sSOToken = null;
            if (debug.messageEnabled()) {
                debug.message("AMAuthCallBackImpl : in constructor. Realm = " + this.theRealm);
            }
            try {
                sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
            catch (NullPointerException nullPointerException) {
                if (!debug.errorEnabled()) break block3;
                debug.error("AMAuthCallBackImpl : constructor cannot get SSO Token. No callbacks will be made for the realm : " + this.theRealm, (Throwable)nullPointerException);
            }
        }
        this.pluginSet = this.getRealmAuthPlugIns(sSOToken, AUTH_PLUGIN_MODULES_ATTR);
    }

    public static final AMAuthCallBackImpl getInstance(String string) throws AMAuthCallBackException {
        if (debug.messageEnabled()) {
            debug.message("AMAuthCallBackImpl : getting instance.");
        }
        Map map = theCallBackInst;
        synchronized (map) {
            if (theCallBackInst.get(string) == null) {
                theCallBackInst.put(string, new AMAuthCallBackImpl(string));
            }
        }
        return (AMAuthCallBackImpl)theCallBackInst.get(string);
    }

    public void processedPasswordChange(Long l, String string) throws AMAuthCallBackException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timechanged", l);
        hashMap.put("realm", this.theRealm);
        hashMap.put("userdn", string);
        this.processedEvent(1, hashMap);
    }

    public void processedAccounttLockout(Long l, String string) throws AMAuthCallBackException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timechanged", l);
        hashMap.put("realm", this.theRealm);
        hashMap.put("userdn", string);
        this.processedEvent(2, hashMap);
    }

    public void processedEvent(int n, Map map) throws AMAuthCallBackException {
        if (this.pluginSet != Collections.EMPTY_SET) {
            Iterator iterator = this.pluginSet.iterator();
            while (iterator.hasNext()) {
                AMAuthCallBack aMAuthCallBack = this.instantiateClass((String)iterator.next());
                if (aMAuthCallBack == null) continue;
                aMAuthCallBack.authEventCallback(n, map);
            }
        }
        if (this.pluginSet.isEmpty() && debug.messageEnabled()) {
            debug.message("AMAuthCallBackImpl : processedEvent. pluginSet is empty");
        }
    }

    private Set getRealmAuthPlugIns(SSOToken sSOToken, String string) {
        Set set = Collections.EMPTY_SET;
        try {
            block8: {
                try {
                    ServiceConfigManager serviceConfigManager = new ServiceConfigManager("iPlanetAMAuthService", sSOToken);
                    ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(this.theRealm, null);
                    if (serviceConfig != null) {
                        Map map = serviceConfig.getAttributes();
                        set = (Set)map.get(AUTH_PLUGIN_MODULES_ATTR);
                        break block8;
                    }
                    ServiceConfig serviceConfig2 = serviceConfigManager.getGlobalConfig(null);
                    if (serviceConfig2 == null) break block8;
                    Map map = serviceConfig2.getAttributes();
                    set = (Set)map.get(AUTH_PLUGIN_MODULES_ATTR);
                }
                catch (SMSException sMSException) {
                    if (debug.errorEnabled()) {
                        debug.error("AMAuthCallBackImpl getRealmAuthPlugIns : SMS error", (Throwable)sMSException);
                    }
                    Object var9_12 = null;
                    return set;
                }
                catch (SSOException sSOException) {
                    if (debug.errorEnabled()) {
                        debug.error("AMAuthCallBackImpl getRealmAuthPlugIns : SSO error", (Throwable)sSOException);
                    }
                    Object var9_13 = null;
                    return set;
                }
            }
            Object var9_11 = null;
            return set;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            return set;
        }
    }

    private AMAuthCallBack instantiateClass(String string) {
        try {
            if (debug.messageEnabled()) {
                debug.message("AMAuthCallBackImpl : instantiateClass. Class name is : " + string);
            }
            return (AMAuthCallBack)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.error("AuthCallBackImpl.instantiateClass(): Unable to locate class " + string, (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            debug.error("AuthCallBackImpl.instantiateClass(): Unable to instantiate class " + string, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.error("AuthCallBackImpl.instantiateClass(): Problem with the Security Manager for class " + string, (Throwable)illegalAccessException);
        }
        catch (Exception exception) {
            debug.error("AMCallBackImpl.instantiateClass(): Unknown error for class " + string, (Throwable)exception);
        }
        return null;
    }
}

