/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthThreadManager;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStateCallback;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DSAMECallbackHandler
implements CallbackHandler {
    static Debug debug = Debug.getInstance((String)"amCallback");
    AMLoginContext am;
    LoginState loginState;
    Callback[] submitRequiredInfo = null;
    static AuthThreadManager authThreadManager;
    String sid = null;

    public DSAMECallbackHandler() {
    }

    public DSAMECallbackHandler(AMLoginContext aMLoginContext) {
        this.am = aMLoginContext;
        authThreadManager = AMLoginContext.authThread;
        this.loginState = aMLoginContext.getLoginState();
    }

    private void setPageTimeout(Callback[] callbackArray) {
        long l = this.getTimeOut(callbackArray);
        this.loginState.setPageTimeOut(l);
        long l2 = System.currentTimeMillis();
        this.loginState.setLastCallbackSent(l2);
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (debug.messageEnabled()) {
            debug.message("callback handler method");
        }
        if (callbackArray.length == 1 && callbackArray[0] instanceof LoginStateCallback) {
            debug.message("LoginState Callbacks");
            ((LoginStateCallback)callbackArray[0]).setLoginState(this.loginState);
        } else {
            if (this.am.isPureJAAS()) {
                this.setPageTimeout(callbackArray);
                this.loginState.setSubmittedCallback(null, this.am);
                this.loginState.setReceivedCallback(callbackArray, this.am);
                Thread thread = Thread.currentThread();
                if (debug.messageEnabled()) {
                    debug.message("waiting for submitted info " + thread);
                }
                callbackArray = this.am.submitCallbackInfo();
                if (authThreadManager.isTimedOut(thread)) {
                    this.loginState.setTimedOut(true);
                    this.loginState.setReceivedCallback(null, this.am);
                    authThreadManager.removeFromHash(thread, "timedOutHash");
                    throw new IOException("110");
                }
                this.checkLoginTimeout();
            } else if (this.loginState.getSubmittedInfo() != null) {
                debug.message("DSAMEHandler: found submitted callbacks !");
                this.checkLoginTimeout();
                Callback[] callbackArray2 = this.loginState.getSubmittedInfo();
                this.copyCallbacks(callbackArray, callbackArray2);
                this.loginState.setReceivedCallback_NoThread(null);
            } else {
                this.setPageTimeout(callbackArray);
                this.loginState.setReceivedCallback_NoThread(callbackArray);
                debug.message("Set callbacks, throwing java.lang.Error.");
                throw new Error("return from DSAMECallback");
            }
            if (debug.messageEnabled()) {
                debug.message("DSAMECAllbackhandler..." + callbackArray);
            }
            if (this.am.isPureJAAS()) {
                this.loginState.setReceivedCallback(null, this.am);
            }
        }
    }

    private void copyCallbacks(Callback[] callbackArray, Callback[] callbackArray2) {
        int n = callbackArray.length;
        int n2 = callbackArray2.length;
        if (n == n2) {
            for (int i = 0; i < n; ++i) {
                if (callbackArray[i] == callbackArray2[i]) continue;
                callbackArray[i] = callbackArray2[i];
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            while (callbackArray[n3] instanceof PagePropertiesCallback) {
                ++n3;
            }
            while (callbackArray2[n4] instanceof PagePropertiesCallback) {
                ++n4;
            }
            int n5 = n - n3;
            if (n5 > n2 - n4) {
                n5 = n2 - n4;
            }
            for (int i = 0; i < n5; ++i) {
                if (callbackArray[n3] != callbackArray2[n4]) {
                    callbackArray[n3] = callbackArray2[n4];
                }
                ++n3;
                ++n4;
            }
        }
    }

    long getTimeOut(Callback[] callbackArray) {
        long l = 60L;
        if (callbackArray != null && callbackArray[0] instanceof PagePropertiesCallback) {
            PagePropertiesCallback pagePropertiesCallback = (PagePropertiesCallback)callbackArray[0];
            l = new Integer(pagePropertiesCallback.getTimeOutValue()).longValue();
        }
        return l;
    }

    void checkLoginTimeout() throws IOException {
        long l;
        long l2;
        long l3 = this.loginState.getLastCallbackSent();
        if (l3 + ((l2 = this.loginState.getPageTimeOut()) - 3L) * 1000L < (l = System.currentTimeMillis())) {
            debug.error(" Page Timeout ");
            this.loginState.setTimedOut(true);
            this.loginState.setReceivedCallback(null, this.am);
            throw new IOException("110");
        }
    }
}

