/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.services.cdm.AuthClient;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.common.ResourceLookup;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class AuthUtils {
    private static final String DEFAULT_CLIENT_TYPE = "genericHTML";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_FILE_PATH = "html";
    private static final boolean DEFAULT_COOKIE_SUPPORT = false;
    private static final String DSAME_VERSION = "7.0";
    public static final String ERROR_MESSAGE = "Error_Message";
    public static final String ERROR_TEMPLATE = "Error_Template";
    public static final String MSG_DELIMITER = "|";
    public static final String BUNDLE_NAME = "amAuth";
    private static boolean setRequestEncoding = false;
    private static ArrayList pureJAASModuleClasses = new ArrayList();
    private static ArrayList ISModuleClasses = new ArrayList();
    private static AMClientDetector clientDetector;
    private static Client defaultClient;
    private static FQDNUtils fqdnUtils;
    private static Hashtable moduleService;
    private static ResourceBundle bundle;
    private static final boolean urlRewriteInPath;
    private static final String templatePath;
    private static final String rootSuffix;
    private static String dsameVersion;
    private static String cookieName;
    private static String authCookieName;
    private static String loadBalanceCookieName;
    private static String persistentCookieName;
    private static String loadBalanceCookieValue;
    private static String serviceURI;
    private static String webContainer;
    private static String amCookieEncodeMode;
    private static String serverURL;
    static Debug utilDebug;

    public AuthUtils() {
        utilDebug.message("AuthUtil: constructor");
    }

    public InternalSession getSession(AuthContextLocal authContextLocal) {
        InternalSession internalSession = AuthUtils.getLoginState(authContextLocal).getSession();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("returning session : " + internalSession);
        }
        return internalSession;
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionID sessionID, boolean bl, boolean bl2) throws AuthException {
        return AuthUtils.getAuthContext(httpServletRequest, httpServletResponse, sessionID, bl, bl2, false);
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionID sessionID, boolean bl, boolean bl2, boolean bl3) throws AuthException {
        AuthContextLocal authContextLocal;
        block18: {
            utilDebug.message("In AuthUtils:getAuthContext");
            authContextLocal = null;
            LoginState loginState = null;
            AuthD authD = AuthD.getAuth();
            try {
                Hashtable hashtable = AuthUtils.parseRequestParameters(httpServletRequest);
                authContextLocal = AuthUtils.retrieveAuthContext(httpServletRequest, sessionID);
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("AuthUtil:getAuthContext:sid is.. .: " + sessionID);
                    utilDebug.message("AuthUtil:getAuthContext:authContext is.. .: " + authContextLocal);
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("isSessionUpgrade  :" + bl);
                    utilDebug.message("BACK with Request method POST : " + bl2);
                }
                if (authContextLocal == null && bl3) {
                    return null;
                }
                if (authContextLocal == null || bl || bl2) {
                    try {
                        loginState = new LoginState();
                        if (bl) {
                            loginState.setPrevAuthContext(authContextLocal);
                            loginState.setSessionUpgrade(bl);
                        } else if (bl2) {
                            loginState.setPrevAuthContext(authContextLocal);
                        }
                        authContextLocal = loginState.createAuthContext(httpServletRequest, httpServletResponse, sessionID, hashtable);
                        authContextLocal.setLoginState(loginState);
                        String string = AuthUtils.getQueryOrgName(httpServletRequest, AuthUtils.getOrgParam(hashtable));
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("query org is .. : " + string);
                        }
                        loginState.setQueryOrg(string);
                        break block18;
                    }
                    catch (AuthException authException) {
                        utilDebug.message("Error creating AuthContextLocal : ");
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("Exception ", (Throwable)((Object)authException));
                        }
                        throw new AuthException((Throwable)((Object)authException));
                    }
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("getAuthContext: found existing request.");
                }
                try {
                    authContextLocal = AuthUtils.processAuthContext(authContextLocal, httpServletRequest, httpServletResponse, hashtable, sessionID);
                    loginState = AuthUtils.getLoginState(authContextLocal);
                    loginState.setRequestType(false);
                }
                catch (AuthException authException) {
                    utilDebug.message("Error Retrieving AuthContextLocal");
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("Exception ", (Throwable)((Object)authException));
                    }
                    throw new AuthException("102", null);
                }
            }
            catch (Exception exception) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Error creating AuthContextLocal : " + exception.getMessage());
                }
                throw new AuthException(exception);
            }
        }
        return authContextLocal;
    }

    static AuthContextLocal processAuthContext(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, SessionID sessionID) throws AuthException {
        AuthD authD = AuthD.getAuth();
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        InternalSession internalSession = null;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("in processAuthContext authcontext : " + authContextLocal);
            utilDebug.message("in processAuthContext request : " + httpServletRequest);
            utilDebug.message("in processAuthContext response : " + httpServletResponse);
            utilDebug.message("in processAuthContext sid : " + sessionID);
        }
        if (AuthUtils.newSessionArgExists(hashtable, sessionID) && loginState.getLoginStatus() == 3) {
            utilDebug.message("newSession arg exists");
            AuthUtils.destroySession(loginState);
            try {
                loginState = new LoginState();
                authContextLocal = loginState.createAuthContext(httpServletRequest, httpServletResponse, sessionID, hashtable);
                authContextLocal.setLoginState(loginState);
                String string = AuthUtils.getQueryOrgName(httpServletRequest, AuthUtils.getOrgParam(hashtable));
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("query org is .. : " + string);
                }
                loginState.setQueryOrg(string);
            }
            catch (AuthException authException) {
                utilDebug.message("Error creating AuthContextLocal");
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Exception ", (Throwable)((Object)authException));
                }
                throw new AuthException("102", null);
            }
        } else {
            utilDebug.message("new session arg does not exist");
            loginState.setHttpServletRequest(httpServletRequest);
            loginState.setHttpServletResponse(httpServletResponse);
            loginState.setParamHash(hashtable);
            internalSession = AuthD.getSession(sessionID);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtil :Session is .. : " + internalSession);
            }
            loginState.setSession(internalSession);
            loginState.persistentCookieArgExists();
            loginState.setRequestLocale(httpServletRequest);
        }
        return authContextLocal;
    }

    public static LoginState getLoginState(AuthContextLocal authContextLocal) {
        LoginState loginState = null;
        if (authContextLocal != null) {
            loginState = authContextLocal.getLoginState();
        }
        return loginState;
    }

    public static Hashtable parseRequestParameters(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        return AuthUtils.decodeHash(httpServletRequest, enumeration);
    }

    private static Hashtable decodeHash(HttpServletRequest httpServletRequest, Enumeration enumeration) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = httpServletRequest.getParameter("gx_charset");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils::decodeHash:enc = " + string);
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = httpServletRequest.getParameter(string2);
            if (setRequestEncoding) {
                hashtable.put(string2, com.iplanet.am.util.Locale.URLDecodeField((String)string3, (String)string, (Debug)AuthD.debug));
                continue;
            }
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    public Hashtable getRequestParameters(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            return loginState.getRequestParamHash();
        }
        return new Hashtable();
    }

    public static String getSidString(AuthContextLocal authContextLocal) throws AuthException {
        String string = null;
        try {
            SessionID sessionID;
            LoginState loginState;
            if (authContextLocal != null && (loginState = authContextLocal.getLoginState()) != null && (sessionID = loginState.getSid()) != null) {
                string = sessionID.toString();
            }
        }
        catch (Exception exception) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error retreiving sid.. :" + exception.getMessage());
            }
            throw new AuthException("noSid", new Object[]{exception.getMessage()});
        }
        return string;
    }

    public Cookie getCookieString(AuthContextLocal authContextLocal, String string) {
        Cookie cookie;
        block4: {
            cookie = null;
            String string2 = AuthUtils.getCookieName();
            try {
                String string3 = AuthUtils.getSidString(authContextLocal);
                LoginState loginState = AuthUtils.getLoginState(authContextLocal);
                if (loginState != null && loginState.isSessionInvalid()) {
                    string2 = AuthUtils.getAuthCookieName();
                    utilDebug.message("Create AM AUTH cookie");
                }
                cookie = this.createCookie(string2, string3, string);
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error getting sid : " + exception.getMessage());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Cookie is : " + cookie);
        }
        return cookie;
    }

    public Cookie getLogoutCookie(AuthContextLocal authContextLocal, String string) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        SessionID sessionID = loginState.getSid();
        String string2 = AuthUtils.getLogoutCookieString(sessionID);
        Cookie cookie = this.createCookie(string2, string);
        cookie.setMaxAge(0);
        return cookie;
    }

    public Cookie getLogoutCookie(SessionID sessionID, String string) {
        String string2 = AuthUtils.getLogoutCookieString(sessionID);
        Cookie cookie = this.createCookie(string2, string);
        cookie.setMaxAge(0);
        return cookie;
    }

    public static String getLogoutCookieString(SessionID sessionID) {
        String string;
        block3: {
            string = null;
            try {
                string = (String)AccessController.doPrivileged(new EncodeAction("LOGOUT@" + sessionID.getSessionServerProtocol() + "@" + sessionID.getSessionServer() + "@" + sessionID.getSessionServerPort() + "@" + sessionID.getSessionDomain(), Crypt.getHardcodedKeyEncryptor()));
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Logout cookie : " + string);
                }
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block3;
                utilDebug.message("Error creating cookie : " + exception.getMessage());
            }
        }
        return string;
    }

    public Cookie createCookie(String string, String string2) {
        String string3 = AuthUtils.getCookieName();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("cookieName : " + string3);
            utilDebug.message("cookieValue : " + string);
            utilDebug.message("cookieDomain : " + string2);
        }
        return this.createCookie(string3, string, string2);
    }

    public boolean isNewRequest(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState.isNewRequest()) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("this is a newRequest");
            }
            return true;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("this is an existing request");
        }
        return false;
    }

    public String getLoginSuccessURL(AuthContextLocal authContextLocal) {
        String string = null;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        string = loginState == null ? AuthD.getAuth().defaultSuccessURL : AuthUtils.getLoginState(authContextLocal).getSuccessLoginURL();
        return string;
    }

    public String getLoginFailedURL(AuthContextLocal authContextLocal) {
        try {
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            if (loginState == null) {
                return AuthD.getAuth().defaultFailureURL;
            }
            String string = loginState.getFailureLoginURL();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtils: getLoginFailedURL " + string);
            }
            return string;
        }
        catch (Exception exception) {
            utilDebug.message("Exception ", (Throwable)exception);
            return null;
        }
    }

    public String getFileName(AuthContextLocal authContextLocal, String string) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        String string2 = null;
        if (loginState != null) {
            string2 = AuthUtils.getLoginState(authContextLocal).getFileName(string);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getFileName:AuthUtilsFile name is :" + string2);
        }
        return string2;
    }

    public boolean getInetDomainStatus(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).getInetDomainStatus();
    }

    public static boolean newSessionArgExists(Hashtable hashtable, SessionID sessionID) {
        String string = (String)hashtable.get("arg");
        if (string != null && string.equals("newsession")) {
            return AuthUtils.retrieveAuthContext(sessionID) != null;
        }
        return false;
    }

    public String encodeURL(String string, AuthContextLocal authContextLocal, HttpServletResponse httpServletResponse) {
        LoginState loginState;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils:input url is :" + string);
        }
        String string2 = (loginState = AuthUtils.getLoginState(authContextLocal)) == null ? string : loginState.encodeURL(string, httpServletResponse);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils:encoded url is :" + string2);
        }
        return string2;
    }

    public String getLocale(AuthContextLocal authContextLocal) {
        AuthD authD = AuthD.getAuth();
        if (authContextLocal == null) {
            return authD.getPlatformLocale();
        }
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return authD.getPlatformLocale();
        }
        return loginState.getLocale();
    }

    public static String getQueryOrgName(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        if (string != null && !string.equals("")) {
            string2 = string;
        } else if (httpServletRequest != null) {
            string2 = httpServletRequest.getServerName();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("queryOrg is :" + string2);
        }
        return string2;
    }

    static void destroySession(LoginState loginState) {
        try {
            if (loginState != null) {
                loginState.destroySession();
            }
        }
        catch (Exception exception) {
            utilDebug.message("Error destroySEssion : ", (Throwable)exception);
        }
    }

    public void destroySession(AuthContextLocal authContextLocal) {
        if (authContextLocal != null) {
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            AuthUtils.destroySession(loginState);
        }
    }

    public static void printCookies(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            utilDebug.message("No Cookie in header");
            return;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!utilDebug.messageEnabled()) continue;
            utilDebug.message("Received Cookie:" + cookieArray[i].getName() + " = " + cookieArray[i].getValue());
        }
    }

    public boolean sessionTimedOut(AuthContextLocal authContextLocal) {
        boolean bl = false;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            bl = loginState.isTimedOut();
            if (!bl) {
                InternalSession internalSession = loginState.getSession();
                if (internalSession == null && AuthD.isHttpSessionUsed()) {
                    HttpSession httpSession = loginState.getHttpSession();
                    bl = httpSession == null;
                } else if (internalSession != null) {
                    bl = internalSession.isTimedOut();
                }
                loginState.setTimedOut(bl);
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtils.sessionTimedOut: " + bl);
            }
        }
        return bl;
    }

    public static void printHash(Hashtable hashtable) {
        block6: {
            try {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("AuthRequest: In printHash" + hashtable);
                }
                if (hashtable == null) {
                    return;
                }
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = hashtable.get(k);
                    utilDebug.message("printHash Key is : " + k);
                    if (!(v instanceof String[])) continue;
                    String[] stringArray = (String[])v;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!utilDebug.messageEnabled()) continue;
                        utilDebug.message("printHash : String[] keyname (" + k + ") = " + stringArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block6;
                utilDebug.warning("Exception: printHash :", (Throwable)exception);
            }
        }
    }

    public boolean isPersistentCookieOn(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).isPersistentCookieOn();
    }

    public boolean getPersistentCookieMode(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal).getPersistentCookieMode();
    }

    public Cookie getPersistentCookieString(AuthContextLocal authContextLocal, String string) {
        return null;
    }

    public String searchPersistentCookie(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        return loginState.searchPersistentCookie();
    }

    public Cookie createPersistentCookie(AuthContextLocal authContextLocal, String string) throws AuthException {
        Cookie cookie = null;
        try {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieDomain : " + string);
            }
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            cookie = loginState.setPersistentCookie(string);
            return cookie;
        }
        catch (Exception exception) {
            utilDebug.message("Unable to create persistent Cookie");
            throw new AuthException("102", null);
        }
    }

    public Cookie createlbCookie(AuthContextLocal authContextLocal, String string, boolean bl) throws AuthException {
        Cookie cookie = null;
        try {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieDomain : " + string);
            }
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            cookie = loginState.setlbCookie(string, bl);
            return cookie;
        }
        catch (Exception exception) {
            utilDebug.message("Unable to create Load Balance Cookie");
            throw new AuthException("102", null);
        }
    }

    public void setlbCookie(AuthContextLocal authContextLocal, HttpServletResponse httpServletResponse) throws AuthException {
        String string = AuthUtils.getlbCookieName();
        if (string != null && string.length() != 0) {
            Set set = this.getCookieDomains();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Cookie cookie = this.createlbCookie(authContextLocal, string2, false);
                    httpServletResponse.addCookie(cookie);
                }
            } else {
                httpServletResponse.addCookie(this.createlbCookie(authContextLocal, null, false));
            }
        }
    }

    public void setlbCookie(HttpServletResponse httpServletResponse) throws AuthException {
        String string = AuthUtils.getlbCookieName();
        if (string != null && string.length() != 0) {
            Set set = this.getCookieDomains();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Cookie cookie = this.createlbCookie(string2);
                    httpServletResponse.addCookie(cookie);
                }
            } else {
                httpServletResponse.addCookie(this.createlbCookie(null));
            }
        }
    }

    public Cookie createCookie(String string, String string2, String string3) {
        Cookie cookie;
        block4: {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieName   : " + string);
                utilDebug.message("cookieValue  : " + string2);
                utilDebug.message("cookieDomain : " + string3);
            }
            cookie = null;
            try {
                cookie = CookieUtils.newCookie((String)string, (String)string2, (String)"/", (String)string3);
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error creating cookie. : " + exception.getMessage());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("createCookie Cookie is set : " + cookie);
        }
        return cookie;
    }

    public Cookie clearPersistentCookie(String string, AuthContextLocal authContextLocal) {
        String string2 = LoginState.encodePCookie();
        int n = 0;
        Cookie cookie = AuthUtils.createPersistentCookie(AuthUtils.getPersistentCookieName(), string2, n, string);
        return cookie;
    }

    public void clearlbCookie(HttpServletResponse httpServletResponse) {
        String string = AuthUtils.getlbCookieName();
        if (string != null && string.length() != 0) {
            Set set = this.getCookieDomains();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Cookie cookie = AuthUtils.createPersistentCookie(string, "LOGOUT", 0, string2);
                    httpServletResponse.addCookie(cookie);
                }
            } else {
                httpServletResponse.addCookie(AuthUtils.createPersistentCookie(string, "LOGOUT", 0, null));
            }
        }
    }

    public AuthContext.IndexType getIndexType(AuthContextLocal authContextLocal) {
        try {
            AuthContext.IndexType indexType = null;
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            if (loginState != null) {
                indexType = loginState.getIndexType();
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("in getIndexType, index type : " + indexType);
            }
            return indexType;
        }
        catch (Exception exception) {
            utilDebug.message("ERROR in getIndexType : ", (Throwable)exception);
            return null;
        }
    }

    public Callback[] getRecdCallback(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        Callback[] callbackArray = null;
        if (loginState != null) {
            callbackArray = loginState.getRecdCallback();
        }
        if (callbackArray != null) {
            if (utilDebug.messageEnabled()) {
                for (int i = 0; i < callbackArray.length; ++i) {
                    utilDebug.message("in getRecdCallback, recdCallback[" + i + "] :" + callbackArray[i]);
                }
            }
        } else {
            utilDebug.message("in getRecdCallback, recdCallback is null");
        }
        return callbackArray;
    }

    public String getErrorMessage(String string) {
        String string2 = this.getErrorVal(string, ERROR_MESSAGE);
        return string2;
    }

    public String getErrorTemplate(String string) {
        String string2 = this.getErrorVal(string, ERROR_TEMPLATE);
        return string2;
    }

    public String getDefaultFileName(HttpServletRequest httpServletRequest, String string) {
        AuthD authD = AuthD.getAuth();
        String string2 = authD.getPlatformLocale();
        String string3 = this.getFilePath(this.getClientType(httpServletRequest));
        String string4 = "default";
        String string5 = null;
        try {
            string5 = ResourceLookup.getFirstExisting((ServletContext)authD.getServletContext(), (String)string4, (String)string2, null, (String)string3, (String)string, (String)templatePath, (boolean)true);
        }
        catch (Exception exception) {
            string5 = templatePath + string4 + File.separator + string;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getDefaultFileName:templateFile is :" + string5);
        }
        return string5;
    }

    public String getOrgDN(AuthContextLocal authContextLocal) {
        String string = null;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            string = loginState.getOrgDN();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgDN is : " + string);
        }
        return string;
    }

    public static AuthContextLocal getAuthContext(String string) throws AuthException {
        return AuthUtils.getAuthContext(string, "0", false, null);
    }

    public static AuthContextLocal getAuthContext(String string, String string2) throws AuthException {
        return AuthUtils.getAuthContext(string, string2, false, null);
    }

    public static AuthContextLocal getAuthContext(String string, HttpServletRequest httpServletRequest) throws AuthException {
        return AuthUtils.getAuthContext(string, "0", false, httpServletRequest);
    }

    public static AuthContextLocal getAuthContext(String string, String string2, boolean bl) throws AuthException {
        return AuthUtils.getAuthContext(string, string2, bl, null);
    }

    public static AuthContextLocal getAuthContext(HttpServletRequest httpServletRequest, String string) throws AuthException {
        return AuthUtils.getAuthContext(null, string, false, httpServletRequest);
    }

    public static AuthContextLocal getAuthContext(String string, String string2, boolean bl, HttpServletRequest httpServletRequest) throws AuthException {
        AuthContextLocal authContextLocal;
        block23: {
            authContextLocal = null;
            SessionID sessionID = null;
            LoginState loginState = null;
            boolean bl2 = false;
            AuthD authD = AuthD.getAuth();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("orgName : " + string);
                utilDebug.message("sessionID is " + string2);
                utilDebug.message("sessionID is " + string2.length());
                utilDebug.message("isLogout : " + bl);
            }
            try {
                Object object;
                if (string2 != null && !string2.equals("0")) {
                    sessionID = new SessionID(string2);
                    authContextLocal = AuthUtils.retrieveAuthContext(httpServletRequest, sessionID);
                    object = AuthUtils.getLoginState(authContextLocal);
                    InternalSession internalSession = null;
                    if (object != null) {
                        internalSession = ((LoginState)object).getSession();
                    }
                    if (internalSession == null) {
                        bl2 = false;
                    } else {
                        int n = internalSession.getState();
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("sid from sess is : " + internalSession.getID());
                            utilDebug.message("sess is : " + n);
                        }
                        bl2 = true;
                        if (n == 0 || bl) {
                            bl2 = false;
                        }
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("session upgrade is : " + bl2);
                        }
                    }
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("AuthUtil:getAuthContext:sid is.. .: " + sessionID);
                    utilDebug.message("AuthUtil:getAuthContext:authContext is.. .: " + authContextLocal);
                    utilDebug.message("AuthUtil:getAuthContext:sessionUpgrade is.. .: " + bl2);
                }
                if (string == null && authContextLocal == null) {
                    utilDebug.error("Cannot create authcontext with null org ");
                    throw new AuthException("102", null);
                }
                if (string != null && (authContextLocal == null || bl2)) {
                    try {
                        loginState = new LoginState();
                        if (bl2) {
                            loginState.setPrevAuthContext(authContextLocal);
                            loginState.setSessionUpgrade(bl2);
                        }
                        authContextLocal = loginState.createAuthContext(sessionID, string, httpServletRequest);
                        authContextLocal.setLoginState(loginState);
                        object = AuthUtils.getQueryOrgName(null, string);
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("query org is .. : " + (String)object);
                        }
                        loginState.setQueryOrg((String)object);
                        break block23;
                    }
                    catch (AuthException authException) {
                        utilDebug.message("Error creating AuthContextLocal 2: ");
                        if (utilDebug.messageEnabled()) {
                            utilDebug.message("Exception ", (Throwable)((Object)authException));
                        }
                        throw new AuthException((Throwable)((Object)authException));
                    }
                }
                try {
                    object = AuthD.getSession(string2);
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("AuthUtil :Session is .. : " + object);
                    }
                    loginState = AuthUtils.getLoginState(authContextLocal);
                    loginState.setSession((InternalSession)object);
                    loginState.setRequestType(false);
                }
                catch (Exception exception) {
                    utilDebug.message("Error Retrieving AuthContextLocal");
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("Exception ", (Throwable)exception);
                    }
                    throw new AuthException("102", null);
                }
            }
            catch (Exception exception) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Creating AuthContextLocal 2: ", (Throwable)exception);
                }
                throw new AuthException(exception);
            }
        }
        return authContextLocal;
    }

    public static Set getAuthModules(int n, String string, String string2) {
        return AMAuthLevelManager.getInstance().getModulesForLevel(n, string, string2);
    }

    public AuthContextLocal getPrevAuthContext(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        AuthContextLocal authContextLocal2 = loginState.getPrevAuthContext();
        return authContextLocal2;
    }

    public LoginState getPrevLoginState(AuthContextLocal authContextLocal) {
        return AuthUtils.getLoginState(authContextLocal);
    }

    public AuthContextLocal getOrigAuthContext(SessionID sessionID) throws AuthException {
        AuthContextLocal authContextLocal = null;
        AuthD authD = AuthD.getAuth();
        try {
            authContextLocal = AuthUtils.retrieveAuthContext(null, sessionID);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AuthUtil:getOrigAuthContext:sid is.:" + sessionID);
                utilDebug.message("AuthUtil:getOrigAuthContext:authContext is:" + authContextLocal);
            }
            InternalSession internalSession = AuthUtils.getLoginState(authContextLocal).getSession();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Session is : " + internalSession);
                if (internalSession != null) {
                    utilDebug.message("Session State is : " + internalSession.getState());
                }
                utilDebug.message("Returning Orig AuthContext:" + authContextLocal);
            }
            if (internalSession == null) {
                return null;
            }
            int n = internalSession.getState();
            if (n == 0) {
                return null;
            }
            return authContextLocal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSessionActive(AuthContextLocal authContextLocal) {
        try {
            InternalSession internalSession = this.getSession(authContextLocal);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Sess is : " + internalSession);
            }
            boolean bl = false;
            if (internalSession != null) {
                if (internalSession.getState() == 1) {
                    bl = true;
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Sess State is : " + internalSession.getState());
                    utilDebug.message("Is Session Active : " + bl);
                }
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getSessionProperty(String string, AuthContextLocal authContextLocal) {
        String string2 = null;
        try {
            InternalSession internalSession = this.getSession(authContextLocal);
            if (internalSession != null) {
                string2 = internalSession.getProperty(string);
            }
        }
        catch (Exception exception) {
            utilDebug.message("Error : ", (Throwable)exception);
        }
        return string2;
    }

    public boolean isSessionUpgrade(AuthContextLocal authContextLocal) {
        boolean bl = false;
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            bl = loginState.isSessionUpgrade();
        }
        return bl;
    }

    public void setCookieSupported(AuthContextLocal authContextLocal, boolean bl) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("set cookieSupported to : " + bl);
            utilDebug.message("set cookieDetect to false");
        }
        loginState.setCookieSupported(bl);
    }

    public boolean isCookieSupported(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return false;
        }
        return loginState.isCookieSupported();
    }

    public boolean isCookieSet(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return false;
        }
        return loginState.isCookieSet();
    }

    public boolean checkForCookies(HttpServletRequest httpServletRequest, AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            utilDebug.message("set cookieSet to false.");
            loginState.setCookieSet(false);
            loginState.setCookieDetect(false);
        }
        return CookieUtils.getCookieValueFromReq((HttpServletRequest)httpServletRequest, (String)AuthUtils.getAuthCookieName()) != null || CookieUtils.getCookieValueFromReq((HttpServletRequest)httpServletRequest, (String)AuthUtils.getCookieName()) != null;
    }

    public boolean checkForCookies(HttpServletRequest httpServletRequest) {
        return CookieUtils.getCookieValueFromReq((HttpServletRequest)httpServletRequest, (String)AuthUtils.getAuthCookieName()) != null || CookieUtils.getCookieValueFromReq((HttpServletRequest)httpServletRequest, (String)AuthUtils.getCookieName()) != null;
    }

    public String getLoginURL(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState == null) {
            return null;
        }
        return loginState.getLoginURL();
    }

    public static AuthContextLocal getAuthContextFromHash(SessionID sessionID) {
        AuthContextLocal authContextLocal = null;
        if (sessionID != null) {
            authContextLocal = AuthUtils.retrieveAuthContext(null, sessionID);
        }
        return authContextLocal;
    }

    public String getOrigRedirectURL(HttpServletRequest httpServletRequest, SessionID sessionID) {
        try {
            SSOToken sSOToken;
            SSOTokenManager sSOTokenManager;
            String string = null;
            if (sessionID != null) {
                string = sessionID.toString();
            }
            if ((sSOTokenManager = SSOTokenManager.getInstance()).isValidToken(sSOToken = sSOTokenManager.createSSOToken(string))) {
                utilDebug.message("Valid SSOToken");
                String string2 = sSOToken.getProperty("successURL");
                String string3 = httpServletRequest.getParameter("goto");
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Original successURL : " + string2);
                    utilDebug.message("Request gotoURL : " + string3);
                }
                if (string3 != null && string3.length() != 0) {
                    string2 = string3;
                }
                return string2;
            }
        }
        catch (Exception exception) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getOrigRedirectURL:" + exception.toString());
            }
            return null;
        }
        return null;
    }

    public Callback[] getCallbacksPerState(AuthContextLocal authContextLocal, String string) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        Callback[] callbackArray = null;
        if (loginState != null) {
            callbackArray = loginState.getCallbacksPerState(string);
        }
        if (callbackArray != null) {
            if (utilDebug.messageEnabled()) {
                for (int i = 0; i < callbackArray.length; ++i) {
                    utilDebug.message("in getCallbacksPerState, recdCallback[" + i + "] :" + callbackArray[i]);
                }
            }
        } else {
            utilDebug.message("in getCallbacksPerState, recdCallback is null");
        }
        return callbackArray;
    }

    public void setCallbacksPerState(AuthContextLocal authContextLocal, String string, Callback[] callbackArray) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            loginState.setCallbacksPerState(string, callbackArray);
        }
        if (callbackArray != null) {
            if (utilDebug.messageEnabled()) {
                for (int i = 0; i < callbackArray.length; ++i) {
                    utilDebug.message("in setCallbacksPerState, callbacks[" + i + "] :" + callbackArray[i]);
                }
            }
        } else {
            utilDebug.message("in setCallbacksPerState, callbacks is null");
        }
    }

    public static String addLogoutCookieToURL(String string, String string2, boolean bl) {
        String string3 = null;
        if (string2 == null || bl) {
            string3 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AMURLEncDec.encode((String)AuthUtils.getCookieName())).append("=").append(AMURLEncDec.encode((String)string2));
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string.indexOf("?") != -1) {
                stringBuffer.insert(0, "&amp;");
            } else {
                stringBuffer.insert(0, "?");
            }
            stringBuffer.insert(0, string);
            string3 = stringBuffer.toString();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieString is : " + stringBuffer);
            }
        }
        return string3;
    }

    public SessionID getSidValue(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest) {
        SessionID sessionID = null;
        if (authContextLocal != null) {
            utilDebug.message("AuthContext is not null");
            try {
                String string = AuthUtils.getSidString(authContextLocal);
                if (string != null) {
                    sessionID = new SessionID(string);
                }
            }
            catch (Exception exception) {
                utilDebug.message("Exception getting sid", (Throwable)exception);
            }
        }
        if (sessionID == null) {
            utilDebug.message("Sid from AuthContext is null");
            sessionID = new SessionID(httpServletRequest);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("sid is : " + sessionID);
        }
        return sessionID;
    }

    public boolean isCookieSupported(AuthContextLocal authContextLocal, HttpServletRequest httpServletRequest) {
        boolean bl;
        if (authContextLocal != null) {
            utilDebug.message("AuthContext is not null");
            bl = this.isCookieSupported(authContextLocal);
        } else {
            bl = this.checkForCookies(httpServletRequest, null);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Cookie supported" + bl);
        }
        return bl;
    }

    public AuthContext.IndexType getPrevIndexType(AuthContextLocal authContextLocal) {
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        if (loginState != null) {
            return loginState.getPreviousIndexType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int isPureJAASModulePresent(String string, AMLoginContext aMLoginContext) throws AuthLoginException {
        if (AuthD.enforceJAASThread) {
            return 1;
        }
        int n = -1;
        Configuration configuration = null;
        try {
            configuration = Configuration.getConfiguration();
        }
        catch (Exception exception) {
            return 1;
        }
        AppConfigurationEntry[] appConfigurationEntryArray = configuration.getAppConfigurationEntry(string);
        if (appConfigurationEntryArray == null) {
            throw new AuthLoginException(BUNDLE_NAME, "105", null);
        }
        aMLoginContext.setConfigEntries(appConfigurationEntryArray);
        for (int i = 0; i < appConfigurationEntryArray.length; ++i) {
            ArrayList arrayList;
            String string2 = appConfigurationEntryArray[i].getLoginModuleName();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("config entry: " + string2);
            }
            if (pureJAASModuleClasses.contains(string2)) {
                n = 1;
                break;
            }
            if (ISModuleClasses.contains(string2)) continue;
            try {
                Object obj = Class.forName(string2).newInstance();
                if (obj instanceof AMLoginModule) {
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message(string2 + " is instance of AMLoginModule");
                    }
                    arrayList = ISModuleClasses;
                    synchronized (arrayList) {
                        if (!ISModuleClasses.contains(string2)) {
                            ISModuleClasses.add(string2);
                        }
                        continue;
                    }
                }
                if (utilDebug.messageEnabled()) {
                    utilDebug.message(string2 + " is a pure jaas module");
                }
                arrayList = pureJAASModuleClasses;
                synchronized (arrayList) {
                    if (!pureJAASModuleClasses.contains(string2)) {
                        pureJAASModuleClasses.add(string2);
                    }
                }
                n = 1;
            }
            catch (Exception exception) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("fail to instantiate class for " + string2);
                }
                arrayList = pureJAASModuleClasses;
                synchronized (arrayList) {
                    if (!pureJAASModuleClasses.contains(string2)) {
                        pureJAASModuleClasses.add(string2);
                    }
                }
                n = 1;
            }
            break;
        }
        return n;
    }

    public static String getModuleServiceName(String string) {
        String string2 = (String)moduleService.get(string);
        if (string2 == null) {
            string2 = AMAuthConfigUtils.getModuleServiceName(string);
            try {
                SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                new ServiceSchemaManager(string2, sSOToken);
            }
            catch (Exception exception) {
                string2 = AMAuthConfigUtils.getNewModuleServiceName(string);
            }
            moduleService.put(string, string2);
        }
        return string2;
    }

    public static int getAuthRevisionNumber() {
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthService", sSOToken);
            return serviceSchemaManager.getRevisionNumber();
        }
        catch (Exception exception) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("getAuthRevisionNumber error", (Throwable)exception);
            }
            return 0;
        }
    }

    private static SessionID getSidFromCookie(HttpServletRequest httpServletRequest) {
        SessionID sessionID = null;
        String string = AuthUtils.getAuthCookieName();
        String string2 = AuthUtils.getAMAuthCookieValue(httpServletRequest);
        if (string2 == null) {
            string2 = SessionEncodeURL.getSidFromURL((HttpServletRequest)httpServletRequest, (String)string);
        }
        if (string2 != null) {
            sessionID = new SessionID(string2);
            utilDebug.message("sidValue from Auth Cookie");
        }
        return sessionID;
    }

    public SessionID getSessionIDFromRequest(HttpServletRequest httpServletRequest) {
        boolean bl = httpServletRequest != null && httpServletRequest.getMethod().equalsIgnoreCase("GET");
        SessionID sessionID = new SessionID(httpServletRequest);
        SessionID sessionID2 = AuthUtils.getSidFromCookie(httpServletRequest);
        SessionID sessionID3 = sessionID2 == null ? sessionID : (bl ? sessionID : sessionID2);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AuthUtils:returning sessionID:" + sessionID3);
        }
        return sessionID3;
    }

    public String getSuccessURL(HttpServletRequest httpServletRequest, AuthContextLocal authContextLocal) {
        String string = null;
        if (httpServletRequest != null) {
            string = httpServletRequest.getParameter("goto");
        }
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("null")) {
            LoginState loginState = AuthUtils.getLoginState(authContextLocal);
            string = loginState == null ? this.getSessionProperty("successURL", authContextLocal) : AuthUtils.getLoginState(authContextLocal).getConfiguredSuccessLoginURL();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getSuccessURL : " + string);
        }
        return string;
    }

    public boolean newSessionArgExists(Hashtable hashtable) {
        boolean bl;
        String string = (String)hashtable.get("arg");
        boolean bl2 = bl = string != null && string.equals("newsession");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("newSessionArgExists : " + bl);
        }
        return bl;
    }

    public AuthContext.IndexType getIndexType(String string) {
        AuthContext.IndexType indexType = null;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getIndexType : strIndexType = " + string);
        }
        if (string != null) {
            if (string.equalsIgnoreCase("user")) {
                indexType = AuthContext.IndexType.USER;
            } else if (string.equalsIgnoreCase("role")) {
                indexType = AuthContext.IndexType.ROLE;
            } else if (string.equalsIgnoreCase("service")) {
                indexType = AuthContext.IndexType.SERVICE;
            } else if (string.equalsIgnoreCase("module_instance")) {
                indexType = AuthContext.IndexType.MODULE_INSTANCE;
            } else if (string.equalsIgnoreCase("level")) {
                indexType = AuthContext.IndexType.LEVEL;
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getIndexType : IndexType = " + indexType);
        }
        return indexType;
    }

    public String getIndexName(SSOToken sSOToken, AuthContext.IndexType indexType) {
        String string = "";
        try {
            if (indexType == AuthContext.IndexType.USER) {
                string = sSOToken.getProperty("UserToken");
            } else if (indexType == AuthContext.IndexType.ROLE) {
                string = sSOToken.getProperty("Role");
            } else if (indexType == AuthContext.IndexType.SERVICE) {
                string = sSOToken.getProperty("Service");
            } else if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
                string = this.getLatestIndexName(sSOToken.getProperty("AuthType"));
            } else if (indexType == AuthContext.IndexType.LEVEL) {
                string = sSOToken.getProperty("AuthLevel");
            }
        }
        catch (Exception exception) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getIndexName :" + exception.toString());
            }
            return string;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getIndexName : IndexType = " + indexType);
            utilDebug.message("getIndexName : IndexName = " + string);
        }
        return string;
    }

    private String getLatestIndexName(String string) {
        StringTokenizer stringTokenizer;
        String string2 = string;
        if (string != null && (stringTokenizer = new StringTokenizer(string, MSG_DELIMITER)).hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private boolean isContain(String string, String string2) {
        if (string == null) {
            return false;
        }
        try {
            if (string.indexOf(MSG_DELIMITER) != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, MSG_DELIMITER);
                while (stringTokenizer.hasMoreTokens()) {
                    if (!stringTokenizer.nextToken().equals(string2)) continue;
                    return true;
                }
            } else if (string.trim().equals(string2.trim())) {
                return true;
            }
        }
        catch (Exception exception) {
            utilDebug.error("error : " + exception.toString());
        }
        return false;
    }

    public boolean checkSessionUpgrade(SSOToken sSOToken, Hashtable hashtable) {
        boolean bl;
        block15: {
            utilDebug.message("Check Session upgrade!");
            String string = null;
            String string2 = null;
            bl = false;
            try {
                if (hashtable.get("user") != null) {
                    string = (String)hashtable.get("user");
                    string2 = sSOToken.getProperty("UserToken");
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("user : " + string);
                        utilDebug.message("userToken : " + string2);
                    }
                    if (!string.equals(string2)) {
                        bl = true;
                    }
                    break block15;
                }
                if (hashtable.get("role") != null) {
                    string = (String)hashtable.get("role");
                    string2 = sSOToken.getProperty("Role");
                    if (!this.isContain(string2, string)) {
                        bl = true;
                    }
                    break block15;
                }
                if (hashtable.get("service") != null) {
                    string = (String)hashtable.get("service");
                    string2 = sSOToken.getProperty("Service");
                    if (!this.isContain(string2, string)) {
                        bl = true;
                    }
                    break block15;
                }
                if (hashtable.get("module") != null) {
                    string = (String)hashtable.get("module");
                    string2 = sSOToken.getProperty("AuthType");
                    if (!this.isContain(string2, string)) {
                        bl = true;
                    }
                    break block15;
                }
                if (hashtable.get("authlevel") != null) {
                    int n = Integer.parseInt((String)hashtable.get("authlevel"));
                    if (n > Integer.parseInt(sSOToken.getProperty("AuthLevel"))) {
                        bl = true;
                    }
                    break block15;
                }
                if (hashtable.get("sunamcompositeadvice") == null) break block15;
                string = (String)hashtable.get("sunamcompositeadvice");
                String string3 = sSOToken.getProperty("Organization");
                String string4 = sSOToken.getProperty("clientType");
                Set set = AuthUtils.processCompositeAdviceXML(string, string3, string4);
                string2 = sSOToken.getProperty("AuthType");
                if (set == null || set.isEmpty()) break block15;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (this.isContain(string2, string5)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                utilDebug.message("Exception in checkSessionUpgrade : " + exception);
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Check session upgrade : " + bl);
        }
        return bl;
    }

    public static Set processCompositeAdviceXML(String string, String string2, String string3) {
        HashSet hashSet;
        block7: {
            hashSet = null;
            try {
                String string4 = URLDecoder.decode(string);
                Map map = PolicyUtils.parseAdvicesXML(string4);
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("processCompositeAdviceXML - decoded XML : " + string4);
                    utilDebug.message("processCompositeAdviceXML - result Map : " + map);
                }
                if (map != null) {
                    hashSet = new HashSet();
                    Set set = map.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string5 = (String)iterator.next();
                        Set set2 = (Set)map.get(string5);
                        if (string5.equals("AuthSchemeConditionAdvice")) {
                            hashSet.addAll(set2);
                        }
                        if (!string5.equals("AuthLevelConditionAdvice")) continue;
                        Set set3 = AuthUtils.processAuthLevelCondition(set2, string2, string3);
                        hashSet.addAll(set3);
                    }
                }
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block7;
                utilDebug.message("Error in processCompositeAdviceXML : " + exception.toString());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("processCompositeAdviceXML - returnModuleInstances : " + hashSet);
        }
        return hashSet;
    }

    private static Set processAuthLevelCondition(Set set, String string, String string2) {
        Set set2;
        block8: {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("processAuthLevelCondition - authLevelvalues : " + set);
            }
            set2 = Collections.EMPTY_SET;
            try {
                if (set != null) {
                    int n = Integer.MAX_VALUE;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        try {
                            int n2 = Integer.parseInt(string3);
                            if (n2 >= n) continue;
                            n = n2;
                        }
                        catch (Exception exception) {}
                    }
                    set2 = AuthUtils.getAuthModules(n, string, string2);
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("processAuthLevelCondition - returnModuleInstances : " + set2 + " for auth level : " + n);
                    }
                }
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block8;
                utilDebug.message("Error in processAuthLevelCondition : " + exception.toString());
            }
        }
        return set2;
    }

    public static boolean isClientDetectionEnabled() {
        boolean bl = false;
        if (clientDetector.isServicePassed()) {
            String string = clientDetector.detectionEnabled();
            bl = string.equalsIgnoreCase("true");
        } else {
            utilDebug.message("getClientDetector,Service does not exist");
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("clientDetectionEnabled = " + bl);
        }
        return bl;
    }

    public String getClientType(HttpServletRequest httpServletRequest) {
        if (AuthUtils.isClientDetectionEnabled() && clientDetector != null) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("clienttype = " + clientDetector.getClientType(httpServletRequest));
            }
            return clientDetector.getClientType(httpServletRequest);
        }
        return AuthUtils.getDefaultClientType();
    }

    public static String getDefaultClientType() {
        String string = DEFAULT_CLIENT_TYPE;
        try {
            if (defaultClient == null) {
                utilDebug.warning("Failed to get the defaut Auth Client instance");
                return string;
            }
            string = defaultClient.getClientType();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("getDefaultClientType, ClientType = " + string);
            }
        }
        catch (Exception exception) {
            utilDebug.error("getDefaultClientType", (Throwable)exception);
        }
        return string;
    }

    private Client getClientInstance(String string) {
        if (!string.equals(AuthUtils.getDefaultClientType())) {
            try {
                return AuthClient.getInstance(string, null);
            }
            catch (Exception exception) {
                utilDebug.warning("getClientInstance()", (Throwable)exception);
            }
        }
        return defaultClient;
    }

    private String getProperty(String string, String string2) {
        try {
            return this.getClientInstance(string).getProperty(string2);
        }
        catch (Exception exception) {
            utilDebug.warning("Error retrieving Client Data : " + string2, (Throwable)exception);
            return this.getDefaultProperty(string2);
        }
    }

    public String getDefaultProperty(String string) {
        try {
            return defaultClient.getProperty(string);
        }
        catch (Exception exception) {
            utilDebug.warning("Could not get " + string, (Throwable)exception);
            return null;
        }
    }

    public String getCharSet(String string, Locale locale) {
        String string2 = this.getClientInstance(string).getCharset(locale);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Charset from Client is : " + string2);
        }
        return string2;
    }

    public String getFilePath(String string) {
        String string2 = this.getProperty(string, "filePath");
        if (string2 == null) {
            return DEFAULT_FILE_PATH;
        }
        return string2;
    }

    public String getContentType(String string) {
        String string2 = this.getProperty(string, "contentType");
        if (string2 == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        return string2;
    }

    public String getCookieSupport(String string) {
        String string2 = this.getProperty(string, "cookieSupport");
        return string2;
    }

    public boolean isGenericHTMLClient(String string) {
        String string2 = this.getProperty(string, DEFAULT_CLIENT_TYPE);
        if (string2 == null) {
            return false;
        }
        return string2.equals("true");
    }

    public Vector getCharSets(String string) {
        Vector<String> vector;
        block8: {
            String string2;
            block7: {
                vector = new Vector<String>();
                string2 = null;
                try {
                    string2 = this.getProperty(string, "charsets");
                }
                catch (Exception exception) {
                    if (!utilDebug.messageEnabled()) break block7;
                    utilDebug.message("getCharSets: Exception :", (Throwable)exception);
                }
            }
            if (utilDebug.messageEnabled()) {
                utilDebug.message("getCharSets::clientType : " + string);
                utilDebug.message("getCharSets::charsets  : " + string2);
            }
            if (string2 == null || string2.equals("")) {
                return vector;
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                vector.clear();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    vector.add(string3);
                    utilDebug.message(" Charset ->" + string3);
                }
            }
            catch (Exception exception) {
                if (!utilDebug.warningEnabled()) break block8;
                utilDebug.warning("getCharSets : ", (Throwable)exception);
            }
        }
        return vector;
    }

    public boolean isSetCookie(String string) {
        boolean bl = this.setCookieVal(string, "true");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("setCookie : " + bl);
        }
        return bl;
    }

    public boolean setCookieVal(String string, String string2) {
        boolean bl;
        String string3 = this.getCookieSupport(string);
        boolean bl2 = this.getCookieDetect(string3);
        boolean bl3 = string3 != null && (string3.equalsIgnoreCase(string2) || string3.equalsIgnoreCase("cookieDetect"));
        boolean bl4 = bl = bl3 || bl2;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("cookieSupport : " + string3);
            utilDebug.message("cookieDetect : " + bl2);
            utilDebug.message(" setCookie is : " + bl);
        }
        return bl;
    }

    public boolean getCookieDetect(String string) {
        boolean bl;
        boolean bl2 = bl = string == null || string.equalsIgnoreCase("cookieDetect");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("CookieDetect : " + bl);
        }
        return bl;
    }

    public String getClientURLFromString(String string, int n, HttpServletRequest httpServletRequest) {
        String string2;
        String string3 = null;
        if (string != null && (string2 = string.substring(0, n)) != null && string2.equals(this.getClientType(httpServletRequest)) && string.length() > n) {
            string3 = string.substring(n + 1);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Client URL is :" + string3);
        }
        return string3;
    }

    public boolean isUrlRewrite(String string) {
        boolean bl = this.setCookieVal(string, "false");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("rewriteURL : " + bl);
        }
        return bl;
    }

    public static String getDSAMEVersion() {
        return dsameVersion;
    }

    public static String getAuthCookieName() {
        return authCookieName;
    }

    public static String getCookieName() {
        return cookieName;
    }

    public static String getPersistentCookieName() {
        return persistentCookieName;
    }

    public static String getlbCookieName() {
        return loadBalanceCookieName;
    }

    public static String getlbCookieValue() {
        return loadBalanceCookieValue;
    }

    public Set getCookieDomains() {
        Object object;
        Set set = Collections.EMPTY_SET;
        try {
            object = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", (SSOToken)object);
                ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
                Map map = serviceSchema.getAttributeDefaults();
                set = (Set)map.get("iplanet-am-platform-cookie-domains");
            }
            catch (SMSException sMSException) {
                utilDebug.message("getCookieDomains - SMSException ");
            }
            if (set == null) {
                set = Collections.EMPTY_SET;
            }
        }
        catch (SSOException sSOException) {
            utilDebug.message("getCookieDomains - SSOException ");
        }
        if (utilDebug.messageEnabled() && !set.isEmpty()) {
            utilDebug.message("CookieDomains : ");
            object = set.iterator();
            while (object.hasNext()) {
                utilDebug.message("  " + (String)object.next());
            }
        }
        return set;
    }

    public String getOrganizationDN(String string, boolean bl, HttpServletRequest httpServletRequest) {
        String string2;
        block7: {
            SSOToken sSOToken;
            block6: {
                string2 = null;
                sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                try {
                    string2 = IdUtils.getOrganization(sSOToken, string);
                }
                catch (Exception exception) {
                    if (!utilDebug.messageEnabled()) break block6;
                    utilDebug.message("Could not get orgName", (Throwable)exception);
                }
            }
            if ((string2 == null || string2.equals("")) && bl && httpServletRequest != null) {
                String string3 = httpServletRequest.getRequestURL().toString();
                int n = string3.indexOf(";");
                string = n != -1 ? this.stripPort(string3.substring(0, n)) : this.stripPort(string3);
                try {
                    string2 = IdUtils.getOrganization(sSOToken, string);
                }
                catch (Exception exception) {
                    if (!utilDebug.messageEnabled()) break block7;
                    utilDebug.message("Could not get orgName" + string, (Throwable)exception);
                }
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getOrganizationDN : orgParam... :" + string);
            utilDebug.message("getOrganizationDN : orgDN ... :" + string2);
        }
        return string2;
    }

    public String getDomainNameByRequest(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        boolean bl = false;
        String string = AuthUtils.getOrgParam(hashtable);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgParam is.. :" + string);
        }
        if (string == null || string.equals("")) {
            bl = true;
            string = httpServletRequest.getServerName();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Hostname : " + string);
            }
        }
        String string2 = this.getOrganizationDN(string, bl, httpServletRequest);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgDN is " + string2);
        }
        return string2;
    }

    public static String getOrgParam(Hashtable hashtable) {
        String string = null;
        if (hashtable != null && !hashtable.isEmpty()) {
            string = (String)hashtable.get("domain");
            if (string == null || string.equals("")) {
                string = (String)hashtable.get("org");
            }
            if (string == null || string.equals("")) {
                string = (String)hashtable.get("realm");
            }
        }
        return string;
    }

    String stripPort(String string) {
        try {
            URL uRL = new URL(string);
            return uRL.getProtocol() + "://" + uRL.getHost() + uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public static boolean isValidFQDNRequest(String string) {
        boolean bl;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("hostName is : " + string);
        }
        if (bl = fqdnUtils.isHostnameValid(string)) {
            utilDebug.message("hostname  and fqdnDefault match returning true");
        } else {
            utilDebug.message("hostname and fqdnDefault don't match");
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("retVal is : " + bl);
        }
        return bl;
    }

    public static String getValidFQDNResource(String string, HttpServletRequest httpServletRequest) {
        String string2;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Get mapping for " + string);
        }
        if ((string2 = fqdnUtils.getFullyQualifiedHostName(string)) == null) {
            string2 = string;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("fully qualified hostname :" + string2);
        }
        String string3 = AuthUtils.constructURL(string2, httpServletRequest);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Request URL :" + string3);
        }
        return string3;
    }

    public static String getHostName(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("host");
        if (string != null) {
            int n = string.indexOf(":");
            if (n != -1) {
                string = string.substring(0, n);
            }
        } else {
            string = httpServletRequest.getServerName();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Returning host name : " + string);
        }
        return string;
    }

    static String constructURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = RequestUtils.getRedirectProtocol((String)httpServletRequest.getScheme(), (String)string);
        int n = httpServletRequest.getServerPort();
        String string3 = httpServletRequest.getRequestURI();
        String string4 = httpServletRequest.getQueryString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2).append("://").append(string).append(":").append(n).append(string3);
        if (string4 != null) {
            stringBuffer.append("?").append(string4);
        }
        String string5 = stringBuffer.toString();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("returning new url : " + string5);
        }
        return string5;
    }

    public String constructLoginURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(serviceURI);
        String string = httpServletRequest.getQueryString();
        if (string != null && !string.equals("")) {
            stringBuffer.append("?");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public SSOToken getExistingValidSSOToken(SessionID sessionID) {
        SSOToken sSOToken = null;
        try {
            if (sessionID != null) {
                SSOToken sSOToken2;
                String string = sessionID.toString();
                SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                if (sSOTokenManager.isValidToken(sSOToken2 = sSOTokenManager.createSSOToken(string))) {
                    sSOToken = sSOToken2;
                }
            }
        }
        catch (Exception exception) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Error in getExistingValidSSOToken :" + exception.toString());
            }
            return sSOToken;
        }
        return sSOToken;
    }

    public String getErrorVal(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = bundle.getString(string);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("errorCod is.. : " + string);
            utilDebug.message("resProperty is.. : " + string5);
        }
        if (string5 != null && !string5.equals("")) {
            int n = string5.indexOf(MSG_DELIMITER);
            if (n != -1) {
                string4 = string5.substring(n + 1, string5.length());
                string3 = string5.substring(0, n);
            } else {
                string3 = string5;
            }
        }
        if (string2.equals(ERROR_MESSAGE)) {
            return string3;
        }
        if (string2.equals(ERROR_TEMPLATE)) {
            return string4;
        }
        return null;
    }

    public boolean isCookieSupported(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        String string = this.getCookieSupport(this.getClientType(httpServletRequest));
        if (string != null && string.equals("false")) {
            bl = false;
        }
        return bl;
    }

    public boolean isCookieSet(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        String string = this.getCookieSupport(this.getClientType(httpServletRequest));
        boolean bl2 = this.getCookieDetect(string);
        if (AuthUtils.isClientDetectionEnabled() && bl2) {
            bl = true;
        }
        return bl;
    }

    public static Cookie createPersistentCookie(String string, String string2, int n, String string3) {
        Cookie cookie = CookieUtils.newCookie((String)string, (String)string2, (String)"/", (String)string3);
        if (n >= 0) {
            cookie.setMaxAge(n);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("pCookie is.. :" + cookie);
        }
        return cookie;
    }

    public Cookie createlbCookie(String string) throws AuthException {
        Cookie cookie = null;
        try {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("cookieDomain : " + string);
            }
            String string2 = AuthUtils.getlbCookieName();
            String string3 = AuthUtils.getlbCookieValue();
            cookie = AuthUtils.createPersistentCookie(string2, string3, -1, string);
            return cookie;
        }
        catch (Exception exception) {
            utilDebug.message("Unable to create Load Balance Cookie");
            throw new AuthException("102", null);
        }
    }

    public Cookie getCookieString(AuthContext authContext, String string) {
        Cookie cookie;
        block4: {
            cookie = null;
            String string2 = AuthUtils.getAuthCookieName();
            String string3 = serverURL + serviceURI;
            try {
                if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                    string2 = AuthUtils.getCookieName();
                    string3 = authContext.getAuthIdentifier();
                    utilDebug.message("Create AM cookie");
                }
                cookie = this.createCookie(string2, string3, string);
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block4;
                utilDebug.message("Error getCookieString : " + exception.getMessage());
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Cookie is : " + cookie);
        }
        return cookie;
    }

    public String encodeURL(String string, HttpServletRequest httpServletRequest, AuthContext authContext) {
        if (this.isCookieSupported(httpServletRequest)) {
            return string;
        }
        String string2 = AuthUtils.getAuthCookieName();
        if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
            string2 = AuthUtils.getCookieName();
        }
        String string3 = string;
        string3 = urlRewriteInPath ? this.encodeURL(string, (short)2, false, string2, authContext.getAuthIdentifier()) : this.encodeURL(string, (short)0, true, string2, authContext.getAuthIdentifier());
        if (utilDebug.messageEnabled()) {
            utilDebug.message("encodeURL : URL = " + string + ", \nRewritten URL = " + string3);
        }
        return string3;
    }

    private String encodeURL(String string, short s, boolean bl, String string2, String string3) {
        String string4 = string;
        String string5 = SessionEncodeURL.createCookieString((String)string2, (String)string3);
        string4 = SessionEncodeURL.encodeURL((String)string5, (String)string, (short)s, (boolean)bl);
        return string4;
    }

    public String getDefaultFileName(HttpServletRequest httpServletRequest, String string, Locale locale, ServletContext servletContext) {
        String string2 = "";
        if (locale != null) {
            string2 = locale.toString();
        }
        String string3 = this.getFilePath(this.getClientType(httpServletRequest));
        String string4 = "default";
        String string5 = null;
        try {
            string5 = ResourceLookup.getFirstExisting((ServletContext)servletContext, (String)string4, (String)string2, null, (String)string3, (String)string, (String)templatePath, (boolean)true);
        }
        catch (Exception exception) {
            string5 = templatePath + string4 + File.separator + string;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getDefaultFileName:templateFile is :" + string5);
        }
        return string5;
    }

    public static String DNtoName(String string) {
        String string2 = string;
        if (DN.isDN((String)string)) {
            string2 = LDAPDN.explodeDN((String)string, (boolean)true)[0];
        }
        return string2;
    }

    public String getRootSuffix() {
        return rootSuffix;
    }

    private String getFileRoot() {
        String string = "default";
        String string2 = AuthUtils.DNtoName(rootSuffix);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("rootOrgName is : " + string2);
        }
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    private String getCharsetFileName(String string) {
        ISLocaleContext iSLocaleContext = new ISLocaleContext();
        String string2 = iSLocaleContext.getMIMECharset();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        String string3 = null;
        string3 = n != -1 ? string.substring(0, n) + "_" + string2 + string.substring(n) : string + "_" + string2;
        if (utilDebug.messageEnabled()) {
            utilDebug.message("charsetFilename is : " + string3);
        }
        return string3;
    }

    public String getResourceLocation(String string, String string2, String string3, String string4, String string5, String string6, ServletContext servletContext, HttpServletRequest httpServletRequest) {
        String string7 = null;
        String string8 = this.getClientType(httpServletRequest);
        if (string8 != null && !string8.equals(AuthUtils.getDefaultClientType())) {
            String string9 = this.getCharsetFileName(string5);
            string7 = ResourceLookup.getFirstExisting((ServletContext)servletContext, (String)string, (String)string2, (String)string3, (String)string4, (String)string9, (String)string6, (boolean)true);
        }
        if (string7 == null) {
            string7 = ResourceLookup.getFirstExisting((ServletContext)servletContext, (String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6, (boolean)true);
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Resource is.. " + string7);
        }
        return string7;
    }

    public String getFilePath(HttpServletRequest httpServletRequest, AuthContext.IndexType indexType, String string) {
        String string2 = this.getFilePath(this.getClientType(httpServletRequest));
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (indexType != null && indexType.equals(AuthContext.IndexType.SERVICE)) {
            string3 = string;
        }
        if (string2 == null && string3 == null) {
            return null;
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(File.separator).append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(File.separator).append(string3);
        }
        String string4 = stringBuffer.toString();
        if (utilDebug.messageEnabled()) {
            utilDebug.message("FilePath is.. :" + string4);
        }
        return string4;
    }

    String getOrgFilePath(String string) {
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getOrgFilePath : orgDN is: " + string);
        }
        String string2 = AuthUtils.getNormalizedDN(string);
        String string3 = null;
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = string2;
            String string5 = null;
            while (string4 != null && string4.length() != 0 && !string4.equals(this.getRootSuffix())) {
                string5 = AuthUtils.DNtoName(string4);
                stringBuffer = stringBuffer.insert(0, File.separator + string5);
                int n = string4.indexOf(",");
                if (n != -1) {
                    string4 = string4.substring(n + 1);
                }
                if (!utilDebug.messageEnabled()) continue;
                utilDebug.message("remOrgDN is : " + string4);
            }
            string3 = stringBuffer.toString();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("getOrgFilePath: orgPath is : " + string3);
        }
        return string3;
    }

    public String getFileName(String string, String string2, String string3, HttpServletRequest httpServletRequest, ServletContext servletContext, AuthContext.IndexType indexType, String string4) {
        String string5 = this.getFileRoot();
        String string6 = null;
        try {
            String string7 = this.getFilePath(httpServletRequest, indexType, string4);
            String string8 = this.getOrgFilePath(string3);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Calling ResourceLookup: filename = " + string + ", defaultOrg = " + string5 + ", locale = " + string2 + ", filePath = " + string7 + ", orgPath = " + string8);
            }
            string6 = this.getResourceLocation(string5, string2, string8, string7, string, templatePath, servletContext, httpServletRequest);
        }
        catch (Exception exception) {
            utilDebug.message("Error getting File : " + exception.getMessage());
            string6 = templatePath + File.separator + "default" + File.separator + string;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("File/Resource is : " + string6);
        }
        return string6;
    }

    public static String getAMAuthCookieValue(HttpServletRequest httpServletRequest) {
        String string = CookieUtils.getCookieValueFromReq((HttpServletRequest)httpServletRequest, (String)AuthUtils.getAuthCookieName());
        if (amCookieEncodeMode.equals("false") && string != null && string.indexOf(37) != -1) {
            string = URLDecoder.decode(string);
        }
        return string;
    }

    public String getAuthCookieValue(HttpServletRequest httpServletRequest) {
        return AuthUtils.getAMAuthCookieValue(httpServletRequest);
    }

    public String getDomainNameByRequest(Hashtable hashtable) {
        String string = AuthUtils.getOrgParam(hashtable);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgParam is.. :" + string);
        }
        if (string == null || string.equals("")) {
            string = "/";
            if (utilDebug.messageEnabled()) {
                utilDebug.message("defaultOrg : " + string);
            }
        }
        String string2 = this.getOrganizationDN(string, false, null);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("orgDN is " + string2);
        }
        return string2;
    }

    public static String getNormalizedDN(String string) {
        String string2 = null;
        if (string != null && (string2 = new DN(string).toRFCString().toLowerCase()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private static AuthContextLocal retrieveAuthContext(HttpServletRequest httpServletRequest, SessionID sessionID) {
        AuthContextLocal authContextLocal = null;
        if (httpServletRequest != null && AuthD.isHttpSessionUsed()) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                authContextLocal = (AuthContextLocal)httpSession.getAttribute("authContextObject");
                if (utilDebug.messageEnabled() && authContextLocal != null) {
                    utilDebug.message("authContext from httpsession: " + authContextLocal);
                }
            }
        } else if (sessionID != null) {
            authContextLocal = AuthUtils.retrieveAuthContext(sessionID);
        }
        return authContextLocal;
    }

    private static AuthContextLocal retrieveAuthContext(SessionID sessionID) {
        InternalSession internalSession = AuthD.getSession(sessionID);
        AuthContextLocal authContextLocal = null;
        if (internalSession != null) {
            authContextLocal = (AuthContextLocal)internalSession.getObject("authContextObject");
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("retrieveAuthContext - InternalSession = " + internalSession);
            utilDebug.message("retrieveAuthContext - aclocal = " + authContextLocal);
        }
        return authContextLocal;
    }

    public static void removeAuthContext(SessionID sessionID) {
        InternalSession internalSession = AuthD.getSession(sessionID);
        if (internalSession != null) {
            internalSession.removeObject("authContextObject");
        }
    }

    public boolean isLocalServer(String string, boolean bl) {
        boolean bl2;
        block8: {
            bl2 = false;
            try {
                String string2 = serverURL + serviceURI;
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("This server URL : " + string2);
                    utilDebug.message("Server URL from cookie : " + string);
                }
                if (string2 != null && string != null && string.equalsIgnoreCase(string2)) {
                    bl2 = true;
                }
                if (!bl2 && bl && string != null) {
                    int n = string.indexOf(serviceURI);
                    String string3 = string;
                    if (n != -1) {
                        string3 = string.substring(0, n);
                    }
                    Vector vector = WebtopNaming.getPlatformServerList();
                    if (utilDebug.messageEnabled()) {
                        utilDebug.message("search CookieURL : " + string3);
                        utilDebug.message("platform server List : " + vector);
                    }
                    if (!vector.contains(string3)) {
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                if (!utilDebug.messageEnabled()) break block8;
                utilDebug.message("Error isLocalServer : " + exception.getMessage());
            }
        }
        return bl2;
    }

    public boolean isLocalServer(String string, String string2) {
        int n = string.indexOf(string2);
        String string3 = string;
        if (n != -1) {
            string3 = string.substring(0, n);
        }
        return this.isLocalServer(string3 + serviceURI, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashMap sendAuthRequestToOrigServer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        Object object;
        CharSequence charSequence;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (utilDebug.messageEnabled()) {
            object4 = httpServletRequest.getHeaderNames();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = httpServletRequest.getHeaders((String)object3);
                utilDebug.message("Header name = " + (String)object3 + " Value = " + object2);
            }
        }
        object4 = null;
        object3 = null;
        object2 = null;
        URL uRL = new URL(string);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Connecting to : " + uRL);
        }
        object4 = (HttpURLConnection)uRL.openConnection();
        ((URLConnection)object4).setDoOutput(true);
        ((URLConnection)object4).setUseCaches(false);
        ((HttpURLConnection)object4).setRequestMethod("POST");
        HttpURLConnection.setFollowRedirects(false);
        ((HttpURLConnection)object4).setInstanceFollowRedirects(false);
        object2 = this.getCookiesString(httpServletRequest);
        if (object2 != null) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Sending cookies : " + (String)object2);
            }
            ((URLConnection)object4).setRequestProperty("Cookie", (String)object2);
        }
        ((URLConnection)object4).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        ((URLConnection)object4).setRequestProperty("Content-Length", httpServletRequest.getHeader("content-length"));
        ((URLConnection)object4).setRequestProperty("Host", httpServletRequest.getHeader("host"));
        utilDebug.message("SENDING DATA ... ");
        String string2 = this.getFormData(httpServletRequest);
        object3 = ((URLConnection)object4).getOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)object3);
        printWriter.print(string2);
        printWriter.flush();
        printWriter.close();
        utilDebug.message("RECEIVING DATA ... ");
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Response Code: " + ((HttpURLConnection)object4).getResponseCode());
            utilDebug.message("Response Message: " + ((HttpURLConnection)object4).getResponseMessage());
            utilDebug.message("Follow redirect : " + HttpURLConnection.getFollowRedirects());
        }
        if (((HttpURLConnection)object4).getResponseCode() == 200) {
            int n;
            charSequence = new StringBuffer();
            object = new BufferedReader(new InputStreamReader(((URLConnection)object4).getInputStream(), "UTF-8"));
            char[] cArray = new char[1024];
            while ((n = ((BufferedReader)object).read(cArray, 0, cArray.length)) != -1) {
                ((StringBuffer)charSequence).append(cArray, 0, n);
            }
            String string3 = ((StringBuffer)charSequence).toString();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("Received response data : " + string3);
            }
            hashMap.put("OUTPUT_DATA", string3);
        } else {
            utilDebug.message("Response code NOT OK");
        }
        charSequence = ((URLConnection)object4).getHeaderField("AM_CLIENT_TYPE");
        if (charSequence != null) {
            hashMap.put("AM_CLIENT_TYPE", charSequence);
        }
        if ((object = ((URLConnection)object4).getHeaderField("Location")) != null) {
            hashMap.put("AM_REDIRECT_URL", object);
        }
        Map<String, List<String>> map = ((URLConnection)object4).getHeaderFields();
        this.processCookies(map, httpServletResponse);
        ((OutputStream)object3).flush();
        Object var17_18 = null;
        if (object3 == null) return hashMap;
        try {
            ((OutputStream)object3).close();
            return hashMap;
        }
        catch (IOException iOException) {
            if (!utilDebug.messageEnabled()) return hashMap;
            utilDebug.message("send IOException : " + iOException.toString());
        }
        return hashMap;
        {
            catch (Exception exception) {
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("send exception : ", (Throwable)exception);
                }
                Object var17_19 = null;
                if (object3 == null) return hashMap;
                try {
                    ((OutputStream)object3).close();
                    return hashMap;
                }
                catch (IOException iOException) {
                    if (!utilDebug.messageEnabled()) return hashMap;
                    utilDebug.message("send IOException : " + iOException.toString());
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (object3 == null) throw throwable;
            try {
                ((OutputStream)object3).close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (!utilDebug.messageEnabled()) throw throwable;
                utilDebug.message("send IOException : " + iOException.toString());
            }
            throw throwable;
        }
    }

    private String getFormData(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getParameter(string);
            stringBuffer.append(URLEncoder.encode(string));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2));
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append('&');
        }
        return stringBuffer.toString();
    }

    private void processCookies(Map map, HttpServletResponse httpServletResponse) {
        if (utilDebug.messageEnabled()) {
            utilDebug.message("processCookies : headers : " + map);
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            List list;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string == null || !string.equalsIgnoreCase("Set-cookie") && !string.equalsIgnoreCase("Cookie") || (list = (List)entry.getValue()) == null || list.isEmpty()) continue;
            Cookie cookie = null;
            String string2 = null;
            Object var9_9 = null;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string3;
                int n;
                StringTokenizer stringTokenizer;
                String string4 = (String)iterator2.next();
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("processCookies : cookie : " + string4);
                }
                if (!(stringTokenizer = new StringTokenizer(string4, ";")).hasMoreTokens() || (n = (string3 = stringTokenizer.nextToken()).indexOf("=")) == -1) continue;
                String string5 = string3.substring(0, n).trim();
                String string6 = string3.substring(n + 1);
                Set set = this.getCookieDomains();
                if (string6.indexOf(37) != -1) {
                    string6 = URLDecoder.decode(string6);
                }
                if (!set.isEmpty()) {
                    Iterator iterator3 = set.iterator();
                    while (iterator3.hasNext()) {
                        string2 = (String)iterator3.next();
                        cookie = this.createCookie(string5, string6, string2);
                        httpServletResponse.addCookie(cookie);
                    }
                    continue;
                }
                cookie = this.createCookie(string5, string6, null);
                httpServletResponse.addCookie(cookie);
            }
        }
    }

    private String getCookiesString(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        StringBuffer stringBuffer = null;
        String string = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                String string2 = cookieArray[i].getName();
                String string3 = cookieArray[i].getValue();
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("Cookie name = " + string2);
                    utilDebug.message("Cookie value = " + string3);
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(";");
                }
                if (string3.indexOf(37) == -1) {
                    string3 = URLEncoder.encode(string3);
                }
                stringBuffer.append(string2).append("=").append(string3);
            }
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    static {
        moduleService = new Hashtable();
        urlRewriteInPath = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.cookieRewritingInPath", (String)""));
        templatePath = File.separator + "config" + File.separator + "auth";
        rootSuffix = SMSEntry.getRootSuffix();
        dsameVersion = SystemProperties.get((String)"com.iplanet.am.version", (String)DSAME_VERSION);
        cookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name");
        authCookieName = SystemProperties.get((String)"com.sun.identity.auth.cookieName", (String)"AMAuthCookie");
        loadBalanceCookieName = SystemProperties.get((String)"com.iplanet.am.lbcookie.name");
        persistentCookieName = SystemProperties.get((String)"com.iplanet.am.pcookie.name");
        loadBalanceCookieValue = SystemProperties.get((String)"com.iplanet.am.lbcookie.value");
        serviceURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor") + "/UI/Login";
        webContainer = SystemProperties.get((String)"com.sun.identity.webcontainer");
        amCookieEncodeMode = SystemProperties.get((String)"com.iplanet.am.cookie.encode", (String)"false");
        serverURL = null;
        utilDebug = Debug.getInstance((String)"amAuthUtils");
        clientDetector = new AMClientDetector();
        defaultClient = ClientsManager.getDefaultInstance();
        fqdnUtils = new FQDNUtils();
        bundle = com.iplanet.am.util.Locale.getInstallResourceBundle((String)BUNDLE_NAME);
        if (webContainer != null && webContainer.length() > 0 && webContainer.indexOf("BEA") >= 0) {
            setRequestEncoding = true;
        }
        String string = SystemProperties.get((String)"com.iplanet.distAuth.server.protocol");
        String string2 = null;
        String string3 = null;
        if (string != null && string.length() != 0) {
            string2 = SystemProperties.get((String)"com.iplanet.distAuth.server.host");
            string3 = SystemProperties.get((String)"com.iplanet.distAuth.server.port");
        } else {
            string = SystemProperties.get((String)"com.iplanet.am.server.protocol");
            string2 = SystemProperties.get((String)"com.iplanet.am.server.host");
            string3 = SystemProperties.get((String)"com.iplanet.am.server.port");
        }
        serverURL = string + "://" + string2 + ":" + string3;
    }
}

