/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;

public class AuthLevel {
    String indexName;
    String orgDN;
    private static AuthD ad = AuthD.getAuth();
    int authLevel = 0;
    int numberOfModules = 1;
    Vector modList;
    AuthContext.IndexType indexType = null;
    String clientType = AuthUtils.getDefaultClientType();
    java.util.Locale userLocale;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    ResourceBundle rb = null;
    Map moduleMap = null;

    public AuthLevel(AuthContext.IndexType indexType, String string, String string2, String string3, java.util.Locale locale) throws AuthException {
        try {
            AuthD.debug.message("in auth level constructor");
            this.indexName = string;
            this.indexType = indexType;
            this.orgDN = string2;
            this.clientType = string3;
            this.userLocale = locale;
            try {
                this.authLevel = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new AuthException("119", null);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("indexType : " + indexType);
                AuthD.debug.message("indexName : " + string);
                AuthD.debug.message("orgDN     : " + string2);
                AuthD.debug.message("clientType: " + string3);
                AuthD.debug.message("authLevel : " + this.authLevel);
                AuthD.debug.message("userLocale: " + this.userLocale);
            }
            this.rb = amCache.getResBundle("amAuth", this.userLocale);
            this.getAuthModulesConfig();
            AuthD.debug.message("end auth level constructor");
        }
        catch (Exception exception) {
            throw new AuthException(exception);
        }
    }

    public void getAuthModulesConfig() {
        Set set = AuthUtils.getAuthModules(this.authLevel, this.orgDN, this.clientType);
        this.modList = new Vector();
        this.moduleMap = new HashMap();
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getModuleLocalizedName(string);
            this.moduleMap.put(string2, string);
            this.modList.addElement(string2);
            ++n;
        }
        this.numberOfModules = n;
    }

    public int getNumberOfAuthModules() {
        return this.numberOfModules;
    }

    public String[] getModuleList() {
        String[] stringArray = new String[this.modList.size()];
        this.modList.copyInto(stringArray);
        return stringArray;
    }

    public String getModuleName() {
        Enumeration enumeration = this.modList.elements();
        return (String)this.moduleMap.get(enumeration.nextElement());
    }

    public Callback[] createChoiceCallback() throws AuthException {
        AuthD.debug.message("In createChoiceCallback");
        String[] stringArray = this.getModuleList();
        Callback[] callbackArray = new Callback[1];
        try {
            ChoiceCallback choiceCallback = new ChoiceCallback(Locale.getString((ResourceBundle)this.rb, (String)"modulePrompt", (Debug)AuthD.debug), stringArray, 0, false);
            callbackArray[0] = choiceCallback;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AuthD.debug.error("Number of arguments not correct", (Throwable)illegalArgumentException);
            throw new AuthException("callbackError", null);
        }
        catch (Exception exception) {
            AuthD.debug.error("Error: ", (Throwable)exception);
            throw new AuthException("callbackError", null);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Callback is.. :" + callbackArray[0]);
        }
        return callbackArray;
    }

    protected String getModuleLocalizedName(String string) {
        return Locale.getString((ResourceBundle)this.rb, (String)string, (Debug)AuthD.debug);
    }

    protected Map getModuleMap() {
        return this.moduleMap;
    }
}

