/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.server.AuthXMLHandler;
import com.sun.identity.authentication.service.AuthConfigMonitor;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProviderBase;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import netscape.ldap.util.DN;

public class AuthD {
    public static Debug debug;
    private static Map bundles;
    private static AuthD authInstance;
    private static boolean authInitFailed;
    private static String superAdmin;
    private static String specialUser;
    private static final String consoleProto;
    private static final String consoleHost;
    private static final String consolePort;
    private static final boolean isConsoleRemote;
    public static final String DEFAULT_AUTH_LEVEL = "0";
    public static final int LOG_ACCESS = 0;
    public static final int LOG_ERROR = 1;
    public static Hashtable sAuth;
    public static boolean enforceJAASThread;
    public static String directoryHostName;
    public static int directoryPort;
    public static int revisionNumber;
    private static HashMap idRepoMap;
    private static HashMap orgMap;
    public static final String BUNDLE_NAME = "amAuth";
    private String defaultOrg;
    private String platformLocale;
    private String platformCharset;
    private Set platformClientCharsets;
    public ResourceBundle bundle;
    private SessionService sessionService;
    private SSOToken ssoAuthSession;
    private Session authSession;
    private AMStoreConnection dpStore;
    String clientDetectionClass;
    public static String platLocale;
    private String defaultAuthLocale;
    ServiceSchema platformSchema;
    ServiceSchema sessionSchema;
    private static boolean logStatus;
    public Set defaultSuccessURLSet;
    public String defaultSuccessURL;
    public Set defaultFailureURLSet;
    public String defaultFailureURL;
    public Set defaultServiceSuccessURLSet;
    public Set defaultServiceFailureURLSet;
    private String adminAuthModule;
    public String defaultAuthLevel;
    private Hashtable authMethods;
    private long defaultSleepTime;
    private ServletContext servletContext;
    private static boolean useHttpSession;
    Logger logger;
    String rootSuffix;
    static /* synthetic */ Class class$com$sun$identity$authentication$service$AuthD;

    private AuthD() {
        block5: {
            this.bundle = null;
            this.sessionService = null;
            this.ssoAuthSession = null;
            this.authSession = null;
            this.dpStore = null;
            this.clientDetectionClass = null;
            this.defaultSuccessURLSet = null;
            this.defaultSuccessURL = null;
            this.defaultFailureURLSet = null;
            this.defaultFailureURL = null;
            this.defaultServiceSuccessURLSet = null;
            this.defaultServiceFailureURLSet = null;
            this.authMethods = new Hashtable();
            this.defaultSleepTime = 300L;
            this.logger = null;
            this.rootSuffix = null;
            debug.message("AuthD initializing");
            try {
                this.rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
                this.defaultOrg = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
                if (!this.defaultOrg.equals(this.rootSuffix)) {
                    this.defaultOrg = this.defaultOrg + "," + this.rootSuffix;
                }
                this.initAuthSessions();
                this.dpStore = new AMStoreConnection(this.ssoAuthSession);
                this.initAuthServiceGlobalSettings();
                this.initPlatformServiceGlobalSettings();
                this.initSessionServiceDynamicSettings();
                this.initAuthConfigGlobalSettings();
                this.bundle = Locale.getInstallResourceBundle((String)BUNDLE_NAME);
                ResourceBundle resourceBundle = Locale.getInstallResourceBundle((String)"amPlatform");
                this.platformCharset = resourceBundle.getString("iplanet-am-platform-html-char-set");
                this.printProfileAttrs();
                new AuthXMLHandler();
                authInitFailed = false;
            }
            catch (Exception exception) {
                debug.error("AuthD init()", (Throwable)exception);
                authInitFailed = true;
            }
            try {
                enforceJAASThread = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.authentication.usingJaasThread"));
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block5;
                debug.message("Wrong format of com.sun.identity.authentication.usingJaasThread");
            }
        }
    }

    private void initAuthServiceGlobalSettings() throws SMSException, SSOException, Exception {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthService", this.ssoAuthSession);
        revisionNumber = serviceSchemaManager.getRevisionNumber();
        if (debug.messageEnabled()) {
            debug.message("revision number = " + revisionNumber);
        }
        this.updateAuthServiceGlobals(serviceSchemaManager);
        new AuthConfigMonitor(serviceSchemaManager);
    }

    synchronized void updateAuthServiceGlobals(ServiceSchemaManager serviceSchemaManager) throws SMSException, Exception {
        Object object;
        ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationSchema();
        Map map = serviceSchema.getAttributeDefaults();
        serviceSchema = serviceSchemaManager.getGlobalSchema();
        map.putAll(serviceSchema.getAttributeDefaults());
        if (debug.messageEnabled()) {
            debug.message("attrs : " + map);
        }
        this.defaultAuthLocale = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-locale");
        this.adminAuthModule = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-admin-auth-module");
        this.defaultAuthLevel = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-default-auth-level", (String)DEFAULT_AUTH_LEVEL);
        Set set = (Set)map.get("iplanet-am-auth-authenticators");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            int n = ((String)object).lastIndexOf(46);
            if (n > -1) {
                String string = ((String)object).substring(n + 1, ((String)object).length());
                this.authMethods.put(string, object);
                continue;
            }
            this.authMethods.put(object, object);
        }
        if (debug.messageEnabled()) {
            debug.message("AM.update authMethods = " + this.authMethods.toString());
        }
        this.defaultSuccessURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
        this.defaultFailureURLSet = (Set)map.get("iplanet-am-auth-login-failure-url");
        if (debug.messageEnabled()) {
            debug.message("Default Success URL Set = " + this.defaultSuccessURLSet);
            debug.message("Default Failure URL Set = " + this.defaultFailureURLSet);
        }
        object = new Integer(Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-sleep-interval"));
        this.defaultSleepTime = ((Integer)object).longValue();
    }

    private void initAuthConfigGlobalSettings() throws SMSException, SSOException, Exception {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthConfiguration", this.ssoAuthSession);
        this.updateAuthConfigGlobals(serviceSchemaManager);
        new AuthConfigMonitor(serviceSchemaManager);
    }

    synchronized void updateAuthConfigGlobals(ServiceSchemaManager serviceSchemaManager) throws SMSException {
        ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationSchema();
        serviceSchema = serviceSchema.getSubSchema("Configurations");
        Map map = (serviceSchema = serviceSchema.getSubSchema("NamedConfiguration")).getAttributeDefaults();
        if (map != null) {
            this.defaultServiceSuccessURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
            this.defaultServiceFailureURLSet = (Set)map.get("iplanet-am-auth-login-failure-url");
        }
        if (debug.messageEnabled()) {
            debug.message("Default Service Success URL Set = " + this.defaultServiceSuccessURLSet);
            debug.message("Default Service Failure URL Set = " + this.defaultServiceFailureURLSet);
        }
    }

    private void initPlatformServiceGlobalSettings() throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", this.ssoAuthSession);
        this.updatePlatformServiceGlobals(serviceSchemaManager);
        new AuthConfigMonitor(serviceSchemaManager);
    }

    synchronized void updatePlatformServiceGlobals(ServiceSchemaManager serviceSchemaManager) throws SMSException {
        this.platformSchema = serviceSchemaManager.getGlobalSchema();
        Map map = this.platformSchema.getAttributeDefaults();
        this.platformLocale = Misc.getMapAttr((Map)map, (String)"iplanet-am-platform-locale");
        this.platformClientCharsets = (Set)map.get("iplanet-am-platform-client-charsets");
        if (debug.messageEnabled()) {
            debug.message("PlatformLocale = " + this.platformLocale + "\nplatformClientCharsets = " + this.platformClientCharsets);
        }
    }

    private void initSessionServiceDynamicSettings() throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMSessionService", this.ssoAuthSession);
        this.updateSessionServiceDynamics(serviceSchemaManager);
        new AuthConfigMonitor(serviceSchemaManager);
    }

    synchronized void updateSessionServiceDynamics(ServiceSchemaManager serviceSchemaManager) throws SMSException {
        this.sessionSchema = serviceSchemaManager.getDynamicSchema();
        if (debug.messageEnabled()) {
            Map map = this.sessionSchema.getAttributeDefaults();
            String string = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-session-time", (String)"120");
            String string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-idle-time", (String)"30");
            String string3 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-max-caching-time", (String)"3");
            debug.message("AuthD.defaultMaxSessionTime=" + string + "\nAuthD.defaultMaxIdleTime=" + string2 + "\nAuthD.defaultMaxCachingTime=" + string3);
        }
    }

    String getDefaultMaxSessionTime() {
        return Misc.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-session-time", (String)"120");
    }

    String getDefaultMaxIdleTime() {
        return Misc.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-idle-time", (String)"30");
    }

    String getDefaultMaxCachingTime() {
        return Misc.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-caching-time", (String)"3");
    }

    public Map getOrgServiceAttributes(String string, String string2) {
        Map map;
        block3: {
            map = Collections.EMPTY_MAP;
            try {
                AMIdentityRepository aMIdentityRepository = this.getAMIdentityRepository(string);
                AMIdentity aMIdentity = aMIdentityRepository.getRealmIdentity();
                Set set = aMIdentity.getAssignedServices();
                if (set.contains(string2)) {
                    map = aMIdentity.getServiceAttributes(string2);
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block3;
                debug.message("Exception in getting service attributes for " + string2 + " in org " + string);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthD getAuth() {
        if (authInstance == null) {
            Class clazz = class$com$sun$identity$authentication$service$AuthD == null ? (class$com$sun$identity$authentication$service$AuthD = AuthD.class$("com.sun.identity.authentication.service.AuthD")) : class$com$sun$identity$authentication$service$AuthD;
            synchronized (clazz) {
                if (authInstance == null) {
                    authInstance = new AuthD();
                    if (authInitFailed) {
                        authInstance = null;
                    }
                }
            }
        }
        return authInstance;
    }

    public void destroySession(SessionID sessionID) {
        AuthD.getSS().destroyInternalSession(sessionID);
    }

    public void logoutSession(SessionID sessionID) {
        AuthD.getSS().logoutInternalSession(sessionID);
    }

    public InternalSession newSession(String string, HttpSession httpSession) {
        InternalSession internalSession = null;
        try {
            internalSession = AuthD.getSS().newInternalSession(string, httpSession);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            debug.error("Error creating session: ", (Throwable)exception);
        }
        return internalSession;
    }

    public static InternalSession getSession(String string) {
        if (debug.messageEnabled()) {
            debug.message("getSession for " + string);
        }
        InternalSession internalSession = null;
        if (string != null) {
            SessionID sessionID = new SessionID(string);
            internalSession = AuthD.getSession(sessionID);
        }
        if (internalSession == null) {
            debug.message("getSession returned null");
        }
        return internalSession;
    }

    public static InternalSession getSession(SessionID sessionID) {
        InternalSession internalSession = null;
        if (sessionID != null) {
            internalSession = AuthD.getSS().getInternalSession(sessionID);
        }
        return internalSession;
    }

    public InternalSession getSession(HttpServletRequest httpServletRequest) {
        SessionID sessionID = new SessionID(httpServletRequest);
        return AuthD.getSession(sessionID);
    }

    public String getAuthenticatorForName(String string) {
        return (String)this.authMethods.get(string);
    }

    public boolean containsAuthenticator(String string) {
        return this.authMethods.containsKey(string);
    }

    public Iterator getAuthenticators() {
        return this.authMethods.keySet().iterator();
    }

    public int getAuthenticatorCount() {
        return this.authMethods.size();
    }

    public String getPlatformCharset() {
        return this.platformCharset;
    }

    public String getPlatformLocale() {
        return this.platformLocale;
    }

    public String getCoreAuthLocaleFromAuthService() {
        return this.defaultAuthLocale;
    }

    public String getDefaultAuthLocale() {
        if (this.defaultAuthLocale == null || this.defaultAuthLocale.length() == 0) {
            return "en_US";
        }
        return this.defaultAuthLocale;
    }

    public void logIt(String[] stringArray, int n, String string, Hashtable hashtable) {
        if (stringArray == null) {
            return;
        }
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            if (logStatus) {
                LogMessageProviderBase logMessageProviderBase = (LogMessageProviderBase)MessageProviderFactory.getProvider("Authentication");
                LogRecord logRecord = null;
                logRecord = hashtable == null ? logMessageProviderBase.createLogRecord(string, stringArray, sSOToken) : logMessageProviderBase.createLogRecord(string, stringArray, hashtable);
                switch (n) {
                    case 0: {
                        this.logger = (Logger)Logger.getLogger("amAuthentication.access");
                        this.logger.log(logRecord, sSOToken);
                        break;
                    }
                    case 1: {
                        this.logger = (Logger)Logger.getLogger("amAuthentication.error");
                        this.logger.log(logRecord, sSOToken);
                        break;
                    }
                    default: {
                        this.logger = (Logger)Logger.getLogger("amAuthentication.access");
                        this.logger.log(logRecord, sSOToken);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            debug.error("Logging exception:", (Throwable)exception);
        }
    }

    public AMStoreConnection getSDK() {
        return this.dpStore;
    }

    void printProfileAttrs() {
        if (!debug.messageEnabled()) {
            return;
        }
        debug.message("Authd Profile Attributes");
        String string = this.adminAuthModule;
        int n = this.adminAuthModule.lastIndexOf(".");
        if (n > 0) {
            string = this.adminAuthModule.substring(n + 1);
        }
        if (debug.messageEnabled()) {
            debug.message("adminAuthModule->" + this.adminAuthModule + "\nadminAuthName->" + string + "\ndefaultOrg->" + this.defaultOrg + "\nlocale->" + this.platformLocale + "\ncharset>" + this.platformCharset);
        }
    }

    static SessionService getSS() {
        SessionService sessionService = SessionService.getSessionService();
        if (sessionService == null) {
            debug.error("AuthD failed to get session service instance");
        }
        return sessionService;
    }

    public String getDefaultOrg() {
        return this.defaultOrg;
    }

    public Session getAuthSession() {
        return this.authSession;
    }

    public SSOToken getSSOAuthSession() {
        return this.ssoAuthSession;
    }

    private void initAuthSessions() throws SSOException, SessionException {
        if (this.authSession == null) {
            this.authSession = AuthD.getSS().getAuthenticationSession(this.defaultOrg, null);
            if (this.authSession == null) {
                debug.error("AuthD failed to get auth session");
                throw new SessionException(BUNDLE_NAME, "gettingSessionFailed", null);
            }
            this.authSession.setProperty("Principal", this.authSession.getClientID());
            this.authSession.setProperty("Organization", this.defaultOrg);
            this.authSession.setProperty("Host", this.authSession.getID().getSessionServer());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            this.ssoAuthSession = sSOTokenManager.createSSOToken(this.authSession.getID().toString());
        }
    }

    boolean getInetDomainStatus(String string) throws IdRepoException, SSOException {
        return IdUtils.isOrganizationActive(this.ssoAuthSession, string);
    }

    public String getClientPlatformCharset(Vector vector, String string) {
        String string2;
        block11: {
            block10: {
                String string3;
                if (debug.messageEnabled()) {
                    debug.message("platform charset : " + this.platformCharset);
                }
                if ((string3 = this.getClientCharsets(string)) != null && string3.length() > 0) {
                    return string3;
                }
                string2 = null;
                try {
                    if (vector.contains(this.platformCharset)) {
                        string2 = this.platformCharset;
                    }
                }
                catch (Exception exception) {
                    if (!debug.warningEnabled()) break block10;
                    debug.warning("Exception: getClientPlatformCharset :", (Throwable)exception);
                }
            }
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            try {
                string2 = (String)vector.firstElement();
                if (debug.messageEnabled()) {
                    debug.message("Platform CharSet is.. :" + string2);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block11;
                debug.warning("Exception:getPlatformCharsets :", (Throwable)exception);
            }
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return this.platformCharset;
    }

    String getClientCharsets(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                if (this.platformClientCharsets == null) break block4;
                Iterator iterator = this.platformClientCharsets.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    int n;
                    String string4 = (String)iterator.next();
                    if (string4 == null || string4.length() <= 0 || (n = string4.indexOf("|")) == -1 || !(string3 = string4.substring(0, n)).equals(string)) continue;
                    string2 = string4.substring(n + 1);
                    if (debug.messageEnabled()) {
                        debug.message("clientCharset:" + string2);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("Exception:getClientCharsets : ", (Throwable)exception);
            }
        }
        return string2;
    }

    public boolean isSuperAdmin(String string) {
        boolean bl = false;
        if (string != null && DN.isDN((String)string) && (superAdmin != null || specialUser != null)) {
            String string2 = AuthUtils.getNormalizedDN(string);
            if (debug.messageEnabled()) {
                debug.message("passed dn is :" + string);
                debug.message("normalied dn is :" + string2);
            }
            if (superAdmin != null) {
                String string3 = AuthUtils.getNormalizedDN(superAdmin);
                if (debug.messageEnabled()) {
                    debug.message("normalized super dn is :" + string3);
                }
                bl = string2.equals(string3);
            }
            if (!bl) {
                bl = this.isSpecialUser(string2);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("is Super Admin :" + bl);
        }
        return bl;
    }

    public boolean isSpecialUser(String string) {
        boolean bl = false;
        if (string != null && DN.isDN((String)string) && specialUser != null) {
            String string2 = AuthUtils.getNormalizedDN(string);
            if (debug.messageEnabled()) {
                debug.message("passed dn is :" + string);
                debug.message("normalied dn is :" + string2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(specialUser, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                String string4 = AuthUtils.getNormalizedDN(string3);
                if (debug.messageEnabled()) {
                    debug.message("normalized special dn is :" + string4);
                }
                if (!string2.equals(string4)) continue;
                bl = true;
                break;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("is Special User :" + bl);
        }
        return bl;
    }

    public ResourceBundle getResourceBundle(String string) {
        if (string == null) {
            return this.bundle;
        }
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = Locale.getResourceBundle((String)BUNDLE_NAME, (String)string);
            if (resourceBundle == null) {
                resourceBundle = this.bundle;
            }
            bundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    public long getDefaultSleepTime() {
        return this.defaultSleepTime * 1000L;
    }

    public String getOrgDN(String string) {
        DN dN = new DN(string);
        DN dN2 = new DN(this.rootSuffix);
        String string2 = null;
        if (debug.messageEnabled()) {
            debug.message("userOrg is : " + string);
            debug.message("rootSuffix is : " + this.rootSuffix);
            debug.message("rootSuffixDN is : " + dN2);
            debug.message("userOrgDN is : " + dN);
        }
        string2 = dN.equals(dN2) || dN.isDescendantOf(dN2) ? dN.toString() : new StringBuffer(50).append(dN.toString()).append(",").append(dN2).toString();
        if (debug.messageEnabled()) {
            debug.message("Returning OrgDN is : " + string2);
        }
        return string2.toString();
    }

    public String processURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = string;
        if (string2 != null) {
            string2 = this.processDynamicVariables(string2, httpServletRequest);
        }
        if (debug.messageEnabled()) {
            debug.message("processURL : " + string2);
        }
        return string2;
    }

    private String processDynamicVariables(String string, HttpServletRequest httpServletRequest) {
        if (string.indexOf("%") != -1) {
            StringBuffer stringBuffer = new StringBuffer(200);
            int n = string.indexOf("%protocol");
            if (n != -1) {
                stringBuffer.append(string.substring(0, n));
                if (isConsoleRemote) {
                    stringBuffer.append(consoleProto);
                } else {
                    String string2 = null;
                    if (httpServletRequest != null) {
                        string2 = RequestUtils.getRedirectProtocol((String)httpServletRequest.getScheme(), (String)httpServletRequest.getServerName());
                    }
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(consoleProto);
                    }
                }
                stringBuffer.append(string.substring(n + "%protocol".length()));
                string = stringBuffer.toString();
            }
            if ((n = string.indexOf("%host")) != -1) {
                int n2 = "%host".length();
                stringBuffer.delete(0, 200);
                stringBuffer.append(string.substring(0, n));
                if (isConsoleRemote) {
                    stringBuffer.append(consoleHost);
                } else {
                    String string3 = null;
                    if (httpServletRequest != null) {
                        string3 = httpServletRequest.getHeader("Host");
                    }
                    if (string3 != null) {
                        stringBuffer.append(string3);
                        ++n2;
                    } else {
                        stringBuffer.append(consoleHost);
                    }
                }
                stringBuffer.append(string.substring(n + n2));
                string = stringBuffer.toString();
            }
            if ((n = string.indexOf("%port")) != -1) {
                stringBuffer.delete(0, 200);
                stringBuffer.append(string.substring(0, n));
                if (isConsoleRemote) {
                    stringBuffer.append(consolePort);
                }
                stringBuffer.append(string.substring(n + "%port".length()));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        if (debug.messageEnabled()) {
            debug.message("Setting servletContext" + servletContext);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMIdentityRepository getAMIdentityRepository(String string) {
        AMIdentityRepository aMIdentityRepository;
        block6: {
            aMIdentityRepository = null;
            try {
                if (idRepoMap != null && !idRepoMap.isEmpty()) {
                    aMIdentityRepository = (AMIdentityRepository)idRepoMap.get(string);
                }
                if (aMIdentityRepository != null) break block6;
                aMIdentityRepository = new AMIdentityRepository(this.ssoAuthSession, string);
                HashMap hashMap = idRepoMap;
                synchronized (hashMap) {
                    idRepoMap.put(string, aMIdentityRepository);
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block6;
                debug.message("Error getAMIdentityRepository", (Throwable)exception);
            }
        }
        return aMIdentityRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationConfigManager getOrgConfigManager(String string) {
        OrganizationConfigManager organizationConfigManager;
        block7: {
            organizationConfigManager = null;
            try {
                if (orgMap != null && !orgMap.isEmpty()) {
                    organizationConfigManager = (OrganizationConfigManager)orgMap.get(string);
                }
                HashMap hashMap = orgMap;
                synchronized (hashMap) {
                    if (organizationConfigManager == null) {
                        organizationConfigManager = new OrganizationConfigManager(this.ssoAuthSession, string);
                        orgMap.put(string, organizationConfigManager);
                    }
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block7;
                debug.message("Error getAMIdentityRepository", (Throwable)exception);
            }
        }
        return organizationConfigManager;
    }

    public AMIdentity getIdentity(IdType idType, String string, String string2) throws AuthException {
        AMIdentity aMIdentity;
        block17: {
            block16: {
                if (debug.messageEnabled()) {
                    debug.message("IdType is :" + idType);
                    debug.message("IdName is :" + string);
                    debug.message("orgName is :" + string2);
                }
                aMIdentity = null;
                try {
                    if (debug.messageEnabled()) {
                        debug.message("AuthD.getIdentity() from IdUtils Name: " + string + " Org: " + string2);
                    }
                    if ((aMIdentity = IdUtils.getIdentity(this.getSSOAuthSession(), string, string2)) != null && aMIdentity.getType().equals(idType) && aMIdentity.getAttributes() != null) {
                        if (debug.messageEnabled()) {
                            debug.message("AuthD.getIdentity obtained identityusing IdUtil.getIdentity: " + aMIdentity);
                        }
                        return aMIdentity;
                    }
                }
                catch (IdRepoException idRepoException) {
                    if (debug.messageEnabled()) {
                        debug.message("AuthD.getIdentity: Got IdRepoException while getting Identity from IdUtils: " + idRepoException.getMessage());
                    }
                }
                catch (SSOException sSOException) {
                    if (!debug.messageEnabled()) break block16;
                    debug.message("AuthD.getIdentity: Got SSOException while getting Identity from IdUtils: " + sSOException.getMessage());
                }
            }
            try {
                string = AuthUtils.DNtoName(string);
                AMIdentityRepository aMIdentityRepository = this.getAMIdentityRepository(string2);
                IdSearchControl idSearchControl = new IdSearchControl();
                idSearchControl.setRecursive(true);
                idSearchControl.setTimeOut(0);
                idSearchControl.setMaxResults(0);
                idSearchControl.setAllReturnAttributes(false);
                IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(idType, string, idSearchControl);
                Set set = Collections.EMPTY_SET;
                if (idSearchResults != null) {
                    set = idSearchResults.getSearchResults();
                }
                if (set != null && set.size() > 1) {
                    debug.error("getIdentity: Multiple matches found for user '" + string);
                    throw new AuthException("102", null);
                }
                Iterator iterator = set.iterator();
                if (iterator.hasNext()) {
                    aMIdentity = (AMIdentity)iterator.next();
                }
            }
            catch (SSOException sSOException) {
                if (debug.messageEnabled()) {
                    debug.message("getIdentity error " + sSOException.getMessage());
                }
            }
            catch (IdRepoException idRepoException) {
                if (!debug.messageEnabled()) break block17;
                debug.message("IdRepoException error " + idRepoException.getMessage());
            }
        }
        if (aMIdentity == null) {
            throw new AuthException("100", null);
        }
        return aMIdentity;
    }

    public String getSuperUserName() {
        return superAdmin;
    }

    public static boolean isHttpSessionUsed() {
        return useHttpSession;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        bundles = new HashMap();
        authInitFailed = false;
        superAdmin = SystemProperties.get((String)"com.sun.identity.authentication.super.user", (String)"");
        specialUser = SystemProperties.get((String)"com.sun.identity.authentication.special.users", (String)"");
        consoleProto = SystemProperties.get((String)"com.iplanet.am.console.protocol", (String)"http");
        consoleHost = SystemProperties.get((String)"com.iplanet.am.console.host");
        consolePort = SystemProperties.get((String)"com.iplanet.am.console.port");
        isConsoleRemote = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.console.remote"));
        enforceJAASThread = false;
        directoryHostName = SystemProperties.get((String)"com.iplanet.am.directory.host");
        directoryPort = Integer.parseInt(SystemProperties.get((String)"com.iplanet.am.directory.port"));
        idRepoMap = new HashMap();
        orgMap = new HashMap();
        platLocale = SystemProperties.get((String)"com.iplanet.am.locale");
        logStatus = false;
        String string2 = "INACTIVE";
        string2 = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (string2.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
        if ((string = SystemProperties.get((String)"com.sun.identity.auth.sessionStore")) != null && string.equalsIgnoreCase("HttpSession")) {
            useHttpSession = true;
        }
        if ((debug = Debug.getInstance((String)BUNDLE_NAME)).messageEnabled()) {
            debug.message("Directory Host: " + directoryHostName + "\nDirectory PORT : " + directoryPort);
            debug.message("Session store using " + string);
        }
    }
}

