/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.Locale;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.common.AccountLockoutInfo;
import com.sun.identity.common.ISAccountLockout;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.util.DN;

class AMAccountLockout {
    LoginState loginState = null;
    private static AuthD ad = AuthD.getAuth();
    public boolean loginFailureLockoutMode = false;
    public boolean loginFailureLockoutStoreInDS = true;
    private long loginFailureLockoutTime = 300L;
    private int loginFailureLockoutCount = 5;
    private String loginLockoutNotification = null;
    private int loginLockoutUserWarning = 3;
    private int userWarningCount = 0;
    private int warnUser = -1;
    private long loginFailureLockoutDuration = 0L;
    public String loginLockoutAttrValue = null;
    public String loginLockoutAttrName = null;
    private ISAccountLockout isAccountLockout;
    private AccountLockoutInfo acInfo = null;
    static String bundleName = "amAuth";
    String token = null;
    private boolean accountLocked = false;
    private static final String USER_ACTIVE = "active";
    private static final String FALSE_VALUE = "false";
    private static final String INETUSERSTATUS_ATTR = "inetuserstatus";
    private static final String LOGIN_STATUS_ATTR = "iplanet-am-user-login-status";
    private static final String NSACCOUNTLOCK_ATTR = "nsaccountlock";
    static AuthUtils au = new AuthUtils();

    public AMAccountLockout(LoginState loginState) {
        this.loginState = loginState;
        this.loginFailureLockoutTime = loginState.getLoginFailureLockoutTime();
        this.loginFailureLockoutCount = loginState.getLoginFailureLockoutCount();
        this.loginLockoutNotification = loginState.getLoginLockoutNotification();
        this.loginLockoutUserWarning = loginState.getLoginLockoutUserWarning();
        this.loginLockoutAttrName = loginState.getLoginLockoutAttrName();
        this.loginLockoutAttrValue = loginState.getLoginLockoutAttrValue();
        this.loginFailureLockoutDuration = loginState.getLoginFailureLockoutDuration();
        this.loginFailureLockoutMode = loginState.getLoginFailureLockoutMode();
        this.loginFailureLockoutStoreInDS = loginState.getLoginFailureLockoutStoreInDS();
        this.isAccountLockout = new ISAccountLockout(this.loginFailureLockoutMode, this.loginFailureLockoutTime, this.loginFailureLockoutCount, this.loginLockoutNotification, this.loginLockoutUserWarning, this.loginLockoutAttrName, this.loginLockoutAttrValue, this.loginFailureLockoutDuration, bundleName);
        this.isAccountLockout.setStoreInvalidAttemptsInDS(this.loginFailureLockoutStoreInDS);
    }

    public void invalidPasswd(String string) {
        block8: {
            try {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("AMAccountLockout::invalidPasswd : " + string);
                }
                this.token = string;
                if (!this.isAccountLockout.isLockoutEnabled()) {
                    AuthD.debug.message("Failure lockout mode disabled");
                } else {
                    String string2 = null;
                    AMIdentity aMIdentity = null;
                    if (this.isAccountLockout.getStoreInvalidAttemptsInDS() || !this.isAccountLockout.isMemoryLocking()) {
                        aMIdentity = AuthD.getAuth().getIdentity(IdType.USER, string, this.loginState.getOrgDN());
                        string2 = this.normalizeDN(IdUtils.getDN(aMIdentity));
                    } else {
                        string2 = string;
                    }
                    if (this.acInfo == null) {
                        this.acInfo = this.isAccountLockout.getAcInfo(string2, aMIdentity);
                    }
                    this.warnUser = this.isAccountLockout.invalidPasswd(string2, string, aMIdentity, this.acInfo);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block8;
                AuthD.debug.message("invalidPasswd:Error : " + exception.toString());
            }
        }
    }

    public boolean isAccountExpired() {
        AuthD.debug.message("in AMAccountLockout::isAccountExpired");
        String string = this.loginState.getAccountLife();
        if (string == null) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("EXIT accountLife is null :" + string);
            }
            return false;
        }
        Date date = Locale.parseNormalizedDateString((String)string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("exprDate = " + date);
        }
        if (date != null) {
            return date.before(new Date());
        }
        return false;
    }

    public int getWarnUserCount() {
        return this.warnUser;
    }

    public void sendLockOutNotice(String string) {
        this.isAccountLockout.sendLockOutNotice(string);
    }

    public void resetPasswdLockout(String string) {
        try {
            String string2 = null;
            if (string != null) {
                AMIdentity aMIdentity = null;
                if (this.isAccountLockout.getStoreInvalidAttemptsInDS()) {
                    aMIdentity = AuthD.getAuth().getIdentity(IdType.USER, string, this.loginState.getOrgDN());
                    string2 = this.normalizeDN(IdUtils.getDN(aMIdentity));
                } else {
                    string2 = string;
                }
                if (this.acInfo == null) {
                    this.acInfo = this.isAccountLockout.getAcInfo(string2, aMIdentity);
                }
                this.isAccountLockout.resetLockoutAttempts(string2, aMIdentity, this.acInfo);
                this.warnUser = 0;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("resetPasswordFailCount: token=" + string + "  userDN=" + string2);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Exception in resetPasswordLockout");
        }
    }

    public boolean isLockoutEnabled() {
        return this.isAccountLockout.isLockoutEnabled();
    }

    public boolean isLockedOut() {
        String string = this.loginState.getUserDN();
        return this.isLockedOut(string);
    }

    public boolean isLockedOut(String string) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.isAccountLockout.isMemoryLocking() ? this.isMemoryLockout(string) : this.isAccountLocked(string);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("isLockedOut:Exception : ", (Throwable)exception);
            }
        }
        return bl;
    }

    private boolean isMemoryLockout(String string) {
        boolean bl;
        block8: {
            bl = false;
            try {
                String string2 = null;
                AMIdentity aMIdentity = null;
                if (this.isAccountLockout.getStoreInvalidAttemptsInDS()) {
                    aMIdentity = AuthD.getAuth().getIdentity(IdType.USER, string, this.loginState.getOrgDN());
                    string2 = this.normalizeDN(IdUtils.getDN(aMIdentity));
                } else {
                    string2 = string;
                }
                if (this.acInfo == null) {
                    this.acInfo = this.isAccountLockout.getAcInfo(string2, aMIdentity);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("isLockedOut:userDN=" + string2);
                    AuthD.debug.message("isLockedOut:acInfo=" + this.acInfo);
                }
                if (this.acInfo != null && !(bl = this.isAccountLockout.isLockedOut(this.acInfo)) && this.acInfo.isLockout()) {
                    this.resetPasswdLockout(string);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("isLockedOut :" + bl);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block8;
                AuthD.debug.message("isLockedOut:Exception : ", (Throwable)exception);
            }
        }
        return bl;
    }

    public boolean isAccountLocked(String string) {
        boolean bl;
        block10: {
            bl = false;
            try {
                AMIdentity aMIdentity = AuthD.getAuth().getIdentity(IdType.USER, string, this.loginState.getOrgDN());
                String string2 = this.normalizeDN(IdUtils.getDN(aMIdentity));
                if (this.acInfo == null) {
                    this.acInfo = this.isAccountLockout.getAcInfo(string2, aMIdentity);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("userDN=" + string2);
                    AuthD.debug.message("acInfo=" + this.acInfo);
                }
                if (this.isAccountLockout.isMemoryLocking() && this.acInfo != null) {
                    bl = this.acInfo.isLockout();
                } else if (this.isAccountValid(aMIdentity)) {
                    bl = this.isAccountLockout.isAccountLocked(aMIdentity);
                    if (bl) {
                        this.resetPasswdLockout(string);
                    }
                } else {
                    bl = true;
                    this.resetPasswdLockout(string);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("isLockedOut :" + bl);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block10;
                AuthD.debug.message("isAccountLocked:Exception : ", (Throwable)exception);
            }
        }
        return bl;
    }

    boolean isAccountValid(AMIdentity aMIdentity) {
        boolean bl;
        block13: {
            bl = true;
            try {
                Iterator iterator = null;
                Set set = aMIdentity.getAttribute(INETUSERSTATUS_ATTR);
                String string = null;
                if (set == null || set.isEmpty()) {
                    string = USER_ACTIVE;
                } else {
                    iterator = set.iterator();
                    string = (String)iterator.next();
                    if (string == null || string.length() == 0) {
                        string = USER_ACTIVE;
                    }
                }
                Set set2 = aMIdentity.getAttribute(LOGIN_STATUS_ATTR);
                String string2 = null;
                if (set2 == null || set2.isEmpty()) {
                    string2 = USER_ACTIVE;
                } else {
                    iterator = set2.iterator();
                    string2 = (String)iterator.next();
                    if (string2 == null || string2.length() == 0) {
                        string2 = USER_ACTIVE;
                    }
                }
                Set set3 = aMIdentity.getAttribute(NSACCOUNTLOCK_ATTR);
                String string3 = null;
                if (set3 == null || set3.isEmpty()) {
                    string3 = FALSE_VALUE;
                } else {
                    iterator = set3.iterator();
                    string3 = (String)iterator.next();
                    if (string3 == null || string3.length() == 0) {
                        string3 = FALSE_VALUE;
                    }
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("inetuserstatus : " + string);
                    AuthD.debug.message("loginStatus : " + string2);
                    AuthD.debug.message("nsAccountLockVal : " + string3);
                }
                bl = string.equalsIgnoreCase(USER_ACTIVE) && string2.equalsIgnoreCase(USER_ACTIVE) && string3.equalsIgnoreCase(FALSE_VALUE);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block13;
                AuthD.debug.message("isAccountValid:Error :" + exception.toString());
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("User enabled..." + bl);
        }
        return bl;
    }

    private String normalizeDN(String string) {
        String string2 = string;
        if (string != null && DN.isDN((String)string)) {
            string2 = AuthUtils.getNormalizedDN(string);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Original DN is:" + string);
            AuthD.debug.message("Normalized DN is:" + string2);
        }
        return string2;
    }
}

