/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.server.AuthXMLResponse;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.X509CertificateCallback;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.L10NMessage;
import java.io.Serializable;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthXMLHandler
implements RequestHandler {
    private String localAuthServerProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    private String localAuthServer = SystemProperties.get((String)"com.iplanet.am.server.host");
    private String localAuthServerPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    static Debug debug;
    private Locale locale = null;
    private static Set cookieDomains;
    private static AuthUtils au;
    private static String serviceURI;

    public AuthXMLHandler() {
        AuthContext.localAuthServiceID = this.localAuthServerProtocol + "://" + this.localAuthServer + ":" + this.localAuthServerPort;
        this.locale = new ISLocaleContext().getLocale();
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        ResponseSet responseSet = new ResponseSet("auth");
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request, httpServletRequest, httpServletResponse);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        Serializable serializable;
        String string;
        Object object2;
        debug.message("=======================Entering processRequest");
        httpServletRequest.getSession(true);
        String string2 = request.getContent();
        AuthXMLResponse authXMLResponse = null;
        String string3 = null;
        int n = string2.indexOf("authIdentifier");
        if (n != -1) {
            int n2 = string2.indexOf(34, n);
            int n3 = string2.indexOf(34, n2 + 1);
            object2 = string2.substring(n2 + 1, n3);
            if (debug.messageEnabled()) {
                debug.message("authIdentifier = " + (String)object2 + "beginIndex = " + n2 + "endIndex =" + n3);
            }
            if (!((String)object2).equals("0")) {
                try {
                    string = new SessionID((String)object2);
                    serializable = Session.getSessionServiceURL((SessionID)string);
                    object = new StringBuffer(100);
                    ((StringBuffer)object).append(((URL)serializable).getProtocol()).append("://").append(((URL)serializable).getHost()).append(":").append(Integer.toString(((URL)serializable).getPort())).append(serviceURI);
                    string3 = ((StringBuffer)object).toString();
                }
                catch (Exception exception) {
                    debug.error("Error in getting URL from session");
                    string3 = null;
                }
            }
        }
        if (string3 != null && string3.trim().length() != 0 && !au.isLocalServer(string3, serviceURI)) {
            HashMap hashMap = new HashMap();
            HashMap<String, Serializable> hashMap2 = new HashMap<String, Serializable>();
            object2 = httpServletRequest.getHeaderNames();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                serializable = new ArrayList();
                object = httpServletRequest.getHeaders(string);
                while (object.hasMoreElements()) {
                    serializable.add(object.nextElement());
                }
                hashMap2.put(string, serializable);
            }
            if (debug.messageEnabled()) {
                debug.message("Headers: " + hashMap2);
            }
            PLLClient.parseCookies(hashMap2, hashMap);
            if (debug.messageEnabled()) {
                debug.message("Cookies: " + hashMap);
            }
            string = new RequestSet("auth");
            string.addRequest(request);
            try {
                serializable = PLLClient.send((URL)new URL(string3), (RequestSet)string, hashMap);
                if (!((Vector)serializable).isEmpty()) {
                    debug.message("=====================Returning redirected");
                    return (Response)((Vector)serializable).elementAt(0);
                }
            }
            catch (Exception exception) {
                debug.error("Error in misrouted ", (Throwable)exception);
                authXMLResponse = new AuthXMLResponse(0);
                this.setErrorCode(authXMLResponse, exception);
                return new Response(authXMLResponse.toXMLString());
            }
        }
        try {
            AuthXMLRequest authXMLRequest = AuthXMLRequest.parseXML(string2, httpServletRequest);
            authXMLRequest.setHttpServletRequest(httpServletRequest);
            authXMLResponse = this.processAuthXMLRequest(authXMLRequest, httpServletRequest, httpServletResponse);
        }
        catch (AuthException authException) {
            debug.error("Got Auth Exception", (Throwable)((Object)authException));
            authXMLResponse = new AuthXMLResponse(0);
            authXMLResponse.setErrorCode(authException.getErrorCode());
        }
        debug.message("=======================Returning");
        return new Response(authXMLResponse.toXMLString());
    }

    private AuthXMLResponse processAuthXMLRequest(AuthXMLRequest authXMLRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Callback[] callbackArray;
        Object object;
        Object object2;
        if (debug.messageEnabled()) {
            debug.message("authXMLRequest is : " + authXMLRequest);
        }
        int n = authXMLRequest.getRequestType();
        String string = authXMLRequest.getAuthIdentifier();
        String string2 = authXMLRequest.getOrgName();
        AuthContextLocal authContextLocal = authXMLRequest.getAuthContext();
        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
        String string3 = authXMLRequest.getParams();
        AuthXMLResponse authXMLResponse = new AuthXMLResponse(n);
        authXMLResponse.setAuthContext(authContextLocal);
        authXMLResponse.setAuthIdentifier(string);
        if (debug.messageEnabled()) {
            debug.message("authContext is : " + authContextLocal);
            debug.message("requestType : " + n);
        }
        if (au.getIndexType(authContextLocal) == AuthContext.IndexType.LEVEL || au.getIndexType(authContextLocal) == AuthContext.IndexType.COMPOSITE_ADVICE) {
            object2 = authXMLRequest.getSubmittedCallbacks();
            if (debug.messageEnabled()) {
                debug.message("Callbacks are  : " + object2);
            }
            if (object2 != null) {
                if (debug.messageEnabled()) {
                    debug.message("Callback length is : " + ((Callback[])object2).length);
                }
                if (object2[0] instanceof ChoiceCallback) {
                    object = (ChoiceCallback)object2[0];
                    callbackArray = (Callback[])((ChoiceCallback)object).getSelectedIndexes();
                    Callback callback = callbackArray[0];
                    String[] stringArray = ((ChoiceCallback)object).getChoices();
                    String string4 = stringArray[callback];
                    if (debug.messageEnabled()) {
                        debug.message("Selected Index is : " + string4);
                    }
                    authXMLRequest.setIndexType("moduleInstance");
                    authXMLRequest.setIndexName(string4);
                    authXMLRequest.setRequestType(6);
                    n = 6;
                }
            }
        }
        object2 = AuthContext.Status.IN_PROGRESS;
        switch (n) {
            case 0: {
                try {
                    this.processNewRequest(httpServletRequest, httpServletResponse, authXMLResponse, loginState, authContextLocal);
                    this.postProcess(loginState, authXMLResponse);
                }
                catch (Exception exception) {
                    debug.error("Error creating AuthContext ", (Throwable)exception);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 1: {
                try {
                    if (string != null && string.equals("0")) {
                        this.processNewRequest(httpServletRequest, httpServletResponse, authXMLResponse, loginState, authContextLocal);
                    }
                    authContextLocal.login();
                    this.processRequirements(authContextLocal, authXMLResponse, string3);
                    this.postProcess(loginState, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error during login ", (Throwable)exception);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 6: {
                try {
                    object = authXMLRequest.getIndexType();
                    callbackArray = authXMLRequest.getIndexName();
                    if (debug.messageEnabled()) {
                        debug.message("indexName is : " + (String)callbackArray);
                        debug.message("indexType is : " + object);
                    }
                    if (string != null && string.equals("0")) {
                        this.processNewRequest(httpServletRequest, httpServletResponse, authXMLResponse, loginState, authContextLocal);
                    }
                    authContextLocal.login((AuthContext.IndexType)object, (String)callbackArray);
                    this.processRequirements(authContextLocal, authXMLResponse, string3);
                    this.postProcess(loginState, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Login Exception ", (Throwable)exception);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 8: {
                try {
                    object = authXMLRequest.getSubject();
                    authContextLocal.login((Subject)object);
                    this.processRequirements(authContextLocal, authXMLResponse, string3);
                    this.postProcess(loginState, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Login Exception ", (Throwable)authLoginException);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 2: {
                try {
                    object = authXMLRequest.getSubmittedCallbacks();
                    authContextLocal.submitRequirements((Callback[])object);
                    callbackArray = null;
                    if (authContextLocal.hasMoreRequirements()) {
                        callbackArray = authContextLocal.getRequirements();
                        authXMLResponse.setReqdCallbacks(callbackArray);
                    }
                    this.postProcess(loginState, authXMLResponse);
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error during login ", (Throwable)exception);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 3: {
                try {
                    if (string != null && string.equals("0")) {
                        this.processNewRequest(httpServletRequest, httpServletResponse, authXMLResponse, loginState, authContextLocal);
                    }
                    object = authContextLocal.getModuleInstanceNames();
                    authXMLResponse.setModuleNames((Set)object);
                    authXMLResponse.setAuthContext(authContextLocal);
                    this.postProcess(loginState, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error aborting ", (Throwable)exception);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 4: {
                try {
                    authContextLocal.logout();
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error logging out", (Throwable)authLoginException);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 5: {
                try {
                    authContextLocal.abort();
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                    break;
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error aborting ", (Throwable)authLoginException);
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("loginStatus: " + object2);
            debug.message("error Code: " + authContextLocal.getErrorCode());
            debug.message("error Template: " + authContextLocal.getErrorTemplate());
        }
        if (object2 == AuthContext.Status.FAILED) {
            if (authContextLocal.getErrorCode() != null && authContextLocal.getErrorCode().length() > 0) {
                authXMLResponse.setErrorCode(authContextLocal.getErrorCode());
            }
            this.checkACException(authXMLResponse, authContextLocal);
            if (authContextLocal.getErrorTemplate() != null && authContextLocal.getErrorTemplate().length() > 0) {
                authXMLResponse.setErrorTemplate(authContextLocal.getErrorTemplate());
            }
        }
        return authXMLResponse;
    }

    private void processNewRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthXMLResponse authXMLResponse, LoginState loginState, AuthContextLocal authContextLocal) throws AuthException {
        if (authContextLocal == null) {
            throw new AuthException("108", null);
        }
        Object object = httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        X509Certificate[] x509CertificateArray = (X509Certificate[])object;
        AuthContextLocal authContextLocal2 = loginState.getPrevAuthContext();
        authXMLResponse.setPrevAuthContext(authContextLocal2);
        if (x509CertificateArray != null && x509CertificateArray.length != 0) {
            if (debug.messageEnabled()) {
                debug.message("length of cert array : " + x509CertificateArray.length);
            }
            loginState.setX509Certificate(x509CertificateArray[0]);
        }
        String string = null;
        if (httpServletRequest != null) {
            string = httpServletRequest.getRemoteAddr();
            loginState.setClient(string);
        }
        authXMLResponse.setLoginStatus(AuthContext.Status.IN_PROGRESS);
        au.setlbCookie(authContextLocal, httpServletResponse);
    }

    private void postProcess(LoginState loginState, AuthXMLResponse authXMLResponse) {
        SessionID sessionID = loginState.getSid();
        String string = null;
        if (sessionID != null) {
            string = sessionID.toString();
        }
        if (debug.messageEnabled()) {
            debug.message("sidString is.. : " + string);
        }
        authXMLResponse.setAuthIdentifier(string);
    }

    private String getNextParam(StringTokenizer stringTokenizer) {
        String string = null;
        if (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    void processRequirements(AuthContextLocal authContextLocal, AuthXMLResponse authXMLResponse, String string) {
        Callback[] callbackArray;
        Object var4_4 = null;
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "|");
        }
        boolean bl = true;
        while (authContextLocal.hasMoreRequirements()) {
            callbackArray = authContextLocal.getRequirements();
            int n = 0;
            while (n < callbackArray.length) {
                block18: {
                    Callback callback;
                    if (callbackArray[n] instanceof X509CertificateCallback) {
                        callback = (X509CertificateCallback)callbackArray[n];
                        LoginState loginState = AuthUtils.getLoginState(authContextLocal);
                        if (loginState != null) {
                            X509Certificate x509Certificate = loginState.getX509Certificate();
                            ((X509CertificateCallback)callback).setCertificate(x509Certificate);
                        }
                    } else {
                        String string2 = null;
                        if (callbackArray[n] instanceof NameCallback) {
                            string2 = this.getNextParam(stringTokenizer);
                            if (string2 != null) {
                                callback = (NameCallback)callbackArray[n];
                                ((NameCallback)callback).setName(string2);
                                if (debug.messageEnabled()) {
                                    debug.message("Name callback set to " + string2);
                                }
                                break block18;
                            } else {
                                bl = false;
                                break;
                            }
                        }
                        if (callbackArray[n] instanceof PasswordCallback) {
                            string2 = this.getNextParam(stringTokenizer);
                            if (string2 != null) {
                                callback = (PasswordCallback)callbackArray[n];
                                ((PasswordCallback)callback).setPassword(string2.toCharArray());
                                if (debug.messageEnabled()) {
                                    debug.message("Password callback is set");
                                }
                            } else {
                                bl = false;
                                break;
                            }
                        }
                    }
                }
                ++n;
            }
            if (bl) {
                if (debug.messageEnabled()) {
                    debug.message("submit callbacks with passed in params");
                }
                authContextLocal.submitRequirements(callbackArray);
                continue;
            }
            authXMLResponse.setReqdCallbacks(callbackArray);
            break;
        }
        if (!authContextLocal.hasMoreRequirements()) {
            callbackArray = authContextLocal.getStatus();
            if (debug.messageEnabled()) {
                debug.message(" Status: " + callbackArray);
            }
            authXMLResponse.setLoginStatus((AuthContext.Status)callbackArray);
        }
    }

    private void checkACException(AuthXMLResponse authXMLResponse, AuthContextLocal authContextLocal) {
        AuthLoginException authLoginException = authContextLocal.getLoginException();
        if (authLoginException == null) {
            return;
        }
        if (authLoginException.getL10NMessage(this.locale) != null && authLoginException.getL10NMessage(this.locale).length() > 0) {
            authXMLResponse.setErrorMessage(authLoginException.getL10NMessage(this.locale));
        }
        authXMLResponse.setIsException(true);
    }

    private void setErrorCode(AuthXMLResponse authXMLResponse, Exception exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof L10NMessage) {
            authXMLResponse.setErrorCode(this.getAuthErrorCode((L10NMessage)exception));
        } else {
            authXMLResponse.setErrorCode(exception.getMessage());
        }
        authXMLResponse.setIsException(true);
    }

    private String getAuthErrorCode(L10NMessage l10NMessage) {
        String string = l10NMessage.getErrorCode();
        if (string == null) {
            string = l10NMessage.getMessage();
        }
        return string;
    }

    static {
        cookieDomains = null;
        debug = Debug.getInstance((String)"amXMLHandler");
        au = new AuthUtils();
        serviceURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor") + "/authservice";
    }
}

