/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStatus;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpSession;

public final class AuthContextLocal
implements Serializable {
    private static final String amAuthContextLocal = "amAuthContextLocal";
    protected static Debug authDebug = Debug.getInstance((String)"amAuthContextLocal");
    protected static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amAuthContextLocal");
    protected String organizationName;
    protected Set moduleInstanceNames;
    protected AuthContext.IndexType indexType;
    protected String indexName;
    protected AuthContext.Status loginStatus;
    protected String hostName;
    protected HttpSession httpSession;
    protected SSOToken ssoToken;
    protected volatile AuthLoginException loginException = null;
    protected Callback[] informationRequired = null;
    public AMLoginContext amlc = null;
    public LoginStatus ls;
    protected Subject subject;
    protected char[] password;
    private static boolean initialized = false;
    private LoginState loginState = null;
    public static final String LDAP_AUTH_URL = "ldap://";
    public static final String PCOOKIE = "pCookieMode";
    public static final String PRINCIPAL = "principal";
    public static final String PASSWORD = "password";
    public static final String SUBJECT = "subject";
    public static final String INDEX_TYPE = "indexType";
    public static final String INDEX_NAME = "indexName";

    public AuthContextLocal(String string) {
        authDebug.message("AuthContextLocal() constructor called");
        this.organizationName = string;
        this.amlc = new AMLoginContext(this);
        if (authDebug.messageEnabled()) {
            authDebug.message("AMLoginContext object is... " + this.amlc);
        }
        this.reset();
    }

    public Set getModuleInstanceNames() {
        this.moduleInstanceNames = this.amlc.getModuleInstanceNames();
        return this.moduleInstanceNames;
    }

    public void login() throws AuthLoginException {
        this.login(null);
    }

    public void login(Principal principal, char[] cArray) throws AuthLoginException {
        if (principal == null) {
            throw new AuthLoginException(amAuthContextLocal, "invalid-username", null);
        }
        if (cArray == null) {
            throw new AuthLoginException(amAuthContextLocal, "invalid-password", null);
        }
        this.password = cArray;
        this.login(null, null, principal, cArray, null, false);
    }

    public void login(AuthContext.IndexType indexType, String string) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + indexType + " & Indexname : " + string);
        }
        this.login(indexType, string, null, null, null, false);
    }

    public void login(Subject subject) throws AuthLoginException {
        this.login(null, null, null, null, subject, false);
    }

    public void login(AuthContext.IndexType indexType, String string, boolean bl) throws AuthLoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal::login() called with IndexType : " + indexType + " & Indexname : " + string);
        }
        this.login(indexType, string, null, null, null, bl);
    }

    protected void login(AuthContext.IndexType indexType, String string, Principal principal, char[] cArray, Subject subject, boolean bl) throws AuthLoginException {
        try {
            this.loginStatus = AuthContext.Status.IN_PROGRESS;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(INDEX_TYPE, indexType);
            hashMap.put(INDEX_NAME, string);
            hashMap.put(PRINCIPAL, principal);
            hashMap.put(PASSWORD, cArray);
            hashMap.put(SUBJECT, subject);
            hashMap.put(PCOOKIE, new Boolean(bl));
            if (authDebug.messageEnabled()) {
                authDebug.message("loginParamsMap : " + hashMap.toString());
            }
            authDebug.message("calling AMLoginContext::exceuteLogin : ");
            this.amlc.executeLogin(hashMap);
            authDebug.message("after AMLoginContext::exceuteLogin : ");
            if (this.amlc.getStatus() == 3) {
                this.loginStatus = AuthContext.Status.SUCCESS;
            } else if (this.amlc.getStatus() == 4) {
                this.loginStatus = AuthContext.Status.FAILED;
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Status at the end of login() : " + this.loginStatus);
            }
        }
        catch (AuthLoginException authLoginException) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Exception in ac.login : " + authLoginException.toString());
            }
            throw new AuthLoginException(authLoginException);
        }
    }

    public void reset() {
        authDebug.message("AuthContextLocal::reset() called");
        this.loginStatus = AuthContext.Status.NOT_STARTED;
        this.informationRequired = null;
        this.loginException = null;
    }

    public Subject getSubject() {
        if (!this.loginStatus.equals(AuthContext.Status.SUCCESS)) {
            return null;
        }
        if (this.subject == null) {
            this.subject = this.amlc.getSubject();
        }
        return this.subject;
    }

    public boolean hasMoreRequirements() {
        authDebug.message("AuthContextLocal::hasMoreRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return false;
        }
        this.informationRequired = this.amlc.getRequiredInfo();
        return this.informationRequired != null;
    }

    public boolean hasMoreRequirements(boolean bl) {
        authDebug.message("AuthContextLocal::hasMoreRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return false;
        }
        this.informationRequired = this.amlc.getRequiredInfo();
        return AuthContextLocal.getCallbacks(this.informationRequired, bl) != null;
    }

    public Callback[] getRequirements() {
        authDebug.message("AuthContextLocal::getRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return null;
        }
        return this.informationRequired;
    }

    public Callback[] getRequirements(boolean bl) {
        authDebug.message("AuthContextLocal::getRequirements()");
        if (this.amlc.getStatus() == 3 || this.amlc.getStatus() == 4) {
            return null;
        }
        return AuthContextLocal.getCallbacks(this.informationRequired, bl);
    }

    public void submitRequirements(Callback[] callbackArray) {
        authDebug.message("AuthContextLocal::submitRequirements()");
        this.informationRequired = null;
        this.amlc.submitRequiredInfo(callbackArray);
        if (!this.amlc.isPureJAAS()) {
            this.amlc.runLogin();
        }
        if (this.amlc.getStatus() == 3) {
            this.loginStatus = AuthContext.Status.SUCCESS;
        } else if (this.amlc.getStatus() == 4) {
            this.loginStatus = AuthContext.Status.FAILED;
        }
        authDebug.message("AuthContextLocal::submitRequirements end");
        if (authDebug.messageEnabled()) {
            authDebug.message("Status at the end of submitRequirements() : " + this.loginStatus);
        }
    }

    public void logout() throws AuthLoginException {
        authDebug.message("AuthContextLocal::logout()");
        try {
            this.amlc.logout();
        }
        catch (Exception exception) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Exception in AMLoginContext::logout() " + exception.getMessage());
            }
            throw new AuthLoginException(amAuthContextLocal, "logoutError", null, exception);
        }
        authDebug.message("Called AMLoginContext::logout()");
        this.loginStatus = AuthContext.Status.COMPLETED;
    }

    public AuthLoginException getLoginException() {
        authDebug.message("AuthContextLocal::getLoginException()");
        return this.loginException;
    }

    public void setLoginException(AuthLoginException authLoginException) {
        this.loginException = authLoginException;
    }

    public AuthContext.Status getStatus() {
        authDebug.message("AuthContextLocal::getStatus()");
        if (this.amlc.getStatus() == 3) {
            this.loginStatus = AuthContext.Status.SUCCESS;
        } else if (this.amlc.getStatus() == 4) {
            this.loginStatus = AuthContext.Status.FAILED;
        } else if (this.amlc.getStatus() == 7) {
            this.loginStatus = AuthContext.Status.RESET;
        } else if (this.amlc.getStatus() == 8) {
            this.loginStatus = AuthContext.Status.ORG_MISMATCH;
        } else if (this.amlc.getStatus() == 2) {
            this.loginStatus = AuthContext.Status.IN_PROGRESS;
        } else if (this.amlc.getStatus() == 5) {
            this.loginStatus = AuthContext.Status.COMPLETED;
        }
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContextLocal:: Status : " + this.loginStatus);
        }
        return this.loginStatus;
    }

    protected void setLoginStatus(AuthContext.Status status) {
        authDebug.message("AuthContextLocal::setLoginStatus()");
        this.loginStatus = status;
    }

    public SSOToken getSSOToken() {
        this.ssoToken = this.amlc.getSSOToken();
        return this.ssoToken;
    }

    public String getSuccessURL() {
        return this.amlc.getSuccessURL();
    }

    public String getFailureURL() {
        return this.amlc.getFailureURL();
    }

    public String getOrganizationName() {
        return this.amlc.getOrganizationName();
    }

    public void abort() throws AuthLoginException {
        authDebug.message("AuthContextLocal::abort()");
        try {
            this.amlc.abort();
        }
        catch (Exception exception) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Exception in AMLoginContext::abort() " + exception.getMessage());
            }
            throw new AuthLoginException(amAuthContextLocal, "abortError", null, exception);
        }
        this.loginStatus = AuthContext.Status.COMPLETED;
    }

    public String getErrorTemplate() {
        return this.amlc.getErrorTemplate();
    }

    public String getErrorMessage() {
        return this.amlc.getErrorMessage();
    }

    public String getErrorCode() {
        return this.amlc.getErrorCode();
    }

    public String getAuthIdentifier() {
        return this.amlc.getAuthIdentifier();
    }

    public String getLockoutMsg() {
        String string = this.amlc.getLockoutMsg();
        if (authDebug.messageEnabled()) {
            authDebug.message("getLockoutMsg: lockoutMsg: " + string);
        }
        return string;
    }

    public boolean isLockedOut() {
        boolean bl = this.amlc.isLockedOut();
        if (authDebug.messageEnabled()) {
            authDebug.message("isLockedOut : " + bl);
        }
        return bl;
    }

    public void setClientHostName(String string) {
        this.hostName = string;
    }

    protected String getClientHostName() {
        return this.hostName;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    protected HttpSession getHttpSession() {
        return this.httpSession;
    }

    protected static Callback[] getCallbacks(Callback[] callbackArray, boolean bl) {
        if (callbackArray == null) {
            return null;
        }
        if (bl) {
            return callbackArray;
        }
        Callback[] callbackArray2 = new Callback[]{};
        ArrayList<Callback> arrayList = new ArrayList<Callback>();
        int n = 0;
        while (n < callbackArray.length) {
            if (authDebug.messageEnabled()) {
                authDebug.message("In getCallbacks() callback : " + callbackArray[n]);
            }
            if (!(callbackArray[n] instanceof PagePropertiesCallback)) {
                arrayList.add(callbackArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(callbackArray2);
    }

    public void setLoginState(LoginState loginState) {
        this.loginState = loginState;
    }

    public LoginState getLoginState() {
        return this.loginState;
    }
}

