/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.windowsdesktopsso;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.windowsdesktopsso.WindowsDesktopSSOConfig;
import com.sun.identity.authentication.modules.windowsdesktopsso.WindowsDesktopSSOPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.util.DerValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import sun.misc.BASE64Decoder;
import sun.security.provider.Sun;

public class WindowsDesktopSSO
extends AMLoginModule {
    private static final String amAuthWindowsDesktopSSO = "amAuthWindowsDesktopSSO";
    private static final String[] configAttributes = new String[]{"iplanet-am-auth-windowsdesktopsso-principal-name", "iplanet-am-auth-windowsdesktopsso-keytab-file", "iplanet-am-auth-windowsdesktopsso-kerberos-realm", "iplanet-am-auth-windowsdesktopsso-kdc", "iplanet-am-auth-windowsdesktopsso-returnRealm", "iplanet-am-auth-windowsdesktopsso-auth-level", "serviceSubject"};
    private static final int PRINCIPAL = 0;
    private static final int KEYTAB = 1;
    private static final int REALM = 2;
    private static final int KDC = 3;
    private static final int RETURNREALM = 4;
    private static final int AUTHLEVEL = 5;
    private static final int SUBJECT = 6;
    private static Hashtable configTable = new Hashtable();
    private Principal userPrincipal = null;
    private Subject serviceSubject = null;
    private String servicePrincipalName = null;
    private String keyTabFile = null;
    private String kdcRealm = null;
    private String kdcServer = null;
    private boolean returnRealm = false;
    private String authLevel = null;
    private Map options = null;
    private String confIndex = null;
    private Debug debug = Debug.getInstance((String)"amAuthWindowsDesktopSSO");
    private static byte[] spnegoOID = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};
    private static byte[] MS_KERBEROS_OID = new byte[]{6, 9, 42, -122, 72, -126, -9, 18, 1, 2, 2};
    private static byte[] KERBEROS_V5_OID = new byte[]{6, 9, 42, -122, 72, -122, -9, 18, 1, 2, 2};

    public void init(Subject subject, Map map, Map map2) {
        this.options = map2;
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        byte[] byArray;
        byte[] byArray2;
        int n2 = 0;
        if (!this.getConfigParams()) {
            this.initWindowsDesktopSSOAuth(this.options);
        }
        if ((byArray2 = this.getSPNEGOToken()) == null) {
            this.debug.message("spnego token is not valid.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "token", null);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("SPNEGO token: \n" + DerValue.printByteArray(byArray2, 0, byArray2.length));
        }
        if ((byArray = this.parseToken(byArray2)) == null) {
            this.debug.message("kerberos token is not valid.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "token", null);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Kerberos token retrieved from SPNEGO token: \n" + DerValue.printByteArray(byArray, 0, byArray.length));
        }
        try {
            this.authenticateToken(byArray);
            this.debug.message("WindowsDesktopSSO authentication succeeded.");
            n2 = -1;
        }
        catch (GSSException gSSException) {
            int n3 = gSSException.getMajor();
            if (n3 == 8) {
                this.debug.message("Credential expired. Re-establish credential...");
                this.serviceLogin();
                try {
                    this.authenticateToken(byArray);
                    this.debug.message("Authentication succeeded with new cred.");
                    n2 = -1;
                }
                catch (Exception exception) {
                    this.debug.message("Authentication failed with new cred.");
                    throw new AuthLoginException(amAuthWindowsDesktopSSO, "auth", null, exception);
                }
            }
            this.debug.message("Authentication failed with GSSException.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "auth", null, gSSException);
        }
        catch (AuthLoginException authLoginException) {
            throw authLoginException;
        }
        catch (Exception exception) {
            this.debug.message("Authentication failed with generic exception.");
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "auth", null, exception);
        }
        return n2;
    }

    private void authenticateToken(final byte[] byArray) throws AuthLoginException, GSSException, Exception {
        this.debug.message("In authenticationToken ...");
        Subject.doAs(this.serviceSubject, new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                GSSContext gSSContext = GSSManager.getInstance().createContext((GSSCredential)null);
                WindowsDesktopSSO.this.debug.message("Context created.");
                byte[] byArray2 = gSSContext.acceptSecContext(byArray, 0, byArray.length);
                if (byArray2 != null && WindowsDesktopSSO.this.debug.messageEnabled()) {
                    WindowsDesktopSSO.this.debug.message("Token returned from acceptSecContext: \n" + DerValue.printByteArray(byArray2, 0, byArray2.length));
                }
                if (!gSSContext.isEstablished()) {
                    WindowsDesktopSSO.this.debug.message("Cannot establish context !");
                    throw new AuthLoginException(WindowsDesktopSSO.amAuthWindowsDesktopSSO, "context", null);
                }
                WindowsDesktopSSO.this.debug.message("Context establised !");
                GSSName gSSName = gSSContext.getSrcName();
                WindowsDesktopSSO.this.storeUsernamePasswd(gSSName.toString(), null);
                if (WindowsDesktopSSO.this.debug.messageEnabled()) {
                    WindowsDesktopSSO.this.debug.message("User authenticated: " + gSSName.toString());
                }
                if (gSSName != null) {
                    WindowsDesktopSSO.this.setPrincipal(gSSName.toString());
                }
                gSSContext.dispose();
                return null;
            }
        });
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.serviceSubject = null;
        this.servicePrincipalName = null;
        this.keyTabFile = null;
        this.kdcRealm = null;
        this.kdcServer = null;
        this.authLevel = null;
        this.options = null;
        this.confIndex = null;
    }

    private void setPrincipal(String string) {
        int n;
        String string2 = string;
        if (!this.returnRealm && (n = string.indexOf("@")) != -1) {
            string2 = string.substring(0, n);
        }
        this.userPrincipal = new WindowsDesktopSSOPrincipal(string2);
    }

    private byte[] getSPNEGOToken() {
        byte[] byArray;
        block2: {
            byArray = null;
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            String string = httpServletRequest.getHeader("Authorization");
            if (!string.startsWith("Negotiate")) break block2;
            string = string.substring("Negotiate".length()).trim();
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            try {
                byArray = bASE64Decoder.decodeBuffer(string);
            }
            catch (Exception exception) {
                this.debug.error("Decoding token error.");
                if (!this.debug.messageEnabled()) break block2;
                this.debug.message("Stack trace: ", (Throwable)exception);
            }
        }
        return byArray;
    }

    private byte[] parseToken(byte[] byArray) {
        byte[] byArray2 = byArray;
        DerValue derValue = new DerValue(byArray);
        if (this.debug.messageEnabled()) {
            this.debug.message("token tag:" + DerValue.printByte(derValue.getTag()));
        }
        if (derValue.getTag() != 96) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(derValue.getData());
        byte[] byArray3 = new byte[spnegoOID.length];
        byteArrayInputStream.read(byArray3, 0, byArray3.length);
        if (Arrays.equals(byArray3, spnegoOID)) {
            this.debug.message("SPNEGO OID found in the Auth Token");
            derValue = new DerValue(byteArrayInputStream);
            if (derValue.getTag() == -96) {
                this.debug.message("DerValue: found init token");
                derValue = new DerValue(derValue.getData());
                if (derValue.getTag() == 48) {
                    this.debug.message("DerValue: 0x30 constructed token found");
                    byteArrayInputStream = new ByteArrayInputStream(derValue.getData());
                    derValue = new DerValue(byteArrayInputStream);
                    while (derValue.getTag() != -1 && derValue.getTag() != -94) {
                        derValue = new DerValue(byteArrayInputStream);
                    }
                    if (derValue.getTag() != -1) {
                        derValue = new DerValue(derValue.getData());
                        byArray2 = derValue.getData();
                    }
                }
            }
        } else {
            this.debug.message("SPNEGO OID not found in the Auth Token");
            byte[] byArray4 = new byte[KERBEROS_V5_OID.length];
            int n = 0;
            while (n < byArray3.length) {
                byArray4[n] = byArray3[n];
                ++n;
            }
            byteArrayInputStream.read(byArray4, n, byArray4.length - n);
            if (!Arrays.equals(byArray4, KERBEROS_V5_OID)) {
                this.debug.message("Kerberos V5 OID not found in the Auth Token");
                byArray2 = null;
            } else {
                this.debug.message("Kerberos V5 OID found in the Auth Token");
            }
        }
        return byArray2;
    }

    private boolean getConfigParams() {
        this.servicePrincipalName = this.getMapAttr(this.options, 0);
        this.keyTabFile = this.getMapAttr(this.options, 1);
        this.kdcRealm = this.getMapAttr(this.options, 2);
        this.kdcServer = this.getMapAttr(this.options, 3);
        this.authLevel = this.getMapAttr(this.options, 5);
        this.returnRealm = Boolean.valueOf(this.getMapAttr(this.options, 4));
        if (this.debug.messageEnabled()) {
            this.debug.message("WindowsDesktopSSO params: \nprincipal: " + this.servicePrincipalName + "\nkeytab file: " + this.keyTabFile + "\nrealm : " + this.kdcRealm + "\nkdc server: " + this.kdcServer + "\ndomain principal: " + this.returnRealm + "\nauth level: " + this.authLevel);
        }
        this.confIndex = this.getRequestOrg() + "/" + this.options.get("moduleInstanceName");
        Map map = (Map)configTable.get(this.confIndex);
        if (map == null) {
            return false;
        }
        String string = (String)map.get(configAttributes[0]);
        String string2 = (String)map.get(configAttributes[1]);
        String string3 = (String)map.get(configAttributes[2]);
        String string4 = (String)map.get(configAttributes[3]);
        if (!(string != null && string2 != null && string3 != null && string4 != null && this.servicePrincipalName.equalsIgnoreCase(string) && this.keyTabFile.equals(string2) && this.kdcRealm.equals(string3) && this.kdcServer.equalsIgnoreCase(string4))) {
            return false;
        }
        this.serviceSubject = (Subject)map.get(configAttributes[6]);
        if (this.serviceSubject == null) {
            return false;
        }
        this.debug.message("Retrieved config params from cache.");
        return true;
    }

    private void initWindowsDesktopSSOAuth(Map map) throws AuthLoginException {
        this.debug.message("Init WindowsDesktopSSO. This should not happen often.");
        this.verifyAttributes();
        this.serviceLogin();
        HashMap<String, Subject> hashMap = (HashMap<String, Subject>)configTable.get(this.confIndex);
        if (hashMap == null) {
            hashMap = new HashMap<String, Subject>();
        }
        hashMap.put(configAttributes[6], this.serviceSubject);
        hashMap.put(configAttributes[0], (Subject)((Object)this.servicePrincipalName));
        hashMap.put(configAttributes[1], (Subject)((Object)this.keyTabFile));
        hashMap.put(configAttributes[2], (Subject)((Object)this.kdcRealm));
        hashMap.put(configAttributes[3], (Subject)((Object)this.kdcServer));
        configTable.put(this.confIndex, hashMap);
    }

    private synchronized void serviceLogin() throws AuthLoginException {
        this.debug.message("New Service Login ...");
        System.setProperty("java.security.krb5.realm", this.kdcRealm);
        System.setProperty("java.security.krb5.kdc", this.kdcServer);
        System.setProperty("java.security.auth.login.config", "/dev/null");
        try {
            Object object;
            Object object2;
            Provider provider = null;
            boolean bl = true;
            Provider[] providerArray = Security.getProviders();
            provider = providerArray[0];
            Sun sun = new Sun();
            if (this.debug.messageEnabled()) {
                this.debug.message("default provider: " + provider.getName() + ", sun provider: " + sun.getName());
            }
            if (!provider.getName().equals(sun.getName())) {
                Security.removeProvider(sun.getName());
                Security.insertProviderAt(sun, 1);
            } else {
                bl = false;
            }
            if (this.debug.messageEnabled()) {
                object2 = new StringBuffer();
                providerArray = Security.getProviders();
                int n = 0;
                while (n < providerArray.length) {
                    object = providerArray[n];
                    ((StringBuffer)object2).append("\t" + ((Provider)object).getName() + "\n");
                    ++n;
                }
                this.debug.message("Current providers = " + ((StringBuffer)object2).toString());
            }
            object2 = Configuration.getConfiguration();
            WindowsDesktopSSOConfig windowsDesktopSSOConfig = null;
            if (object2 instanceof WindowsDesktopSSOConfig) {
                windowsDesktopSSOConfig = (WindowsDesktopSSOConfig)object2;
                windowsDesktopSSOConfig.setRefreshConfig("true");
            } else {
                windowsDesktopSSOConfig = new WindowsDesktopSSOConfig((Configuration)object2);
            }
            windowsDesktopSSOConfig.setPrincipalName(this.servicePrincipalName);
            windowsDesktopSSOConfig.setKeyTab(this.keyTabFile);
            Configuration.setConfiguration(windowsDesktopSSOConfig);
            object = new LoginContext("com.sun.identity.authentication.windowsdesktopsso");
            ((LoginContext)object).login();
            this.serviceSubject = ((LoginContext)object).getSubject();
            this.debug.message("Service login succeeded.");
            if (bl) {
                Security.removeProvider(provider.getName());
                Security.insertProviderAt(provider, 1);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.debug.error("Service Login Error: ");
            if (this.debug.messageEnabled()) {
                this.debug.message("Stack trace: ", (Throwable)exception);
            }
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "serviceAuth", null, exception);
        }
    }

    private String getMapAttr(Map map, int n) {
        return Misc.getMapAttr((Map)map, (String)configAttributes[n]);
    }

    private void verifyAttributes() throws AuthLoginException {
        if (this.servicePrincipalName == null || this.servicePrincipalName.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullprincipal", null);
        }
        if (this.keyTabFile == null || this.keyTabFile.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullkeytab", null);
        }
        if (this.kdcRealm == null || this.kdcRealm.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullrealm", null);
        }
        if (this.kdcServer == null || this.kdcServer.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullkdc", null);
        }
        if (this.authLevel == null || this.authLevel.length() == 0) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nullauthlevel", null);
        }
        if (!new File(this.keyTabFile).exists()) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "nokeytab", null);
        }
        try {
            this.setAuthLevel(Integer.parseInt(this.authLevel));
        }
        catch (Exception exception) {
            throw new AuthLoginException(amAuthWindowsDesktopSSO, "authlevel", null, exception);
        }
    }
}

