/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.unix;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.unix.UnixHelper;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.security.auth.SolarisPrincipal;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;

public class Unix
extends AMLoginModule {
    private static int helper_config_done = 0;
    private static Locale locale = null;
    private static String amAuthUnix = "amAuthUnix";
    private static Debug debug = null;
    private static int UNIX_HELPER_PORT;
    private static final String DEFAULT_UNIX_HELPER_PORT = "57946";
    private static final String DEFAULT_UNIX_TIMEOUT = "3";
    private static final String DEFAULT_UNIX_THREADS = "5";
    private int UNIX_CONFIG_PORT = 58946;
    private String str_UNIX_TIMEOUT;
    private String str_UNIX_THREADS;
    private String str_UNIX_HELPER_PORT;
    private String password;
    private Map sharedState;
    private ResourceBundle bundle = null;
    private String userTokenId;
    private Principal userPrincipal = null;
    private String user;
    private String serviceModule;
    private String clientIPAddr;
    private UnixHelper unixClient;
    private Map options = null;
    private boolean getCredentialsFromSharedState = false;
    private boolean needInit = true;
    private static String PAM_SERVICE_ATTR;
    private static String CONFIG_PORT_ATTR;
    private static String HELPER_PORT_ATTR;
    private static String HELPER_TIMEOUT_ATTR;
    private static String HELPER_THREADS_ATTR;
    private static String AUTH_LEVEL_ATTR;

    public Unix() throws AuthLoginException {
        try {
            debug = Debug.getInstance((String)amAuthUnix);
            debug.message("Unix constructor called");
        }
        catch (Exception exception) {
            debug.error("this is an error ", (Throwable)exception);
        }
    }

    public void init_helper() throws AuthLoginException {
        try {
            this.unixClient = new UnixHelper(this.UNIX_CONFIG_PORT, amAuthUnix);
            debug.message("Re-initializing helper.");
            int n = this.unixClient.configHelper(this.str_UNIX_HELPER_PORT, this.str_UNIX_TIMEOUT, this.str_UNIX_THREADS, debug, this.bundle);
            this.unixClient.destroy(this.bundle);
            if (n != 0) {
                debug.message("Unable to contact helper to re-initialize(1).");
                throw new AuthLoginException(amAuthUnix, "UnixconfigHelper", null);
            }
            Thread.sleep(1000L);
        }
        catch (AuthLoginException authLoginException) {
            debug.message("Unable to contact helper to re-initialize(2).");
            throw new AuthLoginException(amAuthUnix, "UnixInitializeLex", null, authLoginException);
        }
        catch (Exception exception) {
            debug.message("Unable to contact helper to re-initialize(3).");
            throw new AuthLoginException(amAuthUnix, "UnixInitializeEx", null, exception);
        }
    }

    public void init(Subject subject, Map map, Map map2) {
        try {
            debug.message("in init ...");
            Locale locale = this.getLoginLocale();
            this.bundle = AMLoginModule.amCache.getResBundle(amAuthUnix, locale);
            if (debug.messageEnabled()) {
                debug.message("Unix resource bundle locale=" + locale);
            }
            this.options = map2;
            this.serviceModule = Misc.getMapAttr((Map)map2, (String)PAM_SERVICE_ATTR);
            if (debug.messageEnabled()) {
                debug.message("serviceModule is : " + this.serviceModule);
            }
            this.sharedState = map;
            String string = Misc.getMapAttr((Map)map2, (String)AUTH_LEVEL_ATTR);
            if (string != null) {
                try {
                    this.setAuthLevel(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    debug.error("Unable to set auth level " + string, (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            debug.error("Error....", (Throwable)exception);
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        int n2;
        block33: {
            HttpServletRequest httpServletRequest;
            if (this.needInit) {
                this.initialize_helper();
                debug.message("initialized helper");
            }
            if ((httpServletRequest = this.getHttpServletRequest()) != null) {
                this.clientIPAddr = this.getHttpServletRequest().getRemoteAddr();
                if (debug.messageEnabled()) {
                    debug.message("Unix client IPAddr = " + this.clientIPAddr);
                }
            }
            if (n != 1) {
                debug.message("Inavlid login state");
                throw new AuthLoginException(amAuthUnix, "UnixInvalidState", new Object[]{new Integer(n)});
            }
            if (callbackArray != null && callbackArray.length == 0) {
                this.user = (String)this.sharedState.get(this.getUserKey());
                this.password = (String)this.sharedState.get(this.getPwdKey());
                if (this.user == null || this.password == null) {
                    return 1;
                }
                this.getCredentialsFromSharedState = true;
            } else {
                this.user = ((NameCallback)callbackArray[0]).getName();
                if (debug.messageEnabled()) {
                    debug.message("user is.. " + this.user);
                }
                if (callbackArray.length > 1) {
                    char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
                    if (cArray == null) {
                        cArray = new char[]{};
                    }
                    this.password = new String(cArray);
                    ((PasswordCallback)callbackArray[1]).clearPassword();
                }
            }
            this.storeUsernamePasswd(this.user, this.password);
            if (this.user == null || this.user.equals("")) {
                debug.message("user id empty....");
                throw new AuthLoginException(amAuthUnix, "UnixUserIdNull", null);
            }
            try {
                if (!this.user.equals(new String(this.user.getBytes("ASCII"), "ASCII"))) {
                    debug.message("enter ascii for user");
                    this.setFailureID(this.user);
                    throw new AuthLoginException(amAuthUnix, "UnixUseridNotASCII", null);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (this.getCredentialsFromSharedState) {
                    this.getCredentialsFromSharedState = false;
                    return 1;
                }
                debug.message("unsupported encodidng..");
                throw new AuthLoginException(amAuthUnix, "UnixInputEncodingException", null);
            }
            if (this.password == null) {
                this.password = "";
            } else {
                try {
                    if (!this.password.equals(new String(this.password.getBytes("ASCII"), "ASCII"))) {
                        throw new AuthLoginException(amAuthUnix, "UnixPasswordNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    this.setFailureID(this.user);
                    throw new AuthLoginException(amAuthUnix, "UnixInputEncodingException", null);
                }
            }
            debug.message("before calling unixClient...");
            n2 = -1;
            try {
                if (debug.messageEnabled()) {
                    debug.message("unixClient is... " + this.unixClient);
                }
                n2 = this.unixClient.authenticate(this.user, this.password, this.serviceModule, this.clientIPAddr, this.bundle);
                this.unixClient.destroy(this.bundle);
            }
            catch (Exception exception) {
                debug.error("Exception unixClient... :" + exception.getMessage());
                if (!debug.messageEnabled()) break block33;
                debug.message("Stack: ", (Throwable)exception);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ires...... is... " + n2);
        }
        if (n2 != 0) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            this.setFailureID(this.user);
            if (n2 == -1) {
                if (debug.messageEnabled()) {
                    debug.message("Auth failed for user " + this.user);
                }
                throw new InvalidPasswordException(amAuthUnix, "UnixLoginFailed", new Object[]{this.user}, this.user, null);
            }
            if (n2 == 2) {
                if (debug.messageEnabled()) {
                    debug.message("Auth failed for user " + this.user + ". Password expired.");
                }
                return 2;
            }
        } else {
            this.userTokenId = this.user;
        }
        if (debug.messageEnabled()) {
            debug.message("Authentication for " + this.user + " succeeded!!");
        }
        return -1;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SolarisPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.sharedState = null;
        this.bundle = null;
        this.str_UNIX_HELPER_PORT = null;
        this.str_UNIX_TIMEOUT = null;
        this.str_UNIX_THREADS = null;
        this.user = null;
        this.password = null;
        this.serviceModule = null;
        this.clientIPAddr = null;
        this.password = null;
        this.unixClient = null;
        this.options = null;
    }

    public void getDaemonParams() {
        String string = Misc.getMapAttr((Map)this.options, (String)CONFIG_PORT_ATTR);
        this.str_UNIX_HELPER_PORT = Misc.getMapAttr((Map)this.options, (String)HELPER_PORT_ATTR);
        this.str_UNIX_TIMEOUT = Misc.getMapAttr((Map)this.options, (String)HELPER_TIMEOUT_ATTR);
        this.str_UNIX_THREADS = Misc.getMapAttr((Map)this.options, (String)HELPER_THREADS_ATTR);
        if (string != null) {
            try {
                this.UNIX_CONFIG_PORT = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.str_UNIX_HELPER_PORT == null || this.str_UNIX_HELPER_PORT.length() == 0) {
            this.str_UNIX_HELPER_PORT = DEFAULT_UNIX_HELPER_PORT;
        }
        try {
            UNIX_HELPER_PORT = Integer.parseInt(this.str_UNIX_HELPER_PORT);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.str_UNIX_TIMEOUT == null || this.str_UNIX_TIMEOUT.length() == 0) {
            this.str_UNIX_TIMEOUT = DEFAULT_UNIX_TIMEOUT;
        }
        if (this.str_UNIX_THREADS == null || this.str_UNIX_THREADS.length() == 0) {
            this.str_UNIX_THREADS = DEFAULT_UNIX_THREADS;
        }
    }

    public void initialize_helper() throws AuthLoginException {
        this.getDaemonParams();
        if (helper_config_done == 0) {
            this.init_helper();
            helper_config_done = 1;
        }
        try {
            this.unixClient = new UnixHelper(UNIX_HELPER_PORT, amAuthUnix);
        }
        catch (AuthenticationException authenticationException) {
            debug.message("Unable to connect to auth port; Try init again.");
            try {
                this.getDaemonParams();
                this.init_helper();
                debug.message("Successfully re-initialized helper.");
                try {
                    this.unixClient = new UnixHelper(UNIX_HELPER_PORT, amAuthUnix);
                    debug.message("Re-opened auth port tohelper(2).");
                }
                catch (AuthenticationException authenticationException2) {
                    debug.error("Unable to open auth port to helper(2)", (Throwable)((Object)authenticationException2));
                    throw new AuthLoginException(amAuthUnix, "UnixInitializeLex", null, (Throwable)((Object)authenticationException2));
                }
            }
            catch (AuthLoginException authLoginException) {
                debug.error("Unable to contact helper to re-init", (Throwable)authLoginException);
                throw new AuthLoginException(amAuthUnix, "UnixInitLex", null);
            }
        }
        catch (Exception exception) {
            debug.error("Exception... ", (Throwable)exception);
            throw new AuthLoginException(amAuthUnix, "UnixInitEx", null);
        }
        this.needInit = false;
    }

    static {
        PAM_SERVICE_ATTR = "iplanet-am-auth-unix-pam-service-name";
        CONFIG_PORT_ATTR = "iplanet-am-auth-unix-config-port";
        HELPER_PORT_ATTR = "iplanet-am-auth-unix-helper-port";
        HELPER_TIMEOUT_ATTR = "iplanet-am-auth-unix-helper-timeout";
        HELPER_THREADS_ATTR = "iplanet-am-auth-unix-helper-threads";
        AUTH_LEVEL_ATTR = "iplanet-am-auth-unix-auth-level";
    }
}

