/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.securid;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.securid.SecurIDHelper;
import com.sun.identity.authentication.modules.securid.SecurIDPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.AuthenticationException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class SecurID
extends AMLoginModule {
    private Map sharedState;
    private Map options;
    private static String adminDN;
    private static String hostName;
    private String userTokenId = null;
    private static HashSet orgHash;
    private String username;
    private SecurIDPrincipal userPrincipal = null;
    private String wtOrgName = "";
    static ResourceBundle bundle;
    private static String bundleName;
    private static Debug debug;
    private static Locale locale;
    private static HashMap helperConfigDone;
    private static HashMap helperConfigValues;
    private boolean initialized = false;
    private final String CONFIG_PORT_SUFFIX = "_CONFIG_PORT";
    private final String HELPER_PORT_SUFFIX = "_HELPER_PORT";
    private final String CONFIG_PATH_SUFFIX = "_CONFIG_PATH";
    public int SECURID_CONFIG_PORT;
    public int SECURID_HELPER_PORT;
    public String str_SECURID_CONFIG_PORT = "";
    public String str_SECURID_HELPER_PORT = "";
    public String str_SECURID_CONFIG_PATH = "/opt/ace/data";
    public int SECURID_TIMEOUT = 5;
    public int SECURID_THREADS = 5;
    public String str_SECURID_TIMEOUT = "5";
    public String str_SECURID_THREADS = "5";
    public static final String str_DEFAULT_SECURID_HELPER_PORT = "57943";
    public static final String str_DEFAULT_SECURID_CONFIG_PORT = "58943";
    public static final int DEFAULT_SECURID_CONFIG_PORT = 58943;
    public static final int DEFAULT_SECURID_HELPER_PORT = 57943;
    public static final String DEFAULT_SECURID_TIMEOUT = "5";
    public static final String DEFAULT_SECURID_THREADS = "5";
    private SecurIDHelper securidClient;
    private boolean getCredentialsFromSharedState;

    public void init(Subject subject, Map map, Map map2) {
        try {
            bundle = AMLoginModule.amCache.getResBundle("amAuthSecurID", this.getLoginLocale());
            if (debug.messageEnabled()) {
                debug.message("SecurID resbundle locale=" + this.getLoginLocale());
            }
            this.options = map2;
            this.sharedState = map;
            String string = this.getRequestOrg();
        }
        catch (Exception exception) {
            debug.error("SecurID init Error...", (Throwable)exception);
        }
    }

    private void init_helper() throws AuthenticationException {
        try {
            this.securidClient = new SecurIDHelper(this.SECURID_CONFIG_PORT, bundleName);
            if (debug.messageEnabled()) {
                debug.message("Re-initializing helper.");
            }
            int n = this.securidClient.configHelper(this.str_SECURID_HELPER_PORT, this.str_SECURID_TIMEOUT, this.str_SECURID_THREADS, this.str_SECURID_CONFIG_PATH, debug, bundle);
            this.securidClient.destroy(bundle, debug);
            if (n != 0) {
                if (debug.messageEnabled()) {
                    debug.message("Unable to contact helper to re-initialize(1).");
                }
                throw new AuthenticationException(bundleName, "SecurIDconfigHelper", new Object[]{new Integer(n)});
            }
        }
        catch (AuthenticationException authenticationException) {
            if (debug.messageEnabled()) {
                debug.message("Unable to contact helper to re-initialize(2).");
            }
            throw new AuthenticationException(bundleName, "SecurIDInitializeLex", new Object[]{authenticationException.getMessage()});
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Unable to contact helper to re-initialize(3).");
            }
            throw new AuthenticationException(bundleName, "SecurIDInitializeEx", new Object[]{exception.getMessage()});
        }
        if (debug.messageEnabled()) {
            debug.message("Re-initialized helper.");
        }
        this.securidClient = new SecurIDHelper(this.SECURID_HELPER_PORT, bundleName);
        if (debug.messageEnabled()) {
            debug.message("Re-opened auth port to helper.");
        }
    }

    private void setDynamicText(boolean bl, int n, String string) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("setDynamic: isPswd=" + bl + ", state=" + n);
        }
        Callback[] callbackArray = this.getCallback(n);
        boolean bl2 = false;
        if (bl) {
            bl2 = ((PasswordCallback)callbackArray[0]).isEchoOn();
        }
        if (bl) {
            callbackArray[0] = new PasswordCallback(string, bl2);
        } else {
            if (debug.messageEnabled()) {
                debug.message(" prompt=" + string);
            }
            callbackArray[0] = new NameCallback(string);
        }
        this.replaceCallback(n, 0, callbackArray[0]);
    }

    private void initializeSecurID() throws AuthLoginException {
        debug.message("SecurID initialize()");
        if (debug.messageEnabled()) {
            debug.message("initializeSecurID:Org = " + this.wtOrgName + "\n\tstr_SECURID_HELPER_PORT = " + this.str_SECURID_HELPER_PORT + "\n\tstr_SECURID_CONFIG_PATH = " + this.str_SECURID_CONFIG_PATH);
        }
        try {
            if (debug.messageEnabled()) {
                debug.message("SecurID init done: Open request port " + this.SECURID_HELPER_PORT + " for org " + this.wtOrgName);
            }
            this.securidClient = new SecurIDHelper(this.SECURID_HELPER_PORT, bundleName);
        }
        catch (AuthenticationException authenticationException) {
            if (debug.messageEnabled()) {
                debug.message("Unable to connect to auth port; Try initializing again.");
            }
            try {
                this.init_helper();
                if (debug.messageEnabled()) {
                    debug.message("Successfully re-initialized helper.");
                }
                try {
                    this.securidClient = new SecurIDHelper(this.SECURID_HELPER_PORT, bundleName);
                    if (debug.messageEnabled()) {
                        debug.message("Re-opened auth port to helper(2).");
                    }
                }
                catch (AuthenticationException authenticationException2) {
                    if (debug.messageEnabled()) {
                        debug.message("Unable to open auth port to helper(2).");
                    }
                    throw new AuthLoginException(bundleName, "SecurIDInitLex", null, (Throwable)((Object)authenticationException2));
                }
            }
            catch (AuthenticationException authenticationException3) {
                if (debug.messageEnabled()) {
                    debug.message("Unable to contact helper to re-initialize.");
                }
                throw new AuthLoginException(bundleName, "SecurIDInitLex", null, (Throwable)((Object)authenticationException3));
            }
        }
        catch (Exception exception) {
            throw new AuthLoginException(bundleName, "SecurIDInitEx", null, exception);
        }
    }

    private void getOrgConfig() throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("getOrgConfig:Org = " + this.wtOrgName);
        }
        if (!helperConfigDone.containsKey(this.wtOrgName)) {
            if (debug.messageEnabled()) {
                debug.message("getOrgConfig: config helper for org " + this.wtOrgName);
            }
            try {
                this.initializeOrgProperties();
                this.securidClient = new SecurIDHelper(this.SECURID_CONFIG_PORT, bundleName);
                if (debug.messageEnabled()) {
                    debug.message("getOrgConfig:Initializing helper for org " + this.wtOrgName + ", using:" + "\n\tstr_SECURID_HELPER_PORT = " + this.str_SECURID_HELPER_PORT + "\n\tstr_SECURID_CONFIG_PATH = " + this.str_SECURID_CONFIG_PATH);
                }
                int n = this.securidClient.configHelper(this.str_SECURID_HELPER_PORT, this.str_SECURID_TIMEOUT, this.str_SECURID_THREADS, this.str_SECURID_CONFIG_PATH, debug, bundle);
                this.securidClient.destroy(bundle, debug);
                if (n != 0) {
                    if (debug.messageEnabled()) {
                        debug.message("getOrgConfig:Unable to contact helper to initialize(1).");
                    }
                    throw new AuthLoginException(bundleName, "SecurIDconfigHelper", new Object[]{new Integer(n)});
                }
                helperConfigDone.put(this.wtOrgName, "true");
            }
            catch (AuthenticationException authenticationException) {
                if (debug.messageEnabled()) {
                    debug.message("getOrgConfig:SecurID init lex: " + authenticationException.getMessage());
                }
                throw new AuthLoginException(bundleName, "SecurIDInitializeLex", null, (Throwable)((Object)authenticationException));
            }
            catch (Exception exception) {
                if (debug.messageEnabled()) {
                    debug.message("getOrgConfig:SecurID init ex: " + exception.getMessage());
                }
                throw new AuthLoginException(bundleName, "SecurIDInitializeEx", null, exception);
            }
            debug.message("SecurID init: done with helper config");
        } else {
            String string;
            if (debug.messageEnabled()) {
                debug.message("getOrgConfig:initialize: Org " + this.wtOrgName + " init-ed; retrieve config values");
            }
            if (helperConfigValues.containsKey(string = this.wtOrgName + "_CONFIG_PORT")) {
                this.str_SECURID_CONFIG_PORT = (String)helperConfigValues.get(string);
                try {
                    this.SECURID_CONFIG_PORT = Integer.parseInt(this.str_SECURID_CONFIG_PORT);
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("getOrgConfig:Can't convert str_SECURID_CONFIG_PORT = " + this.str_SECURID_CONFIG_PORT + " to int");
                    throw new AuthLoginException(bundleName, "SecurIDInitializeEx", null, numberFormatException);
                }
            } else {
                debug.error("getOrgConfig:Can't find key " + string + " in helperConfigValues");
                throw new AuthLoginException(bundleName, "SecurIDInitializeEx", null);
            }
            string = this.wtOrgName + "_HELPER_PORT";
            if (helperConfigValues.containsKey(string)) {
                this.str_SECURID_HELPER_PORT = (String)helperConfigValues.get(string);
                try {
                    this.SECURID_HELPER_PORT = Integer.parseInt(this.str_SECURID_HELPER_PORT);
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("getOrgConfig:Can't convert str_SECURID_CONFIG_PORT = " + this.str_SECURID_CONFIG_PORT + " to int");
                    throw new AuthLoginException(bundleName, "SecurIDInitializeEx", null, numberFormatException);
                }
            } else {
                debug.error("getOrgConfig:Can't find key " + string + " in helperConfigValues");
                throw new AuthLoginException(bundleName, "SecurIDInitializeEx", null);
            }
            string = this.wtOrgName + "_CONFIG_PATH";
            if (!helperConfigValues.containsKey(string)) {
                debug.error("getOrgConfig:Can't find key " + string + " in helperConfigValues");
                throw new AuthLoginException(bundleName, "SecurIDInitializeEx", null);
            }
            this.str_SECURID_CONFIG_PATH = (String)helperConfigValues.get(string);
            if (debug.messageEnabled()) {
                debug.message("getOrgConfig:retrieved config values:\n\tSECURID_CONFIG_PORT = " + this.SECURID_CONFIG_PORT + "\n\tSECURID_HELPER_PORT = " + this.SECURID_HELPER_PORT + "\n\tSECURID_CONFIG_PATH = " + this.str_SECURID_CONFIG_PATH);
            }
        }
    }

    private void initializeOrgProperties() throws AuthLoginException {
        block19: {
            if (this.options != null) {
                try {
                    String string;
                    int n;
                    String string2 = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-securid-config-port");
                    String string3 = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-securid-helper-port");
                    String string4 = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-securid-server-config-path");
                    if (debug.messageEnabled()) {
                        debug.message("SecurID init: config_port=" + string2 + "\n\thelper_port=" + string3 + "\n\tconfig_path=" + string4);
                    }
                    try {
                        this.SECURID_CONFIG_PORT = n = Integer.parseInt(string2);
                        this.str_SECURID_CONFIG_PORT = string2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        debug.error("initializeOrgProperties: config port = " + string2 + "; invalid, set to default = " + str_DEFAULT_SECURID_CONFIG_PORT);
                        this.SECURID_CONFIG_PORT = 58943;
                        this.str_SECURID_CONFIG_PORT = str_DEFAULT_SECURID_CONFIG_PORT;
                    }
                    try {
                        this.SECURID_HELPER_PORT = n = Integer.parseInt(string3);
                        this.str_SECURID_HELPER_PORT = string3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        debug.error("initializeOrgProperties: helper port = " + string3 + "; invalid, set to default = " + str_DEFAULT_SECURID_HELPER_PORT);
                        this.SECURID_HELPER_PORT = 57943;
                        this.str_SECURID_HELPER_PORT = str_DEFAULT_SECURID_HELPER_PORT;
                    }
                    if (string4 == null || string4.equals("")) {
                        debug.error("No SecurID config path specified for org = " + this.wtOrgName);
                        throw new AuthLoginException(bundleName, "SecurIDNoSrvrPath", null);
                    }
                    String string5 = string4 + "/sdconf.rec";
                    File file = new File(string5);
                    if (debug.messageEnabled()) {
                        debug.message("About to check on Server File Path " + string5 + " for Org " + this.wtOrgName);
                    }
                    if (!file.exists()) {
                        debug.error("SecurID Server Path '" + string5 + "' does not exist.  Organization = " + this.wtOrgName);
                        throw new AuthLoginException(bundleName, "SecurIDSrvrPathNoExist", null);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("found SecurID Server Path = " + string5 + " for Org " + this.wtOrgName);
                    }
                    this.str_SECURID_CONFIG_PATH = string4;
                    if (debug.messageEnabled()) {
                        debug.message("SecurID (org=" + this.wtOrgName + ")->configPort = " + this.SECURID_CONFIG_PORT + "\n\thelperPort = " + this.str_SECURID_HELPER_PORT + "\n\ttimeout = " + this.str_SECURID_TIMEOUT + "\n\tconfig path = " + this.str_SECURID_CONFIG_PATH);
                    }
                    if (helperConfigValues.containsKey(string = this.wtOrgName + "_CONFIG_PORT")) {
                        helperConfigValues.remove(string);
                    }
                    helperConfigValues.put(string, this.str_SECURID_CONFIG_PORT);
                    string = this.wtOrgName + "_HELPER_PORT";
                    if (helperConfigValues.containsKey(string)) {
                        helperConfigValues.remove(string);
                    }
                    helperConfigValues.put(string, this.str_SECURID_HELPER_PORT);
                    string = this.wtOrgName + "_CONFIG_PATH";
                    if (helperConfigValues.containsKey(string)) {
                        helperConfigValues.remove(string);
                    }
                    helperConfigValues.put(string, this.str_SECURID_CONFIG_PATH);
                    String string6 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-securid-auth-level");
                    if (string6 == null) break block19;
                    try {
                        this.setAuthLevel(Integer.parseInt(string6));
                    }
                    catch (Exception exception) {
                        debug.error("Unable to set auth level " + string6);
                    }
                }
                catch (Exception exception) {
                    debug.error("SecurID parameters initialization failure", (Throwable)exception);
                }
            } else {
                debug.error("SecurID options not initialized");
            }
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        int n2 = -1;
        String string = null;
        this.wtOrgName = this.getRequestOrg();
        if (debug.messageEnabled()) {
            debug.message("process: Org = " + this.wtOrgName + "\n\tSECURID_CONFIG_PORT = " + this.SECURID_CONFIG_PORT + "\n\tSECURID_HELPER_PORT = " + this.SECURID_HELPER_PORT + "\n\tstr_SECURID_CONFIG_PATH = " + this.str_SECURID_CONFIG_PATH + "\n\tinitialized = " + this.initialized);
        }
        if (!this.initialized) {
            this.getOrgConfig();
            this.initializeSecurID();
            this.initialized = true;
        }
        if (debug.messageEnabled()) {
            debug.message("process; after getOrgConfig: Org = " + this.wtOrgName + "\n\tSECURID_CONFIG_PORT = " + this.SECURID_CONFIG_PORT + "\n\tSECURID_HELPER_PORT = " + this.SECURID_HELPER_PORT + "\n\tstr_SECURID_CONFIG_PATH = " + this.str_SECURID_CONFIG_PATH + "\n\tstate = " + n + "\n\tuserTokenId = " + this.userTokenId + "\n\tusername = " + this.username);
        }
        block5 : switch (n) {
            case 1: {
                if (callbackArray != null && callbackArray.length == 0) {
                    this.username = (String)this.sharedState.get(this.getUserKey());
                    string = (String)this.sharedState.get(this.getPwdKey());
                    if (this.username == null || string == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.username = ((NameCallback)callbackArray[0]).getName();
                    if (this.username == null || this.username.equals("")) {
                        this.securidClient.destroy(bundle, debug);
                        throw new AuthLoginException(bundleName, "securIDUserIdNull", null);
                    }
                    string = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
                    if (string == null || string.equals("")) {
                        this.securidClient.destroy(bundle, debug);
                        throw new AuthLoginException(bundleName, "SecurIDPasscodeNull", null);
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("username: " + this.username);
                }
                this.storeUsernamePasswd(this.username, string);
                int n3 = this.securidClient.authenticate(this.str_SECURID_CONFIG_PATH, this.username, string, debug, bundle);
                if (debug.messageEnabled()) {
                    debug.message("SecurID:validate: authenticate rtn = " + n3);
                }
                switch (n3) {
                    case 0: {
                        this.securidClient.destroy(bundle, debug);
                        this.userTokenId = this.username;
                        n2 = -1;
                        break block5;
                    }
                    case 2: {
                        String string2 = this.securidClient.getReplaceText();
                        this.setDynamicText(true, n3, string2);
                        n2 = 2;
                        break block5;
                    }
                    case 3: {
                        n2 = 3;
                        break block5;
                    }
                    case 4: {
                        String string3 = this.securidClient.getReplaceText();
                        this.setDynamicText(false, n3, string3);
                        n2 = 4;
                        break block5;
                    }
                    case 5: {
                        String string4 = this.securidClient.getReplaceText();
                        this.setDynamicText(true, n3, string4);
                        n2 = 5;
                        break block5;
                    }
                }
                if (this.getCredentialsFromSharedState) {
                    this.getCredentialsFromSharedState = false;
                    n2 = 1;
                    break;
                }
                this.securidClient.destroy(bundle, debug);
                this.setFailureID(this.username);
                throw new AuthLoginException(bundleName, "SecurIDLoginFailed", new Object[]{this.username});
            }
            case 2: {
                String string5 = this.charToString(((PasswordCallback)callbackArray[0]).getPassword(), callbackArray[0]);
                if (debug.messageEnabled()) {
                    debug.message("validate:state2: token length = " + string5.length());
                }
                if (string5 == null || string5.equals("")) {
                    this.securidClient.destroy(bundle, debug);
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDInvNewPin", null);
                }
                try {
                    if (!string5.equals(new String(string5.getBytes("ASCII"), "ASCII"))) {
                        this.setFailureID(this.username);
                        throw new AuthLoginException(bundleName, "SecurIDNewPINNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDInputEncodingException", null);
                }
                int n4 = this.securidClient.newPINMode(string5, debug, bundle);
                if (debug.messageEnabled()) {
                    debug.message("process state 2:newPINMode returns " + n4);
                }
                if (n4 == 0) {
                    this.securidClient.destroy(bundle, debug);
                    this.userTokenId = this.username;
                    n2 = -1;
                    break;
                }
                if (n4 == -1) {
                    this.securidClient.destroy(bundle, debug);
                    debug.message("validate:state2: New PIN specified is invalid.");
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDAuthInvNewPin", null);
                }
                String string6 = this.securidClient.getReplaceText();
                if (debug.messageEnabled()) {
                    debug.message("process state 2: newPINMode returned " + n4 + ", rpText = " + string6);
                }
                if (string6 == null || string6.equals("")) {
                    string6 = " ";
                }
                this.setDynamicText(true, 5, string6);
                n2 = 5;
                break;
            }
            case 3: {
                String string7 = this.charToString(((PasswordCallback)callbackArray[0]).getPassword(), callbackArray[0]);
                if (string7 == null || string7.equals("")) {
                    this.securidClient.destroy(bundle, debug);
                    throw new AuthLoginException(bundleName, "SecurIDInvNextToken", null);
                }
                try {
                    if (!string7.equals(new String(string7.getBytes("ASCII"), "ASCII"))) {
                        this.setFailureID(this.username);
                        throw new AuthLoginException(bundleName, "SecurIDNextTokenNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDInputEncodingException", null);
                }
                int n5 = this.securidClient.nextTokenMode(string7, debug, bundle);
                if (n5 == 0) {
                    this.securidClient.destroy(bundle, debug);
                    this.userTokenId = this.username;
                    n2 = -1;
                    break;
                }
                this.setFailureID(this.username);
                throw new AuthLoginException(bundleName, "SecurIDInvNextToken", null);
            }
            case 4: {
                String string8 = ((NameCallback)callbackArray[0]).getName();
                debug.message("received answer(state 4) = " + string8);
                if (string8 == null || string8.equals("")) {
                    string8 = "y";
                    debug.message("made answer(state 4) = " + string8);
                } else {
                    string8 = string8.startsWith("y") || string8.startsWith("Y") ? "y" : (string8.startsWith("n") || string8.startsWith("N") ? "n" : "n");
                }
                try {
                    if (!string8.equals(new String(string8.getBytes("ASCII"), "ASCII"))) {
                        this.setFailureID(this.username);
                        throw new AuthLoginException(bundleName, "SecurIDNextTokenNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDInputEncodingException", null);
                }
                int n6 = this.securidClient.newPINAnswer(string8, debug, bundle);
                debug.message("return from newPINAnswer = " + n6);
                if (n6 == 0) {
                    this.securidClient.destroy(bundle, debug);
                    this.userTokenId = this.username;
                    n2 = -1;
                    break;
                }
                debug.message("return from curstate4 = " + n6);
                String string9 = this.securidClient.getReplaceText();
                if (string9 == null || string9.equals("")) {
                    string9 = " ";
                }
                this.setDynamicText(true, n6, string9);
                n2 = n6;
                break;
            }
            case 5: {
                String string10 = "";
                String string11 = this.getRequestOrg();
                if (debug.messageEnabled()) {
                    debug.message("about to get securid service template for Org '" + string11 + "'");
                }
                if (this.username == null || this.username.equals("")) {
                    this.securidClient.destroy(bundle, debug);
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDPrevUserid", null);
                }
                String string12 = this.charToString(((PasswordCallback)callbackArray[0]).getPassword(), callbackArray[0]);
                if (string12 == null || string12.equals("")) {
                    this.securidClient.destroy(bundle, debug);
                    throw new AuthLoginException(bundleName, "SecurIDInvNextToken", null);
                }
                try {
                    if (!string12.equals(new String(string12.getBytes("ASCII"), "ASCII"))) {
                        this.setFailureID(this.username);
                        throw new AuthLoginException(bundleName, "SecurIDNextTokenNotASCII", null);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDInputEncodingException", null);
                }
                this.securidClient.destroy(bundle, debug);
                try {
                    this.securidClient = new SecurIDHelper(this.SECURID_HELPER_PORT, bundleName);
                }
                catch (Exception exception) {
                    this.setFailureID(this.username);
                    throw new AuthLoginException(bundleName, "SecurIDIntializeEx", null, exception);
                }
                int n7 = this.securidClient.authenticate(this.str_SECURID_CONFIG_PATH, this.username, string12, debug, bundle);
                this.securidClient.destroy(bundle, debug);
                if (n7 == 0) {
                    this.userTokenId = this.username;
                    n2 = -1;
                    break;
                }
                this.setFailureID(this.username);
                throw new AuthLoginException(bundleName, "SecurIDLoginFailed", new Object[]{this.username});
            }
            default: {
                this.securidClient.destroy(bundle, debug);
                this.setFailureID(this.username);
                throw new AuthLoginException(bundleName, "SecurIDAuth", null);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("process; after process:\n\tstate = " + n + "\n\tuserTokenId = " + this.userTokenId + "\n\tusername = " + this.username);
        }
        return n2;
    }

    private String charToString(char[] cArray, Callback callback) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callback).clearPassword();
        return new String(cArray2);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            if (debug.messageEnabled()) {
                debug.message("getPrincipal: userPrincipal not null; userPrincipal = " + this.userPrincipal);
            }
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SecurIDPrincipal(this.userTokenId);
            if (debug.messageEnabled()) {
                debug.message("getPrincipal: userPrincipal null, userTokenId = " + this.userTokenId + ", returning userPrincipal = " + this.userPrincipal);
            }
            return this.userPrincipal;
        }
        if (debug.messageEnabled()) {
            debug.message("getPrincipal: returning null");
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.sharedState = null;
        this.options = null;
        this.username = null;
        this.wtOrgName = null;
        this.str_SECURID_CONFIG_PORT = null;
        this.str_SECURID_HELPER_PORT = null;
        this.str_SECURID_CONFIG_PATH = null;
        this.str_SECURID_TIMEOUT = null;
        this.str_SECURID_THREADS = null;
    }

    public void shutdown() {
    }

    static {
        orgHash = new HashSet();
        bundle = null;
        bundleName = "amAuthSecurID";
        debug = null;
        locale = null;
        helperConfigDone = new HashMap();
        helperConfigValues = new HashMap();
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthSecurID");
        }
    }
}

