/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.msisdn;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class MSISDNValidation {
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private String userTokenId;
    private String errorMsgKey = null;
    private Map options;
    protected static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String userSearchAttr;
    private String serverHost;
    private int serverPort = 389;
    private String startSearchLoc;
    private String principalUser;
    private String principalPasswd;
    private boolean useSSL;
    private String userNamingAttr;
    private String returnUserDN;
    private static final String amAuthMSISDN = "amAuthMSISDN";
    private Locale locale;
    private static final String TRUSTED_GATEWAY_LIST = "sunAMAuthMSISDNTrustedGatewayList";
    private static final String MSISDN_PARAMETER_NAME = "sunAMAuthMSISDNParameterNameList";
    private static final String USER_SEARCH_ATTR = "sunAMAuthMSISDNUserSearchAttribute";
    private static final String PRINCIPAL = "sunAMAuthMSISDNPrincipalUser";
    private static final String PRINCIPAL_PASSWD = "sunAMAuthMSISDNPrincipalPasswd";
    private static final String USE_SSL = "sunAMAuthMSISDNUseSsl";
    private static final String LDAP_URL = "sunAMAuthMSISDNLdapProviderUrl";
    private static final String MSISDN_AUTH_LEVEL = "sunAMAuthMSISDNAuthLevel";
    private static final String START_SEARCH_DN = "sunAMAuthMSISDNBaseDn";
    private static final String RETURN_USER_DN = "sunAMAuthMSISDNReturnUserDN";
    private static final String USER_NAMING_ATTR = "sunAMAuthMSISDNUserNamingAttribute";
    private static final String DEFAULT_USER_NAMING_ATTR = "uid";

    protected MSISDNValidation(Map map, Debug debug, ResourceBundle resourceBundle, Locale locale) throws AuthLoginException {
        MSISDNValidation.debug = debug;
        this.bundle = resourceBundle;
        this.locale = locale;
        this.initMSISDNConfig(map);
    }

    private void initMSISDNConfig(Map map) throws AuthLoginException {
        String string = null;
        if (map != null) {
            debug.message("MSISDN: getting attributes.");
            this.userSearchAttr = Misc.getMapAttr((Map)map, (String)USER_SEARCH_ATTR);
            this.principalUser = Misc.getMapAttr((Map)map, (String)PRINCIPAL);
            this.principalPasswd = Misc.getMapAttr((Map)map, (String)PRINCIPAL_PASSWD);
            this.useSSL = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)USE_SSL, (String)"false"));
            this.serverHost = Misc.getServerMapAttr((Map)map, (String)LDAP_URL);
            this.userNamingAttr = Misc.getMapAttr((Map)map, (String)USER_NAMING_ATTR, (String)DEFAULT_USER_NAMING_ATTR);
            this.returnUserDN = Misc.getMapAttr((Map)map, (String)RETURN_USER_DN, (String)"true");
            if (this.serverHost == null) {
                debug.error("Fatal error: LDAP Server and Port misconfigured");
                string = "wrongLDAPServer";
            } else {
                String string2 = null;
                int n = this.serverHost.indexOf(58);
                if (n != -1) {
                    string2 = this.serverHost.substring(n + 1);
                    this.serverPort = Integer.parseInt(string2);
                    this.serverHost = this.serverHost.substring(0, n);
                }
                this.startSearchLoc = Misc.getServerMapAttr((Map)map, (String)START_SEARCH_DN);
                if (this.startSearchLoc == null) {
                    debug.error("Fatal error: LDAP Start Search DN misconfigured");
                    string = "wrongStartDN";
                }
            }
            if (debug.messageEnabled()) {
                debug.message("\n ldapProviderUrl=" + this.serverHost + "\n\t serverPort = " + this.serverPort + "\n\t startSearchLoc=" + this.startSearchLoc + "\n\t userSearchAttr=" + this.userSearchAttr + "\n\t principalUser=" + this.principalUser + "\n\t serverHost =" + this.serverHost + "\n\t userNamingAttr =" + this.userNamingAttr + "\n\t returnUserDN =" + this.returnUserDN + "\n\t useSSL=" + this.useSSL);
            }
        } else {
            debug.error("options is null");
            string = "MSISDNValidateEx";
        }
        if (string != null) {
            throw new AuthLoginException(amAuthMSISDN, string, null);
        }
    }

    protected String getUserId(String string) throws AuthLoginException {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = amCache.getResBundle("amAuthLDAP", this.locale);
            LDAPAuthUtils lDAPAuthUtils = new LDAPAuthUtils(this.serverHost, this.serverPort, this.useSSL, resourceBundle, this.startSearchLoc, debug);
            String string3 = new StringBuffer(250).append("(").append(this.userSearchAttr).append("=").append(string).append(")").toString();
            lDAPAuthUtils.setReturnUserDN(this.returnUserDN);
            lDAPAuthUtils.setUserNamingAttribute(this.userNamingAttr);
            lDAPAuthUtils.setFilter(string3);
            lDAPAuthUtils.setAuthDN(this.principalUser);
            lDAPAuthUtils.setAuthPassword(this.principalPasswd);
            lDAPAuthUtils.searchForUser();
            switch (lDAPAuthUtils.getState()) {
                case 33: {
                    debug.message("User search successful");
                    string2 = lDAPAuthUtils.getUserId();
                    return string2;
                }
                case 1: {
                    debug.error("MSISDN - Error finding user");
                    throw new AuthLoginException(amAuthMSISDN, "userNotFound", null);
                }
                case 31: {
                    debug.error("Server down");
                    throw new AuthLoginException(amAuthMSISDN, "MSISDNServerDown", null);
                }
            }
            throw new AuthLoginException(amAuthMSISDN, "MSISDNValidateEx", null);
        }
        catch (Exception exception) {
            throw new AuthLoginException(exception);
        }
    }
}

