/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.am.util.Debug;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class LDAPCallbacks {
    private CallbackHandler callbackHandler;
    private static Debug debug = null;
    private String passwd;
    private String username;
    private String oldPassword;
    private String newPassword;
    private String confirmPassword;
    private ResourceBundle bundle;

    public LDAPCallbacks(CallbackHandler callbackHandler, ResourceBundle resourceBundle) {
        this.callbackHandler = callbackHandler;
        this.bundle = resourceBundle;
    }

    public void setLoginScreen() throws LoginException {
        this.loginCallbacks();
    }

    public void setPwdExpiryScreen() throws LoginException {
        this.chgPwdCallback();
    }

    public void sendMessage(int n, String string) throws LoginException {
        this.messageCallback(n, string);
    }

    protected String getUserName() {
        return this.username;
    }

    protected String getUserPWD() {
        return this.passwd;
    }

    protected String getOldPWD() {
        return this.oldPassword;
    }

    protected String getNewPWD() {
        return this.newPassword;
    }

    protected String getConfirmPWD() {
        return this.confirmPassword;
    }

    private void loginCallbacks() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        Callback[] callbackArray = new Callback[]{new TextOutputCallback(0, "LDAP Authentication"), new NameCallback("Enter Username :"), new PasswordCallback("Enter Password :", false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = new String(((NameCallback)callbackArray[1]).getName());
            this.passwd = this.charToString(((PasswordCallback)callbackArray[2]).getPassword(), callbackArray[2]);
        }
        catch (IOException iOException) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException();
        }
    }

    private void chgPwdCallback() throws LoginException {
        Object var1_1 = null;
        if (this.callbackHandler == null) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        Callback[] callbackArray = new Callback[]{new TextOutputCallback(0, "Change Password"), new PasswordCallback("EnterOld Password", false), new PasswordCallback("Enter New Password", false), new PasswordCallback("Confirm Password", false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.oldPassword = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
            this.newPassword = this.charToString(((PasswordCallback)callbackArray[2]).getPassword(), callbackArray[2]);
            this.confirmPassword = this.charToString(((PasswordCallback)callbackArray[3]).getPassword(), callbackArray[3]);
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
    }

    private String charToString(char[] cArray, Callback callback) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callback).clearPassword();
        return new String(cArray2);
    }

    private void messageCallback(int n, String string) throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        try {
            Callback[] callbackArray = new Callback[]{new TextOutputCallback(n, string)};
            this.callbackHandler.handle(callbackArray);
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.message("message type missing");
            throw new LoginException(this.bundle.getString("IllegalArgs"));
        }
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthLDAP");
        }
    }
}

