/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.jdbc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.jdbc.JDBCPasswordSyntaxTransform;
import com.sun.identity.authentication.modules.jdbc.JDBCPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Wrapper;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.sql.DataSource;

public class JDBC
extends AMLoginModule {
    private String userTokenId;
    private String userName;
    private String password;
    private String resultPassword;
    private char[] passwordCharArray;
    private Principal userPrincipal = null;
    private String errorMsg = null;
    private static final String amAuthJDBC = "amAuthJDBC";
    private static Debug debug = Debug.getInstance((String)"amAuthJDBC");
    private ResourceBundle bundle = null;
    private Map options;
    private static String CONNECTIONTYPE = "sunAMAuthJDBCConnectionType";
    private static String JNDINAME = "sunAMAuthJDBCJndiName";
    private static String DRIVER = "sunAMAuthJDBCDriver";
    private static String URL = "sunAMAuthJDBCUrl";
    private static String DBUSER = "sunAMAuthJDBCDbuser";
    private static String DBPASSWORD = "sunAMAuthJDBCDbpassword";
    private static String PASSWORDCOLUMN = "sunAMAuthJDBCPasswordColumn";
    private static String STATEMENT = "sunAMAuthJDBCStatement";
    private static String TRANSFORM = "sunAMAuthJDBCPasswordSyntaxTransformPlugin";
    private static String AUTHLEVEL = "sunAMAuthJDBCAuthLevel";
    private static String DEFAULT_TRANSFORM = "com.sun.identity.authentication.modules.jdbc.ClearTextTransform";
    private String driver;
    private String connectionType;
    private String jndiName;
    private String url;
    private String dbuser;
    private String dbpassword;
    private String passwordColumn;
    private String statement;
    private String transform;
    private Map sharedState;
    private boolean getCredentialsFromSharedState = false;
    private static final int MAX_NAME_LENGTH = 80;
    private boolean useJNDI = false;

    public JDBC() {
        debug.message("JDBC()");
    }

    public void init(Subject subject, Map map, Map map2) {
        block27: {
            debug.message("in initialize...");
            Locale locale = this.getLoginLocale();
            this.bundle = AMLoginModule.amCache.getResBundle(amAuthJDBC, locale);
            if (debug.messageEnabled()) {
                debug.message("amAuthJDBC Authentication resource bundle locale=" + locale);
            }
            this.options = map2;
            this.sharedState = map;
            if (map2 == null) break block27;
            try {
                this.connectionType = Misc.getMapAttr((Map)map2, (String)CONNECTIONTYPE);
                if (this.connectionType == null) {
                    debug.message("No CONNECTIONTYPE for configuring");
                    this.errorMsg = "noCONNECTIONTYPE";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for CONNECTIONTYPE: " + this.connectionType);
                }
                if (this.connectionType.equals("JNDI")) {
                    this.useJNDI = true;
                }
                if (this.useJNDI) {
                    debug.message("Using JNDI Retrieved Connection pool");
                    this.jndiName = Misc.getMapAttr((Map)map2, (String)JNDINAME);
                    if (this.jndiName == null) {
                        debug.message("No JNDINAME for configuring");
                        this.errorMsg = "noJNDINAME";
                        return;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Found config for JNDINAME: " + this.jndiName);
                    }
                } else {
                    debug.message("Using non pooled JDBC");
                    this.driver = Misc.getMapAttr((Map)map2, (String)DRIVER);
                    if (this.driver == null) {
                        debug.message("No DRIVER for configuring");
                        this.errorMsg = "noDRIVER";
                        return;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Found config for DRIVER: " + this.driver);
                    }
                }
                this.url = Misc.getMapAttr((Map)map2, (String)URL);
                if (this.url == null) {
                    debug.message("No URL for configuring");
                    this.errorMsg = "noURL";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for URL: " + this.url);
                }
                this.dbuser = Misc.getMapAttr((Map)map2, (String)DBUSER);
                if (this.dbuser == null) {
                    debug.message("No DBUSER for configuring");
                    this.errorMsg = "noDBUSER";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for DBUSER: " + this.dbuser);
                }
                this.dbpassword = Misc.getMapAttr((Map)map2, (String)DBPASSWORD, (String)"");
                if (this.dbpassword == null) {
                    debug.message("No DBPASSWORD for configuring");
                    this.errorMsg = "noDBPASSWORD";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for DBPASSWORD: " + this.dbpassword);
                }
                this.passwordColumn = Misc.getMapAttr((Map)map2, (String)PASSWORDCOLUMN);
                if (this.passwordColumn == null) {
                    debug.message("No PASSWORDCOLUMN for configuring");
                    this.errorMsg = "noPASSWORDCOLUMN";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for PASSWORDCOLUMN: " + this.passwordColumn);
                }
                this.statement = Misc.getMapAttr((Map)map2, (String)STATEMENT);
                if (this.statement == null) {
                    debug.message("No STATEMENT for configuring");
                    this.errorMsg = "noSTATEMENT";
                }
                this.transform = Misc.getMapAttr((Map)map2, (String)TRANSFORM);
                if (this.transform == null) {
                    if (debug.messageEnabled()) {
                        debug.message("No TRANSFORM for configuring.Using clear text");
                    }
                    this.transform = DEFAULT_TRANSFORM;
                } else if (debug.messageEnabled()) {
                    debug.message("Plugin for TRANSFORM: " + this.transform);
                }
                String string = Misc.getMapAttr((Map)map2, (String)AUTHLEVEL);
                if (string == null) break block27;
                try {
                    this.setAuthLevel(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    debug.error("Unable to set auth level " + string, (Throwable)exception);
                }
            }
            catch (Exception exception) {
                debug.error("JDBC Init Exception", (Throwable)exception);
            }
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        Object object;
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthJDBC, this.errorMsg, null);
        }
        if (debug.messageEnabled()) {
            debug.message("State: " + n);
        }
        if (n != 1) {
            throw new AuthLoginException(amAuthJDBC, "invalidState", null);
        }
        if (callbackArray != null && callbackArray.length == 0) {
            this.userName = (String)this.sharedState.get(this.getUserKey());
            this.password = (String)this.sharedState.get(this.getPwdKey());
            if (this.userName == null || this.password == null) {
                return 1;
            }
            this.getCredentialsFromSharedState = true;
        } else {
            this.userName = ((NameCallback)callbackArray[0]).getName();
            if (debug.messageEnabled()) {
                debug.message("Authenticating this user: " + this.userName);
            }
            this.passwordCharArray = ((PasswordCallback)callbackArray[1]).getPassword();
            this.password = new String(this.passwordCharArray);
            if (this.userName == null || this.userName.length() == 0) {
                throw new AuthLoginException(amAuthJDBC, "noUserName", null);
            }
        }
        this.storeUsernamePasswd(this.userName, this.password);
        if (this.userName.length() > 80) {
            throw new AuthLoginException(amAuthJDBC, "userNameTooLong", null);
        }
        Connection connection = null;
        try {
            Wrapper wrapper;
            if (this.useJNDI) {
                object = new InitialContext();
                wrapper = (DataSource)object.lookup(this.jndiName);
                if (debug.messageEnabled()) {
                    debug.message("Datasource Acquired: " + wrapper.toString());
                }
                connection = wrapper.getConnection();
                debug.message("Using JNDI Retrieved Connection pool");
            } else {
                Class.forName(this.driver);
                connection = DriverManager.getConnection(this.url, this.dbuser, this.dbpassword);
            }
            if (debug.messageEnabled()) {
                debug.message("Connection Acquired: " + connection.toString());
            }
            if (debug.messageEnabled()) {
                debug.message("PreparedStatement to build: " + this.statement);
            }
            object = connection.prepareStatement(this.statement);
            object.setString(1, this.userName);
            if (debug.messageEnabled()) {
                debug.message("Statement to execute: " + object);
            }
            if ((wrapper = object.executeQuery()) == null) {
                debug.message("returned null from executeQuery()");
                throw new AuthLoginException(amAuthJDBC, "nullResult", null);
            }
            int n2 = 0;
            while (wrapper.next()) {
                if (++n2 > 1) {
                    if (debug.messageEnabled()) {
                        debug.message("Too many results.UID should be a primary key");
                    }
                    throw new AuthLoginException(amAuthJDBC, "multiEntry", null);
                }
                this.resultPassword = wrapper.getString(this.passwordColumn).trim();
            }
            if (n2 == 0) {
                if (debug.messageEnabled()) {
                    debug.message("No results from your SQL query.UID should be valid");
                }
                throw new AuthLoginException(amAuthJDBC, "nullResult", null);
            }
        }
        catch (Throwable throwable) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                int n3 = 1;
                return n3;
            }
            if (debug.messageEnabled()) {
                debug.message("JDBC Exception:", throwable);
            }
            throw new AuthLoginException(throwable);
        }
        finally {
            block44: {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        debug.error("Error in closing database connection: " + exception.getMessage());
                        if (!debug.messageEnabled()) break block44;
                        debug.message("Fail to close database:", (Throwable)exception);
                    }
                }
            }
        }
        if (!this.transform.equals(DEFAULT_TRANSFORM)) {
            try {
                object = (JDBCPasswordSyntaxTransform)Class.forName(this.transform).newInstance();
                if (debug.messageEnabled()) {
                    debug.message("Got my Transform Object" + object.toString());
                }
                this.resultPassword = object.transform(this.resultPassword);
                if (debug.messageEnabled()) {
                    debug.message("Password transformed by: " + this.transform);
                }
            }
            catch (Throwable throwable) {
                if (debug.messageEnabled()) {
                    debug.message("Syntax Transform Exception:" + throwable.toString());
                }
                throw new AuthLoginException(throwable);
            }
        }
        if (this.password != null && this.password.equals(this.resultPassword)) {
            this.userTokenId = this.userName;
            return -1;
        }
        debug.message("password not match. Auth failed.");
        this.setFailureID(this.userName);
        throw new InvalidPasswordException(amAuthJDBC, "loginFailed", null, this.userName, null);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new JDBCPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUserdVars() {
        this.userName = null;
        this.password = null;
        this.resultPassword = null;
        this.passwordCharArray = null;
        this.errorMsg = null;
        this.bundle = null;
        this.options = null;
        this.driver = null;
        this.connectionType = null;
        this.jndiName = null;
        this.url = null;
        this.dbuser = null;
        this.dbpassword = null;
        this.passwordColumn = null;
        this.statement = null;
        this.transform = null;
        this.sharedState = null;
    }
}

