/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.httpbasic;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.httpbasic.HTTPBasicPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.UserNamePasswordValidationException;
import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class HTTPBasic
extends AMLoginModule {
    private static final String amAuthHTTPBasic = "amAuthHTTPBasic";
    private static Debug debug = Debug.getInstance((String)"amAuthHTTPBasic");
    private static boolean ldapSSL = false;
    private static String hostName;
    private static final int SUCCESS = 26;
    private static String SA;
    private static String LDAPSERVER;
    private static String UNA;
    private static String USERSEARCH;
    private static String SEARCHFILTER;
    private static String BINDPWD;
    private static String BASEDN;
    private static String BINDDN;
    private static String SSL;
    private static String SEARCHSCOPE;
    private static String MODCONFIG;
    private static String AUTHLEVEL;
    private static final String INVALID_CHARS = "iplanet-am-auth-ldap-invalid-chars";
    private Principal userPrincipal = null;
    private ResourceBundle bundle = null;
    private String validatedUserID;
    private String regEx;
    private LDAPAuthUtils ldapUtil;
    private String userName;
    private String userPassword;
    private Map currentConfig;
    private Map options;

    public void init(Subject subject, Map map, Map map2) {
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthHTTPBasic, locale);
        if (debug.messageEnabled()) {
            debug.message("HttpBasicAuth resbundle locale=" + locale);
        }
        this.options = map2;
    }

    private boolean initHttpBasicAuth() throws AuthLoginException {
        String string;
        debug.message("HTTPBasic initialize()");
        String string2 = Misc.getMapAttr((Map)this.options, (String)MODCONFIG);
        if (string2 == null) {
            debug.message("No Service Template created");
            throw new AuthLoginException(amAuthHTTPBasic, "noST", null);
        }
        String string3 = Misc.getMapAttr((Map)this.options, (String)AUTHLEVEL);
        if (string3 != null) {
            try {
                this.setAuthLevel(Integer.parseInt(string3));
            }
            catch (Exception exception) {
                debug.error("Unable to set auth level " + string3, (Throwable)exception);
            }
        }
        if ((string = HTTPBasic.getModuleServiceName(string2)) != null) {
            if (string2.equals("LDAP")) {
                return this.initLDAPAttributes(string);
            }
            debug.error(" Init Exception");
            throw new AuthLoginException(amAuthHTTPBasic, "basicauthInitFalied", null);
        }
        return false;
    }

    private boolean initLDAPAttributes(String string) throws AuthLoginException {
        String string2 = null;
        this.currentConfig = this.getOrgServiceTemplate(this.getRequestOrg(), string);
        try {
            string2 = Misc.getServerMapAttr((Map)this.currentConfig, (String)LDAPSERVER);
            if (string2 == null) {
                debug.message("No server for configuring");
                return false;
            }
            String string3 = Misc.getServerMapAttr((Map)this.currentConfig, (String)BASEDN);
            if (string3 == null) {
                debug.error("Fatal error: baseDN for search has invalid value");
                throw new AuthLoginException(amAuthHTTPBasic, "basednnull", null);
            }
            String string4 = Misc.getMapAttr((Map)this.currentConfig, (String)BINDDN, (String)"");
            String string5 = Misc.getMapAttr((Map)this.currentConfig, (String)BINDPWD, (String)"");
            String string6 = Misc.getMapAttr((Map)this.currentConfig, (String)UNA, (String)"uid");
            Set set = (Set)this.currentConfig.get(USERSEARCH);
            String string7 = Misc.getMapAttr((Map)this.currentConfig, (String)SEARCHFILTER, (String)"");
            boolean bl = Boolean.valueOf(Misc.getMapAttr((Map)this.currentConfig, (String)SSL, (String)"false"));
            String string8 = Misc.getMapAttr((Map)this.currentConfig, (String)SEARCHSCOPE, (String)"SUBTREE");
            int n = 2;
            if (string8.equalsIgnoreCase("OBJECT")) {
                n = 0;
            } else if (string8.equalsIgnoreCase("ONELEVEL")) {
                n = 1;
            }
            String string9 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-return-user-dn", (String)"true");
            this.regEx = Misc.getMapAttr((Map)this.currentConfig, (String)INVALID_CHARS);
            int n2 = string2.indexOf(58);
            int n3 = 389;
            String string10 = null;
            if (n2 != -1) {
                string10 = string2.substring(n2 + 1);
                n3 = Integer.parseInt(string10);
                string2 = string2.substring(0, n2);
            }
            this.ldapUtil = new LDAPAuthUtils(string2, n3, bl, this.bundle, string3, debug);
            this.ldapUtil.setScope(n);
            this.ldapUtil.setFilter(string7);
            this.ldapUtil.setUserNamingAttribute(string6);
            this.ldapUtil.setUserSearchAttribute(set);
            this.ldapUtil.setAuthPassword(string5);
            this.ldapUtil.setAuthDN(string4);
            this.ldapUtil.setReturnUserDN(string9);
            if (debug.messageEnabled()) {
                debug.message("bindDN-> " + string4 + "\nbaseDN-> " + string3 + "\nuserNamingAttr-> " + string6 + "\nuserSearchAttr(s)-> " + set + "\nsearchFilter-> " + string7 + "\nsearchScope-> " + n + "\nssl-> " + bl + "\nHost: " + string2 + "\nINDEDX : " + n2 + "\nPORT : " + n3);
            }
            return true;
        }
        catch (Exception exception) {
            debug.error("LDAP Init Exception", (Throwable)exception);
            throw new AuthLoginException(amAuthHTTPBasic, "basicLDAPex", null, exception);
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        boolean bl = false;
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        HttpServletResponse httpServletResponse = this.getHttpServletResponse();
        if (httpServletRequest == null || httpServletResponse == null) {
            debug.message("Servlet Request and Response cannot be null");
            throw new AuthLoginException(amAuthHTTPBasic, "reqRespNull", null);
        }
        try {
            debug.message("Process HTTPBasic Auth started ...");
            String string = httpServletRequest.getHeader("Authorization");
            if (debug.messageEnabled()) {
                debug.message("AUTH : " + string);
            }
            if (this.authenticate(string)) {
                this.validatedUserID = this.userName;
                return -1;
            }
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthHTTPBasic, "sendError", null);
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setFailureID(this.userName);
            throw new InvalidPasswordException(invalidPasswordException);
        }
        catch (UserNamePasswordValidationException userNamePasswordValidationException) {
            debug.message("Invalid Characters detected");
            throw new AuthLoginException(userNamePasswordValidationException);
        }
        catch (Exception exception) {
            debug.error("login: unknown exception = ", (Throwable)exception);
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthHTTPBasic, "sendError", null, exception);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new HTTPBasicPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
        this.userPrincipal = null;
    }

    public void nullifyUserdVars() {
        this.bundle = null;
        this.regEx = null;
        this.ldapUtil = null;
        this.userName = null;
        this.userPassword = null;
        this.currentConfig = null;
        this.options = null;
    }

    private boolean authenticate(String string) throws AuthLoginException, IOException {
        if (string == null || !string.toUpperCase().startsWith("BASIC")) {
            return false;
        }
        int n = 0;
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        String string2 = string.substring(6);
        String string3 = new String(bASE64Decoder.decodeBuffer(string2));
        int n2 = string3.indexOf(58);
        if (n2 != -1) {
            this.userPassword = string3.substring(n2 + 1);
            this.userName = string3.substring(0, n2);
        }
        this.storeUsernamePasswd(this.userName, this.userPassword);
        n = this.authenticateToLDAP(this.userName, this.userPassword);
        return n == 26;
    }

    private int authenticateToLDAP(String string, String string2) throws AuthLoginException {
        try {
            if (this.isSuperAdmin(string)) {
                this.ldapUtil = new LDAPAuthUtils(AuthD.directoryHostName, AuthD.directoryPort, ldapSSL, this.bundle, debug);
                this.ldapUtil.authenticateSuperAdmin(string, string2);
                return this.ldapUtil.getState();
            }
            if (this.initHttpBasicAuth()) {
                this.validateUserName(string, this.regEx);
                this.ldapUtil.authenticateUser(string, string2);
                return this.ldapUtil.getState();
            }
            this.setFailureID(string);
            throw new AuthLoginException(amAuthHTTPBasic, "basicLDAPex", null);
        }
        catch (LDAPUtilException lDAPUtilException) {
            this.setFailureID(string);
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist.");
                    throw new AuthLoginException(amAuthHTTPBasic, "NoUser", null);
                }
                case 49: {
                    debug.message("Invalid password.");
                    String string3 = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(amAuthHTTPBasic, "InvalidUP", null, string3, (Throwable)((Object)lDAPUtilException));
                }
            }
            throw new AuthLoginException(amAuthHTTPBasic, "basicLDAPex", null);
        }
    }

    public static String getModuleServiceName(String string) {
        return "iPlanetAMAuth" + string + "Service";
    }

    static {
        SA = "iplanet-am-auth-ldap-";
        LDAPSERVER = SA + "server";
        UNA = SA + "user-naming-attribute";
        USERSEARCH = SA + "user-search-attributes";
        SEARCHFILTER = SA + "search-filter";
        BINDPWD = SA + "bind-passwd";
        BASEDN = SA + "base-dn";
        BINDDN = SA + "bind-dn";
        SSL = SA + "ssl-enabled";
        SEARCHSCOPE = SA + "search-scope";
        MODCONFIG = "iplanet-am-auth-http-basic-module-configured";
        AUTHLEVEL = "iplanet-am-auth-http-basic-auth-level";
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthLDAP");
        }
        ldapSSL = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.directory.ssl.enabled", (String)"false"));
    }
}

