/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.cert;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.authentication.modules.cert.CertAuthPrincipal;
import com.sun.identity.authentication.service.X509CertificateCallback;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.cert.AMCRLStore;
import com.sun.identity.security.cert.AMCertPath;
import com.sun.identity.security.cert.AMCertStore;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.internet.MimeUtility;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import org.mozilla.jss.CryptoManager;

public class Cert
extends AMLoginModule {
    private static Locale locale = null;
    private ResourceBundle bundle = null;
    private String userTokenId = null;
    private X509Certificate thecert = null;
    private String amAuthCert_serverHost;
    private String amAuthCert_startSearchLoc;
    private String amAuthCert_securityType;
    private String amAuthCert_principleUser;
    private String amAuthCert_principlePasswd;
    private String amAuthCert_useSSL;
    private String amAuthCert_userProfileMapper;
    private String amAuthCert_altUserProfileMapper;
    private String amAuthCert_chkCRL;
    private String amAuthCert_chkAttrCRL = null;
    private String amAuthCert_uriParamsCRL = null;
    private String amAuthCert_chkCertInLDAP;
    private String amAuthCert_chkAttrCertInLDAP = null;
    private String amAuthCert_ldapProfileID;
    private String amAuthCert_emailAddrTag;
    private int amAuthCert_serverPort = 389;
    private static boolean portal_gw_cert_auth_enabled = false;
    private Set portalGateways = null;
    private String certParamName = null;
    private boolean ocspEnabled = false;
    private AMLDAPCertStoreParameters ldapParam = null;
    private Map options;
    private CertAuthPrincipal userPrincipal;
    private CallbackHandler callbackHandler;
    private LDAPConnection ldc = null;
    static boolean usingJSSEHandler = false;
    static final int ldap_version = 3;
    private static final String amAuthCert = "amAuthCert";
    public static Debug debug = null;

    public void init(Subject subject, Map map, Map map2) {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthCert);
        }
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthCert, locale);
        this.callbackHandler = this.getCallbackHandler();
        this.options = map2;
        if (debug.messageEnabled()) {
            debug.message("Cert Auth resbundle locale=" + locale);
            debug.message("Cert auth init() done");
        }
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options != null) {
            Object object;
            debug.message("Certificate: getting attributes.");
            String string = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-auth-level");
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    this.setAuthLevel(n);
                }
                catch (Exception exception) {
                    debug.error("Invalid auth level " + string, (Throwable)exception);
                }
            }
            this.amAuthCert_securityType = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-security-type");
            this.amAuthCert_principleUser = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-principal-user");
            this.amAuthCert_principlePasswd = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-principal-passwd");
            this.amAuthCert_useSSL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-use-ssl");
            this.amAuthCert_userProfileMapper = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper");
            this.amAuthCert_altUserProfileMapper = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper-other");
            this.amAuthCert_chkCRL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-crl");
            if (this.amAuthCert_chkCRL.equalsIgnoreCase("true")) {
                this.amAuthCert_chkAttrCRL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-attr-check-crl");
                if (this.amAuthCert_chkAttrCRL == null || this.amAuthCert_chkAttrCRL.equals("")) {
                    throw new AuthLoginException(amAuthCert, "noCRLAttr", null);
                }
            }
            this.amAuthCert_uriParamsCRL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-param-get-crl");
            this.amAuthCert_chkCertInLDAP = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-cert-in-ldap");
            if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true")) {
                this.amAuthCert_chkAttrCertInLDAP = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-attr-check-ldap");
                if (this.amAuthCert_chkAttrCertInLDAP == null || this.amAuthCert_chkAttrCertInLDAP.equals("")) {
                    throw new AuthLoginException(amAuthCert, "noLDAPAttr", null);
                }
            }
            this.amAuthCert_ldapProfileID = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-ldap-profile-id");
            String string2 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-ocsp");
            this.ocspEnabled = string2 != null && string2.equalsIgnoreCase("true");
            String string3 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-gw-cert-auth-enabled");
            this.certParamName = Misc.getMapAttr((Map)this.options, (String)"sunAMHttpParamName");
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            String string4 = null;
            if (httpServletRequest != null) {
                string4 = httpServletRequest.getRemoteAddr();
            }
            portal_gw_cert_auth_enabled = false;
            if (string3 == null || string3.equals("") || string3.equalsIgnoreCase("none")) {
                if (debug.messageEnabled()) {
                    debug.message("iplanet-am-auth-cert-gw-cert-auth-enabled = " + string3);
                }
            } else if (string3.equalsIgnoreCase("any")) {
                portal_gw_cert_auth_enabled = true;
            } else {
                this.portalGateways = (Set)this.options.get("iplanet-am-auth-cert-gw-cert-auth-enabled");
                if (string4 != null && this.portalGateways.contains(string4)) {
                    portal_gw_cert_auth_enabled = true;
                } else if (debug.messageEnabled()) {
                    debug.message("gateway list does not contain client");
                    object = this.portalGateways.iterator();
                    while (object.hasNext()) {
                        String string5 = (String)object.next();
                        debug.message("client list entry = " + string5);
                    }
                }
            }
            this.amAuthCert_emailAddrTag = this.bundle.getString("emailAddrTag");
            this.amAuthCert_serverHost = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-ldap-provider-url");
            if (this.amAuthCert_serverHost == null && (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") || this.amAuthCert_chkCRL.equalsIgnoreCase("true"))) {
                debug.error("Fatal error: LDAP Server and Port misconfigured");
                throw new AuthLoginException(amAuthCert, "wrongLDAPServer", null);
            }
            if (this.amAuthCert_serverHost != null) {
                try {
                    object = new LDAPUrl("ldap://" + this.amAuthCert_serverHost);
                    this.amAuthCert_serverPort = object.getPort();
                    this.amAuthCert_serverHost = object.getHost();
                }
                catch (Exception exception) {
                    throw new AuthLoginException(amAuthCert, "wrongLDAPServer", null);
                }
            }
            this.amAuthCert_startSearchLoc = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-start-search-loc");
            if (this.amAuthCert_startSearchLoc == null && (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") || this.amAuthCert_chkCRL.equalsIgnoreCase("true"))) {
                debug.error("Fatal error: LDAP Start Search DN is not configured");
                throw new AuthLoginException(amAuthCert, "wrongStartDN", null);
            }
            if (this.amAuthCert_startSearchLoc != null) {
                try {
                    object = new X500Name(this.amAuthCert_startSearchLoc);
                }
                catch (Exception exception) {
                    debug.error("Fatal error: LDAP Start Search DN misconfigured");
                    throw new AuthLoginException(amAuthCert, "wrongStartDN", null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("\nldapProviderUrl=" + this.amAuthCert_serverHost + "\n\tamAuthCert_serverPort = " + this.amAuthCert_serverPort + "\n\tstartSearchLoc=" + this.amAuthCert_startSearchLoc + "\n\tsecurityType=" + this.amAuthCert_securityType + "\n\tprincipleUser=" + this.amAuthCert_principleUser + "\n\tauthLevel=" + string + "\n\tuseSSL=" + this.amAuthCert_useSSL + "\n\tocspEnable=" + this.ocspEnabled + "\n\tuserProfileMapper=" + this.amAuthCert_userProfileMapper + "\n\taltUserProfileMapper=" + this.amAuthCert_altUserProfileMapper + "\n\tchkCRL=" + this.amAuthCert_chkCRL + "\n\tchkAttrCRL=" + this.amAuthCert_chkAttrCRL + "\n\tchkCertInLDAP=" + this.amAuthCert_chkCertInLDAP + "\n\tchkAttrCertInLDAP=" + this.amAuthCert_chkAttrCertInLDAP + "\n\temailAddr=" + this.amAuthCert_emailAddrTag + "\n\tldapProfileID=" + this.amAuthCert_ldapProfileID + "\n\tgw-cert-auth-enabled=" + portal_gw_cert_auth_enabled + "\n\tclient=" + string4);
            }
        } else {
            debug.error("options is null");
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        Object object;
        debug.message("in Certificate. process()");
        this.initAuthConfig();
        try {
            object = this.getHttpServletRequest();
            if (object != null) {
                X509Certificate[] x509CertificateArray = (X509Certificate[])object.getAttribute("javax.servlet.request.X509Certificate");
                if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                    debug.message("Certificate: checking for cert passed in the URL.");
                    if (!portal_gw_cert_auth_enabled) {
                        debug.error("Certificate: cert passed in URL not enabled for this client");
                        throw new AuthLoginException(amAuthCert, "noURLCertAuth", null);
                    }
                    this.thecert = this.getPortalStyleCert((HttpServletRequest)object);
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("Certificate: got all certs from HttpServletRequest =" + x509CertificateArray.length);
                    }
                    this.thecert = x509CertificateArray[0];
                }
            } else {
                this.thecert = this.sendCallback();
            }
            if (this.thecert == null) {
                debug.message("Certificate: no cert passed in.");
                throw new AuthLoginException(amAuthCert, "noCert", null);
            }
            this.getTokenFromCert(this.thecert);
            this.storeUsernamePasswd(this.userTokenId, null);
            if (debug.messageEnabled()) {
                debug.message("in Certificate. userTokenId=" + this.userTokenId + " from getTokenFromCert");
            }
        }
        catch (AuthLoginException authLoginException) {
            this.setFailureID(this.userTokenId);
            debug.error("Certificate:  exiting validate with exception", (Throwable)authLoginException);
            throw new AuthLoginException(amAuthCert, "noCert", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Got client cert =\n" + this.thecert.toString());
        }
        if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("false") && this.amAuthCert_chkCRL.equalsIgnoreCase("false") && !this.ocspEnabled) {
            return -1;
        }
        if (this.ocspEnabled && !this.certValidation(this.thecert)) {
            debug.error("OCSP cert validation failed");
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertIsNotValid", null);
        }
        if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") && (object = this.getRegisteredCertificate(this.thecert)) == null) {
            debug.error("X509Certificate: getRegCertificate is null");
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
        if (this.amAuthCert_chkCRL.equalsIgnoreCase("true")) {
            int n2 = 0;
            n2 = usingJSSEHandler ? this.doJCECRLValidation(this.thecert) : this.doJSSCRLValidation(this.thecert);
            if (n2 != -1) {
                debug.error("X509Certificate:CRL verify failed.");
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthCert, "CertVerifyFailed", null);
            }
        }
        return -1;
    }

    private int doJSSCRLValidation(X509Certificate x509Certificate) {
        int n = 0;
        if (!this.checkCRL(x509Certificate)) {
            debug.message("X509Certificate:verifyCertificate failed.");
            return n;
        }
        return -1;
    }

    private int doJCECRLValidation(X509Certificate x509Certificate) {
        int n = 0;
        try {
            X509CRL x509CRL = this.getCRL(x509Certificate);
            Vector<X509CRL> vector = new Vector<X509CRL>();
            if (x509CRL != null) {
                vector.add(x509CRL);
            }
            AMCertPath aMCertPath = new AMCertPath(vector);
            X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
            if (!aMCertPath.velify(x509CertificateArray)) {
                debug.error("CertPath:verify failed.");
                return n;
            }
        }
        catch (Exception exception) {
            debug.error("CertPath:verify failed." + exception.toString());
            return n;
        }
        n = -1;
        return -1;
    }

    private X509CRL getCRL(X509Certificate x509Certificate) {
        Object object;
        X509CRL x509CRL = null;
        String string = null;
        try {
            object = AMCRLStore.getIssuerDN(x509Certificate);
            if (object != null) {
                string = ((X500Name)object).getAttributeValue(this.amAuthCert_chkAttrCRL);
            }
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - cn substring: " + exception);
            }
            return null;
        }
        if (string == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Certificate - cn substring: " + string);
        }
        object = this.setSearchFilter(this.amAuthCert_chkAttrCRL, string);
        try {
            if (this.ldapParam == null) {
                this.setLdapStoreParam();
            }
            AMCRLStore aMCRLStore = new AMCRLStore(this.ldapParam);
            this.ldapParam.setSearchFilter((String)object);
            x509CRL = aMCRLStore.getCRL(x509Certificate);
        }
        catch (IOException iOException) {
            debug.error("X509Certificate: verifyCertificate." + iOException.toString());
        }
        catch (LDAPException lDAPException) {
            debug.error("X509Certificate: verifyCertificate." + lDAPException.toString());
        }
        catch (AuthLoginException authLoginException) {
            debug.error("X509Certificate: verifyCertificate." + authLoginException.toString());
        }
        return x509CRL;
    }

    private boolean checkCRL(X509Certificate x509Certificate) {
        X509CRL x509CRL = this.getCRL(x509Certificate);
        return x509CRL != null && !x509CRL.isRevoked(x509Certificate);
    }

    private AMLDAPCertStoreParameters setLdapStoreParam() throws AuthLoginException {
        this.ldapParam = new AMLDAPCertStoreParameters(this.amAuthCert_serverHost, this.amAuthCert_serverPort);
        if (this.amAuthCert_useSSL.equalsIgnoreCase("true")) {
            this.ldapParam.setSecure(true);
        }
        try {
            this.ldapParam.setUser(this.amAuthCert_principleUser);
            this.ldapParam.setPassword(this.amAuthCert_principlePasswd);
            this.ldapParam.setStartLoc(this.amAuthCert_startSearchLoc);
            this.ldapParam.setURIParams(this.amAuthCert_uriParamsCRL);
            this.ldapParam.setSecureSocketFactory(SSLSocketFactoryManager.getSSLSocketFactory());
        }
        catch (Exception exception) {
            debug.error("validate.JSSSocketFactory", (Throwable)exception);
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "jssSokFactoryFail", null);
        }
        return this.ldapParam;
    }

    private void getTokenFromCert(X509Certificate x509Certificate) throws AuthLoginException {
        try {
            sun.security.x509.X500Name x500Name = (sun.security.x509.X500Name)x509Certificate.getSubjectDN();
            X500Name x500Name2 = new X500Name(x500Name.getEncoded());
            if (debug.messageEnabled()) {
                debug.message("getTokenFromCert: Subject DN : " + x500Name2.getName());
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject DN")) {
                this.userTokenId = x500Name2.getName();
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject UID")) {
                this.userTokenId = x500Name2.getAttributeValue("uid");
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject CN")) {
                this.userTokenId = x500Name2.getCommonName();
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase(this.amAuthCert_emailAddrTag)) {
                this.userTokenId = x500Name2.getEmail();
                if (this.userTokenId == null) {
                    this.userTokenId = x500Name2.getAttributeValue("mail");
                }
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("DER Certificate")) {
                this.userTokenId = String.valueOf(x509Certificate.getTBSCertificate());
            }
            if (this.amAuthCert_userProfileMapper.equals("other")) {
                this.userTokenId = x500Name2.getAttributeValue(this.amAuthCert_altUserProfileMapper);
            }
            if (debug.messageEnabled()) {
                debug.message("getTokenFromCert: " + this.amAuthCert_userProfileMapper + this.userTokenId);
            }
            return;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - Error in getTokenFromCert = ", (Throwable)exception);
            }
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
    }

    private X509Certificate getRegisteredCertificate(X509Certificate x509Certificate) {
        X509Certificate x509Certificate2;
        block9: {
            Object object;
            x509Certificate2 = null;
            String string = null;
            try {
                object = AMCertStore.getSubjectDN(x509Certificate);
                if (object != null) {
                    string = ((X500Name)object).getAttributeValue(this.amAuthCert_chkAttrCertInLDAP);
                }
            }
            catch (Exception exception) {
                if (debug.messageEnabled()) {
                    debug.message("Certificate - cn substring: " + exception);
                }
                return null;
            }
            if (string == null) {
                return null;
            }
            if (debug.messageEnabled()) {
                debug.message("Certificate - cn substring: " + string);
            }
            try {
                object = this.setSearchFilter(this.amAuthCert_chkAttrCertInLDAP, string);
                if (this.ldapParam == null) {
                    this.setLdapStoreParam();
                }
                this.ldapParam.setSearchFilter((String)object);
                AMCertStore aMCertStore = new AMCertStore(this.ldapParam);
                x509Certificate2 = aMCertStore.getCertificate(x509Certificate);
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block9;
                debug.message("Certificate - Error finding registered certificate = ", (Throwable)exception);
            }
        }
        return x509Certificate2;
    }

    private String setSearchFilter(String string, String string2) {
        if (debug.messageEnabled()) {
            debug.message("Certificate - ldc.search:searching  " + this.amAuthCert_startSearchLoc + " " + this.ldc);
        }
        String string3 = new StringBuffer(128).append("(").append(string).append("=").append(string2).append(")").toString();
        if (debug.messageEnabled()) {
            debug.message("Certificate - ldc.search: using this filter: " + string3);
        }
        return string3;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new CertAuthPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public X509Certificate getCertificate() {
        return this.thecert;
    }

    public String getChkAttrCRL() {
        return this.amAuthCert_chkAttrCRL;
    }

    public LDAPConnection getLDAPConnection() {
        return this.ldc;
    }

    public Debug getDebug() {
        return debug;
    }

    public String getUriParamsCRL() {
        return this.amAuthCert_uriParamsCRL;
    }

    public String getStartSearchLoc() {
        return this.amAuthCert_startSearchLoc;
    }

    private X509Certificate sendCallback() throws AuthLoginException {
        if (this.callbackHandler == null) {
            throw new AuthLoginException(amAuthCert, "NoCallbackHandler", null);
        }
        X509Certificate x509Certificate = null;
        try {
            Callback[] callbackArray = new Callback[]{new X509CertificateCallback(this.bundle.getString("certificate"))};
            this.callbackHandler.handle(callbackArray);
            x509Certificate = ((X509CertificateCallback)callbackArray[0]).getCertificate();
            return x509Certificate;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.message("message type missing");
            throw new AuthLoginException(amAuthCert, "IllegalArgs", null);
        }
        catch (IOException iOException) {
            throw new AuthLoginException(iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new AuthLoginException(amAuthCert, "NoCallbackHandler", null);
        }
    }

    private X509Certificate getPortalStyleCert(HttpServletRequest httpServletRequest) throws AuthLoginException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = null;
        if (this.certParamName != null && this.certParamName.length() > 0) {
            debug.message("getPortalStyleCert: checking cert in HTTP header");
            object4 = new StringTokenizer(this.certParamName, ",");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                object3 = ((StringTokenizer)object4).nextToken();
                string = httpServletRequest.getHeader((String)object3);
                if (string == null) continue;
                string = string.trim();
                object2 = "-----BEGIN CERTIFICATE-----";
                object = "-----END CERTIFICATE-----";
                int n = string.indexOf((String)object);
                if (n == -1) continue;
                string = string.substring(((String)object2).length(), n);
                string = string.trim();
            }
        } else {
            debug.message("getPortalStyleCert: checking cert in userCert param");
            object4 = this.getLoginState("getPortalStyleCert()").getRequestParamHash();
            if (object4 != null && (string = (String)((Hashtable)object4).get("IDToken0")) == null) {
                string = (String)((Hashtable)object4).get("Login.Token0");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("in Certificate. validate certParam: " + string);
        }
        if (string == null || string.equals("")) {
            debug.message("Certificate: no cert from HttpServletRequest");
            throw new AuthLoginException(amAuthCert, "noCert", null);
        }
        object4 = string.getBytes();
        debug.message("in Certificate: got certbytes");
        object3 = new ByteArrayInputStream((byte[])object4);
        object2 = null;
        try {
            object2 = MimeUtility.decode((InputStream)object3, (String)"base64");
        }
        catch (Exception exception) {
            debug.error("CertificateFromParameter(decode): exception", (Throwable)exception);
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        debug.message("Certificate: CertificateFactory.getInstance.");
        object = null;
        X509Certificate x509Certificate = null;
        try {
            object = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
        }
        catch (Exception exception) {
            debug.error("CertificateFromParameter(X509Cert): exception ", (Throwable)exception);
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        if (x509Certificate == null) {
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        if (debug.messageEnabled()) {
            debug.message("X509Certificate: principal is: " + x509Certificate.getSubjectDN().getName() + "\nissuer DN:" + x509Certificate.getIssuerDN().getName() + "\nserial number:" + String.valueOf(x509Certificate.getSerialNumber()) + "\nsubject dn:" + x509Certificate.getSubjectDN().getName());
        }
        return x509Certificate;
    }

    private boolean certValidation(X509Certificate x509Certificate) {
        try {
            debug.message("inside certValidation");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            if (cryptoManager.isCertValid(x509Certificate.getEncoded(), true, CryptoManager.CertUsage.SSLClient)) {
                debug.message("cert is valid");
                return true;
            }
            debug.message("cert is not valid");
            return false;
        }
        catch (Exception exception) {
            debug.message("certValidation failed with exception", (Throwable)exception);
            return false;
        }
    }

    public void destroyModuleState() {
        this.userPrincipal = null;
        this.userTokenId = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.thecert = null;
        this.options = null;
        this.callbackHandler = null;
        if (this.ldc != null) {
            try {
                this.ldc.disconnect();
            }
            catch (LDAPException lDAPException) {
                debug.error("Failed to disconnect from " + this.amAuthCert_serverHost + ":" + this.amAuthCert_serverPort);
            }
            this.ldc = null;
        }
        this.amAuthCert_serverHost = null;
        this.amAuthCert_startSearchLoc = null;
        this.amAuthCert_securityType = null;
        this.amAuthCert_principleUser = null;
        this.amAuthCert_principlePasswd = null;
        this.amAuthCert_useSSL = null;
        this.amAuthCert_userProfileMapper = null;
        this.amAuthCert_altUserProfileMapper = null;
        this.amAuthCert_chkCRL = null;
        this.amAuthCert_chkAttrCRL = null;
        this.amAuthCert_uriParamsCRL = null;
        this.amAuthCert_chkCertInLDAP = null;
        this.amAuthCert_chkAttrCertInLDAP = null;
        this.amAuthCert_ldapProfileID = null;
        this.amAuthCert_emailAddrTag = null;
        this.portalGateways = null;
    }

    static {
        String string = System.getProperty("java.protocol.handler.pkgs", "com.sun.identity.protocol");
        usingJSSEHandler = string.equals("com.sun.identity.protocol");
    }
}

