/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal.server;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.Hash;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;

public class SMSAuthModule
implements LoginModule {
    private static boolean initialized;
    private static boolean loadedInternalUsers;
    private static boolean registeredCallbackHandler;
    private static Map users;
    private static Map userNameToDN;
    private static Debug debug;
    AuthSubject subject;
    String userDN;
    CallbackHandler cb;
    Map sharedState;
    Map options;
    private static final String IDREPO_SERVICE = "sunIdentityRepositoryService";
    private static final String USERS = "users";
    private static final String DN = "dn";
    private static final String PASSWORD = "userPassword";

    public SMSAuthModule() {
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule constructor called");
        }
    }

    public void initialize(AuthSubject authSubject, CallbackHandler callbackHandler, Map map, Map map2) {
        HashMap hashMap;
        this.subject = authSubject;
        this.cb = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        if (debug.messageEnabled()) {
            hashMap = new HashMap(this.sharedState);
            boolean bl = hashMap.remove("javax.security.auth.login.password") != null;
            debug.message("SMSAuthModule::initialize called \nPrincipals: " + authSubject.getPrincipals() + "\nSharedState: " + hashMap + "\n" + (bl ? "<Password Present> " : "<Password Absent>") + "\nOptions: " + map2);
        }
        if (!initialized) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModule::initialize() Initializing Username and password from serverconfig.xml");
            }
            hashMap = (String)AccessController.doPrivileged(new AdminDNAction());
            String string = (String)AccessController.doPrivileged(new AdminPasswordAction());
            SMSAuthModule.addUserToCache((String)((Object)hashMap), Hash.hash((String)string));
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModule::initialize() Username serviceconfig.xml: " + (String)((Object)hashMap));
            }
            initialized = true;
        }
    }

    public boolean login() throws LoginException {
        Object object;
        String string = (String)this.sharedState.get("javax.security.auth.login.name");
        String string2 = (String)this.sharedState.get("javax.security.auth.login.password");
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule::login() From shared state: Username: " + string + " Password: " + (string2 == null ? "<not present>" : "<present>"));
        }
        if (string == null || string2 == null) {
            Callback[] callbackArray = new Callback[]{new NameCallback("User name: "), new PasswordCallback("Password: ", false)};
            try {
                if (debug.messageEnabled()) {
                    debug.message("SMSAuthModule::login() Sending Name & Password Callback");
                }
                this.cb.handle(callbackArray);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException(unsupportedCallbackException.getMessage());
            }
            catch (IOException iOException) {
                throw new LoginException(iOException.getMessage());
            }
            string = ((NameCallback)callbackArray[0]).getName();
            object = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object != null) {
                string2 = new String(string2);
            }
        }
        boolean bl = false;
        if (string != null && string2 != null) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModule::login() For authentication: Username: " + string + " Password: <present>");
            }
            if (netscape.ldap.util.DN.isDN((String)string)) {
                this.userDN = string;
                string = new DN(this.userDN).explodeDN(true)[0];
            } else {
                this.userDN = (String)userNameToDN.get(string);
                if (this.userDN == null && !loadedInternalUsers) {
                    SMSAuthModule.loadInternalUsers();
                    this.userDN = (String)userNameToDN.get(string);
                }
            }
            if (this.userDN != null) {
                object = (String)users.get(string);
                if (object != null && ((String)object).equals(Hash.hash((String)string2))) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSAuthModule::login() Success AuthN");
                    }
                    bl = true;
                } else if (!loadedInternalUsers && object != null) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSAuthModule::login() Loading internal users");
                    }
                    SMSAuthModule.loadInternalUsers();
                    if (((String)object).equals(Hash.hash((String)string2))) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSAuthModule::login() Success AuthN");
                        }
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        Set set;
        if (debug.messageEnabled()) {
            debug.message("SMSAuthModule::commit() Adding Principal: " + this.userDN + " to Subject");
        }
        if ((set = this.subject.getPrincipals()).size() == 0) {
            set.add(new AuthPrincipal(this.userDN));
        }
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    private static synchronized void loadInternalUsers() {
        if (loadedInternalUsers) {
            return;
        }
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(IDREPO_SERVICE, sSOToken);
            ServiceConfig serviceConfig = serviceConfigManager.getGlobalConfig(null);
            serviceConfig = serviceConfig.getSubConfig(USERS);
            Iterator iterator = serviceConfig.getSubConfigNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
                Map map = serviceConfig2.getAttributes();
                String string2 = null;
                Set set = (Set)map.get(DN);
                if (set != null && !set.isEmpty()) {
                    string2 = (String)set.iterator().next();
                }
                String string3 = null;
                set = (Set)map.get(PASSWORD);
                if (set != null && !set.isEmpty()) {
                    string3 = (String)set.iterator().next();
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSAuthModule::loadInternalUsers() Added user: " + string2);
                }
                SMSAuthModule.addUserToCache(string2, string3);
            }
            loadedInternalUsers = true;
            if (!registeredCallbackHandler) {
                serviceConfigManager.addListener(new SMSAuthModuleListener());
                registeredCallbackHandler = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addUserToCache(String string, String string2) {
        users.put(string, string2);
        String[] stringArray = new DN(string).explodeDN(true);
        users.put(stringArray[0], string2);
        userNameToDN.put(stringArray[0], string);
    }

    static {
        users = new HashMap();
        userNameToDN = new HashMap();
        debug = Debug.getInstance((String)"amAuthInternalSMModule");
    }

    static class SMSAuthModuleListener
    implements ServiceListener {
        SMSAuthModuleListener() {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::init called");
            }
        }

        public void schemaChanged(String string, String string2) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::schemaChanged called");
            }
        }

        public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::globalConfigChanged");
            }
            if (string.equalsIgnoreCase(SMSAuthModule.IDREPO_SERVICE)) {
                loadedInternalUsers = false;
            }
        }

        public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
            if (debug.messageEnabled()) {
                debug.message("SMSAuthModuleListener::orgConfigChanged");
            }
        }
    }
}

