/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private AuthSubject subject;
    private CallbackHandler cbHandler;
    private String organization;
    private LoginModule module;
    private HashMap sharedState = new HashMap();
    public static final String LDAP_AUTH_URL = "ldap://";
    public static final String LDAPS_AUTH_URL = "ldaps://";
    public static final String ORGNAME = "ORGANIZATION";
    public static final String PASSWORD = "PASSWORD";
    public static final String AUTH_MODULES = "admin.auth.classname";
    public static final String DONOT_INCLUDE_SMS_MODULE = "admin.auth.donotIncludeSMSModule";
    private static final String LDAP_LOGIN_MODULE = "com.sun.identity.authentication.internal.server.LocalLdapAuthModule";
    private static final String SMS_LOGIN_MODULE = "com.sun.identity.authentication.internal.server.SMSAuthModule";

    protected LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.organization = string;
        this.subject = new AuthSubject();
        this.cbHandler = callbackHandler;
    }

    protected LoginContext(String string, AuthSubject authSubject, CallbackHandler callbackHandler) throws LoginException {
        this.organization = string;
        this.subject = authSubject;
        this.cbHandler = callbackHandler;
    }

    protected AuthSubject getSubject() {
        return this.subject;
    }

    protected void login() throws LoginException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.organization != null) {
            hashMap.put(ORGNAME, this.organization);
        }
        this.module = null;
        LoginModule[] loginModuleArray = null;
        try {
            loginModuleArray = this.getLoginModules();
        }
        catch (Exception exception) {
            if (AuthContext.authDebug.warningEnabled()) {
                AuthContext.authDebug.warning("LoginContext::login() Got exception while getting auth module", (Throwable)exception);
                AuthContext.authDebug.warning("LoginContext::login() Using default auth modules");
            }
            try {
                loginModuleArray = this.getDefaultLoginModules();
            }
            catch (Exception exception2) {
                throw new LoginException(exception.getMessage() + "\n" + exception2.getMessage());
            }
        }
        LoginException loginException = null;
        boolean bl = false;
        int n = 0;
        while (n < loginModuleArray.length) {
            this.module = loginModuleArray[n];
            this.module.initialize(this.subject, this.cbHandler, this.sharedState, hashMap);
            bl = false;
            try {
                bl = this.module.login();
            }
            catch (LoginException loginException2) {
                loginException = loginException2;
            }
            if (bl) {
                this.module.commit();
                break;
            }
            this.module.abort();
            ++n;
        }
        if (!bl && loginException != null) {
            throw loginException;
        }
    }

    void updateSharedState(Callback[] callbackArray) {
        int n = 0;
        while (callbackArray != null && n < callbackArray.length) {
            Object object;
            if (callbackArray[n] instanceof NameCallback) {
                object = ((NameCallback)callbackArray[n]).getName();
                if (object != null) {
                    this.sharedState.put("javax.security.auth.login.name", object);
                }
            } else if (callbackArray[n] instanceof PasswordCallback && (object = (Object)((PasswordCallback)callbackArray[n]).getPassword()) != null) {
                this.sharedState.put("javax.security.auth.login.password", new String((char[])object));
            }
            ++n;
        }
    }

    void updateSharedState(String string, char[] cArray) {
        this.sharedState.put("javax.security.auth.login.name", string);
        this.sharedState.put("javax.security.auth.login.password", new String(cArray));
    }

    protected LoginModule[] getLoginModules() throws Exception {
        LoginModule[] loginModuleArray = null;
        String string = SystemProperties.get((String)AUTH_MODULES);
        if (string == null) {
            loginModuleArray = this.getDefaultLoginModules();
            if (AuthContext.authDebug.messageEnabled()) {
                AuthContext.authDebug.message("LoginContext:getLoginModules() Using default modules");
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            String string2 = SystemProperties.get((String)DONOT_INCLUDE_SMS_MODULE);
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                loginModuleArray = new LoginModule[stringTokenizer.countTokens()];
            } else {
                loginModuleArray = new LoginModule[stringTokenizer.countTokens() + 1];
                loginModuleArray[loginModuleArray.length - 1] = (LoginModule)Class.forName(SMS_LOGIN_MODULE).newInstance();
            }
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                loginModuleArray[n] = (LoginModule)Class.forName(string3).newInstance();
                if (AuthContext.authDebug.messageEnabled()) {
                    AuthContext.authDebug.message("LoginContext:getLoginModules() Adding module: " + string3);
                }
                ++n;
            }
        }
        return loginModuleArray;
    }

    protected LoginModule[] getDefaultLoginModules() throws Exception {
        LoginModule[] loginModuleArray = new LoginModule[]{(LoginModule)Class.forName(SMS_LOGIN_MODULE).newInstance(), (LoginModule)Class.forName(LDAP_LOGIN_MODULE).newInstance()};
        return loginModuleArray;
    }

    protected void logout() throws LoginException {
        this.module.logout();
    }
}

