/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import java.io.Serializable;
import org.w3c.dom.Node;

public class AuthConfigurationEntry
implements Serializable {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private String module = null;
    private String flag = null;
    private String options = null;

    public AuthConfigurationEntry(String string, String string2, String string3) throws AMConfigurationException {
        this.checkModule(string);
        this.checkFlag(string2);
        this.module = string;
        this.flag = string2;
        this.options = string3;
    }

    protected AuthConfigurationEntry(Node node) throws AMConfigurationException {
        String string;
        if (debug.messageEnabled()) {
            debug.message("AuthConfigEntry, value=" + node.toString());
        }
        if ((string = node.getFirstChild().getNodeValue()) == null || string.equals("")) {
            debug.error("AuthConfigEntry, invalid value=" + string);
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
        int n = (string = string.trim()).indexOf(" ");
        if (n == -1) {
            debug.error("AuthConfigEntry, invalid value=" + string);
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
        this.module = string.substring(0, n);
        if ((n = (string = string.substring(n + 1).trim()).indexOf(" ")) == -1) {
            this.flag = string;
        } else {
            this.flag = string.substring(0, n);
            this.options = string.substring(n + 1).trim();
        }
        this.checkFlag(this.flag);
    }

    public String toString() {
        if (this.options == null) {
            return this.module + " " + this.flag;
        }
        return this.module + " " + this.flag + " " + this.options;
    }

    public String getLoginModuleName() {
        return this.module;
    }

    public void setLoginModuleName(String string) throws AMConfigurationException {
        this.checkModule(string);
        this.module = string;
    }

    public String getControlFlag() {
        return this.flag;
    }

    public void setControlFlag(String string) throws AMConfigurationException {
        this.checkFlag(string);
        this.flag = string;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String string) {
        this.options = string;
    }

    private void checkModule(String string) throws AMConfigurationException {
        if (string == null || string.equals("")) {
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
    }

    private void checkFlag(String string) throws AMConfigurationException {
        if (string == null || string.equals("")) {
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
        if (!(string.equalsIgnoreCase("REQUIRED") || string.equalsIgnoreCase("OPTIONAL") || string.equalsIgnoreCase("REQUISITE") || string.equalsIgnoreCase("SUFFICIENT"))) {
            debug.warning("AuthConfigEntry, invalid flag : " + string);
            throw new AMConfigurationException(AMAuthConfigUtils.bundleName, "invalidConfig");
        }
    }
}

