/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationSchema;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AMAuthenticationManager {
    private static String bundleName;
    private static Debug debug;
    private static Set authTypes;
    private static Map moduleServiceNames;
    private static Set globalModuleNames;
    private SSOToken token;
    private String realm;
    private ServiceConfig orgServiceConfig;
    private static Hashtable moduleInstanceTable;
    private static SSOToken adminToken;

    public AMAuthenticationManager(SSOToken sSOToken, String string) throws AMConfigurationException {
        try {
            SMSEntry.validateToken(sSOToken);
            this.token = sSOToken;
            this.realm = AuthUtils.getNormalizedDN(DNMapper.orgNameToDN(string));
            this.orgServiceConfig = this.getOrgServiceConfig();
            if (this.orgServiceConfig == null) {
                throw new AMConfigurationException(bundleName, "badRealm", new Object[]{this.realm});
            }
            if (moduleInstanceTable.get(this.realm) == null && moduleInstanceTable.get(this.realm) == null) {
                AMAuthenticationManager.buildModuleInstanceTable(sSOToken, this.realm);
            }
        }
        catch (SMSException sMSException) {
            throw new AMConfigurationException(sMSException);
        }
        catch (Exception exception) {
            debug.error("Token is invalid.", (Throwable)exception);
        }
    }

    public static synchronized void reInitializeAuthServices() {
        authTypes.clear();
        if (globalModuleNames != Collections.EMPTY_SET) {
            globalModuleNames.clear();
        }
        AMAuthenticationManager.initAuthenticationService(adminToken);
    }

    public static Set getAuthenticationTypes() {
        return authTypes;
    }

    public static Set getAuthenticationServiceNames() {
        Set<Object> set;
        Collection collection = moduleServiceNames.values();
        Set<Object> set2 = set = collection != null ? new HashSet(collection) : Collections.EMPTY_SET;
        if (debug.messageEnabled()) {
            debug.message("Authenticator serviceNames: " + set);
        }
        return set;
    }

    public static String getAuthenticationServiceName(String string) {
        return (String)moduleServiceNames.get(string);
    }

    private static void initAuthenticationService(SSOToken sSOToken) {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMAuthService", sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Set set = (Set)serviceSchema.getAttributeDefaults().get("iplanet-am-auth-authenticators");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                int n = string2.lastIndexOf(".");
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                if (!string2.equals("Application")) {
                    authTypes.add(string2);
                }
                if ((string = (String)moduleServiceNames.get(string2)) != null) continue;
                string = AuthUtils.getModuleServiceName(string2);
                try {
                    new ServiceSchemaManager(string, sSOToken);
                    Map map = moduleServiceNames;
                    synchronized (map) {
                        HashMap<String, String> hashMap = new HashMap<String, String>(moduleServiceNames);
                        hashMap.put(string2, string);
                        moduleServiceNames = hashMap;
                    }
                }
                catch (Exception exception) {
                    if (globalModuleNames == Collections.EMPTY_SET) {
                        globalModuleNames = new HashSet();
                    }
                    globalModuleNames.add(string2);
                    authTypes.remove(string2);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("Global module names: " + globalModuleNames);
                debug.message("moduleServiceNames: " + moduleServiceNames);
            }
        }
        catch (Exception exception) {
            debug.error("Failed to get module types", (Throwable)exception);
        }
    }

    private static void buildModuleInstanceTable(SSOToken sSOToken, String string) {
        block4: {
            try {
                OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string);
                Set set = organizationConfigManager.getAssignedServices();
                if (set == null) {
                    return;
                }
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!moduleServiceNames.containsValue(string2)) continue;
                    AMAuthenticationManager.buildModuleInstanceForService(string, string2);
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block4;
                debug.message("building module instance table error", (Throwable)exception);
            }
        }
    }

    public static synchronized void buildModuleInstanceForService(String string, String string2) {
        block12: {
            if (debug.messageEnabled()) {
                debug.message("start moduleInstanceTable : " + moduleInstanceTable + " for realm : " + string + " and service : " + string2);
            }
            try {
                String string3 = AMAuthenticationManager.getModuleName(string2);
                if (debug.messageEnabled()) {
                    debug.message("Module name : " + string3);
                }
                if (string3 != null && !string3.equals("")) {
                    Set set;
                    Cloneable cloneable;
                    ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string2, adminToken);
                    ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
                    Map<String, Cloneable> map = (Map)moduleInstanceTable.remove(string = DNMapper.orgNameToDN(string));
                    if (map != null) {
                        cloneable = new HashMap(map);
                        cloneable.remove(string3);
                        map = cloneable;
                    }
                    cloneable = new HashSet();
                    Map map2 = serviceConfig.getAttributesWithoutDefaults();
                    if (map2 != null && !map2.isEmpty()) {
                        cloneable.add(string3);
                    }
                    if ((set = serviceConfig.getSubConfigNames()) != null) {
                        cloneable.addAll(set);
                    }
                    if (!cloneable.isEmpty()) {
                        if (map == null) {
                            map = new HashMap<String, Cloneable>();
                        }
                        map.put(string3, cloneable);
                    }
                    if (map != null && !map.isEmpty()) {
                        moduleInstanceTable.put(string, map);
                    }
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block12;
                debug.message("build module instance for service error: ", (Throwable)exception);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("return moduleInstanceTable: " + moduleInstanceTable);
        }
    }

    private static String getModuleName(String string) {
        Iterator iterator = moduleServiceNames.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!moduleServiceNames.get(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public AMAuthenticationSchema getAuthenticationSchema(String string) throws AMConfigurationException {
        return AMAuthenticationManager.getAuthenticationSchema(string, this.token);
    }

    private static AMAuthenticationSchema getAuthenticationSchema(String string, SSOToken sSOToken) throws AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("getting auth schema for " + string);
        }
        try {
            String string2 = AMAuthenticationManager.getServiceName(string);
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string2, sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationSchema();
            ServiceSchema serviceSchema2 = serviceSchema.getSubSchema("serverconfig");
            ServiceSchema serviceSchema3 = serviceSchema2 != null ? serviceSchema2 : serviceSchema;
            AMAuthenticationSchema aMAuthenticationSchema = new AMAuthenticationSchema(serviceSchema3);
            return aMAuthenticationSchema;
        }
        catch (Exception exception) {
            throw new AMConfigurationException(exception);
        }
    }

    public AMAuthenticationInstance getAuthenticationInstance(String string) {
        String string2 = this.getAuthInstanceType(string);
        if (string2 == null) {
            return null;
        }
        return this.getAuthenticationInstance(string, string2);
    }

    private AMAuthenticationInstance getAuthenticationInstance(String string, String string2) {
        if (globalModuleNames.contains(string)) {
            return new AMAuthenticationInstance(string, string2, null, null);
        }
        String string3 = AMAuthenticationManager.getServiceName(string2);
        Object var4_4 = null;
        ServiceConfigManager serviceConfigManager = null;
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            serviceSchemaManager = new ServiceSchemaManager(string3, this.token);
        }
        catch (SMSException sMSException) {
            if (debug.messageEnabled()) {
                debug.message("Instance type does not exist: " + string2);
            }
            return null;
        }
        catch (SSOException sSOException) {
            debug.error("SSO token is invalid", (Throwable)sSOException);
            return null;
        }
        Map map = null;
        ServiceSchema serviceSchema = null;
        try {
            serviceSchema = serviceSchemaManager.getSchema(SchemaType.GLOBAL);
            if (serviceSchema != null) {
                map = serviceSchema.getAttributeDefaults();
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        Map map2 = null;
        ServiceConfig serviceConfig = null;
        try {
            serviceConfigManager = new ServiceConfigManager(string3, this.token);
            serviceConfig = serviceConfigManager.getOrganizationConfig(this.realm, null);
            if (serviceConfig != null) {
                if (string.equals(string2)) {
                    map2 = serviceConfig.getAttributesWithoutDefaults();
                } else if ((serviceConfig = serviceConfig.getSubConfig(string)) != null) {
                    map2 = serviceConfig.getAttributes();
                }
            }
        }
        catch (SSOException sSOException) {
            if (debug.warningEnabled()) {
                debug.warning("Token doesn't have access to service: " + this.token + " :: " + string3);
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        if (debug.messageEnabled()) {
            debug.message("global attrs = " + map);
            debug.message("org attrs = ");
            if (map2 != null) {
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((String)entry.getKey()).endsWith("passwd") || ((String)entry.getKey()).endsWith("Passwd") || ((String)entry.getKey()).endsWith("secret")) {
                        debug.message(entry.getKey() + ": " + "<BLOCKED>");
                        continue;
                    }
                    debug.message(entry.getKey() + ": " + entry.getValue());
                }
            }
        }
        if (map != null && !map.isEmpty() || map2 != null && !map2.isEmpty()) {
            return new AMAuthenticationInstance(string, string2, serviceConfig, serviceSchema);
        }
        return null;
    }

    private String getAuthInstanceType(String string) {
        String string2 = null;
        if (globalModuleNames.contains(string)) {
            string2 = string;
        } else {
            Map map = (Map)moduleInstanceTable.get(this.realm);
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    Set set = (Set)map.get(string3);
                    if (!set.contains(string)) continue;
                    string2 = string3;
                    break;
                }
            }
        }
        return string2;
    }

    private Set getRegisteredModuleNames() {
        HashSet hashSet = Collections.EMPTY_SET;
        Map map = (Map)moduleInstanceTable.get(this.realm);
        if (map != null || !globalModuleNames.isEmpty()) {
            hashSet = new HashSet();
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashSet.addAll((Set)map.get(string));
                }
            }
            if (!globalModuleNames.isEmpty()) {
                hashSet.addAll(globalModuleNames);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Registered module names: " + hashSet);
        }
        return hashSet;
    }

    public Set getAllowedModuleNames() {
        Set set = null;
        if (AuthUtils.getAuthRevisionNumber() >= 30) {
            set = this.getRegisteredModuleNames();
        } else {
            Map map = this.orgServiceConfig.getAttributes();
            Set set2 = (Set)map.get("iplanet-am-auth-allowed-modules");
            HashSet hashSet = Collections.EMPTY_SET;
            if (set2 != null && !globalModuleNames.isEmpty()) {
                hashSet = new HashSet();
                hashSet.addAll(globalModuleNames);
                hashSet.addAll(set2);
            }
            set = hashSet;
        }
        if (set != null) {
            set.remove("Application");
        }
        return set;
    }

    private boolean isInheritedAuthInstance(String string) {
        Map map = this.orgServiceConfig.getAttributes();
        Set set = (Set)map.get("iplanet-am-auth-allowed-modules");
        return set != null && set.contains(string);
    }

    private ServiceConfig getOrgServiceConfig() {
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("iPlanetAMAuthService", this.token);
            return serviceConfigManager.getOrganizationConfig(this.realm, null);
        }
        catch (Exception exception) {
            debug.error("Service config for " + this.realm + " is null." + exception.getMessage());
            return null;
        }
    }

    public Set getAuthenticationInstances() {
        HashSet<Object> hashSet = Collections.EMPTY_SET;
        Map map = (Map)moduleInstanceTable.get(this.realm);
        if (map != null || !globalModuleNames.isEmpty()) {
            Object object;
            String string;
            Iterator<Object> iterator;
            hashSet = new HashSet<Object>();
            if (!globalModuleNames.isEmpty()) {
                iterator = globalModuleNames.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (string.equals("Application") || (object = this.getAuthenticationInstance(string, string)) == null) continue;
                    hashSet.add(object);
                }
            }
            if (map != null) {
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    object = (Set)map.get(string);
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        AMAuthenticationInstance aMAuthenticationInstance = this.getAuthenticationInstance(string2, string);
                        if (aMAuthenticationInstance == null) continue;
                        hashSet.add(aMAuthenticationInstance);
                    }
                }
            }
        }
        return hashSet;
    }

    public AMAuthenticationInstance createAuthenticationInstance(String string, String string2, Map map) throws AMConfigurationException {
        Object object;
        if (string.indexOf(32) != -1) {
            throw new AMConfigurationException(bundleName, "invalidAuthenticationInstanceName", null);
        }
        Set set = AMAuthenticationManager.getAuthenticationTypes();
        if (!set.contains(string2)) {
            throw new AMConfigurationException(bundleName, "wrongType", new Object[]{string2});
        }
        AMAuthenticationInstance aMAuthenticationInstance = this.getAuthenticationInstance(string);
        if (aMAuthenticationInstance != null) {
            if (aMAuthenticationInstance.getServiceConfig() != null) {
                throw new AMConfigurationException(bundleName, "authInstanceExist", new Object[]{string});
            }
            throw new AMConfigurationException(bundleName, "authInstanceIsGlobal", new Object[]{string});
        }
        String string3 = AMAuthenticationManager.getServiceName(string2);
        ServiceSchema serviceSchema = null;
        try {
            object = new ServiceSchemaManager(string3, this.token);
            serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.GLOBAL);
        }
        catch (SSOException sSOException) {
            if (debug.warningEnabled()) {
                debug.warning("Token doesn't have access to service: " + this.token + " -> " + string3);
            }
        }
        catch (SMSException sMSException) {
            // empty catch block
        }
        try {
            ServiceConfig serviceConfig;
            object = new OrganizationConfigManager(this.token, this.realm);
            if (!((OrganizationConfigManager)object).getAssignedServices().contains(string3)) {
                ((OrganizationConfigManager)object).assignService(string3, null);
            }
            if ((serviceConfig = ((OrganizationConfigManager)object).getServiceConfig(string3)) == null) {
                serviceConfig = ((OrganizationConfigManager)object).addServiceConfig(string3, null);
            }
            ServiceConfig serviceConfig2 = serviceConfig;
            if (!string.equals(string2)) {
                serviceConfig.addSubConfig(string, "serverconfig", 0, map);
                serviceConfig2 = serviceConfig.getSubConfig(string);
            } else {
                serviceConfig2.setAttributes(map);
            }
            return new AMAuthenticationInstance(string, string2, serviceConfig2, serviceSchema);
        }
        catch (Exception exception) {
            throw new AMConfigurationException(exception);
        }
    }

    public void deleteAuthenticationInstance(String string) throws AMConfigurationException {
        AMAuthenticationInstance aMAuthenticationInstance = this.getAuthenticationInstance(string);
        if (aMAuthenticationInstance == null) {
            throw new AMConfigurationException(bundleName, "authInstanceNotExist", new Object[]{string});
        }
        if (this.isModuleInstanceInUse(string)) {
            throw new AMConfigurationException(bundleName, "authInstanceInUse", new Object[]{string});
        }
        String string2 = this.getAuthInstanceType(string);
        ServiceConfig serviceConfig = aMAuthenticationInstance.getServiceConfig();
        if (serviceConfig == null) {
            throw new AMConfigurationException(bundleName, "authInstanceIsGloal", new Object[]{string2});
        }
        try {
            Object object;
            if (string.equals(string2)) {
                object = serviceConfig.getAttributesWithoutDefaults();
                if (object != null) {
                    serviceConfig.removeAttributes(object.keySet());
                }
            } else {
                object = serviceConfig.getServiceName();
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager((String)object, this.token);
                ServiceConfig serviceConfig2 = serviceConfigManager.getOrganizationConfig(this.realm, null);
                serviceConfig2.removeSubConfig(string);
            }
            if (this.isInheritedAuthInstance(string)) {
                object = new HashSet<String>();
                object.add(string);
                this.orgServiceConfig.removeAttributeValues("iplanet-am-auth-allowed-modules", (Set)object);
            }
        }
        catch (Exception exception) {
            throw new AMConfigurationException(exception);
        }
    }

    public boolean isEditable(AMAuthenticationInstance aMAuthenticationInstance) {
        return true;
    }

    private static String getServiceName(String string) {
        return (String)moduleServiceNames.get(string);
    }

    private boolean isModuleInstanceInUse(String string) {
        Object object;
        Object object2;
        boolean bl;
        Set set;
        block6: {
            set = Collections.EMPTY_SET;
            bl = false;
            try {
                ServiceConfig serviceConfig;
                object2 = new ServiceConfigManager("iPlanetAMAuthConfiguration", this.token);
                object = ((ServiceConfigManager)object2).getOrganizationConfig(this.realm, null);
                if (object != null && (serviceConfig = ((ServiceConfig)object).getSubConfig("Configurations")) != null) {
                    set = serviceConfig.getSubConfigNames("*");
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block6;
                debug.message("Failed to get named sub configurations.");
            }
        }
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (debug.messageEnabled()) {
                debug.message("Checking " + (String)object + " ...");
            }
            if (!this.serviceContains((String)object, string)) continue;
            if (debug.messageEnabled()) {
                debug.message(string + " is used in " + (String)object);
            }
            bl = true;
            break;
        }
        return bl;
    }

    private boolean serviceContains(String string, String string2) {
        Set set;
        Map map;
        boolean bl;
        block7: {
            bl = false;
            map = null;
            if (string != null) {
                try {
                    map = AMAuthConfigUtils.getNamedConfig(string, this.realm, this.token);
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block7;
                    debug.message("Failed to get named sub config attrs.");
                }
            }
        }
        if (map != null && (set = (Set)map.get("iplanet-am-auth-configuration")) != null && !set.isEmpty()) {
            Document document;
            String string3 = (String)set.iterator().next();
            if (debug.messageEnabled()) {
                debug.message("service config for " + string + "  = " + string3);
            }
            if (string3 != null && string3.length() != 0 && (document = XMLUtils.toDOMDocument((String)string3, (Debug)debug)) != null) {
                Element element = document.getDocumentElement();
                Set set2 = XMLUtils.getAttributeValuePair((Node)element);
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (!string4.startsWith(string2)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    static {
        adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        authTypes = new HashSet();
        moduleServiceNames = new HashMap();
        bundleName = "amAuthConfig";
        debug = Debug.getInstance((String)bundleName);
        moduleInstanceTable = new Hashtable();
        globalModuleNames = Collections.EMPTY_SET;
        AMAuthenticationManager.initAuthenticationService(adminToken);
    }
}

