/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.L10NMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthContext
implements Serializable {
    private static String server_proto = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    private static String server_host = SystemProperties.get((String)"com.iplanet.am.server.host");
    private static String server_port = SystemProperties.get((String)"com.iplanet.am.server.port");
    private static final String amAuthContext = "amAuthContext";
    private static final String JSS_PASSWORD_UTIL = "com.sun.identity.authentication.util.JSSPasswordUtil";
    private static final String JSSE_PASSWORD_CALLBACK = "com.sun.identity.security.keystore.AMCallbackHandler";
    static String protHandlerPkg = System.getProperty("java.protocol.handler.pkgs", "com.sun.identity.protocol");
    static boolean usingJSSEHandler = protHandlerPkg.equals("com.sun.identity.protocol");
    protected static Debug authDebug = Debug.getInstance((String)"amAuthContext");
    protected static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amAuthContext");
    Status loginStatus = Status.IN_PROGRESS;
    String organizationName = "";
    Document receivedDocument;
    AuthLoginException loginException = null;
    String hostName = "";
    String nickName = null;
    private URL authURL = null;
    private URL authServiceURL = null;
    private SSOToken ssoToken = null;
    private String ssoTokenID = null;
    AuthContextLocal acLocal = null;
    public boolean localFlag = false;
    public static String localAuthServiceID;
    static boolean useOldStyleRemoteAuthentication;
    static boolean useNewStyleRemoteAuthentication;
    private HashMap cookieTable = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public AuthContext(String string) throws AuthLoginException {
        this.organizationName = string;
    }

    public AuthContext(String string, URL uRL) throws AuthLoginException {
        this.organizationName = string;
        this.authURL = uRL;
    }

    public AuthContext(String string, String string2) throws AuthLoginException {
        this.organizationName = string;
        this.nickName = string2;
    }

    public AuthContext(String string, String string2, URL uRL) throws AuthLoginException {
        this.organizationName = string;
        this.nickName = string2;
        this.authURL = uRL;
    }

    public AuthContext(SSOToken sSOToken) throws AuthLoginException {
        this.ssoToken = sSOToken;
    }

    public void login() throws AuthLoginException {
        this.login(null, null, null, false);
    }

    public void login(IndexType indexType, String string) throws AuthLoginException {
        this.login(indexType, string, null, false);
    }

    public void login(IndexType indexType, String string, boolean bl) throws AuthLoginException {
        this.login(indexType, string, null, bl);
    }

    public SSOToken login(IndexType indexType, String string, Callback[] callbackArray) throws AuthLoginException {
        this.login(indexType, string, null, false);
        SSOToken sSOToken = null;
        Callback[] callbackArray2 = null;
        while (this.hasMoreRequirements()) {
            callbackArray2 = this.getRequirements();
            if (callbackArray2 == null) continue;
            try {
                this.submitRequirements(callbackArray);
            }
            catch (Exception exception) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("Error: submitRequirements with userInfo : " + exception.getMessage());
                }
                throw new AuthLoginException(exception);
            }
        }
        try {
            if (this.getStatus() == Status.SUCCESS) {
                sSOToken = this.getSSOToken();
            }
        }
        catch (Exception exception) {
            if (authDebug.messageEnabled()) {
                authDebug.message("Error: getSSOToken : " + exception.getMessage());
            }
            throw new AuthLoginException(exception);
        }
        return sSOToken;
    }

    public void login(IndexType indexType, String string, String[] stringArray) throws AuthLoginException {
        this.login(indexType, string, stringArray, false);
    }

    private void login(IndexType indexType, String string, String[] stringArray, boolean bl) throws AuthLoginException {
        if (this.ssoToken != null) {
            try {
                this.organizationName = this.ssoToken.getProperty("Organization");
                this.ssoTokenID = this.ssoToken.getTokenID().toString();
                this.authURL = Session.getSession((SessionID)new SessionID(this.ssoTokenID)).getSessionServiceURL();
            }
            catch (Exception exception) {
                throw new AuthLoginException(exception);
            }
        }
        if (this.authURL != null) {
            this.authServiceURL = AuthContext.getAuthServiceURL(this.authURL.getProtocol(), this.authURL.getHost(), Integer.toString(this.authURL.getPort()));
        }
        AuthLoginException authLoginException = null;
        try {
            if (this.authServiceURL == null) {
                this.authServiceURL = AuthContext.getAuthServiceURL(server_proto, server_host, server_port);
            }
            if (this.authServiceURL != null) {
                this.runLogin(indexType, string, stringArray, bl);
                return;
            }
        }
        catch (AuthLoginException authLoginException2) {
            authLoginException = authLoginException2;
            authDebug.error("Failed to login to " + this.authServiceURL);
        }
        catch (Exception exception) {
            authDebug.error("Failed to login to " + this.authServiceURL + ": " + exception.getMessage());
        }
        if (this.authURL == null) {
            Vector vector = null;
            try {
                vector = WebtopNaming.getServiceAllURLs((String)"auth");
            }
            catch (Exception exception) {
                throw new AuthLoginException(amAuthContext, "loginError", new Object[]{exception.getMessage()});
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Org Name : " + this.organizationName);
                authDebug.message("ssoTokenID: " + this.ssoTokenID);
                authDebug.message("serviceURLs: " + vector);
            }
            if (vector != null) {
                vector.remove(this.authServiceURL);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.authServiceURL = (URL)enumeration.nextElement();
                    try {
                        this.runLogin(indexType, string, stringArray, bl);
                        return;
                    }
                    catch (AuthLoginException authLoginException3) {
                        authLoginException = authLoginException3;
                        authDebug.error("Failed to login in failover with " + this.authServiceURL + ": " + authLoginException3.getMessage());
                    }
                }
            }
        }
        authDebug.error("Authentication failed.");
        if (authLoginException != null) {
            throw authLoginException;
        }
        throw new AuthLoginException(amAuthContext, "loginError", null);
    }

    private void runLogin(IndexType indexType, String string, String[] stringArray, boolean bl) throws AuthLoginException {
        if (!this.localFlag) {
            this.setLocalFlag(this.authServiceURL);
        }
        if (this.localFlag) {
            try {
                this.acLocal = this.ssoTokenID == null ? AuthUtils.getAuthContext(this.organizationName) : AuthUtils.getAuthContext(this.organizationName, this.ssoTokenID);
                this.acLocal.login(indexType, string, bl);
            }
            catch (AuthException authException) {
                throw new AuthLoginException((Throwable)((Object)authException));
            }
            return;
        }
        if (useOldStyleRemoteAuthentication) {
            this.runRemoteOldAuthContext();
            if (this.loginException != null) {
                throw this.loginException;
            }
        }
        this.runRemoteLogin(indexType, string, stringArray, bl);
        if (authDebug.messageEnabled()) {
            authDebug.message("useNewStyleRemoteAuthentication : " + useNewStyleRemoteAuthentication);
            authDebug.message("useOldStyleRemoteAuthentication : " + useOldStyleRemoteAuthentication);
            authDebug.message("receivedDocument : " + this.receivedDocument);
            authDebug.message("loginException : " + this.loginException);
        }
        if (!(useNewStyleRemoteAuthentication || useOldStyleRemoteAuthentication || this.receivedDocument != null && !this.getAuthenticationHandle(this.receivedDocument).equals("null") || this.loginException == null)) {
            if (authDebug.messageEnabled()) {
                authDebug.message("AuthContext: trying 6.3 style remote AuthN and setting the flag to use 6.3 style");
            }
            useOldStyleRemoteAuthentication = true;
            this.loginException = null;
            this.runRemoteOldAuthContext();
            if (this.loginException != null) {
                throw this.loginException;
            }
            this.runRemoteLogin(indexType, string, stringArray, bl);
        } else if (!useNewStyleRemoteAuthentication) {
            useNewStyleRemoteAuthentication = true;
        }
        if (this.loginException != null) {
            throw this.loginException;
        }
    }

    private void runRemoteLogin(IndexType indexType, String string, String[] stringArray, boolean bl) throws AuthLoginException {
        try {
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthHandle()};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<Login");
            if (((String)objectArray[0]).equals("0")) {
                stringBuffer.append(" ").append("orgName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.organizationName)).append("\"");
            }
            stringBuffer.append(">");
            if (indexType != null) {
                stringBuffer.append("<IndexTypeNamePair").append(" ").append("indexType").append("=").append("\"");
                if (indexType == IndexType.USER) {
                    stringBuffer.append("user");
                } else if (indexType == IndexType.ROLE) {
                    stringBuffer.append("role");
                } else if (indexType == IndexType.SERVICE) {
                    stringBuffer.append("service");
                } else if (indexType == IndexType.MODULE_INSTANCE) {
                    stringBuffer.append("moduleInstance");
                } else if (indexType == IndexType.LEVEL) {
                    stringBuffer.append("authLevel");
                } else if (indexType == IndexType.COMPOSITE_ADVICE) {
                    stringBuffer.append("compositeAdvice");
                }
                stringBuffer.append("\"").append(">").append("<IndexName>").append(string).append("</IndexName>").append("</IndexTypeNamePair>");
            }
            if (stringArray != null) {
                StringBuffer stringBuffer2 = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    if (n != 0) {
                        stringBuffer2.append("|");
                    }
                    stringBuffer2.append(stringArray[n]);
                    ++n;
                }
                stringBuffer.append("<Params>").append(stringBuffer2.toString()).append("</Params>");
            }
            stringBuffer.append("</Login>").append("</Request></AuthContext>");
            string2 = stringBuffer.toString();
            this.receivedDocument = this.processRequest(string2);
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    private void runRemoteOldAuthContext() throws AuthLoginException {
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{"0"};
            if (this.ssoTokenID != null) {
                objectArray[0] = this.ssoTokenID;
            }
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<NewAuthContext").append(" ").append("orgName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.organizationName)).append("\"").append(">").append("</NewAuthContext>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public Subject getSubject() {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.SUCCESS)) {
                return null;
            }
            return this.acLocal.getSubject();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            return null;
        }
        return AuthContext.getSubject(this.receivedDocument);
    }

    public boolean hasMoreRequirements() {
        if (this.localFlag) {
            return this.acLocal.hasMoreRequirements(false);
        }
        return this.loginStatus.equals(Status.IN_PROGRESS) && AuthContext.getCallbacks(this.receivedDocument, false) != null;
    }

    public boolean hasMoreRequirements(boolean bl) {
        if (this.localFlag) {
            return this.acLocal.hasMoreRequirements(bl);
        }
        return this.loginStatus.equals(Status.IN_PROGRESS) && AuthContext.getCallbacks(this.receivedDocument, bl) != null;
    }

    public Callback[] getRequirements() {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.IN_PROGRESS)) {
                return null;
            }
            return this.acLocal.getRequirements(false);
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return null;
        }
        return AuthContext.getCallbacks(this.receivedDocument, false);
    }

    public Callback[] getRequirements(boolean bl) {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.IN_PROGRESS)) {
                return null;
            }
            return this.acLocal.getRequirements(bl);
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return null;
        }
        return AuthContext.getCallbacks(this.receivedDocument, bl);
    }

    public void submitRequirements(Callback[] callbackArray) {
        if (authDebug.messageEnabled()) {
            authDebug.message("submitRequirements with Callbacks : " + callbackArray);
        }
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.IN_PROGRESS)) {
                return;
            }
            this.acLocal.submitRequirements(callbackArray);
            return;
        }
        if (!this.loginStatus.equals(Status.IN_PROGRESS)) {
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<SubmitRequirements>").append(AuthXMLUtils.getXMLForCallbacks(callbackArray)).append("</SubmitRequirements>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public void logout() throws AuthLoginException {
        if (this.localFlag) {
            this.acLocal.logout();
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<Logout>").append("</Logout>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public AuthLoginException getLoginException() {
        if (this.localFlag) {
            return this.acLocal.getLoginException();
        }
        return this.loginException;
    }

    public SSOToken getSSOToken() throws Exception {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.SUCCESS)) {
                throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
            }
            return this.acLocal.getSSOToken();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
        }
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (node == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"ssoToken");
        try {
            return SSOTokenManager.getInstance().createSSOToken(string);
        }
        catch (SSOException sSOException) {
            sSOException.printStackTrace();
            throw new L10NMessageImpl(amAuthContext, "createSSOTokenError", null);
        }
    }

    public Status getStatus() {
        if (this.localFlag) {
            return this.acLocal.getStatus();
        }
        return this.loginStatus;
    }

    public String getAuthIdentifier() {
        if (this.localFlag) {
            return this.acLocal.getAuthIdentifier();
        }
        return this.getAuthHandle();
    }

    public String getSuccessURL() throws Exception {
        if (this.localFlag) {
            if (!this.acLocal.getStatus().equals(Status.SUCCESS)) {
                throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
            }
            return this.acLocal.getSuccessURL();
        }
        if (!this.loginStatus.equals(Status.SUCCESS)) {
            throw new L10NMessageImpl(amAuthContext, "statusNotSuccess", null);
        }
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (node == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        return XMLUtils.getNodeAttributeValue((Node)node, (String)"successURL");
    }

    public String getFailureURL() throws Exception {
        if (this.localFlag) {
            return this.acLocal.getFailureURL();
        }
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (node == null) {
            throw new L10NMessageImpl(amAuthContext, "noStatusNode", null);
        }
        return XMLUtils.getNodeAttributeValue((Node)node, (String)"failureURL");
    }

    public void reset() {
        this.loginStatus = Status.NOT_STARTED;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Set getModuleInstanceNames() {
        if (this.authURL != null) {
            this.authServiceURL = AuthContext.getAuthServiceURL(this.authURL.getProtocol(), this.authURL.getHost(), Integer.toString(this.authURL.getPort()));
        }
        if (!this.localFlag) {
            this.setLocalFlag(this.authServiceURL);
        }
        if (this.localFlag) {
            return this.acLocal.getModuleInstanceNames();
        }
        if (this.authServiceURL == null) {
            try {
                this.authServiceURL = AuthContext.getAuthServiceURL(server_proto, server_host, server_port);
            }
            catch (Exception exception) {
                return Collections.EMPTY_SET;
            }
        }
        this.sendQueryInformation("moduleInstanceNames");
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"QueryResult");
        if (node == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                String string = XMLUtils.getValueOfValueNode((Node)node2);
                hashSet.add(string);
                ++n;
            }
        }
        return hashSet;
    }

    public void abort() throws AuthLoginException {
        if (this.localFlag) {
            this.acLocal.abort();
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthenticationHandle(this.receivedDocument)};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<Abort>").append("</Abort>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    public static void setCertDBPassword(String string) {
        try {
            if (usingJSSEHandler) {
                Class<?> clazz = Class.forName(JSSE_PASSWORD_CALLBACK);
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("setPassword", class$java$lang$String == null ? (class$java$lang$String = AuthContext.class$("java.lang.String")) : class$java$lang$String);
                KeyStore keyStore = (KeyStore)method.invoke(obj, string);
            } else {
                Class<?> clazz = Class.forName(JSS_PASSWORD_UTIL);
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AuthContext.class$("java.lang.String")) : class$java$lang$String);
                constructor.newInstance(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            authDebug.message("Error in setCertDBPassword : " + exception.getMessage());
        }
    }

    public String getErrorTemplate() {
        if (this.localFlag) {
            return this.acLocal.getErrorTemplate();
        }
        String string = "";
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (node != null) {
            string = XMLUtils.getNodeAttributeValue((Node)node, (String)"templateName");
        }
        return string;
    }

    public String getErrorMessage() {
        if (this.localFlag) {
            return this.acLocal.getErrorMessage();
        }
        String string = null;
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (node != null) {
            string = XMLUtils.getNodeAttributeValue((Node)node, (String)"message");
        }
        return string;
    }

    public String getErrorCode() {
        if (this.localFlag) {
            return this.acLocal.getErrorCode();
        }
        String string = "";
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"Exception");
        if (node != null) {
            string = XMLUtils.getNodeAttributeValue((Node)node, (String)"errorCode");
        }
        return string;
    }

    public void setClientHostName(String string) {
        this.hostName = string;
    }

    public String getClientHostName() {
        return this.hostName;
    }

    private AuthLoginException checkException() {
        AuthLoginException authLoginException = null;
        String string = this.getErrorCode();
        if (string != null && string.length() != 0) {
            authLoginException = new AuthLoginException("amAuth", string, null);
        } else {
            string = this.getErrorMessage();
            if (string != null && string.length() != 0) {
                authLoginException = new AuthLoginException(string);
            }
        }
        return authLoginException;
    }

    protected void checkAndSetLoginStatus() {
        Node node = XMLUtils.getRootNode((Document)this.receivedDocument, (String)"LoginStatus");
        if (node == null) {
            this.loginException = this.checkException();
        } else {
            String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"status");
            if (string != null) {
                if (string.equals("success")) {
                    this.loginStatus = Status.SUCCESS;
                } else if (string.equals("failed")) {
                    this.loginStatus = Status.FAILED;
                    this.loginException = this.checkException();
                } else if (string.equals("completed")) {
                    this.loginStatus = Status.COMPLETED;
                } else if (string.equals("in_progress")) {
                    this.loginStatus = Status.IN_PROGRESS;
                }
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("LoginStatus : " + this.loginStatus);
            }
        }
    }

    protected void sendQueryInformation(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            Object[] objectArray = new String[]{this.getAuthHandle()};
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Request authIdentifier=\"{0}\">", objectArray)).append("<QueryInformation").append(" ").append("requestedInformation").append("=").append("\"").append(string).append("\"");
            if (((String)objectArray[0]).equals("0")) {
                stringBuffer.append(" ").append("orgName").append("=").append("\"").append(XMLUtils.escapeSpecialCharacters((String)this.organizationName)).append("\"");
            }
            stringBuffer.append(">").append("</QueryInformation>").append("</Request></AuthContext>");
            this.receivedDocument = this.processRequest(stringBuffer.toString());
            this.checkAndSetLoginStatus();
        }
        catch (AuthLoginException authLoginException) {
            this.loginStatus = Status.FAILED;
            this.loginException = authLoginException;
        }
    }

    private void setLocalFlag(URL uRL) {
        try {
            String string = uRL.getProtocol() + "://" + uRL.getHost() + ":" + Integer.toString(uRL.getPort());
            if (authDebug.messageEnabled()) {
                authDebug.message("in setLocalFlag(), url : " + string);
                authDebug.message("AuthContext.localAuthServiceID : " + localAuthServiceID);
            }
            if (localAuthServiceID != null && string.equalsIgnoreCase(localAuthServiceID)) {
                this.localFlag = true;
            }
        }
        catch (Exception exception) {
            authDebug.error("AuthContext::setLocalFlag:: " + exception);
        }
    }

    protected Document processRequest(String string) throws AuthLoginException {
        Document document = null;
        try {
            String string2;
            Response response;
            Class[] classArray;
            Request request = new Request(string);
            RequestSet requestSet = new RequestSet("auth");
            requestSet.addRequest(request);
            URL uRL = this.authServiceURL;
            if (uRL.getProtocol().equals("https") && this.nickName != null) {
                classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AuthContext.class$("java.lang.String")) : class$java$lang$String};
                response = new Response[]{this.nickName};
                string2 = protHandlerPkg + ".https.Handler";
                Constructor<?> constructor = Class.forName(string2).getConstructor(classArray);
                URLStreamHandler uRLStreamHandler = (URLStreamHandler)constructor.newInstance((Object[])response);
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile(), uRLStreamHandler);
            }
            if (authDebug.messageEnabled()) {
                authDebug.message("Service URL : " + uRL.toString());
            }
            if ((classArray = PLLClient.send((URL)uRL, (RequestSet)requestSet, (HashMap)this.cookieTable)).isEmpty() || classArray.size() != 1) {
                throw new L10NMessageImpl(amAuthContext, "responseError", null);
            }
            response = (Response)classArray.elementAt(0);
            string2 = response.getContent();
            if (authDebug.messageEnabled()) {
                authDebug.message("Received XML data : " + string2);
            }
            document = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string2.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            authDebug.message("error in getting service url : " + exception.getMessage(), (Throwable)exception);
            throw new AuthLoginException(amAuthContext, "xmlProcessError", null, exception);
        }
        return document;
    }

    protected static void checkForException(Document document) throws AuthLoginException {
        Node node = XMLUtils.getRootNode((Document)document, (String)"Exception");
        if (node != null) {
            throw new AuthLoginException(XMLUtils.getNodeAttributeValue((Node)node, (String)"message"));
        }
    }

    protected String getAuthenticationHandle(Document document) throws AuthLoginException {
        Node node = XMLUtils.getRootNode((Document)document, (String)"Response");
        if (node == null) {
            throw new AuthLoginException(amAuthContext, "responseError", null);
        }
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"authIdentifier");
        return string;
    }

    protected static Callback[] getCallbacks(Document document, boolean bl) {
        return AuthXMLUtils.getCallbacks(XMLUtils.getRootNode((Document)document, (String)"Callbacks"), bl);
    }

    protected static Subject getSubject(Document document) {
        Node node = XMLUtils.getRootNode((Document)document, (String)"LoginStatus");
        if (node == null) {
            return null;
        }
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Subject");
        if (node2 == null) {
            return null;
        }
        String string = XMLUtils.getValueOfValueNode((Node)node2);
        try {
            Subject subject = AuthXMLUtils.getDeSerializedSubject(string);
            if (authDebug.messageEnabled()) {
                authDebug.message("Deserialized subject : " + subject.toString());
            }
            return subject;
        }
        catch (Exception exception) {
            authDebug.message("get Deserialized subject error : ", (Throwable)exception);
            return null;
        }
    }

    protected static String getXMLforSubject(Subject subject) {
        if (subject == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<Subject>");
        String string = AuthXMLUtils.getSerializedSubject(subject);
        stringBuffer.append(string);
        stringBuffer.append("</Subject>");
        return stringBuffer.toString();
    }

    public String getLockoutMsg() {
        String string = null;
        if (this.localFlag) {
            string = this.acLocal.getLockoutMsg();
        }
        return string;
    }

    public boolean isLockedOut() {
        boolean bl = false;
        if (this.localFlag) {
            bl = this.acLocal.isLockedOut();
        }
        return bl;
    }

    private String getAuthHandle() {
        String string = null;
        if (this.receivedDocument != null) {
            try {
                string = this.getAuthenticationHandle(this.receivedDocument);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "0";
        }
        return string;
    }

    private static URL getAuthServiceURL(String string, String string2, String string3) {
        URL uRL = null;
        try {
            uRL = WebtopNaming.getServiceURL((String)"auth", (String)string, (String)string2, (String)string3);
        }
        catch (Exception exception) {
            authDebug.error("Failed to obtain auth service url from server: " + string + "://" + string2 + ":" + string3);
        }
        return uRL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IndexType {
        private String index;
        public static final IndexType USER = new IndexType("user");
        public static final IndexType ROLE = new IndexType("role");
        public static final IndexType SERVICE = new IndexType("service");
        public static final IndexType LEVEL = new IndexType("level");
        public static final IndexType MODULE_INSTANCE = new IndexType("module_instance");
        public static final IndexType COMPOSITE_ADVICE = new IndexType("composite_advice");

        private IndexType() {
        }

        private IndexType(String string) {
            this.index = string;
        }

        public String toString() {
            return this.index;
        }

        public boolean equals(Object object) {
            if (object instanceof IndexType) {
                IndexType indexType = (IndexType)object;
                return indexType.index.equalsIgnoreCase(this.index);
            }
            return false;
        }
    }

    public static class Status {
        private String status;
        public static final Status NOT_STARTED = new Status("not_started");
        public static final Status IN_PROGRESS = new Status("in_progress");
        public static final Status SUCCESS = new Status("success");
        public static final Status FAILED = new Status("failed");
        public static final Status COMPLETED = new Status("completed");
        public static final Status RESET = new Status("reset");
        public static final Status ORG_MISMATCH = new Status("org_mismatch");

        private Status() {
        }

        private Status(String string) {
            this.status = string;
        }

        public String toString() {
            return this.status;
        }

        public boolean equals(Object object) {
            if (object instanceof Status) {
                Status status = (Status)object;
                return status.status.equalsIgnoreCase(this.status);
            }
            return false;
        }
    }
}

