/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.BaseSearchEnum;
import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.SearchResultWithControls;
import com.netscape.jndi.ldap.controls.NetscapeControlFactory;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;

class SearchResultEnum
extends BaseSearchEnum {
    boolean m_returnObjs;
    String[] m_userBinaryAttrs;

    public SearchResultEnum(LDAPSearchResults lDAPSearchResults, boolean bl, LdapContextImpl ldapContextImpl) throws NamingException {
        super(lDAPSearchResults, ldapContextImpl);
        this.m_returnObjs = bl;
        this.m_userBinaryAttrs = ldapContextImpl.m_ctxEnv.getUserDefBinaryAttrs();
    }

    public Object next() throws NamingException {
        LDAPEntry lDAPEntry = this.nextLDAPEntry();
        String string = LdapNameParser.getRelativeName(this.m_ctxName, lDAPEntry.getDN());
        Object object = this.m_returnObjs ? ObjectMapper.entryToObject(lDAPEntry, this.m_ctx) : null;
        AttributesImpl attributesImpl = new AttributesImpl(lDAPEntry.getAttributeSet(), this.m_userBinaryAttrs);
        LDAPControl[] lDAPControlArray = this.m_res.getResponseControls();
        if (lDAPControlArray != null) {
            Control[] controlArray = new Control[lDAPControlArray.length];
            int n = 0;
            while (n < lDAPControlArray.length) {
                controlArray[n] = NetscapeControlFactory.getControlInstance(lDAPControlArray[n]);
                if (controlArray[n] == null) {
                    throw new NamingException("Unsupported control " + lDAPControlArray[n].getID());
                }
                ++n;
            }
            SearchResultWithControls searchResultWithControls = new SearchResultWithControls(string, object, attributesImpl);
            searchResultWithControls.setControls(controlArray);
            return searchResultWithControls;
        }
        return new SearchResult(string, object, attributesImpl);
    }
}

