/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.LdapService;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.ProviderUtils;
import com.netscape.jndi.ldap.common.Debug;
import com.netscape.jndi.ldap.common.ExceptionMapper;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;

class EventService
implements Runnable {
    LdapService m_ldapSvc;
    Vector m_eventList = new Vector();
    Thread m_monitorThread;
    LDAPSearchListener m_msgQueue;

    public EventService(LdapService ldapService) {
        this.m_ldapSvc = ldapService;
    }

    private void abandonRequest(int n) {
        LDAPConnection lDAPConnection = this.m_ldapSvc.getConnection();
        try {
            lDAPConnection.abandon(n);
        }
        catch (LDAPException lDAPException) {}
    }

    synchronized void addListener(LdapContextImpl ldapContextImpl, String string, String string2, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        Object object;
        EventEntry eventEntry = null;
        LDAPSearchListener lDAPSearchListener = null;
        Debug.println(1, "ADD LISTENER");
        String string3 = ldapContextImpl.getDN();
        if (string.length() > 0) {
            string3 = string3.length() > 0 ? String.valueOf(string) + "," + string3 : string;
        }
        LDAPConnection lDAPConnection = (LDAPConnection)this.m_ldapSvc.getConnection().clone();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        LDAPPersistSearchControl lDAPPersistSearchControl = this.createSrchCtrl(namingListener);
        lDAPSearchConstraints.setServerControls((LDAPControl)lDAPPersistSearchControl);
        boolean bl = searchControls.getReturningObjFlag();
        String[] stringArray = new String[]{"javaclassname"};
        int n = ProviderUtils.jndiSearchScopeToLdap(searchControls.getSearchScope());
        int n2 = 0;
        while (n2 < this.m_eventList.size()) {
            object = (EventEntry)this.m_eventList.elementAt(n2);
            if (((EventEntry)object).isEqualEvent(string3, n, string2, stringArray, lDAPSearchConstraints)) {
                eventEntry = object;
                break;
            }
            ++n2;
        }
        if (eventEntry == null) {
            try {
                Debug.println(1, "Do persistent search for " + string3);
                lDAPSearchListener = lDAPConnection.search(string3, n, string2, stringArray, false, null, lDAPSearchConstraints);
                object = lDAPSearchListener.getMessageIDs();
                Object object2 = object[((Object)object).length - 1];
                eventEntry = new EventEntry((int)object2, ldapContextImpl, string3, n, string2, stringArray, lDAPSearchConstraints);
                this.m_eventList.addElement(eventEntry);
            }
            catch (Exception exception) {
                throw ExceptionMapper.getNamingException(exception);
            }
        }
        eventEntry.addListener(namingListener);
        if (this.m_msgQueue == null) {
            this.m_msgQueue = lDAPSearchListener;
        } else {
            this.m_msgQueue.merge(lDAPSearchListener);
        }
        if (this.m_monitorThread == null) {
            this.m_monitorThread = new Thread((Runnable)this, "EventService");
            this.m_monitorThread.setDaemon(true);
            this.m_monitorThread.start();
        }
    }

    private NamingEvent createNamingEvent(LdapContextImpl ldapContextImpl, LDAPEntry lDAPEntry, LDAPEntryChangeControl lDAPEntryChangeControl) throws NamingException {
        Binding binding = null;
        Binding binding2 = null;
        int n = -1;
        Integer n2 = null;
        String string = null;
        String string2 = null;
        String string3 = ObjectMapper.getClassName(lDAPEntry);
        int n3 = lDAPEntryChangeControl.getChangeType();
        switch (n3) {
            case 1: {
                n = 0;
                string2 = LdapNameParser.getRelativeName(ldapContextImpl.m_ctxDN, lDAPEntry.getDN());
                break;
            }
            case 2: {
                n = 1;
                string = LdapNameParser.getRelativeName(ldapContextImpl.m_ctxDN, lDAPEntry.getDN());
                break;
            }
            case 4: {
                n = 3;
                string = string2 = LdapNameParser.getRelativeName(ldapContextImpl.m_ctxDN, lDAPEntry.getDN());
                break;
            }
            case 8: {
                n = 2;
                String string4 = lDAPEntryChangeControl.getPreviousDN();
                if (string4 != null) {
                    string = LdapNameParser.getRelativeName(ldapContextImpl.m_ctxDN, string4);
                }
                try {
                    string2 = LdapNameParser.getRelativeName(ldapContextImpl.m_ctxDN, lDAPEntry.getDN());
                }
                catch (NamingException namingException) {}
                break;
            }
        }
        n2 = new Integer(lDAPEntryChangeControl.getChangeNumber());
        if (string != null) {
            binding = new Binding(string, string3, null, true);
        }
        if (string2 != null) {
            binding2 = new Binding(string2, string3, null, true);
        }
        return new NamingEvent(ldapContextImpl, n, binding2, binding, n2);
    }

    private LDAPPersistSearchControl createSrchCtrl(NamingListener namingListener) throws NamingException {
        int n = 0;
        if (namingListener instanceof ObjectChangeListener) {
            n = 4;
        }
        if (namingListener instanceof NamespaceChangeListener) {
            n |= 0xB;
        }
        if (n == 0) {
            throw new NamingException("Non supported listener type " + namingListener.getClass().getName());
        }
        return new LDAPPersistSearchControl(n, true, true, true);
    }

    private void dispatchEvent(EventObject eventObject, EventEntry eventEntry) {
        NamingListener[] namingListenerArray = null;
        EventEntry eventEntry2 = eventEntry;
        synchronized (eventEntry2) {
            namingListenerArray = new NamingListener[eventEntry.listeners.size()];
            int n = 0;
            while (n < namingListenerArray.length) {
                namingListenerArray[n] = (NamingListener)eventEntry.listeners.elementAt(n);
                ++n;
            }
        }
        int n = 0;
        while (n < namingListenerArray.length) {
            if (eventObject instanceof NamingEvent) {
                ((NamingEvent)eventObject).dispatch(namingListenerArray[n]);
            } else {
                ((NamingExceptionEvent)eventObject).dispatch(namingListenerArray[n]);
            }
            ++n;
        }
    }

    private EventEntry getEventEntry(int n) {
        int n2 = 0;
        while (n2 < this.m_eventList.size()) {
            EventEntry eventEntry = (EventEntry)this.m_eventList.elementAt(n2);
            if (eventEntry.id == n) {
                return eventEntry;
            }
            ++n2;
        }
        return null;
    }

    private void processNetworkError(LDAPException lDAPException) {
        NamingException namingException = ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        int n = 0;
        while (n < this.m_eventList.size()) {
            EventEntry eventEntry = (EventEntry)this.m_eventList.elementAt(n);
            this.dispatchEvent(new NamingExceptionEvent(eventEntry.ctx, namingException), eventEntry);
            ++n;
        }
    }

    private void processResponseMsg(LDAPResponse lDAPResponse, EventEntry eventEntry) {
        if (lDAPResponse.getResultCode() == 0) {
            return;
        }
        if (lDAPResponse.getResultCode() == 10) {
            return;
        }
        LDAPException lDAPException = new LDAPException("error result", lDAPResponse.getResultCode(), lDAPResponse.getErrorMessage(), lDAPResponse.getMatchedDN());
        NamingException namingException = ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        this.dispatchEvent(new NamingExceptionEvent(eventEntry.ctx, namingException), eventEntry);
    }

    private void processSearchResultMsg(LDAPSearchResult lDAPSearchResult, EventEntry eventEntry) {
        LDAPEntry lDAPEntry = lDAPSearchResult.getEntry();
        Debug.println(1, "Changed " + lDAPEntry.getDN());
        LDAPControl[] lDAPControlArray = lDAPSearchResult.getControls();
        if (lDAPControlArray == null) {
            NamingException namingException = new NamingException("Can not create NamingEvent, no change control info");
            this.dispatchEvent(new NamingExceptionEvent(eventEntry.ctx, namingException), eventEntry);
        }
        int n = 0;
        while (n < lDAPControlArray.length) {
            LDAPEntryChangeControl lDAPEntryChangeControl = null;
            if (lDAPControlArray[n] instanceof LDAPEntryChangeControl) {
                Serializable serializable;
                lDAPEntryChangeControl = (LDAPEntryChangeControl)lDAPControlArray[n];
                if (lDAPEntryChangeControl.getChangeType() == -1) {
                    serializable = new NamingException("Can not create NamingEvent, no change control info");
                    this.dispatchEvent(new NamingExceptionEvent(eventEntry.ctx, (NamingException)serializable), eventEntry);
                }
                try {
                    serializable = this.createNamingEvent(eventEntry.ctx, lDAPEntry, lDAPEntryChangeControl);
                    this.dispatchEvent((EventObject)serializable, eventEntry);
                }
                catch (NamingException namingException) {
                    this.dispatchEvent(new NamingExceptionEvent(eventEntry.ctx, namingException), eventEntry);
                }
            }
            ++n;
        }
    }

    private void processSearchResultRef(LDAPSearchResultReference lDAPSearchResultReference, EventEntry eventEntry) {
    }

    synchronized void removeListener(NamingListener namingListener) throws NamingException {
        boolean bl = false;
        int n = this.m_eventList.size() - 1;
        while (n >= 0) {
            EventEntry eventEntry = (EventEntry)this.m_eventList.elementAt(n);
            if (eventEntry.removeListener(namingListener)) {
                bl = true;
                if (eventEntry.isEmpty()) {
                    this.abandonRequest(eventEntry.id);
                    this.m_eventList.removeElement(eventEntry);
                }
            }
            --n;
        }
        if (this.m_eventList.size() == 0) {
            this.m_monitorThread = null;
        }
        if (!bl) {
            throw new NamingException("Listener not found");
        }
    }

    public void run() {
        LDAPMessage lDAPMessage = null;
        while (this.m_monitorThread != null) {
            try {
                lDAPMessage = this.m_msgQueue.getResponse();
            }
            catch (LDAPException lDAPException) {
                this.processNetworkError(lDAPException);
            }
            if (lDAPMessage == null) {
                Debug.println(1, "No more messages, bye");
                this.m_monitorThread = null;
                return;
            }
            EventService eventService = this;
            synchronized (eventService) {
                EventEntry eventEntry = this.getEventEntry(lDAPMessage.getMessageID());
                if (eventEntry == null) {
                    Debug.println(1, "Received ldap msg with unknown id=" + lDAPMessage.getMessageID());
                    if (!(lDAPMessage instanceof LDAPResponse)) {
                        this.abandonRequest(lDAPMessage.getMessageID());
                    }
                    Object var3_4 = null;
                    continue;
                }
                if (lDAPMessage instanceof LDAPResponse) {
                    this.processResponseMsg((LDAPResponse)lDAPMessage, eventEntry);
                } else if (lDAPMessage instanceof LDAPSearchResultReference) {
                    this.processSearchResultRef((LDAPSearchResultReference)lDAPMessage, eventEntry);
                } else if (lDAPMessage instanceof LDAPSearchResult) {
                    this.processSearchResultMsg((LDAPSearchResult)lDAPMessage, eventEntry);
                }
            }
        }
    }

    private static class EventEntry {
        LdapContextImpl ctx;
        String base;
        String filter;
        String[] attrs;
        int scope;
        LDAPSearchConstraints cons;
        int id;
        Vector listeners = new Vector();

        EventEntry(int n, LdapContextImpl ldapContextImpl, String string, int n2, String string2, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) {
            this.id = n;
            this.ctx = ldapContextImpl;
            this.base = string;
            this.scope = n2;
            this.filter = string2;
            this.attrs = stringArray;
            this.cons = lDAPSearchConstraints;
        }

        synchronized void addListener(NamingListener namingListener) {
            this.listeners.addElement(namingListener);
        }

        boolean isEmpty() {
            return this.listeners.size() == 0;
        }

        boolean isEqualEvent(String string, int n, String string2, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) {
            int n2;
            int n3;
            if (!this.base.equals(string) || this.scope != n || !this.filter.equals(string2)) {
                return false;
            }
            if (this.attrs == null) {
                if (stringArray != null) {
                    return false;
                }
            } else {
                if (stringArray == null) {
                    return false;
                }
                if (this.attrs.length != stringArray.length) {
                    return false;
                }
                int n4 = 0;
                while (n4 < this.attrs.length) {
                    boolean bl = false;
                    n3 = 0;
                    while (n3 < this.attrs.length) {
                        if (this.attrs[n4].equals(stringArray[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        return false;
                    }
                    ++n4;
                }
            }
            LDAPPersistSearchControl lDAPPersistSearchControl = (LDAPPersistSearchControl)this.cons.getServerControls()[0];
            LDAPPersistSearchControl lDAPPersistSearchControl2 = (LDAPPersistSearchControl)lDAPSearchConstraints.getServerControls()[0];
            n3 = lDAPPersistSearchControl.getChangeTypes();
            return n3 == (n2 = lDAPPersistSearchControl2.getChangeTypes());
        }

        synchronized boolean removeListener(NamingListener namingListener) {
            return this.listeners.removeElement(namingListener);
        }

        public String toString() {
            LDAPPersistSearchControl lDAPPersistSearchControl = (LDAPPersistSearchControl)this.cons.getServerControls()[0];
            String string = "[EventEntry] base=" + this.base + " scope=" + this.scope + " filter=" + this.filter + " attrs={";
            int n = 0;
            while (n < this.attrs.length) {
                if (n > 0) {
                    string = String.valueOf(string) + " ";
                }
                string = String.valueOf(string) + this.attrs[n];
                ++n;
            }
            string = String.valueOf(string) + "} chanageTypes=" + lDAPPersistSearchControl.getChangeTypes();
            string = String.valueOf(string) + " listeners=" + this.listeners.size();
            string = String.valueOf(string) + " id=" + this.id;
            return string;
        }
    }
}

