/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.dctree;

import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import com.iplanet.ums.dctree.DomainComponent;
import com.iplanet.ums.dctree.DomainNotFoundException;
import com.iplanet.ums.dctree.InvalidDCRootException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import netscape.ldap.LDAPDN;

public class DomainComponentTree {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private PersistentObject m_dcRoot = null;
    private SSOToken m_token = null;

    public DomainComponentTree() {
    }

    public DomainComponentTree(SSOToken sSOToken, Guid guid) throws InvalidDCRootException, UMSException {
        if (sSOToken == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-token"));
        }
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        this.setSSOToken(sSOToken);
        try {
            this.setDCRoot(guid);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw new InvalidDCRootException(guid.getDn(), entryNotFoundException.getRootCause());
        }
    }

    void setSSOToken(SSOToken sSOToken) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        this.m_token = sSOToken;
    }

    SSOToken getSSOToken() {
        return this.m_token;
    }

    public void setDCRoot(Guid guid) throws UMSException {
        SSOToken sSOToken = this.getSSOToken();
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        if (sSOToken != null) {
            this.m_dcRoot = UMSObject.getObject(sSOToken, guid);
        }
    }

    public PersistentObject getDCRoot() {
        return this.m_dcRoot;
    }

    public DomainComponent addDomain(String string) throws UMSException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.m_dcRoot == null) {
            throw new InvalidDCRootException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        PersistentObject persistentObject = UMSObject.getObject(this.getSSOToken(), this.m_dcRoot.getGuid());
        DomainComponent domainComponent = null;
        n2 = 0;
        while (n2 < n) {
            SearchResults searchResults = persistentObject.getChildren("dc=" + stringArray[n - n2 - 1], null);
            try {
                domainComponent = (DomainComponent)searchResults.assertOneEntry();
            }
            catch (EntryNotFoundException entryNotFoundException) {
                domainComponent = new DomainComponent(this.getSSOToken(), stringArray[n - n2 - 1]);
                persistentObject.addChild(domainComponent);
            }
            persistentObject = UMSObject.getObject(this.getSSOToken(), domainComponent.getGuid());
            ++n2;
        }
        return domainComponent;
    }

    public void removeDomain(String string) throws UMSException {
        if (this.m_dcRoot == null) {
            return;
        }
        DomainComponent domainComponent = this.getDomainComponent(string);
        this.m_dcRoot.removeChild(domainComponent);
    }

    public void setDomainMapping(String string, PersistentObject persistentObject) throws UMSException {
        this.setDomainMapping(string, persistentObject.getGuid());
    }

    public void setDomainMapping(String string, Guid guid) throws UMSException {
        DomainComponent domainComponent = this.getDomainComponent(string);
        domainComponent.setAssociatedOrganization(guid);
    }

    public void setDomainStatus(String string, String string2) throws DomainNotFoundException, UMSException {
        DomainComponent domainComponent = this.getDomainComponent(string);
        domainComponent.setDomainStatus(string2);
    }

    public String getDomainStatus(String string) throws DomainNotFoundException, UMSException {
        DomainComponent domainComponent = this.getDomainComponent(string);
        return domainComponent.getDomainStatus();
    }

    public String mapDomainToDN(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = new String();
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + "dc=" + stringTokenizer.nextToken() + ",";
        }
        string2 = string2 + this.getDCRoot().getDN();
        return string2;
    }

    public DomainComponent getDomainComponent(String string) throws DomainNotFoundException, UMSException {
        String string2 = this.mapDomainToDN(string);
        try {
            DomainComponent domainComponent = (DomainComponent)UMSObject.getObject(this.getSSOToken(), new Guid(string2));
            domainComponent.setSSOToken(this.getSSOToken());
            return domainComponent;
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw new DomainNotFoundException(string, entryNotFoundException.getRootCause());
        }
    }

    public PersistentObject getOrganization(String string) throws DomainNotFoundException, UMSException {
        DomainComponent domainComponent = this.getDomainComponent(string);
        return domainComponent.getOrganization();
    }

    public User getUser(String string, String string2) throws DomainNotFoundException, UMSException {
        return this.getUser("uid", string, string2);
    }

    public User getUser(String string, String string2, String string3) throws DomainNotFoundException, UMSException {
        PersistentObject persistentObject = this.getOrganization(string3);
        SearchResults searchResults = persistentObject.search(string + "=" + string2, null);
        return (User)searchResults.assertOneEntry();
    }

    public String mapDCToDomainName(DomainComponent domainComponent) {
        if (this.m_dcRoot == null) {
            return null;
        }
        String string = LDAPDN.normalize((String)this.m_dcRoot.getDN());
        String string2 = LDAPDN.normalize((String)domainComponent.getDN());
        int n = string2.indexOf("," + string);
        string2 = string2.substring(0, n);
        String[] stringArray = LDAPDN.explodeDN((String)string2, (boolean)true);
        String string3 = stringArray[0];
        int n2 = 1;
        while (n2 < stringArray.length) {
            string3 = string3 + "." + stringArray[n2];
            ++n2;
        }
        return string3;
    }

    public Hashtable getChildDomainIDs() throws UMSException {
        if (this.m_dcRoot == null) {
            return null;
        }
        SearchResults searchResults = this.m_dcRoot.search("(&(objectclass=inetDomain)(inetDomainBaseDN=*))", null);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (searchResults.hasMoreElements()) {
            DomainComponent domainComponent = (DomainComponent)searchResults.next();
            String string = this.mapDCToDomainName(domainComponent);
            hashtable.put(string, domainComponent.getAssociatedOrganizationGuid().getDn());
        }
        return hashtable;
    }
}

