/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import java.security.Principal;

public class UMSObject {
    public static final String UMS = "UMS";
    public static final String ENTITY = "ENTITY";
    public static final String UTIL = "UTIL";
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static I18n i18n = I18n.getInstance((String)"amSDK");

    public static PersistentObject getObject(SSOToken sSOToken, Guid guid) throws UMSException {
        return UMSObject.getObject(sSOToken, guid, null);
    }

    public static PersistentObject getObject(SSOToken sSOToken, Guid guid, String[] stringArray) throws UMSException {
        Principal principal = null;
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        try {
            principal = sSOToken.getPrincipal();
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), sSOException);
        }
        return UMSObject.getObject(principal, guid, stringArray);
    }

    public static void removeObject(SSOToken sSOToken, Guid guid) throws EntryNotFoundException, UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        try {
            DataLayer.getInstance().deleteEntry(sSOToken.getPrincipal(), guid);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), sSOException);
        }
    }

    public static PersistentObject getObject(Principal principal, Guid guid) throws UMSException {
        return UMSObject.getObject(principal, guid, null);
    }

    public static PersistentObject getObject(Principal principal, Guid guid, String[] stringArray) throws UMSException {
        Object object;
        AttrSet attrSet = null;
        if (stringArray == null) {
            attrSet = DataLayer.getInstance().read(principal, guid);
        } else {
            int n = stringArray.length;
            object = new String[n + 1];
            System.arraycopy(stringArray, 0, object, 0, n);
            object[n] = "objectclass";
            attrSet = DataLayer.getInstance().read(principal, guid, (String[])object);
        }
        String string = guid.getDn();
        if (string == null) {
            object = i18n.getString("ums-badid");
            throw new IllegalArgumentException((String)object);
        }
        object = TemplateManager.getTemplateManager().getJavaClassForEntry(string, attrSet);
        PersistentObject persistentObject = null;
        try {
            persistentObject = (PersistentObject)((Class)object).newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{exception.toString()};
            String string2 = i18n.getString("ums-newinstancefailed", objectArray);
            throw new UMSException(string2);
        }
        persistentObject.setAttrSet(attrSet);
        persistentObject.setGuid(guid);
        persistentObject.setPrincipal(principal);
        return persistentObject;
    }

    public static PersistentObject getObjectHandle(SSOToken sSOToken, Guid guid) throws UMSException {
        String string = guid.getDn();
        if (sSOToken == null || string == null) {
            String string2;
            if (sSOToken == null) {
                string2 = i18n.getString("ums-null-token");
                debug.error("UMSObject.PersistentObject: token is null");
            } else {
                string2 = i18n.getString("ums-badguid");
                debug.error("UMSObject.PersistentObject: dn is null");
            }
            throw new UMSException(string2);
        }
        Principal principal = null;
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        try {
            principal = sSOToken.getPrincipal();
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), sSOException);
        }
        PersistentObject persistentObject = new PersistentObject();
        persistentObject.setGuid(guid);
        persistentObject.setPrincipal(principal);
        return persistentObject;
    }
}

