/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.ConfigManagerException;
import com.iplanet.ums.ConfigManagerUMS;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DefaultClassResolver;
import com.iplanet.ums.GroupResolver;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IClassResolver;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.UMSException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TemplateManager
implements Serializable {
    public static final int SCOPE_ORG = 0;
    public static final int SCOPE_ANCESTORS = 1;
    public static final int SCOPE_TOP = 2;
    private static final String TEMPLATE_NAME = "name";
    private static final String TEMPLATE_JAVACLASS = "javaclass";
    private static final String TEMPLATE_OPTIONAL = "optional";
    private static final String TEMPLATE_REQUIRED = "required";
    private static final String TEMPLATE_VALIDATED = "validated";
    private static final String TEMPLATE_NAMINGATTRIBUTE = "namingattribute";
    private static final String TEMPLATE_SEARCH_FILTER = "searchfilter";
    private static final String SCHEMA2_SEARCH_FILTER = "inetDomainSearchFilter";
    private static final String TEMPLATE_ATTRS = "attrs";
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private Vector m_resolvers = new Vector();
    private ConfigManagerUMS m_configManager = null;
    private static TemplateManager m_mgr;
    static /* synthetic */ Class class$com$iplanet$ums$PersistentObject;

    protected TemplateManager() throws UMSException {
        this.addClassResolver(new DefaultClassResolver());
        this.addClassResolver(new GroupResolver());
        try {
            this.m_configManager = ConfigManagerUMS.getConfigManager();
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
    }

    public static synchronized TemplateManager getTemplateManager() throws UMSException {
        if (m_mgr == null) {
            m_mgr = new TemplateManager();
        }
        return m_mgr;
    }

    public void addClassResolver(IClassResolver iClassResolver) {
        this.m_resolvers.addElement(iClassResolver);
    }

    public void removeClassResolver(IClassResolver iClassResolver) {
        this.m_resolvers.remove(iClassResolver);
    }

    public CreationTemplate getCreationTemplate(Class clazz, Guid guid) throws UMSException {
        return this.getCreationTemplate(clazz, guid, 1);
    }

    public CreationTemplate getCreationTemplate(Class clazz, Guid guid, int n) throws UMSException {
        if (clazz == null) {
            String string = i18n.getString("ums-badclass");
            throw new IllegalArgumentException(string);
        }
        AttrSet attrSet = null;
        try {
            attrSet = this.m_configManager.getCreationTemplateForClass(guid, clazz.getName(), n);
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
        if (attrSet == null) {
            return null;
        }
        return this.toCreationTemplate(attrSet);
    }

    public CreationTemplate getCreationTemplate(String string, Guid guid) throws UMSException {
        return this.getCreationTemplate(string, guid, 1);
    }

    public CreationTemplate getCreationTemplate(String string, Guid guid, int n) throws UMSException {
        if (string == null) {
            String string2 = i18n.getString("ums-missingtemplname");
            throw new IllegalArgumentException(string2);
        }
        AttrSet attrSet = null;
        try {
            attrSet = this.m_configManager.getCreationTemplate(guid, string, n);
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
        if (attrSet == null) {
            return null;
        }
        return this.toCreationTemplate(attrSet);
    }

    public SearchTemplate getSearchTemplate(String string, Guid guid) throws UMSException {
        return this.getSearchTemplate(string, guid, 1);
    }

    public SearchTemplate getSearchTemplate(String string, Guid guid, int n) throws UMSException {
        if (string == null) {
            String string2 = i18n.getString("ums-missingtemplname");
            throw new IllegalArgumentException(string2);
        }
        AttrSet attrSet = null;
        try {
            attrSet = this.m_configManager.getSearchTemplate(guid, string, n);
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
        if (attrSet == null) {
            return null;
        }
        return this.toSearchTemplate(attrSet);
    }

    public Set getCreationTemplateNames(Guid guid) throws UMSException {
        Set set = null;
        try {
            set = this.m_configManager.getCreationTemplateNames(guid);
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public Set getSearchTemplateNames(Guid guid) throws UMSException {
        Set set = null;
        try {
            set = this.m_configManager.getSearchTemplateNames(guid);
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public void replaceCreationTemplate(CreationTemplate creationTemplate, Guid guid) throws UMSException {
        if (creationTemplate == null) {
            return;
        }
        String string = creationTemplate.getName();
        if (string == null) {
            String string2 = i18n.getString("ums-missingtemplname");
            throw new IllegalArgumentException(string2);
        }
        AttrSet attrSet = this.toAttrSet(creationTemplate);
        try {
            this.m_configManager.replaceCreationTemplate(guid, string, attrSet);
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
    }

    private AttrSet toAttrSet(CreationTemplate creationTemplate) {
        Attr attr;
        Attr attr2;
        Serializable serializable;
        AttrSet attrSet = new AttrSet();
        attrSet.add(new Attr(TEMPLATE_NAME, creationTemplate.getName()));
        attrSet.add(new Attr(TEMPLATE_NAMINGATTRIBUTE, creationTemplate.getNamingAttribute()));
        ArrayList arrayList = creationTemplate.getCreationClasses();
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            serializable = (Class)arrayList.get(n);
            stringArray[n] = serializable.getName();
            ++n;
        }
        attrSet.add(new Attr(TEMPLATE_JAVACLASS, stringArray));
        serializable = this.encodeAttrSet(TEMPLATE_REQUIRED, creationTemplate.getRequiredAttributeSet(), "=");
        if (serializable != null) {
            attrSet.add((Attr)serializable);
        }
        if ((attr2 = this.encodeAttrSet(TEMPLATE_OPTIONAL, creationTemplate.getOptionalAttributeSet(), "=")) != null) {
            attrSet.add(attr2);
        }
        if ((attr = this.encodeAttrSet(TEMPLATE_VALIDATED, creationTemplate.getValidation(), "=")) != null) {
            attrSet.add(attr);
        }
        return attrSet;
    }

    Class getJavaClassForEntry(String string, AttrSet attrSet) throws UMSException {
        Class clazz = null;
        int n = this.m_resolvers.size() - 1;
        while (clazz == null && n >= 0) {
            IClassResolver iClassResolver = (IClassResolver)this.m_resolvers.elementAt(n);
            clazz = iClassResolver.resolve(string, attrSet);
            --n;
        }
        if (clazz == null) {
            clazz = class$com$iplanet$ums$PersistentObject == null ? (class$com$iplanet$ums$PersistentObject = TemplateManager.class$("com.iplanet.ums.PersistentObject")) : class$com$iplanet$ums$PersistentObject;
        }
        return clazz;
    }

    private CreationTemplate toCreationTemplate(AttrSet attrSet) {
        Attr attr = attrSet.getAttribute(TEMPLATE_NAME);
        String string = null;
        if (attr != null) {
            string = attr.getValue();
        }
        Attr attr2 = attrSet.getAttribute(TEMPLATE_NAMINGATTRIBUTE);
        String string2 = null;
        if (attr2 != null) {
            string2 = attr2.getValue();
        }
        Attr attr3 = attrSet.getAttribute(TEMPLATE_JAVACLASS);
        String[] stringArray = null;
        if (attr3 != null) {
            stringArray = attr3.getStringValues();
        }
        AttrSet attrSet2 = this.decodeAttr(attrSet.getAttribute(TEMPLATE_REQUIRED), "=");
        AttrSet attrSet3 = this.decodeAttr(attrSet.getAttribute(TEMPLATE_OPTIONAL), "=");
        AttrSet attrSet4 = this.decodeAttr(attrSet.getAttribute(TEMPLATE_VALIDATED), "=");
        CreationTemplate creationTemplate = new CreationTemplate();
        ArrayList arrayList = new ArrayList();
        try {
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    Class<?> clazz = Class.forName(stringArray[n]);
                    arrayList.add(clazz);
                    ++n;
                }
            }
            creationTemplate = new CreationTemplate(string, attrSet2, attrSet3, arrayList);
        }
        catch (ClassNotFoundException classNotFoundException) {
            creationTemplate = new CreationTemplate(string, attrSet2, attrSet3);
        }
        if (attrSet4 != null) {
            creationTemplate.setValidation(attrSet4);
        }
        if (string2 != null) {
            creationTemplate.setNamingAttribute(string2);
        }
        return creationTemplate;
    }

    private SearchTemplate toSearchTemplate(AttrSet attrSet) {
        Attr attr;
        Attr attr2 = attrSet.getAttribute(TEMPLATE_NAME);
        String string = null;
        if (attr2 != null) {
            string = attr2.getValue();
        }
        if ((attr = attrSet.getAttribute(SCHEMA2_SEARCH_FILTER)) == null) {
            attr = attrSet.getAttribute(TEMPLATE_SEARCH_FILTER);
        }
        String string2 = null;
        if (attr != null) {
            string2 = attr.getValue();
        }
        AttrSet attrSet2 = this.decodeAttr(attrSet.getAttribute(TEMPLATE_ATTRS), "=");
        SearchTemplate searchTemplate = new SearchTemplate();
        searchTemplate = new SearchTemplate(string, attrSet2, string2);
        return searchTemplate;
    }

    private String[][] toDoubleSubscriptedArray(AttrSet attrSet) {
        String[] stringArray = attrSet.getAttributeNames();
        String[][] stringArray2 = new String[stringArray.length][2];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n][0] = stringArray[n];
            stringArray2[n][1] = attrSet.getAttribute(stringArray[n]).getValue();
            ++n;
        }
        return stringArray2;
    }

    private AttrSet toAttrSet(String[][] stringArray) {
        AttrSet attrSet = new AttrSet();
        int n = 0;
        while (n < stringArray.length) {
            Attr attr = new Attr(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
        return attrSet;
    }

    private AttrSet decodeAttr(Attr attr, String string) {
        if (attr == null) {
            return null;
        }
        String[] stringArray = attr.getStringValues();
        AttrSet attrSet = new AttrSet();
        int n = 0;
        int n2 = attr.size();
        while (n < n2) {
            String string2 = stringArray[n];
            String string3 = null;
            String string4 = null;
            int n3 = string2.indexOf(61);
            if (n3 < 0) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, n3);
                string4 = string2.substring(n3 + 1, string2.length());
            }
            if (string4 != null && string4.length() != 0) {
                attrSet.add(new Attr(string3, string4));
            } else {
                attrSet.add(new Attr(string3));
            }
            ++n;
        }
        return attrSet;
    }

    private Attr encodeAttrSet(String string, AttrSet attrSet, String string2) {
        if (attrSet == null || attrSet.size() == 0) {
            return null;
        }
        Enumeration enumeration = attrSet.getAttributes();
        Attr attr = new Attr(string);
        while (enumeration.hasMoreElements()) {
            Attr attr2 = (Attr)enumeration.nextElement();
            String[] stringArray = attr2.getStringValues();
            String[] stringArray2 = new String[stringArray.length];
            if (stringArray.length == 0) {
                attr.addValue(attr2.getName());
                continue;
            }
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = attr2.getName() + string2 + stringArray[n];
                ++n;
            }
            attr.addValues(stringArray2);
        }
        return attr;
    }

    private boolean compareArraysIgnoreOrder(Object[] objectArray, Object[] objectArray2) {
        List<Object> list;
        boolean bl = false;
        List<Object> list2 = Arrays.asList(objectArray);
        bl = list2.containsAll(list = Arrays.asList(objectArray2)) && list.containsAll(list2);
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

