/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AttributeValueAlreadyExistsException;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.UMSException;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class SchemaManager
implements Serializable,
IUMSConstants {
    public static final String ATTRIBUTE_SYNTAX_CIS = "1.3.6.1.4.1.1466.115.121.1.15";
    public static final String ATTRIBUTE_SYNTAX_CES = "1.3.6.1.4.1.1466.115.121.1.26";
    public static final String ATTRIBUTE_SYNTAX_BINARY = "1.3.6.1.4.1.1466.115.121.1.5";
    public static final String ATTRIBUTE_SYNTAX_INT = "1.3.6.1.4.1.1466.115.121.1.27";
    public static final String ATTRIBUTE_SYNTAX_TELEPHONE = "1.3.6.1.4.1.1466.115.121.1.50";
    public static final String ATTRIBUTE_SYNTAX_DN = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final int STRUCTURAL = 0;
    public static final int ABSTRACT = 1;
    public static final int AUXILIARY = 2;
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private Principal m_principal;
    private DataLayer m_datalayer;
    private LDAPSchema m_schema;
    private boolean m_hasModified;

    protected SchemaManager() {
    }

    protected SchemaManager(Principal principal) throws UMSException {
        this.m_datalayer = DataLayer.getInstance();
        this.m_principal = principal;
    }

    public static SchemaManager getSchemaManager(SSOToken sSOToken) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        Principal principal = null;
        try {
            principal = sSOToken.getPrincipal();
        }
        catch (Exception exception) {
            return null;
        }
        return new SchemaManager(principal);
    }

    public static SchemaManager getSchemaManager(Principal principal) throws UMSException {
        SchemaManager schemaManager = new SchemaManager(principal);
        return schemaManager;
    }

    private LDAPSchema getLDAPSchema() throws UMSException {
        if (this.m_schema == null || this.m_hasModified) {
            this.refresh();
            this.m_hasModified = false;
        }
        return this.m_schema;
    }

    public void refresh() throws UMSException {
        this.m_schema = this.m_datalayer.getSchema(this.m_principal);
    }

    public void addAttribute(String string, String string2, String string3, String string4, boolean bl) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPAttributeSchema lDAPAttributeSchema = new LDAPAttributeSchema(string, string2, string3, string4, bl);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)lDAPAttributeSchema);
        this.m_hasModified = true;
    }

    public void addAttribute(String string) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPAttributeSchema lDAPAttributeSchema = new LDAPAttributeSchema(string);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)lDAPAttributeSchema);
        this.m_hasModified = true;
    }

    public void addObjectClass(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPObjectClassSchema lDAPObjectClassSchema = new LDAPObjectClassSchema(string, string2, string3, string4, stringArray, stringArray2);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)lDAPObjectClassSchema);
        this.m_hasModified = true;
    }

    public void addObjectClass(String string, String string2, String[] stringArray, String string3, String[] stringArray2, String[] stringArray3, int n, String[] stringArray4) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPObjectClassSchema lDAPObjectClassSchema = new LDAPObjectClassSchema(string, string2, stringArray, string3, stringArray2, stringArray3, n, stringArray4);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)lDAPObjectClassSchema);
        this.m_hasModified = true;
    }

    public void addObjectClass(String string) throws AttributeValueAlreadyExistsException, UMSException {
        LDAPObjectClassSchema lDAPObjectClassSchema = new LDAPObjectClassSchema(string);
        this.m_datalayer.addSchema(this.m_principal, (LDAPSchemaElement)lDAPObjectClassSchema);
        this.m_hasModified = true;
    }

    public void removeAttribute(String string) throws UMSException {
        LDAPAttributeSchema lDAPAttributeSchema = this.getLDAPSchema().getAttribute(string);
        if (lDAPAttributeSchema == null) {
            Object[] objectArray = new String[]{string};
            String string2 = i18n.getString("ums-attributetypenotfound", objectArray);
            throw new UMSException(string2);
        }
        this.m_datalayer.removeSchema(this.m_principal, (LDAPSchemaElement)lDAPAttributeSchema);
        this.m_hasModified = true;
    }

    public void removeObjectClass(String string) throws UMSException {
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getLDAPSchema().getObjectClass(string);
        if (lDAPObjectClassSchema == null) {
            Object[] objectArray = new String[]{string};
            String string2 = i18n.getString("ums-objectclassnotfound", objectArray);
            throw new UMSException(string2);
        }
        this.m_datalayer.removeSchema(this.m_principal, (LDAPSchemaElement)lDAPObjectClassSchema);
        this.m_hasModified = true;
    }

    public String getAttribute(String string) throws UMSException {
        LDAPAttributeSchema lDAPAttributeSchema = this.getLDAPSchema().getAttribute(string);
        if (lDAPAttributeSchema != null) {
            return lDAPAttributeSchema.getValue();
        }
        return null;
    }

    public String getObjectClass(String string) throws UMSException {
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getLDAPSchema().getObjectClass(string);
        if (lDAPObjectClassSchema != null) {
            return lDAPObjectClassSchema.getValue();
        }
        return null;
    }

    public Collection getObjectClasses(String string) throws UMSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.getLDAPSchema().getObjectClasses();
        while (enumeration.hasMoreElements()) {
            String string2;
            LDAPObjectClassSchema lDAPObjectClassSchema = (LDAPObjectClassSchema)enumeration.nextElement();
            Enumeration enumeration2 = lDAPObjectClassSchema.getRequiredAttributes();
            Enumeration enumeration3 = lDAPObjectClassSchema.getOptionalAttributes();
            while (enumeration2.hasMoreElements()) {
                string2 = (String)enumeration2.nextElement();
                if (!string2.equalsIgnoreCase(string)) continue;
                arrayList.add(lDAPObjectClassSchema.getName());
            }
            while (enumeration3.hasMoreElements()) {
                string2 = (String)enumeration3.nextElement();
                if (!string2.equalsIgnoreCase(string)) continue;
                arrayList.add(lDAPObjectClassSchema.getName());
            }
        }
        return arrayList;
    }

    public Collection getAttributes(String string) throws UMSException {
        Collection collection = this.getRequiredAttributes(string);
        collection.addAll(this.getOptionalAttributes(string));
        return collection;
    }

    public Collection getRequiredAttributes(String string) throws UMSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getLDAPSchema().getObjectClass(string);
        if (lDAPObjectClassSchema != null) {
            Enumeration enumeration = lDAPObjectClassSchema.getRequiredAttributes();
            while (enumeration.hasMoreElements()) {
                arrayList.add((String)enumeration.nextElement());
            }
        }
        return arrayList;
    }

    public Collection getOptionalAttributes(String string) throws UMSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getLDAPSchema().getObjectClass(string);
        if (lDAPObjectClassSchema != null) {
            Enumeration enumeration = lDAPObjectClassSchema.getOptionalAttributes();
            while (enumeration.hasMoreElements()) {
                arrayList.add((String)enumeration.nextElement());
            }
        }
        return arrayList;
    }

    public Collection getUniqueAttributes(String string, Collection collection) throws UMSException {
        Collection collection2 = this.getAttributes(string);
        ArrayList arrayList = (ArrayList)collection;
        int n = 0;
        while (n < arrayList.size()) {
            collection2.removeAll(this.getAttributes((String)arrayList.get(n)));
            ++n;
        }
        return collection2;
    }

    public Collection getUniqueAttributes(String string) throws UMSException {
        Collection collection = this.getAttributes(string);
        ArrayList arrayList = new ArrayList(collection);
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = (String)arrayList.get(n);
            if (this.getObjectClasses(string2).size() > 1) {
                collection.remove(string2);
            }
            ++n;
        }
        return collection;
    }

    private String getNameFromAttribute(String string) {
        LDAPAttributeSchema lDAPAttributeSchema = new LDAPAttributeSchema(string);
        return lDAPAttributeSchema.getName();
    }

    private String getNameFromObjectClass(String string) {
        LDAPObjectClassSchema lDAPObjectClassSchema = new LDAPObjectClassSchema(string);
        return lDAPObjectClassSchema.getName();
    }

    public void modifySchema(String string) throws UMSException {
        LDAPModification[] lDAPModificationArray = null;
        try {
            LDIF lDIF = new LDIF(string);
            LDIFRecord lDIFRecord = lDIF.nextRecord();
            while (lDIFRecord != null) {
                LDIFContent lDIFContent = lDIFRecord.getContent();
                if (lDIFContent instanceof LDIFModifyContent) {
                    lDAPModificationArray = ((LDIFModifyContent)lDIFContent).getModifications();
                    int n = 0;
                    while (n < lDAPModificationArray.length) {
                        LDAPAttribute lDAPAttribute = lDAPModificationArray[n].getAttribute();
                        String string2 = lDAPAttribute.getStringValueArray()[0];
                        String string3 = lDAPAttribute.getStringValueArray()[0];
                        int n2 = lDAPModificationArray[n].getOp();
                        if (n2 == 0) {
                            if (lDAPAttribute.getName().equalsIgnoreCase("attributetypes")) {
                                this.addAttribute(string2);
                            } else if (lDAPAttribute.getName().equalsIgnoreCase("objectclasses")) {
                                this.addObjectClass(string3);
                            }
                        } else if (n2 == 2) {
                            if (lDAPAttribute.getName().equalsIgnoreCase("attributetypes")) {
                                this.removeAttribute(this.getNameFromAttribute(string2));
                                this.addAttribute(string2);
                            } else if (lDAPAttribute.getName().equalsIgnoreCase("objectclasses")) {
                                this.removeObjectClass(this.getNameFromObjectClass(string3));
                                this.addObjectClass(string3);
                            }
                        } else if (n2 == 1) {
                            if (lDAPAttribute.getName().equalsIgnoreCase("attributetypes")) {
                                this.removeAttribute(this.getNameFromAttribute(string2));
                            } else if (lDAPAttribute.getName().equalsIgnoreCase("objectclasses")) {
                                this.removeObjectClass(this.getNameFromObjectClass(string3));
                            }
                        }
                        ++n;
                    }
                }
                lDIFRecord = lDIF.nextRecord();
            }
        }
        catch (IOException iOException) {
            String string4 = i18n.getString("ums-readingldiffailed");
            throw new UMSException(string4, iOException);
        }
    }
}

