/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.ConfigManagerException;
import com.iplanet.ums.ConfigManagerUMS;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IUMSConstants;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class EntityManager
implements IUMSConstants {
    private static final String ENTITY_CHILDNODE = "childNode";
    private static final String ENTITY_FILTER = "filter";
    private static final String ENTITY_PRIORITY = "priority";
    private static final String ENTITY_CLASS = "class";
    private static final String ENTITY_TEMPLATE = "template";
    private static final String ENTITY_NAME = "name";
    private static final String NAME_TOKEN_DELIM = "=";
    private PersistentObject _pObject;
    private PersistentObject _parentObject;
    private Stack _stack;
    private TemplateManager _templateMgr;
    private Principal _principal;
    private ConfigManagerUMS _configManager;
    private DataLayer _dataLayer;
    private static EntityManager _instance = null;
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");

    public static synchronized EntityManager getEntityManager() throws UMSException {
        if (_instance == null) {
            _instance = new EntityManager();
        }
        return _instance;
    }

    public void execute(Principal principal, PersistentObject persistentObject, Guid guid) throws UMSException {
        HashMap<String, Guid> hashMap = null;
        Set set = null;
        Iterator<Object> iterator = null;
        Attr attr = null;
        AttrSet attrSet = null;
        if (persistentObject == null) {
            String string = i18n.getString("ums-badpersistentobject");
            throw new UMSException(string);
        }
        this._principal = principal;
        this._pObject = persistentObject;
        this._stack = new Stack();
        String string = this._pObject.getClass().getName();
        this._parentObject = this._pObject;
        if (debug.messageEnabled()) {
            debug.message("GETTING ENTITY FOR:CLASS:" + string + ",PARENT:" + guid.getDn());
        }
        try {
            Object[] objectArray;
            set = this._configManager.getEntity(guid, string);
            if (!set.isEmpty()) {
                if (set.size() > 1) {
                    attrSet = this.findEntity(this._pObject, set);
                } else {
                    objectArray = set.iterator();
                    if (objectArray.hasNext()) {
                        attrSet = (AttrSet)objectArray.next();
                    }
                }
            } else {
                return;
            }
            if (attrSet == null) {
                objectArray = new String[]{string};
                String string2 = i18n.getString("ums-structuretemplateattrsetnull", objectArray);
                throw new UMSException(string2);
            }
        }
        catch (ConfigManagerException configManagerException) {
            Object[] objectArray = new String[]{configManagerException.getMessage()};
            String string3 = i18n.getString("ums-configmanagererror", objectArray);
            throw new UMSException(string3);
        }
        if (debug.messageEnabled()) {
            debug.message("ENTITY ATTRSET:" + attrSet);
        }
        if ((attr = attrSet.getAttribute(ENTITY_CHILDNODE)) == null) {
            return;
        }
        String[] stringArray = attr.getStringValues();
        int n = 0;
        while (n < stringArray.length) {
            hashMap = new HashMap<String, Guid>();
            hashMap.put(stringArray[n], this._parentObject.getGuid());
            this._stack.push(hashMap);
            ++n;
        }
        while (!this._stack.empty()) {
            Object object;
            hashMap = (HashMap<String, Guid>)this._stack.pop();
            set = hashMap.keySet();
            iterator = set.iterator();
            String string4 = (String)iterator.next();
            Guid guid2 = (Guid)hashMap.get(string4);
            try {
                object = this._configManager.getEntity(guid, string4);
                if (!object.isEmpty() && (iterator = object.iterator()).hasNext()) {
                    attrSet = (AttrSet)iterator.next();
                }
                if (object.isEmpty() | attrSet == null) {
                    return;
                }
            }
            catch (ConfigManagerException configManagerException) {
                Object[] objectArray = new String[]{configManagerException.getMessage()};
                String string5 = i18n.getString("ums-configmanagererror", objectArray);
                throw new UMSException(string5);
            }
            object = this.createObject(attrSet, guid2, guid);
            attr = attrSet.getAttribute(ENTITY_CHILDNODE);
            if (attr == null) continue;
            stringArray = attr.getStringValues();
            int n2 = 0;
            while (n2 < stringArray.length) {
                hashMap = new HashMap<String, Guid>();
                hashMap.put(stringArray[n2], ((PersistentObject)object).getGuid());
                this._stack.push(hashMap);
                ++n2;
            }
        }
    }

    private AttrSet findEntity(PersistentObject persistentObject, Set set) throws UMSException {
        AttrSet attrSet = null;
        AttrSet attrSet2 = null;
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                attrSet2 = (AttrSet)iterator.next();
                String string = attrSet2.getAttribute(ENTITY_FILTER).getValue();
                SearchControl searchControl = new SearchControl();
                searchControl.setSearchScope(0);
                SearchResults searchResults = persistentObject.search(string, searchControl);
                if (!searchResults.hasMoreElements()) continue;
                searchResults.abandon();
                if (attrSet != null && Integer.parseInt(attrSet2.getAttribute(ENTITY_PRIORITY).getValue()) >= Integer.parseInt(attrSet.getAttribute(ENTITY_PRIORITY).getValue())) continue;
                attrSet = attrSet2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new String[]{"" + attrSet2, "" + attrSet, numberFormatException.getMessage()};
            String string = i18n.getString("ums-badstructuretemplatepriority", objectArray);
            throw new UMSException(string);
        }
        return attrSet;
    }

    private PersistentObject createObject(AttrSet attrSet, Guid guid, Guid guid2) throws UMSException {
        Object object;
        String string;
        DataLayer dataLayer = DataLayer.getInstance();
        Attr attr = attrSet.getAttribute(ENTITY_CLASS);
        Attr attr2 = attrSet.getAttribute(ENTITY_TEMPLATE);
        Attr attr3 = attrSet.getAttribute(ENTITY_NAME);
        if (attr3 == null) {
            String string2 = i18n.getString("ums-badnamingattr");
            throw new UMSException(string2);
        }
        String[] stringArray = attr3.getStringValues();
        attrSet = new AttrSet();
        int n = 0;
        while (n < stringArray.length) {
            string = null;
            object = null;
            int n2 = stringArray[n].indexOf(NAME_TOKEN_DELIM);
            if (n2 < 0) {
                String string3 = i18n.getString("ums-badnamingattr");
                throw new UMSException(string3);
            }
            string = stringArray[n].substring(0, n2);
            object = stringArray[n].substring(n2 + 1, stringArray[n].length());
            attrSet.add(new Attr(string, (String)object));
            ++n;
        }
        string = attr2.getValue();
        object = this._templateMgr.getCreationTemplate(string, guid2);
        PersistentObject persistentObject = new PersistentObject((CreationTemplate)object, attrSet);
        String string4 = persistentObject.getNamingAttribute();
        String string5 = persistentObject.getAttribute(string4).getValue();
        Guid guid3 = new Guid(string4 + NAME_TOKEN_DELIM + string5 + "," + guid.getDn());
        String[] stringArray2 = persistentObject.getAttributeNames();
        AttrSet attrSet2 = persistentObject.getAttributes(stringArray2);
        try {
            dataLayer.addEntry(this._principal, guid3, attrSet2);
        }
        catch (UMSException uMSException) {
            throw new UMSException(uMSException.getMessage());
        }
        UMSObject uMSObject = new UMSObject();
        persistentObject = UMSObject.getObject(this._principal, guid3);
        return persistentObject;
    }

    private EntityManager() throws UMSException {
        try {
            this._configManager = ConfigManagerUMS.getConfigManager();
            this._templateMgr = TemplateManager.getTemplateManager();
        }
        catch (ConfigManagerException configManagerException) {
            throw new UMSException(configManagerException.getMessage());
        }
    }
}

