/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.ldap.event.EventServicePolling;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.services.ldap.event.Request;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class EventService
implements Runnable {
    protected static DSConfigMgr cm = null;
    Hashtable _requestList = new Hashtable();
    static Thread _monitorThread = null;
    static LDAPSearchListener _msgQueue;
    protected static EventService _instance;
    private static final boolean CHANGES_ONLY = true;
    private static final boolean RETURN_CONTROLS = true;
    private static final boolean IS_CRITICAL = true;
    private static final String BAD_TOKEN_HDL = "ums-badsesshdl";
    private static I18n i18n;
    protected static Debug debugger;
    protected static final String EVENT_CONNECTION_NUM_RETRIES = "com.iplanet.am.event.connection.num.retries";
    protected static final String EVENT_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.event.connection.delay.between.retries";
    protected static final String EVENT_CONNECTION_ERROR_CODES = "com.iplanet.am.event.connection.ldap.error.codes.retries";
    protected static final String EVENT_IDLE_TIMEOUT_INTERVAL = "com.sun.am.event.connection.idle.timeout";
    protected static final String EVENT_LISTENER_DISABLE_LIST = "com.sun.am.event.connection.disable.list";
    private static boolean _allDisabled;
    private static int _numRetries;
    private static int _retryInterval;
    protected static HashSet _retryErrorCodes;
    protected static int _idleTimeOut;
    protected static long _idleTimeOutMills;
    protected static final String[] listeners;
    protected static Hashtable _ideListenersMap;
    protected static boolean _listenerInitialized;
    protected static Object _listenerInitMonitor;
    protected static boolean _isThreadStarted;

    private static HashSet getPropertyRetryErrorCodes(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = SystemProperties.get((String)string);
        if (string2 != null && string2.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken().trim());
            }
        }
        return hashSet;
    }

    private static int getPropertyIntValue(String string, int n) {
        int n2;
        block4: {
            n2 = n;
            String string2 = SystemProperties.get((String)string);
            if (string2 != null && string2.trim().length() > 0) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                    if (!debugger.warningEnabled()) break block4;
                    debugger.warning("EventService.getPropertyIntValue(): Invalid value for property: com.iplanet.am.event.connection.num.retries Defaulting to value: " + n);
                }
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getPropertyIntValue(): " + string + " = " + n2);
        }
        return n2;
    }

    private static void getListenerList() {
        String string = SystemProperties.get((String)EVENT_LISTENER_DISABLE_LIST, (String)"");
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getListenerList(): com.sun.am.event.connection.disable.list = " + string);
        }
        if (string.equals("")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("aci")) {
                EventService.listeners[0] = null;
                bl = true;
                continue;
            }
            if (string2.equalsIgnoreCase("um")) {
                EventService.listeners[1] = null;
                bl2 = true;
                continue;
            }
            if (string2.equalsIgnoreCase("sm")) {
                EventService.listeners[2] = null;
                bl3 = true;
                continue;
            }
            if (!debugger.messageEnabled()) continue;
            debugger.message("EventService.getListenerList() - Invalid listener name: " + string2);
        }
        if (bl && bl2 && bl3) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.getListenerList() - all listeners are disabled, EventService won't start");
            }
            _allDisabled = true;
        }
    }

    protected EventService() throws EventException {
        EventService.getConfigManager();
    }

    public static synchronized EventService getEventService() throws EventException, LDAPException {
        if (_allDisabled) {
            return null;
        }
        if (_instance == null) {
            _instance = _idleTimeOut == 0 ? new EventService() : new EventServicePolling();
            EventService.startMonitorThread();
        }
        while (!_listenerInitialized) {
            Object object = _listenerInitMonitor;
            synchronized (object) {
                block8: {
                    try {
                        _listenerInitMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!debugger.messageEnabled()) break block8;
                        debugger.message("EventService.getEventService: InterruptedException " + interruptedException);
                    }
                }
            }
        }
        return _instance;
    }

    protected static String getName() {
        return "EventService";
    }

    public void finalize() {
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            this.removeListener(request);
        }
        this._requestList.clear();
    }

    public synchronized String addListener(SSOToken sSOToken, IDSEventListener iDSEventListener, String string, int n, String string2, int n2) throws LDAPException, EventException {
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = cm.getNewAdminConnection();
        }
        catch (LDAPServiceException lDAPServiceException) {
            throw new EventException(i18n.getString("dscfg-connectFail"), lDAPServiceException);
        }
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        LDAPPersistSearchControl lDAPPersistSearchControl = new LDAPPersistSearchControl(n2, true, true, true);
        lDAPSearchConstraints.setServerControls((LDAPControl)lDAPPersistSearchControl);
        lDAPSearchConstraints.setBatchSize(1);
        String[] stringArray = new String[]{"objectclass"};
        LDAPSearchListener lDAPSearchListener = null;
        try {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.addListener() - Submiting Persistent Search on: " + string + " for listener: " + iDSEventListener);
            }
            lDAPSearchListener = lDAPConnection.search(string, n, string2, stringArray, false, null, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            debugger.error("EventService.addListener() - Failed to set Persistent Search" + lDAPException.getMessage());
            throw lDAPException;
        }
        int[] nArray = lDAPSearchListener.getMessageIDs();
        int n3 = nArray[nArray.length - 1];
        String string3 = Integer.toString(n3);
        long l = System.currentTimeMillis();
        Request request = new Request(n3, string3, sSOToken, string, n, string2, stringArray, n2, iDSEventListener, lDAPConnection, l);
        this._requestList.put(string3, request);
        if (_msgQueue == null) {
            _msgQueue = lDAPSearchListener;
        } else {
            _msgQueue.merge(lDAPSearchListener);
        }
        if (debugger.messageEnabled()) {
            nArray = _msgQueue.getMessageIDs();
            debugger.message("EventService.addListener(): merged Listener:  requestID: " + string3 + " & Request: " + request + " on to message Queue. No. of current outstanding " + "requests = " + nArray.length);
        }
        return string3;
    }

    public IDSEventListener getIDSListeners(String string) {
        return (IDSEventListener)_ideListenersMap.get(string);
    }

    public static boolean isThreadStarted() {
        return _isThreadStarted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initListeners() {
        Object object;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                object = listeners[n2];
                if (object != null) {
                    try {
                        Object object2;
                        if (((String)object).equals("com.sun.identity.sm.ldap.LDAPEventManager")) {
                            object2 = SystemProperties.get((String)"com.sun.identity.sm.enableDataStoreNotification", (String)"true");
                            if (debugger.messageEnabled()) {
                                debugger.message("EventService.initListeners()-com.sun.identity.sm.enableDataStoreNotification:" + (String)object2);
                            }
                            if (((String)object2).equals("false") && ServiceManager.isRealmEnabled()) {
                                debugger.message("EventService.initListeners() - Skipping com.sun.identity.sm.ldap.LDAPEventManager");
                                break block10;
                            }
                        }
                        object2 = Class.forName((String)object);
                        IDSEventListener iDSEventListener = (IDSEventListener)((Class)object2).newInstance();
                        _ideListenersMap.put(object, iDSEventListener);
                        _instance.addListener(EventService.getSSOToken(), iDSEventListener, iDSEventListener.getBase(), iDSEventListener.getScope(), iDSEventListener.getFilter(), iDSEventListener.getOperations());
                        if (debugger.messageEnabled()) {
                            debugger.message("EventService.initListeners() - successfully initialized listener: " + (String)object);
                        }
                    }
                    catch (Exception exception) {
                        debugger.error("EventService.initListeners() Unable to start listener " + (String)object, (Throwable)exception);
                    }
                }
            }
            ++n2;
        }
        object = _listenerInitMonitor;
        synchronized (object) {
            _listenerInitialized = true;
            _listenerInitMonitor.notifyAll();
            return;
        }
    }

    public void run() {
        if (debugger.messageEnabled()) {
            debugger.message("EventService.run(): Event Thread is running! No Idle timeout Set: " + _idleTimeOut + " minutes.");
        }
        this.initListeners();
        boolean bl = true;
        LDAPMessage lDAPMessage = null;
        while (bl) {
            try {
                try {
                    if (debugger.messageEnabled()) {
                        debugger.message("EventService.run(): Waiting for response");
                    }
                    lDAPMessage = _msgQueue.getResponse();
                    bl = this.processResponse(lDAPMessage);
                }
                catch (LDAPException lDAPException) {
                    int n = lDAPException.getLDAPResultCode();
                    if (debugger.warningEnabled()) {
                        debugger.warning("EventService.run() LDAPException received:", (Throwable)lDAPException);
                    }
                    if (_retryErrorCodes.contains("" + n)) {
                        bl = this.resetAllSearches(true);
                        continue;
                    }
                    this.processNetworkError((Exception)((Object)lDAPException));
                }
            }
            catch (Throwable throwable) {
                if (debugger.warningEnabled()) {
                    debugger.warning("EventService.run(): Unknown exception caught. Sleeping for a while.. ", throwable);
                }
                this.sleepRetryInterval();
            }
        }
        debugger.error("EventService.run() - Monitor thread is terminating! Persistent Searches will no longer be operational.");
    }

    private static void startMonitorThread() {
        if (_monitorThread == null || !_monitorThread.isAlive()) {
            _monitorThread = new Thread((Runnable)_instance, EventService.getName());
            _monitorThread.setDaemon(true);
            _monitorThread.start();
            _isThreadStarted = true;
        }
    }

    protected synchronized boolean processResponse(LDAPMessage lDAPMessage) {
        if (lDAPMessage == null) {
            debugger.warning("EventService.processResponse() - Received a NULL Response. Attempting to re-start persistent searches");
            return this.resetAllSearches(false);
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processResponse() - received DS message  => " + lDAPMessage.toString());
        }
        boolean bl = true;
        Request request = this.getRequestEntry(lDAPMessage.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponse() - Received ldap message with unknown id = " + lDAPMessage.getMessageID());
            }
        } else if (lDAPMessage instanceof LDAPSearchResult) {
            this.processSearchResultMessage((LDAPSearchResult)lDAPMessage, request);
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (lDAPMessage instanceof LDAPResponse) {
            LDAPResponse lDAPResponse = (LDAPResponse)lDAPMessage;
            bl = this.processResponseMessage(lDAPResponse, request);
        } else if (lDAPMessage instanceof LDAPSearchResultReference) {
            this.processSearchResultRef((LDAPSearchResultReference)lDAPMessage, request);
        }
        return bl;
    }

    protected void removeListener(Request request) {
        block4: {
            LDAPConnection lDAPConnection = request.getLDAPConnection();
            if (lDAPConnection != null) {
                if (debugger.messageEnabled()) {
                    debugger.message("EventService.removeListener(): Removing listener requestID: " + request.getRequestID() + " Listener: " + request.getListener());
                }
                try {
                    lDAPConnection.abandon(request.getId());
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    if (!debugger.warningEnabled()) break block4;
                    debugger.warning("EventService.removeListener(): LDAPException, when trying to remove listener", (Throwable)lDAPException);
                }
            }
        }
    }

    protected synchronized boolean resetAllSearches(boolean bl) {
        boolean bl2;
        Hashtable hashtable = (Hashtable)this._requestList.clone();
        this._requestList.clear();
        Collection collection = hashtable.values();
        int n = 1;
        boolean bl3 = bl2 = _numRetries == -1 || _numRetries != 0 && n <= _numRetries;
        if (bl) {
            this.dispatchAllEntriesChangedEvent();
        }
        while (bl2) {
            block8: {
                try {
                    Object object;
                    this.sleepRetryInterval();
                    if (debugger.messageEnabled()) {
                        object = _numRetries == -1 ? "indefinitely" : Integer.toString(n);
                        debugger.message("EventService.resetAllSearches(): retrying = " + (String)object);
                    }
                    _msgQueue = null;
                    object = collection.iterator();
                    while (object.hasNext()) {
                        Request request = (Request)object.next();
                        this.removeListener(request);
                        this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations());
                    }
                    return true;
                }
                catch (LDAPServiceException lDAPServiceException) {
                    if (n == _numRetries) {
                        this.processNetworkError(lDAPServiceException);
                    }
                }
                catch (LDAPException lDAPException) {
                    if (n != _numRetries) break block8;
                    this.processNetworkError((Exception)((Object)lDAPException));
                }
            }
            if (_numRetries == -1) continue;
            boolean bl4 = bl2 = ++n <= _numRetries;
        }
        return false;
    }

    protected void sleepRetryInterval() {
        try {
            Thread.sleep(_retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static void getConfigManager() throws EventException {
        try {
            cm = DSConfigMgr.getDSConfigMgr();
        }
        catch (LDAPServiceException lDAPServiceException) {
            debugger.error("EventService.getConfigManager() - Failed to get handle to Configuration Manager", (Throwable)lDAPServiceException);
            throw new EventException(i18n.getString("dscfg-nocfgmgr"), lDAPServiceException);
        }
    }

    private void dispatchException(Exception exception, Request request) {
        IDSEventListener iDSEventListener = request.getListener();
        debugger.error("EventService.dispatchException() - dispatching exception to the listener: " + request.getRequestID() + " Listener: " + request.getListener(), (Throwable)exception);
        iDSEventListener.eventError(exception.toString());
    }

    private void dispatchEvent(DSEvent dSEvent, Request request) {
        IDSEventListener iDSEventListener = request.getListener();
        iDSEventListener.entryChanged(dSEvent);
    }

    private synchronized void dispatchAllEntriesChangedEvent() {
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            IDSEventListener iDSEventListener = request.getListener();
            iDSEventListener.allEntriesChanged();
        }
    }

    protected void processNetworkError(Exception exception) {
        Collection collection = this._requestList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            this.dispatchException(exception, request);
        }
    }

    private boolean processResponseMessage(LDAPResponse lDAPResponse, Request request) {
        boolean bl = true;
        if (_retryErrorCodes.contains("" + lDAPResponse.getResultCode())) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponseMessage() - received LDAP Response for requestID: " + request.getRequestID() + " Listener: " + request.getListener() + "Need restarting");
            }
            bl = this.resetAllSearches(false);
        } else if (lDAPResponse.getResultCode() != 0 || lDAPResponse.getResultCode() != 10) {
            LDAPException lDAPException = new LDAPException("Error result", lDAPResponse.getResultCode(), lDAPResponse.getErrorMessage(), lDAPResponse.getMatchedDN());
            this.dispatchException((Exception)((Object)lDAPException), request);
        } else {
            this.sleepRetryInterval();
        }
        return bl;
    }

    private synchronized void processSearchResultMessage(LDAPSearchResult lDAPSearchResult, Request request) {
        LDAPControl[] lDAPControlArray;
        LDAPEntry lDAPEntry = lDAPSearchResult.getEntry();
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processSearchResultMessage() - Changed " + lDAPEntry.getDN());
        }
        if ((lDAPControlArray = lDAPSearchResult.getControls()) == null) {
            Exception exception = new Exception("EventService - Cannot create NamingEvent, no change control info");
            this.dispatchException(exception, request);
        } else {
            int n = 0;
            while (n < lDAPControlArray.length) {
                LDAPEntryChangeControl lDAPEntryChangeControl = null;
                if (lDAPControlArray[n] instanceof LDAPEntryChangeControl) {
                    Object object;
                    lDAPEntryChangeControl = (LDAPEntryChangeControl)lDAPControlArray[n];
                    if (debugger.messageEnabled()) {
                        debugger.message("EventService.processSearchResultMessage() changeCtrl = " + lDAPEntryChangeControl.toString());
                    }
                    if (lDAPEntryChangeControl.getChangeType() == -1) {
                        object = new Exception("EventService - Cannot create NamingEvent, no change control info");
                        this.dispatchException((Exception)object, request);
                    }
                    try {
                        object = this.createDSEvent(lDAPEntry, lDAPEntryChangeControl, request);
                        this.dispatchEvent((DSEvent)object, request);
                    }
                    catch (Exception exception) {
                        this.dispatchException(exception, request);
                    }
                }
                ++n;
            }
        }
    }

    private void processSearchResultRef(LDAPSearchResultReference lDAPSearchResultReference, Request request) {
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processSearchResultRef() - Ignoring..");
        }
    }

    protected static SSOToken getSSOToken() throws SSOException {
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            ServerInstance serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            AuthPrincipal authPrincipal = new AuthPrincipal(serverInstance.getAuthID());
            String string = (String)AccessController.doPrivileged(new ServerInstanceAction(serverInstance));
            AuthContext authContext = new AuthContext(authPrincipal, string.toCharArray());
            return authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new SSOException(SSOProviderBundle.rbName, "invalidadmin", null);
        }
    }

    private Request getRequestEntry(int n) {
        return (Request)this._requestList.get(Integer.toString(n));
    }

    private DSEvent createDSEvent(LDAPEntry lDAPEntry, LDAPEntryChangeControl lDAPEntryChangeControl, Request request) throws Exception {
        DSEvent dSEvent = new DSEvent();
        if (debugger.messageEnabled()) {
            debugger.message("EventService.createDSEvent() - Notifying event to: " + request.getListener());
        }
        String string = lDAPEntry.getDN();
        dSEvent.setID(string);
        int n = lDAPEntryChangeControl.getChangeType();
        dSEvent.setEventType(n);
        dSEvent.setSearchID(request.getRequestID());
        String string2 = lDAPEntry.getAttribute("objectclass").toString();
        dSEvent.setClassName(string2);
        return dSEvent;
    }

    static {
        _instance = null;
        i18n = I18n.getInstance((String)"amSDK");
        debugger = Debug.getInstance((String)"amEventService");
        _allDisabled = false;
        _numRetries = 3;
        _retryInterval = 3000;
        _idleTimeOut = 0;
        listeners = new String[]{"com.iplanet.am.sdk.ldap.ACIEventListener", "com.iplanet.am.sdk.ldap.EntryEventListener", "com.sun.identity.sm.ldap.LDAPEventManager"};
        _ideListenersMap = new Hashtable();
        _listenerInitialized = false;
        _listenerInitMonitor = new Object();
        _isThreadStarted = false;
        _numRetries = EventService.getPropertyIntValue(EVENT_CONNECTION_NUM_RETRIES, _numRetries);
        _retryInterval = EventService.getPropertyIntValue(EVENT_CONNECTION_RETRY_INTERVAL, _retryInterval);
        _retryErrorCodes = EventService.getPropertyRetryErrorCodes(EVENT_CONNECTION_ERROR_CODES);
        _idleTimeOut = EventService.getPropertyIntValue(EVENT_IDLE_TIMEOUT_INTERVAL, _idleTimeOut);
        _idleTimeOutMills = _idleTimeOut * 60000;
        EventService.getListenerList();
    }
}

