/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;

class ACITargetExpression {
    private String _keyword;
    private String _operator;
    private String _value;

    ACITargetExpression(String string, String string2, String string3) {
        this._keyword = string.toLowerCase();
        this._operator = string2;
        this._value = string3;
    }

    String getKeyword() {
        return this._keyword;
    }

    String getOperator() {
        return this._operator;
    }

    String getValue() {
        return this._value;
    }

    static ACITargetExpression valueOf(String string) throws ACIParseException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf("=");
        if (n <= 0) {
            throw new ACIParseException("Malformed aci");
        }
        if (string.charAt(n - 1) == '!') {
            --n;
            string3 = "!=";
        } else {
            string3 = "=";
        }
        string2 = string.substring(1, n).trim();
        string4 = string.substring(n + string3.length(), string.length() - 1).trim();
        string4 = ACITargetExpression.trimSurroundingQuotes(string4);
        return new ACITargetExpression(string2, string3, string4);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._keyword + ":" + this._operator + ":" + this._value);
        return stringBuffer.toString();
    }

    static String trimSurroundingQuotes(String string) {
        if (string != null && string.length() > 1 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }
}

