/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc;

import com.iplanet.dpro.session.DNOrIPAddressListTokenRestriction;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.services.cdc.CDCServlet;
import com.iplanet.services.cdc.SPValidator;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LdapSPValidator
implements SPValidator {
    private AMIdentityRepository amIdRepo = null;
    private Exception exception;
    private SSOToken adminToken = null;
    private static Map idRepoMap = new HashMap();
    private static final String LDAP_ATTR_NAME = "sunIdentityServerDeviceKeyValue";
    private static final String LDAP_STATUS_ATTR_NAME = "sunIdentityServerDeviceStatus";
    private static final String PROVIDER_ID_ATTR_NAME = "agentRootURL";
    private static final int PROVIDER_ID_ATTR_LEN = 13;
    private static final String HOSTNAME_ATTR_NAME = "hostname";
    private static final int HOSTNAME_ATTR_LEN = 9;
    private static final String REALM_NAME_ATTR = "Realm=";

    public LdapSPValidator() {
        try {
            this.adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            this.amIdRepo = new AMIdentityRepository(this.adminToken, null);
            if (this.amIdRepo == null) {
                this.exception = new IdRepoException(IdRepoBundle.getString("32"), "32");
            }
        }
        catch (SSOException sSOException) {
            this.exception = sSOException;
            CDCServlet.debug.error("CDC:LdapSPValidator unable to get SSO Token: ", (Throwable)sSOException);
        }
        catch (IdRepoException idRepoException) {
            this.exception = idRepoException;
            CDCServlet.debug.error("CDC::LdapSPValidator unable to get Root Realm/Organization: ", (Throwable)idRepoException);
        }
    }

    public TokenRestriction validateAndGetRestriction(FSAuthnRequest fSAuthnRequest, String string) throws Exception {
        CharSequence charSequence;
        int n;
        if (this.exception != null) {
            throw this.exception;
        }
        String string2 = null;
        URL uRL = new URL(fSAuthnRequest.getProviderId());
        if (uRL.getQuery() != null && (n = ((String)(charSequence = uRL.getQuery())).indexOf(REALM_NAME_ATTR)) != -1) {
            string2 = ((String)charSequence).substring(n + REALM_NAME_ATTR.length() + 1);
        }
        charSequence = new StringBuffer(50);
        ((StringBuffer)charSequence).append(uRL.getProtocol()).append("://").append(uRL.getHost()).append(":").append(uRL.getPort()).append("/");
        try {
            Map map = this.searchAgents((StringBuffer)charSequence, string2);
            if (map.size() == 0) {
                if (CDCServlet.debug.warningEnabled()) {
                    CDCServlet.debug.warning("CDC Component: Invalid agent ID: " + charSequence);
                }
                throw new Exception("Invalid Agent: Not configured in directory");
            }
            String string3 = null;
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            boolean bl2 = false;
            URL uRL2 = new URL(string);
            String string4 = uRL2.getHost().toLowerCase();
            String string5 = uRL2.getProtocol().toLowerCase();
            int n2 = uRL2.getPort();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator.next();
                string3 = IdUtils.getDN(aMIdentity);
                Map map2 = aMIdentity.getAttributes();
                bl = this.isAgentActive(map2);
                if (!bl || !this.validateGotoUrlAndUpdateHostList(map2, arrayList, bl2, string4, string5, n2)) continue;
                bl2 = true;
            }
            if (!bl) {
                if (CDCServlet.debug.warningEnabled()) {
                    CDCServlet.debug.warning("Invalid request for Agent ID: " + charSequence);
                }
                throw new Exception("Agent is not active");
            }
            if (!bl2) {
                if (CDCServlet.debug.warningEnabled()) {
                    CDCServlet.debug.warning("Invalid GoTo URL: " + string + " for Agent ID: " + charSequence);
                }
                throw new Exception("Goto URL not valid for the agent Provider ID");
            }
            if (CDCServlet.debug.messageEnabled()) {
                CDCServlet.debug.message("CDC Servlet: Restriction string for: " + charSequence + " is: " + string3 + " " + arrayList);
            }
            return new DNOrIPAddressListTokenRestriction(string3, arrayList);
        }
        catch (Exception exception) {
            throw new Exception("Invalid Agent: Could not get agent for the realm");
        }
    }

    private Map searchAgents(StringBuffer stringBuffer, String string) throws Exception {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("agentRootURL=" + stringBuffer.toString());
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        hashMap.put(LDAP_ATTR_NAME, hashSet);
        IdSearchControl idSearchControl = new IdSearchControl();
        idSearchControl.setRecursive(true);
        idSearchControl.setTimeOut(0);
        idSearchControl.setMaxResults(0);
        idSearchControl.setSearchModifiers(IdSearchOpModifier.AND, hashMap);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(LDAP_ATTR_NAME);
        hashSet2.add(LDAP_STATUS_ATTR_NAME);
        idSearchControl.setReturnAttributes(hashSet2);
        IdSearchResults idSearchResults = null;
        try {
            if (string != null) {
                object = new AMIdentityRepository(this.adminToken, string);
                if (CDCServlet.debug.messageEnabled()) {
                    CDCServlet.debug.message("CDC Servlet: Searching under Realm : " + string);
                }
                idSearchResults = ((AMIdentityRepository)object).searchIdentities(IdType.AGENT, "*", idSearchControl);
            } else {
                idSearchResults = this.amIdRepo.searchIdentities(IdType.AGENT, "*", idSearchControl);
            }
        }
        catch (IdRepoException idRepoException) {
            this.exception = idRepoException;
            CDCServlet.debug.error("CDC Servlet:getAMIdentityRepository : IdRepoException: ", (Throwable)idRepoException);
            throw this.exception;
        }
        catch (SSOException sSOException) {
            this.exception = sSOException;
            CDCServlet.debug.error("CDC Servlet:getAMIdentityRepository : SSOException: ", (Throwable)sSOException);
            throw this.exception;
        }
        object = idSearchResults.getResultAttributes();
        if (CDCServlet.debug.messageEnabled()) {
            CDCServlet.debug.message("CDC Servlet: Directory matches for " + stringBuffer + " is:" + object);
        }
        return object;
    }

    private boolean isAgentActive(Map map) {
        String string;
        Set set;
        boolean bl = false;
        if (map != null && (set = (Set)map.get(LDAP_STATUS_ATTR_NAME)) != null && !set.isEmpty() && (string = (String)set.iterator().next()).equalsIgnoreCase("Active")) {
            bl = true;
        }
        return bl;
    }

    private boolean validateGotoUrlAndUpdateHostList(Map map, ArrayList arrayList, boolean bl, String string, String string2, int n) throws MalformedURLException {
        Set set;
        boolean bl2 = false;
        if (map != null && (set = (Set)map.get(LDAP_ATTR_NAME)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.startsWith(PROVIDER_ID_ATTR_NAME)) {
                    URL uRL = new URL(string3.substring(13));
                    arrayList.add(uRL.getHost());
                    if (bl || !uRL.getHost().toLowerCase().equals(string) || !uRL.getProtocol().toLowerCase().equals(string2) || uRL.getPort() != n) continue;
                    bl2 = true;
                    continue;
                }
                if (!string3.startsWith(HOSTNAME_ATTR_NAME)) continue;
                arrayList.add(string3.substring(9));
            }
        }
        return bl2;
    }
}

