/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVA;
import com.iplanet.security.x509.CertParseError;
import com.iplanet.security.x509.LdapDNStrConverter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class RDN {
    private AVA[] assertion;

    public RDN(String string) throws IOException {
        RDN rDN = LdapDNStrConverter.getDefault().parseRDN(string);
        this.assertion = rDN.getAssertion();
    }

    public RDN(String string, byte[] byArray) throws IOException {
        RDN rDN = LdapDNStrConverter.getDefault().parseRDN(string, byArray);
        this.assertion = rDN.getAssertion();
    }

    public RDN(String string, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        RDN rDN = ldapDNStrConverter.parseRDN(string);
        this.assertion = rDN.getAssertion();
    }

    public RDN(DerValue derValue) throws IOException {
        int n;
        if (derValue.tag != 49) {
            throw new CertParseError("X500 RDN");
        }
        int n2 = 50;
        AVA[] aVAArray = new AVA[n2];
        for (n = 0; n < n2; ++n) {
            aVAArray[n] = new AVA(derValue.data);
            if (derValue.data.available() == 0) break;
        }
        if (n >= n2 - 1) {
            this.assertion = new AVA[n + 1];
        } else {
            this.assertion = new AVA[n + 1];
            for (int i = 0; i < n + 1; ++i) {
                this.assertion[i] = aVAArray[i];
            }
        }
    }

    public RDN(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSet(1);
        this.assertion = new AVA[derValueArray.length];
        for (int i = 0; i < this.assertion.length; ++i) {
            this.assertion[i] = new AVA(derValueArray[i].data);
        }
    }

    public RDN(AVA[] aVAArray) {
        this.assertion = (AVA[])aVAArray.clone();
    }

    public RDN(Vector vector) {
        int n = vector.size();
        this.assertion = new AVA[n];
        for (int i = 0; i < n; ++i) {
            this.assertion[i] = (AVA)vector.elementAt(i);
        }
    }

    public AVA[] getAssertion() {
        return (AVA[])this.assertion.clone();
    }

    public int getAssertionLength() {
        return this.assertion.length;
    }

    public boolean equals(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            if (this.assertion[i].equals(rDN.assertion[i])) continue;
            return false;
        }
        return true;
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        for (int i = 0; i < this.assertion.length; ++i) {
            if (!this.assertion[i].oid.equals(objectIdentifier)) continue;
            return this.assertion[i].value;
        }
        return null;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.assertion.length; ++i) {
            this.assertion[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)49, derOutputStream2);
    }

    public Enumeration getAVAs() {
        return new AVAEnumerator();
    }

    public String toLdapDNString() throws IOException {
        return LdapDNStrConverter.getDefault().encodeRDN(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeRDN(this);
    }

    public String toString() {
        String string;
        try {
            string = this.toLdapDNString();
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    private class AVAEnumerator
    implements Enumeration {
        private int index = 0;

        public boolean hasMoreElements() {
            return this.index < RDN.this.assertion.length;
        }

        public Object nextElement() {
            Object var1_1 = null;
            if (this.index >= RDN.this.assertion.length) {
                return null;
            }
            return RDN.this.assertion[this.index++];
        }
    }
}

