/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVA;
import com.iplanet.security.x509.AVAValueConverter;
import com.iplanet.security.x509.GenericValueConverter;
import com.iplanet.security.x509.LdapDNStrConverter;
import com.iplanet.security.x509.RDN;
import com.iplanet.security.x509.X500Name;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import sun.io.ByteToCharConverter;

public class LdapV3DNStrConverter
extends LdapDNStrConverter {
    protected X500NameAttrMap attrMap;
    protected boolean acceptUnknownOids;
    protected static final String specialChars = ",+=<>#;";
    protected static final String valueEndChars = "+,;>";
    protected static final String quotedEndChars = "\"";
    protected static final String octoEndChars = " +,;>";
    protected static final String hexDigits = "0123456789ABCDEFabcdef";

    public LdapV3DNStrConverter() {
        this.attrMap = X500NameAttrMap.getDefault();
        this.acceptUnknownOids = true;
    }

    public LdapV3DNStrConverter(X500NameAttrMap x500NameAttrMap, boolean bl) {
        this.attrMap = x500NameAttrMap;
        this.acceptUnknownOids = bl;
    }

    public X500Name parseDN(String string) throws IOException {
        return this.parseDN(string, null);
    }

    public X500Name parseDN(String string, byte[] byArray) throws IOException {
        StringReader stringReader = new StringReader(string);
        PushbackReader pushbackReader = new PushbackReader(stringReader, 5);
        Vector vector = new Vector();
        return this.parseDN(pushbackReader, byArray);
    }

    public RDN parseRDN(String string) throws IOException {
        return this.parseRDN(string, null);
    }

    public RDN parseRDN(String string, byte[] byArray) throws IOException {
        StringReader stringReader = new StringReader(string);
        PushbackReader pushbackReader = new PushbackReader(stringReader, 5);
        Vector vector = new Vector();
        return this.parseRDN(pushbackReader, null);
    }

    public AVA parseAVA(String string) throws IOException {
        return this.parseAVA(string, null);
    }

    public AVA parseAVA(String string, byte[] byArray) throws IOException {
        StringReader stringReader = new StringReader(string);
        PushbackReader pushbackReader = new PushbackReader(stringReader, 5);
        return this.parseAVA(pushbackReader, byArray);
    }

    public X500Name parseDN(PushbackReader pushbackReader) throws IOException {
        return this.parseDN(pushbackReader, null);
    }

    public X500Name parseDN(PushbackReader pushbackReader, byte[] byArray) throws IOException {
        int n;
        Vector<RDN> vector = new Vector<RDN>();
        do {
            RDN rDN = this.parseRDN(pushbackReader, byArray);
            vector.addElement(rDN);
        } while ((n = pushbackReader.read()) == 44 || n == 59);
        RDN[] rDNArray = new RDN[vector.size()];
        int n2 = 0;
        int n3 = vector.size() - 1;
        while (n2 < vector.size()) {
            rDNArray[n3] = (RDN)vector.elementAt(n2);
            ++n2;
            --n3;
        }
        return new X500Name(rDNArray);
    }

    public RDN parseRDN(PushbackReader pushbackReader) throws IOException {
        return this.parseRDN(pushbackReader, null);
    }

    public RDN parseRDN(PushbackReader pushbackReader, byte[] byArray) throws IOException {
        int n;
        Vector<AVA> vector = new Vector<AVA>();
        do {
            AVA aVA = this.parseAVA(pushbackReader, byArray);
            vector.addElement(aVA);
        } while ((n = pushbackReader.read()) == 43);
        if (n != -1) {
            pushbackReader.unread(n);
        }
        AVA[] aVAArray = new AVA[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            aVAArray[i] = (AVA)vector.elementAt(i);
        }
        return new RDN(aVAArray);
    }

    public AVA parseAVA(PushbackReader pushbackReader) throws IOException {
        return this.parseAVA(pushbackReader, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AVA parseAVA(PushbackReader pushbackReader, byte[] byArray) throws IOException {
        DerValue derValue;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = pushbackReader.read()) != 61) {
            if (n == -1) {
                throw new IOException("Bad AVA format: Missing '='");
            }
            stringBuffer.append((char)n);
        }
        ObjectIdentifier objectIdentifier = this.parseAVAKeyword(stringBuffer.toString());
        n = pushbackReader.read();
        while (n == 32) {
            n = pushbackReader.read();
        }
        if (n == -1) {
            throw new IOException("Bad AVA format: Missing attribute value");
        }
        if (n == 35) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                n = pushbackReader.read();
                char c = (char)n;
                if (n == -1 || octoEndChars.indexOf(n) > 0) break;
                n = pushbackReader.read();
                char c2 = (char)n;
                if (hexDigits.indexOf(c) == -1 || hexDigits.indexOf(c2) == -1) {
                    throw new IOException("Bad AVA value: bad hex value.");
                }
                int n2 = (Character.digit(c, 16) << 4) + Character.digit(c2, 16);
                byteArrayOutputStream.write(n2);
            }
            if (byteArrayOutputStream.size() == 0) {
                throw new IOException("bad AVA format: invalid hex value");
            }
            derValue = this.parseAVAValue(byteArrayOutputStream.toByteArray(), objectIdentifier);
            while (n == 32 && n != -1) {
                n = pushbackReader.read();
            }
        } else {
            String string;
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            if (n == 34) {
                bl = true;
                string = quotedEndChars;
                n = pushbackReader.read();
                if (n == -1) {
                    throw new IOException("Bad AVA format: Missing attrValue");
                }
            } else {
                string = valueEndChars;
            }
            while (n != -1 && string.indexOf(n) == -1) {
                if (n == 92) {
                    n = pushbackReader.read();
                    if (n == -1) {
                        throw new IOException("Bad AVA format: expecting escaped char.");
                    }
                    if (specialChars.indexOf((char)n) != -1 || n == 10 || n == 92 || n == 34 || n == 32) {
                        stringBuffer2.append((char)n);
                    } else {
                        CharArrayWriter charArrayWriter;
                        block25: {
                            if (hexDigits.indexOf(n) == -1) throw new IOException("Bad AVA format: invalid escaping");
                            charArrayWriter = new CharArrayWriter();
                            do {
                                char c = (char)n;
                                n = pushbackReader.read();
                                char c3 = (char)n;
                                if (hexDigits.indexOf((char)n) == -1) {
                                    throw new IOException("Bad AVA format: invalid escaped hex pair");
                                }
                                charArrayWriter.write(c);
                                charArrayWriter.write(c3);
                                n = pushbackReader.read();
                                if (n == -1) break block25;
                                if (n != 92) {
                                    pushbackReader.unread(n);
                                    break block25;
                                }
                                n = pushbackReader.read();
                                if (n != -1) continue;
                                throw new IOException("Bad AVA format: expecting escaped char.");
                            } while (hexDigits.indexOf((char)n) != -1);
                            pushbackReader.unread(n);
                            pushbackReader.unread(92);
                        }
                        stringBuffer2.append(LdapV3DNStrConverter.getStringFromHexpairs(charArrayWriter.toCharArray()));
                    }
                } else {
                    stringBuffer2.append((char)n);
                }
                n = pushbackReader.read();
            }
            derValue = this.parseAVAValue(stringBuffer2.toString().trim(), objectIdentifier, byArray);
            if (bl) {
                while ((n = pushbackReader.read()) == 32) {
                }
                if (n != -1 && valueEndChars.indexOf(n) == -1) {
                    throw new IOException("Bad AVA format: separator expected at end of ava.");
                }
            }
        }
        if (n == -1) return new AVA(objectIdentifier, derValue);
        pushbackReader.unread(n);
        return new AVA(objectIdentifier, derValue);
    }

    public ObjectIdentifier parseAVAKeyword(String string) throws IOException {
        ObjectIdentifier objectIdentifier;
        String string2 = string.toUpperCase().trim();
        String string3 = null;
        if (Character.digit(string2.charAt(0), 10) != -1) {
            string3 = string2;
        } else if (string2.startsWith("oid.") || string2.startsWith("OID.")) {
            string3 = string2.substring(4);
        }
        if (string3 != null) {
            ObjectIdentifier objectIdentifier2 = new ObjectIdentifier(string3);
            objectIdentifier = this.attrMap.getOid(objectIdentifier2);
            if (objectIdentifier == null) {
                if (!this.acceptUnknownOids) {
                    throw new IOException("Unknown AVA OID.");
                }
                objectIdentifier = objectIdentifier2;
            }
        } else {
            objectIdentifier = this.attrMap.getOid(string2);
            if (objectIdentifier == null) {
                throw new IOException("Unknown AVA keyword '" + string2 + "'.");
            }
        }
        return objectIdentifier;
    }

    public DerValue parseAVAValue(String string, ObjectIdentifier objectIdentifier) throws IOException {
        return this.parseAVAValue(string, objectIdentifier, null);
    }

    public DerValue parseAVAValue(String string, ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        AVAValueConverter aVAValueConverter = this.attrMap.getValueConverter(objectIdentifier);
        if (aVAValueConverter == null) {
            if (!this.acceptUnknownOids) {
                throw new IllegalArgumentException("Unrecognized OID for AVA value conversion");
            }
            aVAValueConverter = new GenericValueConverter();
        }
        return aVAValueConverter.getValue(string, byArray);
    }

    public DerValue parseAVAValue(byte[] byArray, ObjectIdentifier objectIdentifier) throws IOException {
        AVAValueConverter aVAValueConverter = this.attrMap.getValueConverter(objectIdentifier);
        if (aVAValueConverter == null && !this.acceptUnknownOids) {
            throw new IllegalArgumentException("Unrecognized OID for AVA value conversion");
        }
        aVAValueConverter = new GenericValueConverter();
        return aVAValueConverter.getValue(byArray);
    }

    public String encodeDN(X500Name x500Name) throws IOException {
        RDN[] rDNArray = x500Name.getNames();
        StringBuffer stringBuffer = new StringBuffer();
        if (rDNArray.length == 0) {
            return "";
        }
        int n = rDNArray.length - 1;
        stringBuffer.append(this.encodeRDN(rDNArray[n--]));
        while (n >= 0) {
            String string = this.encodeRDN(rDNArray[n--]);
            stringBuffer.append(",");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String encodeRDN(RDN rDN) throws IOException {
        AVA[] aVAArray = rDN.getAssertion();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(this.encodeAVA(aVAArray[n++]));
        while (n < aVAArray.length) {
            String string = this.encodeAVA(aVAArray[n++]);
            stringBuffer.append("+");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String encodeAVA(AVA aVA) throws IOException {
        ObjectIdentifier objectIdentifier = aVA.getOid();
        DerValue derValue = aVA.getValue();
        String string = this.encodeOID(objectIdentifier);
        String string2 = this.encodeValue(derValue, objectIdentifier);
        return string + "=" + string2;
    }

    public String encodeOID(ObjectIdentifier objectIdentifier) throws IOException {
        String string = this.attrMap.getName(objectIdentifier);
        if (string == null) {
            if (this.acceptUnknownOids) {
                string = objectIdentifier.toString();
            } else {
                throw new IOException("Unknown OID");
            }
        }
        return string;
    }

    public String encodeValue(DerValue derValue, ObjectIdentifier objectIdentifier) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(30);
        String string = null;
        AVAValueConverter aVAValueConverter = this.attrMap.getValueConverter(objectIdentifier);
        if (aVAValueConverter == null) {
            if (this.acceptUnknownOids) {
                aVAValueConverter = new GenericValueConverter();
            } else {
                throw new IOException("Unknown AVA type for encoding AVA value");
            }
        }
        try {
            string = aVAValueConverter.getAsString(derValue);
            if (string == null) {
                byte[] byArray = derValue.toByteArray();
                stringBuffer.append('#');
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(hexDigits.charAt(byArray[i] >> 4 & 0xF));
                    stringBuffer.append(hexDigits.charAt(byArray[i] & 0xF));
                }
            } else {
                stringBuffer.append(this.encodeString(string));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("malformed AVA DER Value");
        }
        return stringBuffer.toString();
    }

    public String encodeString(String string) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        for (n2 = n3 - 1; n2 >= 0 && string.charAt(n2) == ' '; --n2) {
        }
        for (n = 0; n <= n2 && string.charAt(n) == ' '; ++n) {
            stringBuffer.append('\\');
            stringBuffer.append(string.charAt(n));
        }
        while (n <= n2) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append(string.charAt(n));
            } else if (specialChars.indexOf(string.charAt(n)) != -1) {
                stringBuffer.append('\\');
                stringBuffer.append(string.charAt(n));
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        while (n < string.length()) {
            stringBuffer.append('\\');
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public X500NameAttrMap getAttrMap() {
        return this.attrMap;
    }

    public boolean getAcceptUnknownOids() {
        return this.acceptUnknownOids;
    }

    protected static char[] getStringFromHexpairs(char[] cArray) throws UnsupportedEncodingException {
        int n;
        ByteToCharConverter byteToCharConverter;
        try {
            byteToCharConverter = ByteToCharConverter.getConverter((String)"UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedEncodingException("No UTF8 byte to char converter to use for parsing LDAP DN String");
        }
        byteToCharConverter.setSubstitutionMode(false);
        byte[] byArray = new byte[cArray.length / 2];
        char[] cArray2 = new char[byArray.length * byteToCharConverter.getMaxCharsPerByte()];
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            byArray[n3] = (byte)((Character.digit(cArray[n2++], 16) << 4) + Character.digit(cArray[n2], 16));
            ++n2;
            ++n3;
        }
        try {
            n = byteToCharConverter.convert(byArray, 0, byArray.length, cArray2, 0, cArray2.length);
        }
        catch (CharConversionException charConversionException) {
            throw new IllegalArgumentException("Invalid hex pair in LDAP DN String.");
        }
        char[] cArray3 = new char[n];
        System.arraycopy(cArray2, 0, cArray3, 0, n);
        return cArray3;
    }
}

