/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.x509.GeneralNamesException;
import com.iplanet.security.x509.RDN;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.x509.GeneralNames;

public class IssuingDistributionPoint
implements ASN1Value {
    private GeneralNames fullName = null;
    private RDN relativeName = null;
    private boolean onlyContainsUserCerts = false;
    private boolean onlyContainsCACerts = false;
    private BitArray onlySomeReasons = null;
    private boolean indirectCRL = false;
    private ANY fullNameEncoding;
    private static final Tag TAG = SEQUENCE.TAG;

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public void setFullName(GeneralNames generalNames) throws GeneralNamesException, IOException {
        this.fullName = generalNames;
        if (generalNames != null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            generalNames.encode(derOutputStream);
            try {
                ANY aNY = new ANY(derOutputStream.toByteArray());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                aNY.encodeWithAlternateTag(Tag.get((long)0L), (OutputStream)byteArrayOutputStream);
                this.fullNameEncoding = new ANY(byteArrayOutputStream.toByteArray());
            }
            catch (InvalidBERException invalidBERException) {
                throw new GeneralNamesException(invalidBERException.toString());
            }
            this.relativeName = null;
        }
    }

    public void setRelativeName(RDN rDN) {
        this.relativeName = rDN;
        if (rDN != null) {
            this.fullName = null;
        }
    }

    public boolean getOnlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public void setOnlyContainsUserCerts(boolean bl) {
        this.onlyContainsUserCerts = bl;
    }

    public boolean getOnlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public void setOnlyContainsCACerts(boolean bl) {
        this.onlyContainsCACerts = bl;
    }

    public BitArray getOnlySomeReasons() {
        return this.onlySomeReasons;
    }

    public void setOnlySomeReasons(BitArray bitArray) {
        this.onlySomeReasons = bitArray;
    }

    public boolean getIndirectCRL() {
        return this.indirectCRL;
    }

    public void setIndirectCRL(boolean bl) {
        this.indirectCRL = bl;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        try {
            ANY aNY;
            ByteArrayOutputStream byteArrayOutputStream;
            com.iplanet.security.util.DerOutputStream derOutputStream;
            EXPLICIT eXPLICIT;
            if (this.fullName != null) {
                eXPLICIT = new EXPLICIT(Tag.get((long)0L), (ASN1Value)this.fullNameEncoding);
                sEQUENCE.addElement((ASN1Value)eXPLICIT);
            } else if (this.relativeName != null) {
                derOutputStream = new com.iplanet.security.util.DerOutputStream();
                this.relativeName.encode(derOutputStream);
                eXPLICIT = new ANY(derOutputStream.toByteArray());
                byteArrayOutputStream = new ByteArrayOutputStream();
                eXPLICIT.encodeWithAlternateTag(Tag.get((long)1L), (OutputStream)byteArrayOutputStream);
                aNY = new ANY(byteArrayOutputStream.toByteArray());
                EXPLICIT eXPLICIT2 = new EXPLICIT(Tag.get((long)0L), (ASN1Value)aNY);
                sEQUENCE.addElement((ASN1Value)eXPLICIT2);
            }
            if (this.onlyContainsUserCerts) {
                sEQUENCE.addElement(Tag.get((long)1L), (ASN1Value)new BOOLEAN(true));
            }
            if (this.onlyContainsCACerts) {
                sEQUENCE.addElement(Tag.get((long)2L), (ASN1Value)new BOOLEAN(true));
            }
            if (this.onlySomeReasons != null) {
                derOutputStream = new com.iplanet.security.util.DerOutputStream();
                derOutputStream.putUnalignedBitString(this.onlySomeReasons);
                eXPLICIT = new ANY(derOutputStream.toByteArray());
                byteArrayOutputStream = new ByteArrayOutputStream();
                eXPLICIT.encodeWithAlternateTag(Tag.get((long)3L), (OutputStream)byteArrayOutputStream);
                aNY = new ANY(byteArrayOutputStream.toByteArray());
                sEQUENCE.addElement((ASN1Value)aNY);
            }
            if (this.indirectCRL) {
                sEQUENCE.addElement(Tag.get((long)4L), (ASN1Value)new BOOLEAN(true));
            }
            sEQUENCE.encode(tag, outputStream);
        }
        catch (InvalidBERException invalidBERException) {
            throw new IOException(invalidBERException.toString());
        }
    }
}

