/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class GenericValueConverter
implements AVAValueConverter {
    private static byte[] DefEncodingTags = new byte[]{19, 22, 30, 12, 20, 28};

    public DerValue getValue(String string) throws IOException {
        return this.getValue(string, null);
    }

    public DerValue getValue(String string, byte[] byArray) throws IOException {
        int n;
        int n2 = -1;
        if (byArray == null || byArray.length == 0) {
            byArray = DefEncodingTags;
        }
        byte[] byArray2 = new byte[4 * string.length()];
        for (n = 0; n < byArray.length; ++n) {
            try {
                CharToByteConverter charToByteConverter = ASN1CharStrConvMap.getDefault().getCBC(byArray[n]);
                if (charToByteConverter == null) continue;
                n2 = charToByteConverter.convert(string.toCharArray(), 0, string.length(), byArray2, 0, byArray2.length);
                break;
            }
            catch (CharConversionException charConversionException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Cannot instantiate CharToByteConverter");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Illegal Access loading CharToByteConverter");
            }
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("Cannot convert the string value to a ASN.1 type");
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        return new DerValue(byArray[n], byArray3);
    }

    public DerValue getValue(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        return derValue;
    }

    public String getAsString(DerValue derValue) throws IOException {
        return derValue.getASN1CharString();
    }
}

