/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerEncoder;
import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.CertParseError;
import com.iplanet.security.x509.LdapDNStrConverter;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;

public final class AVA
implements DerEncoder {
    ObjectIdentifier oid;
    DerValue value;

    public AVA(String string) throws IOException {
        AVA aVA = LdapDNStrConverter.getDefault().parseAVA(string);
        this.oid = aVA.getOid();
        this.value = aVA.getValue();
    }

    public AVA(String string, byte[] byArray) throws IOException {
        AVA aVA = LdapDNStrConverter.getDefault().parseAVA(string, byArray);
        this.oid = aVA.getOid();
        this.value = aVA.getValue();
    }

    public AVA(String string, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        AVA aVA = ldapDNStrConverter.parseAVA(string);
        this.oid = aVA.getOid();
        this.value = aVA.getValue();
    }

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    public AVA(InputStream inputStream) throws IOException {
        ByteToCharConverter byteToCharConverter;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        try {
            byteToCharConverter = ByteToCharConverter.getConverter((String)"UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("UTF8 encoding not supported");
        }
        char[] cArray = byteToCharConverter.convertAll(byArray);
        stringBuffer.append(cArray);
        AVA aVA = LdapDNStrConverter.getDefault().parseAVA(stringBuffer.toString());
        this.oid = aVA.getOid();
        this.value = aVA.getValue();
    }

    public AVA(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        if (derValue.tag != 48) {
            throw new CertParseError("X500 AVA, not a sequence");
        }
        ObjectIdentifier objectIdentifier = derValue.data.getOID();
        this.oid = X500NameAttrMap.getDefault().getOid(objectIdentifier);
        if (this.oid == null) {
            this.oid = objectIdentifier;
        }
        this.value = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new CertParseError("AVA, extra bytes = " + derValue.data.available());
        }
    }

    public boolean equals(AVA aVA) {
        return this.oid.equals(aVA.oid) && this.value.equals(aVA.value);
    }

    public boolean equals(Object object) {
        if (object instanceof AVA) {
            return this.equals((AVA)object);
        }
        return false;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public String toLdapDNString() throws IOException {
        LdapDNStrConverter ldapDNStrConverter = LdapDNStrConverter.getDefault();
        return ldapDNStrConverter.encodeAVA(this);
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        return ldapDNStrConverter.encodeAVA(this);
    }

    public String toString() {
        String string;
        try {
            string = this.toLdapDNString();
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public DerValue getValue() {
        return this.value;
    }
}

