/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.BigInt;
import com.iplanet.security.util.ByteArrayLexOrder;
import com.iplanet.security.util.ByteArrayTagOrder;
import com.iplanet.security.util.DerEncoder;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sun.io.CharToByteConverter;
import sun.security.util.BitArray;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();
    private static Calendar GMTGregorianCalendar = null;

    public DerOutputStream(int n) {
        super(n);
    }

    public DerOutputStream() {
    }

    public void write(byte by, byte[] byArray) throws IOException {
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void writeImplicit(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.encode(this);
    }

    public void putBoolean(boolean bl) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putInteger(BigInt bigInt) throws IOException {
        this.putUnsignedInteger(bigInt.toByteArray());
    }

    public void putUnsignedInteger(byte[] byArray) throws IOException {
        this.write(2);
        if ((byArray[0] & 0x80) != 0) {
            this.putLength(byArray.length + 1);
            this.write(0);
        } else {
            this.putLength(byArray.length);
        }
        this.write(byArray, 0, byArray.length);
    }

    public void putEnumerated(int n) throws IOException {
        this.write(10);
        int n2 = -16777216;
        int n3 = Integer.MIN_VALUE;
        if ((n & Integer.MIN_VALUE) != 0) {
            int n4;
            for (n4 = 4; n4 > 1 && (n & n2) == n2; --n4) {
                n2 >>>= 8;
                n3 >>>= 8;
            }
            if ((n & n3) == 0) {
                this.putLength(n4 + 1);
                this.write(255);
            } else {
                this.putLength(n4);
            }
            switch (n4) {
                case 4: {
                    this.write((byte)(n >>> 24));
                }
                case 3: {
                    this.write((byte)(n >>> 16));
                }
                case 2: {
                    this.write((byte)(n >>> 8));
                }
                case 1: {
                    this.write((byte)n);
                }
            }
        } else {
            int n5;
            for (n5 = 4; n5 > 0 && (n & n2) == 0; --n5) {
                n2 >>>= 8;
                n3 >>>= 8;
            }
            if ((n & n3) != 0) {
                this.putLength(n5 + 1);
                this.write(0);
            } else {
                this.putLength(n5);
            }
            switch (n5) {
                case 4: {
                    this.write((byte)(n >>> 24));
                }
                case 3: {
                    this.write((byte)(n >>> 16));
                }
                case 2: {
                    this.write((byte)(n >>> 8));
                }
                case 1: {
                    this.write((byte)n);
                }
            }
        }
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    private static BitArray toBitArray(boolean[] blArray) {
        int n;
        if (blArray.length == 0) {
            return new BitArray(blArray);
        }
        for (n = blArray.length - 1; n >= 0 && !blArray[n]; --n) {
        }
        int n2 = n + 1;
        if (n2 != blArray.length) {
            boolean[] blArray2 = new boolean[n2];
            System.arraycopy(blArray, 0, blArray2, 0, n2);
            blArray = blArray2;
        }
        return new BitArray(blArray);
    }

    private static BitArray toBitArray(byte[] byArray) {
        int n;
        int n2 = 0;
        if (byArray.length == 0) {
            return new BitArray(0, byArray);
        }
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == 0) continue;
            n2 = n;
        }
        byte by = byArray[n2];
        int n3 = (n2 + 1) * 8;
        for (n = 1; n <= 128 && (by & n) == 0; n <<= 1) {
            --n3;
        }
        return new BitArray(n3, byArray);
    }

    public void putUnalignedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(byArray.length * 8 - bitArray.length());
        this.write(byArray);
    }

    public void putUnalignedBitString(byte[] byArray) throws IOException {
        this.putUnalignedBitString(DerOutputStream.toBitArray(byArray));
    }

    public void putUnalignedBitString(boolean[] blArray) throws IOException {
        this.putUnalignedBitString(DerOutputStream.toBitArray(blArray));
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.encode(this);
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derValueArray[i].encode(derOutputStream);
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derValueArray.length; ++i) {
            derValueArray[i].encode(derOutputStream);
        }
        this.write((byte)49, derOutputStream);
    }

    public void putSet(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, null);
    }

    public void putOrderedSetOf(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, lexOrder);
    }

    public void putOrderedSet(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, tagOrder);
    }

    private void putOrderedSet(byte by, DerEncoder[] derEncoderArray, Comparator comparator) throws IOException {
        DerOutputStream[] derOutputStreamArray = new DerOutputStream[derEncoderArray.length];
        for (int i = 0; i < derEncoderArray.length; ++i) {
            derOutputStreamArray[i] = new DerOutputStream();
            derEncoderArray[i].derEncode(derOutputStreamArray[i]);
        }
        byte[][] byArrayArray = new byte[derOutputStreamArray.length][];
        for (int i = 0; i < derOutputStreamArray.length; ++i) {
            byArrayArray[i] = derOutputStreamArray[i].toByteArray();
        }
        if (comparator != null) {
            Arrays.sort(byArrayArray, comparator);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < derOutputStreamArray.length; ++i) {
            derOutputStream.write(byArrayArray[i]);
        }
        this.write(by, derOutputStream);
    }

    public void putPrintableString(String string) throws IOException {
        this.putStringType((byte)19, string);
    }

    public void putVisibleString(String string) throws IOException {
        this.putStringType((byte)26, string);
    }

    public void putBMPString(String string) throws IOException {
        this.putStringType((byte)30, string);
    }

    public void putUTF8String(String string) throws IOException {
        this.putStringType((byte)12, string);
    }

    public void putIA5String(String string) throws IOException {
        this.putStringType((byte)22, string);
    }

    public void putStringType(byte by, String string) throws IOException {
        int n;
        byte[] byArray;
        try {
            CharToByteConverter charToByteConverter = ASN1CharStrConvMap.getDefault().getCBC(by);
            if (charToByteConverter == null) {
                throw new IOException("No character to byte converter for tag");
            }
            byArray = new byte[charToByteConverter.getMaxBytesPerChar() * string.length()];
            n = charToByteConverter.convert(string.toCharArray(), 0, string.length(), byArray, 0, byArray.length);
        }
        catch (CharConversionException charConversionException) {
            throw new IOException("Not a valid string type " + by);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Cannot load CharToByteConverter class for DER tag " + by);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Cannot instantiate CharToByteConverter class for DER tag " + by);
        }
        this.write(by);
        int n2 = 0;
        if (by == 30 && byArray[0] == -2) {
            n2 = 2;
            n -= 2;
        }
        this.putLength(n);
        this.write(byArray, n2, n);
    }

    private void put2DateBytes(byte[] byArray, int n, int n2) {
        int n3 = n / 10;
        int n4 = n % 10;
        byArray[n2] = (byte)((byte)n3 + 48);
        byArray[n2 + 1] = (byte)((byte)n4 + 48);
    }

    private Calendar getGMTGregorianCalendar() {
        if (GMTGregorianCalendar == null) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GMTGregorianCalendar = new GregorianCalendar(timeZone);
        }
        return (Calendar)GMTGregorianCalendar.clone();
    }

    public byte[] getDateBytes(Date date, boolean bl) {
        byte[] byArray = bl ? new byte[13] : new byte[15];
        Calendar calendar = this.getGMTGregorianCalendar();
        calendar.setTime(date);
        int n = 0;
        if (!bl) {
            this.put2DateBytes(byArray, calendar.get(1) / 100, n);
            n += 2;
        }
        this.put2DateBytes(byArray, calendar.get(1) % 100, n);
        this.put2DateBytes(byArray, calendar.get(2) + 1, n += 2);
        this.put2DateBytes(byArray, calendar.get(5), n += 2);
        this.put2DateBytes(byArray, calendar.get(11), n += 2);
        this.put2DateBytes(byArray, calendar.get(12), n += 2);
        this.put2DateBytes(byArray, calendar.get(13), n += 2);
        byArray[n += 2] = 90;
        return byArray;
    }

    public void putUTCTime(Date date) throws IOException {
        byte[] byArray = this.getDateBytes(date, true);
        this.write(23);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyyyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(24);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putLength(int n) throws IOException {
        if (n < 128) {
            this.write((byte)n);
        } else if (n < 256) {
            this.write(-127);
            this.write((byte)n);
        } else if (n < 65536) {
            this.write(-126);
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else if (n < 0x1000000) {
            this.write(-125);
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else {
            this.write(-124);
            this.write((byte)(n >> 24));
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        }
    }

    public void putTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        this.write(by3);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }
}

