/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.BigInt;
import com.iplanet.security.util.DerInputBuffer;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import sun.security.util.BitArray;

public class DerInputStream {
    DerInputBuffer buffer;

    public DerInputStream(byte[] byArray) {
        this.buffer = new DerInputBuffer(byArray);
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] byArray, int n, int n2) {
        this.buffer = new DerInputBuffer(byArray, n, n2);
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int n, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = this.buffer.dup();
        derInputBuffer.truncate(n);
        if (bl) {
            this.buffer.skip(n);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInt getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        byte[] byArray;
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int n = DerInputStream.getLength(this.buffer);
        if (this.buffer.read() != 0) {
            return null;
        }
        if (this.buffer.read(byArray = new byte[--n]) != n) {
            throw new IOException("short read of DER bit string");
        }
        return byArray;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int n = DerInputStream.getLength(this.buffer) - 1;
        int n2 = n * 8 - this.buffer.read();
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(n2, byArray);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0 && this.buffer.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int n) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n, boolean bl) throws IOException {
        int n2 = this.buffer.read();
        if (!bl && n2 != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    protected DerValue[] readVector(int n) throws IOException {
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.buffer.available() == n2 ? this : this.subStream(n2, true);
        Vector<DerValue> vector = new Vector<DerValue>(n, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.buffer);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n3 = vector.size();
        DerValue[] derValueArray = new DerValue[n3];
        for (int i = 0; i < n3; ++i) {
            derValueArray[i] = (DerValue)vector.elementAt(i);
        }
        return derValueArray;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public String getPrintableString() throws IOException {
        return new DerValue(this.buffer).getPrintableString();
    }

    public String getT61String() throws IOException {
        return new DerValue(this.buffer).getT61String();
    }

    public String getIA5String() throws IOException {
        return new DerValue(this.buffer).getIA5String();
    }

    public String getBMPString() throws IOException {
        return new DerValue(this.buffer).getBMPString();
    }

    public String getUniversalString() throws IOException {
        return new DerValue(this.buffer).getUniversalString();
    }

    public Date getUTCTime() throws IOException {
        int n;
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.buffer.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 < 11 || n2 > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int n3 = 10 * Character.digit((char)this.buffer.read(), 10);
        n3 = (n3 += Character.digit((char)this.buffer.read(), 10)) <= 50 ? (n3 += 2000) : (n3 += 1900);
        int n4 = 10 * Character.digit((char)this.buffer.read(), 10);
        n4 += Character.digit((char)this.buffer.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.buffer.read(), 10);
        n5 += Character.digit((char)this.buffer.read(), 10);
        int n6 = 10 * Character.digit((char)this.buffer.read(), 10);
        n6 += Character.digit((char)this.buffer.read(), 10);
        int n7 = 10 * Character.digit((char)this.buffer.read(), 10);
        n7 += Character.digit((char)this.buffer.read(), 10);
        if ((n2 -= 10) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.buffer.read(), 10);
            n += Character.digit((char)this.buffer.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(14, 0);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int n8 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n9 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n8 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n9 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 45: {
                int n10 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n11 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n10 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n11 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
        }
        date.setTime(l);
        return date;
    }

    public Date getGeneralizedTime() throws IOException {
        int n;
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.buffer.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        int n3 = 1000 * Character.digit((char)this.buffer.read(), 10);
        n3 += 100 * Character.digit((char)this.buffer.read(), 10);
        n3 += 10 * Character.digit((char)this.buffer.read(), 10);
        n3 += Character.digit((char)this.buffer.read(), 10);
        int n4 = 10 * Character.digit((char)this.buffer.read(), 10);
        n4 += Character.digit((char)this.buffer.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.buffer.read(), 10);
        n5 += Character.digit((char)this.buffer.read(), 10);
        int n6 = 10 * Character.digit((char)this.buffer.read(), 10);
        n6 += Character.digit((char)this.buffer.read(), 10);
        int n7 = 10 * Character.digit((char)this.buffer.read(), 10);
        n7 += Character.digit((char)this.buffer.read(), 10);
        if ((n2 -= 12) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.buffer.read(), 10);
            n += Character.digit((char)this.buffer.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(14, 0);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int n8 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n9 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n8 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n9 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 45: {
                int n10 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n11 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n10 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n11 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
        }
        date.setTime(l);
        return date;
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 & 0x80) == 0) {
            n = n2;
        } else {
            if ((n2 &= 0x7F) <= 0 || n2 > 4) {
                throw new IOException("DerInput.getLength(): lengthTag=" + n2 + ", " + (n2 == 0 ? "Indefinite length encoding not supported or incorrect DER encoding." : "too big."));
            }
            n = 0;
            while (n2 > 0) {
                n <<= 8;
                n += 0xFF & inputStream.read();
                --n2;
            }
        }
        return n;
    }

    public void mark(int n) {
        this.buffer.mark(n);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }
}

