/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import java.math.BigInteger;

public final class BigInt {
    private byte[] places;
    private static final String digits = "0123456789abcdef";

    public BigInt(byte[] byArray) {
        this.places = (byte[])byArray.clone();
    }

    public BigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (byArray[0] != 0) {
            this.places = byArray;
        } else if (byArray.length == 1) {
            this.places = new byte[1];
            this.places[0] = 0;
        } else {
            this.places = new byte[byArray.length - 1];
            for (int i = 1; i < byArray.length; ++i) {
                this.places[i - 1] = byArray[i];
            }
        }
    }

    public BigInt(int n) {
        if (n < 256) {
            this.places = new byte[1];
            this.places[0] = (byte)n;
        } else if (n < 65536) {
            this.places = new byte[2];
            this.places[0] = (byte)(n >> 8);
            this.places[1] = (byte)n;
        } else if (n < 0x1000000) {
            this.places = new byte[3];
            this.places[0] = (byte)(n >> 16);
            this.places[1] = (byte)(n >> 8);
            this.places[2] = (byte)n;
        } else {
            this.places = new byte[4];
            this.places[0] = (byte)(n >> 24);
            this.places[1] = (byte)(n >> 16);
            this.places[2] = (byte)(n >> 8);
            this.places[3] = (byte)n;
        }
    }

    public int toInt() {
        if (this.places.length > 4) {
            throw new NumberFormatException("BigInt.toInt, too big");
        }
        int n = 0;
        for (int i = 0; i < this.places.length; ++i) {
            n = (n << 8) + (this.places[i] & 0xFF);
        }
        return n;
    }

    public String toString() {
        return this.hexify();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.places);
    }

    public int byteLength() {
        return this.places.length;
    }

    public byte[] toByteArray() {
        if (this.places.length == 0) {
            byte[] byArray = new byte[]{0};
            return byArray;
        }
        return (byte[])this.places.clone();
    }

    private String hexify() {
        if (this.places.length == 0) {
            return "  0  ";
        }
        StringBuffer stringBuffer = new StringBuffer(this.places.length * 2);
        stringBuffer.append("    ");
        for (int i = 0; i < this.places.length; ++i) {
            stringBuffer.append(digits.charAt(this.places[i] >> 4 & 0xF));
            stringBuffer.append(digits.charAt(this.places[i] & 0xF));
            if ((i + 1) % 32 == 0) {
                if (i + 1 == this.places.length) continue;
                stringBuffer.append("\n    ");
                continue;
            }
            if ((i + 1) % 4 != 0) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof BigInt) {
            return this.equals((BigInt)object);
        }
        return false;
    }

    public boolean equals(BigInt bigInt) {
        if (this == bigInt) {
            return true;
        }
        byte[] byArray = bigInt.toByteArray();
        if (this.places.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < this.places.length; ++i) {
            if (this.places[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }
}

