/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.common.CacheBlock;
import com.iplanet.am.sdk.common.CacheStats;
import com.iplanet.am.sdk.common.ICachedDirectoryServices;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.sdk.common.MiscUtils;
import com.iplanet.am.sdk.remote.RemoteServicesImpl;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class CachedRemoteServicesImpl
extends RemoteServicesImpl
implements ICachedDirectoryServices {
    private static int maxSize = 10000;
    private static IDirectoryServices instance = null;
    static final String CACHE_MAX_SIZE_KEY = "com.iplanet.am.sdk.cache.maxSize";
    protected static String NSROLEDN_ATTR = "nsroledn";
    protected static String NSROLE_ATTR = "nsrole";
    private Cache sdkCache;
    private CacheStats cacheStats;

    private static void initializeParams() {
        String string = SystemProperties.get((String)CACHE_MAX_SIZE_KEY, (String)"10000");
        try {
            maxSize = Integer.parseInt(string);
            if (maxSize < 1) {
                maxSize = 10000;
            }
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.intializeParams() Caching size set to: " + maxSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            maxSize = 10000;
            RemoteServicesImpl.getDebug().warning("CachedRemoteServicesImpl.initializeParams() - invalid value for cache size specified. Setting to default value: " + maxSize);
        }
    }

    private CachedRemoteServicesImpl() {
        this.initializeCache();
        this.cacheStats = CacheStats.createInstance(this.getClass().getName(), RemoteServicesImpl.getDebug());
    }

    private void initializeCache() {
        this.sdkCache = new Cache(maxSize);
    }

    public int getSize() {
        return this.sdkCache.size();
    }

    protected static synchronized IDirectoryServices getInstance() {
        if (instance == null) {
            RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getInstance(): Creating new Instance of CachedRemoteServicesImpl()");
            instance = new CachedRemoteServicesImpl();
        }
        return instance;
    }

    protected static int getMaxSize() {
        return maxSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n<<<<<<< BEGIN SDK CACHE CONTENTS >>>>>>>>");
        if (!this.sdkCache.isEmpty()) {
            Enumeration enumeration = this.sdkCache.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string);
                stringBuffer.append("\nSDK Cache Block: ").append(string);
                stringBuffer.append(cacheBlock.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n<<<<<<< END SDK CACHE CONTENTS >>>>>>>>");
        return stringBuffer.toString();
    }

    private void removeCachedAttributes(String string, Set set) {
        Enumeration enumeration = this.sdkCache.keys();
        while (enumeration.hasMoreElements()) {
            CacheBlock cacheBlock;
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.regionMatches(true, (n2 = string2.length()) - (n = string.length()), string, 0, n) || (cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2)) == null || cacheBlock.hasExpiredAndUpdated() || !cacheBlock.isExists()) continue;
            cacheBlock.removeAttributes(set);
        }
    }

    private void clearCachedEntries(String string) {
        Enumeration enumeration = this.sdkCache.keys();
        while (enumeration.hasMoreElements()) {
            CacheBlock cacheBlock;
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.regionMatches(true, (n2 = string2.length()) - (n = string.length()), string, 0, n) || (cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2)) == null) continue;
            cacheBlock.clear();
        }
    }

    public void dirtyCache(String string, int n, boolean bl, boolean bl2, Set set) {
        String string2 = string;
        string = MiscUtils.formatToRFC(string);
        switch (n) {
            case 1: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string);
                if (cacheBlock != null) {
                    cacheBlock.setExists(true);
                }
                if (!bl) break;
                this.removeCachedAttributes(string, set);
                break;
            }
            case 2: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.remove((Object)string);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(string, set);
                break;
            }
            case 8: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.remove((Object)string);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(string, set);
                break;
            }
            case 4: {
                CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (bl) {
                    this.removeCachedAttributes(string, set);
                    break;
                }
                if (!bl2) break;
                this.clearCachedEntries(string);
            }
        }
        if (RemoteServicesImpl.getDebug().messageEnabled()) {
            RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.dirtyCache(): Cache dirtied because of Event Notification. Parameters - eventType: " + n + ", cosType: " + bl + ", aciChange: " + bl2 + ", fullDN: " + string2 + "; rfcDN =" + string);
        }
    }

    public synchronized void clearCache() {
        this.sdkCache.clear();
        this.initializeCache();
    }

    private synchronized void removeFromCache(String string) {
        String string2 = MiscUtils.formatToRFC(string);
        this.sdkCache.remove((Object)string2);
    }

    private void dirtyCache(String string) {
        String string2 = MiscUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null) {
            cacheBlock.clear();
        }
    }

    private void dirtyCache(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = MiscUtils.formatToRFC(string);
            CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
            if (cacheBlock == null) continue;
            cacheBlock.clear();
        }
    }

    private void updateCache(SSOToken sSOToken, String string, Map map, Map map2) throws SSOException {
        String string2 = MiscUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null && !cacheBlock.hasExpiredAndUpdated() && cacheBlock.isExists()) {
            String string3 = MiscUtils.getPrincipalDN(sSOToken);
            cacheBlock.replaceAttributes(string3, map, map2);
        }
    }

    public void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException, SSOException {
        super.createEntry(sSOToken, string, n, string2, map);
        String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string + "," + string2;
        this.removeFromCache(string3);
    }

    private void validateEntry(SSOToken sSOToken, CacheBlock cacheBlock) throws AMException {
        if (!cacheBlock.hasExpiredAndUpdated() && !cacheBlock.isExists()) {
            Object[] objectArray = new String[]{cacheBlock.getEntryDN()};
            boolean bl = super.doesEntryExists(sSOToken, objectArray[0]);
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.validateEntry(): DN" + objectArray[0] + " got from DS & exists: " + bl);
            }
            if (bl) {
                String string = MiscUtils.formatToRFC(objectArray[0]);
                cacheBlock = new CacheBlock((String)objectArray[0], bl);
                this.sdkCache.put((Object)string, (Object)cacheBlock);
            } else {
                String string = MiscUtils.getUserLocale(sSOToken);
                throw new AMException(AMSDKBundle.getString("461", objectArray, string), "461", objectArray);
            }
        }
    }

    public boolean doesEntryExists(SSOToken sSOToken, String string) {
        String string2 = MiscUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null && !cacheBlock.hasExpiredAndUpdated()) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.doesEntryExist(): entryDN: " + string + " found in cache & exists: " + cacheBlock.isExists());
            }
            return cacheBlock.isExists();
        }
        boolean bl = super.doesEntryExists(sSOToken, string2);
        if (RemoteServicesImpl.getDebug().messageEnabled()) {
            RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.doesEntryExist(): entryDN: " + string + " got from DS & exists: " + bl);
        }
        if (cacheBlock == null) {
            cacheBlock = new CacheBlock(string, bl);
            this.sdkCache.put((Object)string2, (Object)cacheBlock);
        } else {
            cacheBlock.setExists(bl);
        }
        return bl;
    }

    private void setOrganizationDNs(String string, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
            if (cacheBlock == null) {
                cacheBlock = new CacheBlock(string2, string, true);
                this.sdkCache.put((Object)string2, (Object)cacheBlock);
                continue;
            }
            cacheBlock.setOrganizationDN(string);
        }
        if (RemoteServicesImpl.getDebug().messageEnabled() && !set.isEmpty()) {
            RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.setOrganizationDNs(): Set org DNs as: " + string + " for children: " + set);
        }
    }

    public void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        super.updateUserAttribute(sSOToken, set, string, bl);
        this.dirtyCache(set);
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        if (string.length() == 0 || !DN.isDN((String)string)) {
            RemoteServicesImpl.getDebug().error("CachedRemoteServicesImpl.getOrganizationDN() Invalid DN: " + string);
            throw new AMException(sSOToken, "157");
        }
        DN dN = new DN(string);
        String string2 = "";
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl && !bl2) {
            CacheBlock cacheBlock;
            boolean bl3 = true;
            String string3 = dN.toRFCString().toLowerCase();
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getOrganizationDN() - looping Organization DN for entry: " + string3);
            }
            if ((cacheBlock = (CacheBlock)this.sdkCache.get((Object)string3)) != null) {
                string2 = cacheBlock.getOrganizationDN();
                if (string2 != null) {
                    if (RemoteServicesImpl.getDebug().messageEnabled()) {
                        RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getOrganizationDN(): found OrganizationDN: " + string2 + " for: " + string3);
                    }
                    bl2 = true;
                    this.setOrganizationDNs(string2, hashSet);
                    continue;
                }
                if (cacheBlock.getObjectType() == 2 || cacheBlock.getObjectType() == 3) {
                    string2 = string3;
                    bl2 = true;
                    hashSet.add(string3);
                    this.setOrganizationDNs(string2, hashSet);
                    continue;
                }
                if (cacheBlock.getObjectType() != -9999) {
                    bl3 = false;
                }
            }
            hashSet.add(string3);
            if (bl3) {
                string2 = super.verifyAndGetOrgDN(sSOToken, string, string3);
            }
            if (string2 != null && string2.length() > 0) {
                bl2 = true;
                this.setOrganizationDNs(string2, hashSet);
                continue;
            }
            if (dN.countRDNs() == 1) {
                bl = true;
                RemoteServicesImpl.getDebug().error("CachedRemoteServicesImpl.getOrganizationDN(): Reached root suffix. Unable to get parent Org");
                continue;
            }
            dN = dN.getParent();
        }
        return string2;
    }

    public int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        int n = -9999;
        String string2 = MiscUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string2);
        if (cacheBlock != null) {
            this.validateEntry(sSOToken, cacheBlock);
            n = cacheBlock.getObjectType();
            if (n != -9999) {
                return n;
            }
        }
        SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (cacheBlock == null) {
            n = super.getObjectType(sSOToken2, string2);
            cacheBlock = new CacheBlock(string2, true);
            this.sdkCache.put((Object)string2, (Object)cacheBlock);
        } else {
            n = super.getObjectType(sSOToken2, string2, cacheBlock.getAttributes(MiscUtils.getPrincipalDN(sSOToken2), false));
        }
        cacheBlock.setObjectType(n);
        if (n == 2 || n == 3) {
            cacheBlock.setOrganizationDN(string2);
        }
        return n;
    }

    public Map getExternalAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException {
        String string2 = n == 1 ? new DN(string).getParent().toString() : string;
        String string3 = this.getOrganizationDN(sSOToken, string2);
        if (this.callBackHelperBase.isExternalGetAttributesEnabled(string3)) {
            return super.getExternalAttributes(sSOToken, string, set, n);
        }
        return null;
    }

    public Map getAttributes(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, bl, bl2, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, set, bl, bl2, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, bl2, bl, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, set, bl2, bl, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        this.cacheStats.incrementRequestCount(this.getSize());
        String string2 = MiscUtils.getPrincipalDN(sSOToken);
        String string3 = MiscUtils.formatToRFC(string);
        if (RemoteServicesImpl.getDebug().messageEnabled()) {
            RemoteServicesImpl.getDebug().message("In CachedRemoteServicesImpl.getAttributes(SSOToken entryDN, ignoreCompliance) (" + string2 + ", " + string + ", " + bl + " method.");
        }
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string3);
        AMHashMap aMHashMap = null;
        if (cacheBlock != null) {
            this.validateEntry(sSOToken, cacheBlock);
            if (cacheBlock.hasCompleteSet(string2)) {
                this.cacheStats.updateHitCount(this.getSize());
                if (RemoteServicesImpl.getDebug().messageEnabled()) {
                    RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): found all attributes in Cache.");
                }
                aMHashMap = (AMHashMap)cacheBlock.getAttributes(string2, bl2);
            } else {
                if (RemoteServicesImpl.getDebug().messageEnabled()) {
                    RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes():  complete attribute set NOT found in cache. Getting from DS.");
                }
                aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, bl, bl2, n);
                cacheBlock.putAttributes(string2, aMHashMap, null, true, bl2);
            }
        } else {
            aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, bl, bl2, n);
            cacheBlock = new CacheBlock(string, true);
            cacheBlock.putAttributes(string2, aMHashMap, null, true, bl2);
            this.sdkCache.put((Object)string3, (Object)cacheBlock);
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
        }
        Map map = this.getExternalAttributes(sSOToken, string, null, n);
        if (map != null && !map.isEmpty()) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): External attributes present. Adding them with original list");
            }
            aMHashMap.putAll(map);
        }
        return aMHashMap;
    }

    private AMHashMap getPluginAttrsAndUpdateCache(SSOToken sSOToken, String string, String string2, CacheBlock cacheBlock, AMHashMap aMHashMap, Set set, boolean bl, int n) throws AMException {
        Map map = this.getExternalAttributes(sSOToken, string2, set, n);
        if (map != null && !map.isEmpty()) {
            Set set2 = map.keySet();
            cacheBlock.removeAttributes(set2);
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getPluginAttrsAndUpdateCache(): External attributes present. Adding them with original list. External Attributes: " + set2);
            }
            aMHashMap.putAll(map);
        }
        return aMHashMap;
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        String string2;
        CacheBlock cacheBlock;
        if (set == null || set.isEmpty()) {
            return this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        this.cacheStats.incrementRequestCount(this.getSize());
        if (this.dcTreeServicesImpl.isRequired()) {
            this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        String string3 = MiscUtils.getPrincipalDN(sSOToken);
        if (RemoteServicesImpl.getDebug().messageEnabled()) {
            RemoteServicesImpl.getDebug().message("In CachedRemoteServicesImpl.getAttributes(SSOToken entryDN, attrNames, ignoreCompliance, byteValues) (" + string3 + ", " + string + ", " + set + ", " + bl + ", " + bl2 + " method.");
        }
        if ((cacheBlock = (CacheBlock)this.sdkCache.get((Object)(string2 = MiscUtils.formatToRFC(string)))) == null) {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes():  NO entry found in Cache. Getting all these attributes from DS: " + set);
            }
            AMHashMap aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, set, bl, bl2, n);
            Set set2 = aMHashMap.getMissingAndEmptyKeys(set);
            cacheBlock = new CacheBlock(string2, true);
            cacheBlock.putAttributes(string3, aMHashMap, set2, false, bl2);
            this.sdkCache.put((Object)string2, (Object)cacheBlock);
            if (!set2.isEmpty()) {
                aMHashMap = this.getPluginAttrsAndUpdateCache(sSOToken, string3, string, cacheBlock, aMHashMap, set2, bl2, n);
            }
            return aMHashMap;
        }
        this.validateEntry(sSOToken, cacheBlock);
        AMHashMap aMHashMap = (AMHashMap)cacheBlock.getAttributes(string3, set, bl2);
        Set set3 = aMHashMap.getMissingKeys(set);
        if (!set3.isEmpty()) {
            boolean bl3 = cacheBlock.hasCompleteSet(string3);
            AMHashMap aMHashMap2 = null;
            if (!bl3 || set3.contains(NSROLEDN_ATTR) || set3.contains(NSROLE_ATTR)) {
                if (RemoteServicesImpl.getDebug().messageEnabled()) {
                    RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes(): Trying to get these missing attributes from DS: " + set3);
                }
                if ((aMHashMap2 = (AMHashMap)super.getAttributes(sSOToken, string, set3, bl, bl2, n)) != null) {
                    aMHashMap.putAll(aMHashMap2);
                    Set set4 = aMHashMap2.getMissingAndEmptyKeys(set3);
                    aMHashMap2.putAll(cacheBlock.getAttributes(string3, bl2));
                    cacheBlock.putAttributes(string3, aMHashMap2, set4, bl3, bl2);
                    set3 = set4;
                }
            } else {
                cacheBlock.putAttributes(string3, cacheBlock.getAttributes(string3, bl2), set3, bl3, bl2);
            }
            if (!set3.isEmpty()) {
                aMHashMap = this.getPluginAttrsAndUpdateCache(sSOToken, string3, string, cacheBlock, aMHashMap, set3, bl2, n);
            }
        } else {
            if (RemoteServicesImpl.getDebug().messageEnabled()) {
                RemoteServicesImpl.getDebug().message("CachedRemoteServicesImpl.getAttributes():  found all attributes in Cache.");
            }
            this.cacheStats.updateHitCount(this.getSize());
        }
        return aMHashMap;
    }

    public String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        String string3 = super.renameEntry(sSOToken, n, string, string2, bl);
        String string4 = MiscUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.remove((Object)string4);
        string3 = MiscUtils.formatToRFC(string3);
        this.sdkCache.put((Object)string3, (Object)cacheBlock);
        return string3;
    }

    public void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        super.setAttributes(sSOToken, string, n, map, map2, bl);
        if (n == 1) {
            this.updateCache(sSOToken, string, map, map2);
        } else if (n != 1) {
            this.dirtyCache(string);
        }
    }

    public void removeEntry(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws AMException, SSOException {
        super.removeEntry(sSOToken, string, n, bl, bl2);
        this.removeFromCache(string);
    }

    public String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        String string3 = super.createAMTemplate(sSOToken, string, n, string2, map, n2);
        String string4 = MiscUtils.formatToRFC(string3);
        CacheBlock cacheBlock = (CacheBlock)this.sdkCache.get((Object)string4);
        if (cacheBlock != null) {
            cacheBlock.setExists(true);
        }
        return string3;
    }

    public void setGroupFilter(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        super.setGroupFilter(sSOToken, string, string2);
    }

    static {
        CachedRemoteServicesImpl.initializeParams();
    }
}

