/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMUserPasswordValidation;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.NamingAttributeManager;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class UserPasswordValidationHelper
implements AMConstants {
    private static Map pluginsCache = Collections.EMPTY_MAP;
    private Debug debug = CommonUtils.debug;
    private AMUserPasswordValidation plugin = null;
    private String orgdn;

    public UserPasswordValidationHelper(SSOToken sSOToken, String string) throws AMException {
        this.orgdn = string;
        String string2 = this.getOrgUserPasswordValidationClass(string);
        if (string2 != null && string2.length() != 0) {
            if (pluginsCache == Collections.EMPTY_MAP) {
                pluginsCache = new Hashtable();
            } else {
                this.plugin = (AMUserPasswordValidation)pluginsCache.get(string2);
            }
            if (this.plugin == null) {
                this.plugin = this.instantiateClass(sSOToken, string2);
                pluginsCache.put(string2, this.plugin);
            }
        }
    }

    public void validate(Map map) throws AMException {
        if (this.plugin != null) {
            Object object;
            Object object2;
            String string = NamingAttributeManager.getNamingAttribute(1);
            Set set = (Set)map.get(string);
            if (set != null && !set.isEmpty()) {
                object2 = (String)set.iterator().next();
                try {
                    object = new HashMap<String, String>(2);
                    object.put("organization_name", this.orgdn);
                    this.plugin.validateUserID((String)object2, (Map)object);
                }
                catch (AMException aMException) {
                    this.debug.error("AMUserPasswordValidationImpl:validate() User Name validation Failed" + aMException);
                    throw aMException;
                }
            }
            if ((object2 = (Set)map.get("userpassword")) != null && !object2.isEmpty()) {
                object = (String)object2.iterator().next();
                HashMap<String, String> hashMap = new HashMap<String, String>(2);
                hashMap.put("organization_name", this.orgdn);
                this.plugin.validatePassword((String)object, hashMap);
            }
        }
    }

    private String getOrgUserPasswordValidationClass(String string) {
        try {
            SSOToken sSOToken = CommonUtils.getInternalToken();
            ServiceConfig serviceConfig = AMServiceUtils.getOrgConfig(sSOToken, string, "iPlanetAMAdminConsoleService");
            if (serviceConfig != null) {
                Map map = serviceConfig.getAttributes();
                Set set = (Set)map.get("iplanet-am-admin-console-user-password-validation-class");
                return set == null || set.isEmpty() ? null : (String)set.iterator().next();
            }
            return this.getGlobalUserValiadationClass();
        }
        catch (Exception exception) {
            return this.getGlobalUserValiadationClass();
        }
    }

    private String getGlobalUserValiadationClass() {
        block4: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMUserPasswordValidationImplImpl.getGlobalUserValiadationClass() Organization config for service (iPlanetAMAdminConsoleService,iplanet-am-admin-console-user-password-validation-class) not found. Obtaining default service config values ..");
            }
            try {
                Map map = AMServiceUtils.getServiceConfig(CommonUtils.getInternalToken(), "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (map != null) {
                    Set set = (Set)map.get("iplanet-am-admin-console-user-password-validation-class");
                    return set == null || set.isEmpty() ? null : (String)set.iterator().next();
                }
            }
            catch (Exception exception) {
                if (!this.debug.warningEnabled()) break block4;
                this.debug.warning("AMUserPasswordValidationImplImpl.getGlobalUserValiadationClass(): Unable to get UserID & Password validation plugin information", (Throwable)exception);
            }
        }
        return null;
    }

    private AMUserPasswordValidation instantiateClass(SSOToken sSOToken, String string) throws AMException {
        try {
            return (AMUserPasswordValidation)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.debug.error("AMUserPasswordValidationImpl.instantiateClass(): Unable to instantiate class: " + string, (Throwable)instantiationException);
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("164", objectArray), "164", objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.debug.error("AMUserPasswordValidationImpl.instantiateClass(): The class is " + string + " unaccessable: ", (Throwable)illegalAccessException);
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("164", objectArray), "164", objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug.error("AMUserPasswordValidationImpl.instantiateClass(): Unable to locate class " + string, (Throwable)classNotFoundException);
            Object[] objectArray = new Object[]{string};
            throw new AMException(AMSDKBundle.getString("164", objectArray), "164", objectArray);
        }
    }
}

